/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import com.google.android.gms.internal.ads.zzdbk;
import com.google.android.gms.internal.ads.zzdbs;
import com.google.android.gms.internal.ads.zzdbu;
import com.google.android.gms.internal.ads.zzdca;
import com.google.android.gms.internal.ads.zzdcb;
import com.google.android.gms.internal.ads.zzdcc;
import com.google.android.gms.internal.ads.zzdch;
import com.google.android.gms.internal.ads.zzdgr;
import com.google.android.gms.internal.ads.zzdgu;
import com.google.android.gms.internal.ads.zzdgw;
import com.google.android.gms.internal.ads.zzdha;
import com.google.android.gms.internal.ads.zzdmr;
import com.google.android.gms.internal.ads.zzdpk;
import java.security.GeneralSecurityException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class zzdcf {
    private static final Logger logger = Logger.getLogger(zzdcf.class.getName());
    private static final ConcurrentMap<String, zzdbs> zzgpp = new ConcurrentHashMap<String, zzdbs>();
    private static final ConcurrentMap<String, Boolean> zzgpq = new ConcurrentHashMap<String, Boolean>();
    private static final ConcurrentMap<String, zzdbk> zzgpr = new ConcurrentHashMap<String, zzdbk>();
    private static final ConcurrentMap<Class<?>, zzdcc<?>> zzgps = new ConcurrentHashMap();

    public static synchronized void zza(String string2, zzdbk<?> zzdbk2) throws GeneralSecurityException {
        if (zzgpr.containsKey(string2.toLowerCase())) {
            zzdbk zzdbk3 = (zzdbk)zzgpr.get(string2.toLowerCase());
            if (!zzdbk2.getClass().equals(zzdbk3.getClass())) {
                String string3 = String.valueOf(string2);
                logger.logp(Level.WARNING, "com.google.crypto.tink.Registry", "addCatalogue", string3.length() != 0 ? "Attempted overwrite of a catalogueName catalogue for name ".concat(string3) : new String("Attempted overwrite of a catalogueName catalogue for name "));
                throw new GeneralSecurityException(new StringBuilder(47 + String.valueOf(string2).length()).append("catalogue for name ").append(string2).append(" has been already registered").toString());
            }
        }
        zzgpr.put(string2.toLowerCase(), zzdbk2);
    }

    public static zzdbk<?> zzgi(String string2) throws GeneralSecurityException {
        if (string2 == null) {
            throw new IllegalArgumentException("catalogueName must be non-null.");
        }
        zzdbk zzdbk2 = (zzdbk)zzgpr.get(string2.toLowerCase());
        if (zzdbk2 == null) {
            String string3 = String.format("no catalogue found for %s. ", string2);
            if (string2.toLowerCase().startsWith("tinkaead")) {
                string3 = String.valueOf(string3).concat("Maybe call AeadConfig.register().");
            }
            if (string2.toLowerCase().startsWith("tinkdeterministicaead")) {
                string3 = String.valueOf(string3).concat("Maybe call DeterministicAeadConfig.register().");
            } else if (string2.toLowerCase().startsWith("tinkstreamingaead")) {
                string3 = String.valueOf(string3).concat("Maybe call StreamingAeadConfig.register().");
            } else if (string2.toLowerCase().startsWith("tinkhybriddecrypt") || string2.toLowerCase().startsWith("tinkhybridencrypt")) {
                string3 = String.valueOf(string3).concat("Maybe call HybridConfig.register().");
            } else if (string2.toLowerCase().startsWith("tinkmac")) {
                string3 = String.valueOf(string3).concat("Maybe call MacConfig.register().");
            } else if (string2.toLowerCase().startsWith("tinkpublickeysign") || string2.toLowerCase().startsWith("tinkpublickeyverify")) {
                string3 = String.valueOf(string3).concat("Maybe call SignatureConfig.register().");
            } else if (string2.toLowerCase().startsWith("tink")) {
                string3 = String.valueOf(string3).concat("Maybe call TinkConfig.register().");
            }
            throw new GeneralSecurityException(string3);
        }
        return zzdbk2;
    }

    private static <T> T checkNotNull(T t) {
        if (t == null) {
            throw new NullPointerException();
        }
        return t;
    }

    public static synchronized <P> void zza(zzdbs<P> zzdbs2) throws GeneralSecurityException {
        zzdcf.zza(zzdbs2, true);
    }

    public static synchronized <P> void zza(zzdbs<P> zzdbs2, boolean bl) throws GeneralSecurityException {
        if (zzdbs2 == null) {
            throw new IllegalArgumentException("key manager must be non-null.");
        }
        String string2 = zzdbs2.getKeyType();
        if (zzgpp.containsKey(string2)) {
            zzdbs<P> zzdbs3 = zzdcf.zza(string2, null);
            boolean bl2 = (Boolean)zzgpq.get(string2);
            if (!zzdbs2.getClass().equals(zzdbs3.getClass()) || !bl2 && bl) {
                String string3 = String.valueOf(string2);
                logger.logp(Level.WARNING, "com.google.crypto.tink.Registry", "registerKeyManager", string3.length() != 0 ? "Attempted overwrite of a registered key manager for key type ".concat(string3) : new String("Attempted overwrite of a registered key manager for key type "));
                throw new GeneralSecurityException(String.format("typeUrl (%s) is already registered with %s, cannot be re-registered with %s", string2, zzdbs3.getClass().getName(), zzdbs2.getClass().getName()));
            }
        }
        zzgpp.put(string2, zzdbs2);
        zzgpq.put(string2, bl);
    }

    public static synchronized <P> void zza(zzdcc<P> zzdcc2) throws GeneralSecurityException {
        if (zzdcc2 == null) {
            throw new IllegalArgumentException("wrapper must be non-null");
        }
        Class<P> clazz = zzdcc2.zzanr();
        if (zzgps.containsKey(clazz)) {
            zzdcc zzdcc3 = (zzdcc)zzgps.get(clazz);
            if (!zzdcc2.getClass().equals(zzdcc3.getClass())) {
                String string2 = String.valueOf(clazz.toString());
                logger.logp(Level.WARNING, "com.google.crypto.tink.Registry", "registerPrimitiveWrapper", string2.length() != 0 ? "Attempted overwrite of a registered SetWrapper for type ".concat(string2) : new String("Attempted overwrite of a registered SetWrapper for type "));
                throw new GeneralSecurityException(String.format("SetWrapper for primitive (%s) is already registered to be %s, cannot be re-registered with %s", clazz.getName(), zzdcc3.getClass().getName(), zzdcc2.getClass().getName()));
            }
        }
        zzgps.put(clazz, zzdcc2);
    }

    private static <P> zzdbs<P> zza(String string2, Class<P> clazz) throws GeneralSecurityException {
        zzdbs zzdbs2 = (zzdbs)zzgpp.get(string2);
        if (zzdbs2 == null) {
            throw new GeneralSecurityException(new StringBuilder(78 + String.valueOf(string2).length()).append("No key manager found for key type: ").append(string2).append(".  Check the configuration of the registry.").toString());
        }
        if (clazz != null && !zzdbs2.zzanr().equals(clazz)) {
            String string3 = zzdbs2.zzanr().getName();
            String string4 = clazz.getName();
            throw new GeneralSecurityException(new StringBuilder(80 + String.valueOf(string3).length() + String.valueOf(string2).length() + String.valueOf(string4).length()).append("Primitive type ").append(string3).append(" of keymanager for type ").append(string2).append(" does not match requested primitive type ").append(string4).toString());
        }
        return zzdbs2;
    }

    public static synchronized zzdgr zza(zzdgw zzdgw2) throws GeneralSecurityException {
        zzdbs zzdbs2 = zzdcf.zza(zzdgw2.zzart(), null);
        if (((Boolean)zzgpq.get(zzdgw2.zzart())).booleanValue()) {
            return zzdbs2.zzr(zzdgw2.zzaru());
        }
        String string2 = String.valueOf(zzdgw2.zzart());
        throw new GeneralSecurityException(string2.length() != 0 ? "newKey-operation not permitted for key type ".concat(string2) : new String("newKey-operation not permitted for key type "));
    }

    public static synchronized zzdpk zzb(zzdgw zzdgw2) throws GeneralSecurityException {
        zzdbs zzdbs2 = zzdcf.zza(zzdgw2.zzart(), null);
        if (((Boolean)zzgpq.get(zzdgw2.zzart())).booleanValue()) {
            return zzdbs2.zzq(zzdgw2.zzaru());
        }
        String string2 = String.valueOf(zzdgw2.zzart());
        throw new GeneralSecurityException(string2.length() != 0 ? "newKey-operation not permitted for key type ".concat(string2) : new String("newKey-operation not permitted for key type "));
    }

    public static synchronized zzdpk zza(String string2, zzdpk zzdpk2) throws GeneralSecurityException {
        zzdbs zzdbs2 = zzdcf.zza(string2, null);
        if (((Boolean)zzgpq.get(string2)).booleanValue()) {
            return zzdbs2.zzb(zzdpk2);
        }
        String string3 = String.valueOf(string2);
        throw new GeneralSecurityException(string3.length() != 0 ? "newKey-operation not permitted for key type ".concat(string3) : new String("newKey-operation not permitted for key type "));
    }

    public static <P> P zza(String string2, zzdpk zzdpk2, Class<P> clazz) throws GeneralSecurityException {
        Class<P> clazz2 = zzdcf.checkNotNull(clazz);
        zzdpk zzdpk3 = zzdpk2;
        return zzdcf.zza(string2, clazz2).zza(zzdpk3);
    }

    private static <P> P zza(String string2, zzdmr zzdmr2, Class<P> clazz) throws GeneralSecurityException {
        return zzdcf.zza(string2, clazz).zzp(zzdmr2);
    }

    public static <P> P zza(String string2, byte[] byArray, Class<P> clazz) throws GeneralSecurityException {
        Class<P> clazz2 = clazz;
        zzdmr zzdmr2 = zzdmr.zzz((byte[])byArray);
        return zzdcf.zza(string2, zzdmr2, zzdcf.checkNotNull(clazz2));
    }

    public static <P> zzdca<P> zza(zzdbu zzdbu2, zzdbs<P> zzdbs2, Class<P> clazz) throws GeneralSecurityException {
        Class<P> clazz2 = zzdcf.checkNotNull(clazz);
        zzdbu zzdbu3 = zzdbu2;
        zzdch.zzd(zzdbu3.zzant());
        zzdca<P> zzdca2 = zzdca.zza(clazz2);
        for (zzdha.zzb zzb2 : zzdbu3.zzant().zzasi()) {
            if (zzb2.zzaso() != zzdgu.zzgul) continue;
            P p = zzdcf.zza(zzb2.zzasn().zzart(), zzb2.zzasn().zzaru(), clazz2);
            zzdcb<P> zzdcb2 = zzdca2.zza(p, zzb2);
            if (zzb2.zzasp() != zzdbu3.zzant().zzash()) continue;
            zzdca2.zza(zzdcb2);
        }
        return zzdca2;
    }

    public static <P> P zza(zzdca<P> zzdca2) throws GeneralSecurityException {
        zzdcc zzdcc2 = (zzdcc)zzgps.get(zzdca2.zzanr());
        if (zzdcc2 == null) {
            String string2 = String.valueOf(zzdca2.zzanr().getName());
            throw new GeneralSecurityException(string2.length() != 0 ? "No wrapper found for ".concat(string2) : new String("No wrapper found for "));
        }
        return zzdcc2.zza(zzdca2);
    }
}

