/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.internal.ads.zzjq;
import com.google.android.gms.internal.ads.zzjx;
import com.google.android.gms.internal.ads.zzjy;
import com.google.android.gms.internal.ads.zzke;
import com.google.android.gms.internal.ads.zzkf;
import com.google.android.gms.internal.ads.zzkn;
import com.google.android.gms.internal.ads.zzkq;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.NoRouteToHostException;
import java.net.ProtocolException;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class zzjs
implements zzkf {
    private static final Pattern zzapl = Pattern.compile("^bytes (\\d+)-(\\d+)/(\\d+)$");
    private static final AtomicReference<byte[]> zzapm = new AtomicReference();
    private final boolean zzapn;
    private final int zzapo;
    private final int zzapp;
    private final String zzapq;
    private final zzkn<String> zzapr;
    private final HashMap<String, String> zzaps;
    private final zzke zzaoz;
    private zzjq zzapt;
    private HttpURLConnection zzapu;
    private InputStream zzapv;
    private boolean zzapd;
    private long zzapw;
    private long zzapx;
    private long zzapy;
    private long zzce;

    public zzjs(String string2, zzkn<String> zzkn2, zzke zzke2, int n, int n2, boolean bl) {
        String string3 = string2;
        if (TextUtils.isEmpty((CharSequence)string3)) {
            throw new IllegalArgumentException();
        }
        this.zzapq = string3;
        this.zzapr = null;
        this.zzaoz = null;
        this.zzaps = new HashMap();
        this.zzapo = n;
        this.zzapp = n2;
        this.zzapn = bl;
    }

    @Override
    public final long zza(zzjq zzjq2) throws zzjx {
        int n;
        this.zzapt = zzjq2;
        this.zzce = 0L;
        this.zzapy = 0L;
        try {
            HttpURLConnection httpURLConnection;
            block16: {
                boolean bl;
                zzjq zzjq3 = zzjq2;
                zzjs zzjs2 = this;
                URL uRL = new URL(zzjq3.uri.toString());
                long l = zzjq3.zzahv;
                long l2 = zzjq3.zzcd;
                boolean bl2 = bl = (zzjq3.flags & 1) != 0;
                if (!zzjs2.zzapn) {
                    HttpURLConnection httpURLConnection2 = zzjs2.zza(uRL, l, l2, bl);
                    httpURLConnection2.connect();
                    httpURLConnection = httpURLConnection2;
                } else {
                    int n2 = 0;
                    while (n2++ <= 20) {
                        HttpURLConnection httpURLConnection3 = zzjs2.zza(uRL, l, l2, bl);
                        httpURLConnection3.setInstanceFollowRedirects(false);
                        httpURLConnection3.connect();
                        int n3 = httpURLConnection3.getResponseCode();
                        if (n3 == 300 || n3 == 301 || n3 == 302 || n3 == 303 || n3 == 307 || n3 == 308) {
                            String string2 = httpURLConnection3.getHeaderField("Location");
                            httpURLConnection3.disconnect();
                            String string3 = string2;
                            URL uRL2 = uRL;
                            if (string3 == null) {
                                throw new ProtocolException("Null location redirect");
                            }
                            URL uRL3 = new URL(uRL2, string3);
                            String string4 = uRL3.getProtocol();
                            if (!"https".equals(string4) && !"http".equals(string4)) {
                                String string5 = String.valueOf(string4);
                                throw new ProtocolException(string5.length() != 0 ? "Unsupported protocol redirect: ".concat(string5) : new String("Unsupported protocol redirect: "));
                            }
                            uRL = uRL3;
                            continue;
                        }
                        httpURLConnection = httpURLConnection3;
                        break block16;
                    }
                    int n4 = n2;
                    throw new NoRouteToHostException(new StringBuilder(31).append("Too many redirects: ").append(n4).toString());
                }
            }
            this.zzapu = httpURLConnection;
        }
        catch (IOException iOException) {
            String string6 = String.valueOf(zzjq2.uri.toString());
            throw new zzjx(string6.length() != 0 ? "Unable to connect to ".concat(string6) : new String("Unable to connect to "), iOException, zzjq2);
        }
        try {
            n = this.zzapu.getResponseCode();
        }
        catch (IOException iOException) {
            this.closeConnection();
            String string7 = String.valueOf(zzjq2.uri.toString());
            throw new zzjx(string7.length() != 0 ? "Unable to connect to ".concat(string7) : new String("Unable to connect to "), iOException, zzjq2);
        }
        if (n < 200 || n > 299) {
            Map<String, List<String>> map = this.zzapu.getHeaderFields();
            this.closeConnection();
            throw new zzjy(n, map, zzjq2);
        }
        this.zzapu.getContentType();
        long l = this.zzapw = n == 200 && zzjq2.zzahv != 0L ? zzjq2.zzahv : 0L;
        if ((zzjq2.flags & 1) == 0) {
            long l3 = zzjs.zzc(this.zzapu);
            this.zzapx = zzjq2.zzcd != -1L ? zzjq2.zzcd : (l3 != -1L ? l3 - this.zzapw : -1L);
        } else {
            this.zzapx = zzjq2.zzcd;
        }
        try {
            this.zzapv = this.zzapu.getInputStream();
        }
        catch (IOException iOException) {
            this.closeConnection();
            throw new zzjx(iOException, zzjq2);
        }
        this.zzapd = true;
        if (this.zzaoz != null) {
            this.zzaoz.zzgc();
        }
        return this.zzapx;
    }

    @Override
    public final int read(byte[] byArray, int n, int n2) throws zzjx {
        try {
            int n3;
            int n4;
            byte[] byArray2;
            zzjs zzjs2 = this;
            if (zzjs2.zzapy != zzjs2.zzapw) {
                byArray2 = zzapm.getAndSet(null);
                if (byArray2 == null) {
                    byArray2 = new byte[4096];
                }
                while (zzjs2.zzapy != zzjs2.zzapw) {
                    n4 = (int)Math.min(zzjs2.zzapw - zzjs2.zzapy, (long)byArray2.length);
                    n3 = zzjs2.zzapv.read(byArray2, 0, n4);
                    if (Thread.interrupted()) {
                        throw new InterruptedIOException();
                    }
                    if (n3 == -1) {
                        throw new EOFException();
                    }
                    zzjs2.zzapy += (long)n3;
                    if (zzjs2.zzaoz == null) continue;
                    zzjs2.zzaoz.zzab(n3);
                }
                zzapm.set(byArray2);
            }
            n3 = n2;
            n4 = n;
            byArray2 = byArray;
            zzjs2 = this;
            n3 = zzjs2.zzapx == -1L ? n3 : (int)Math.min((long)n3, zzjs2.zzapx - zzjs2.zzce);
            if (n3 == 0) {
                return -1;
            }
            int n5 = zzjs2.zzapv.read(byArray2, n4, n3);
            if (n5 == -1) {
                if (zzjs2.zzapx != -1L && zzjs2.zzapx != zzjs2.zzce) {
                    throw new EOFException();
                }
                return -1;
            }
            zzjs2.zzce += (long)n5;
            if (zzjs2.zzaoz != null) {
                zzjs2.zzaoz.zzab(n5);
            }
            return n5;
        }
        catch (IOException iOException) {
            throw new zzjx(iOException, this.zzapt);
        }
    }

    @Override
    public final void close() throws zzjx {
        try {
            if (this.zzapv != null) {
                block15: {
                    Object object = this;
                    long l = ((zzjs)object).zzapx == -1L ? ((zzjs)object).zzapx : ((zzjs)object).zzapx - ((zzjs)object).zzce;
                    object = this.zzapu;
                    if (zzkq.SDK_INT == 19 || zzkq.SDK_INT == 20) {
                        InputStream inputStream = ((URLConnection)object).getInputStream();
                        if (l != -1L ? l <= 2048L : inputStream.read() == -1) break block15;
                        try {
                            String string2 = inputStream.getClass().getName();
                            if (string2.equals("com.android.okhttp.internal.http.HttpTransport$ChunkedInputStream") || string2.equals("com.android.okhttp.internal.http.HttpTransport$FixedLengthInputStream")) {
                                Method method = inputStream.getClass().getSuperclass().getDeclaredMethod("unexpectedEndOfInput", new Class[0]);
                                method.setAccessible(true);
                                method.invoke((Object)inputStream, new Object[0]);
                            }
                        }
                        catch (IOException iOException) {
                        }
                        catch (Exception exception) {}
                    }
                }
                try {
                    this.zzapv.close();
                }
                catch (IOException iOException) {
                    throw new zzjx(iOException, this.zzapt);
                }
                this.zzapv = null;
            }
            if (this.zzapd) {
                this.zzapd = false;
                if (this.zzaoz != null) {
                    this.zzaoz.zzgd();
                }
                this.closeConnection();
                return;
            }
        }
        catch (Throwable throwable) {
            if (this.zzapd) {
                this.zzapd = false;
                if (this.zzaoz != null) {
                    this.zzaoz.zzgd();
                }
                this.closeConnection();
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final HttpURLConnection zza(URL uRL, long l, long l2, boolean bl) throws IOException {
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
        httpURLConnection.setConnectTimeout(this.zzapo);
        httpURLConnection.setReadTimeout(this.zzapp);
        httpURLConnection.setDoOutput(false);
        Object object = this.zzaps;
        synchronized (object) {
            for (Map.Entry<String, String> entry : this.zzaps.entrySet()) {
                httpURLConnection.setRequestProperty(entry.getKey(), entry.getValue());
            }
        }
        if (l != 0L || l2 != -1L) {
            object = new StringBuilder(27).append("bytes=").append(l).append("-").toString();
            if (l2 != -1L) {
                String string2 = String.valueOf(object);
                long l3 = l + l2 - 1L;
                object = new StringBuilder(20 + String.valueOf(string2).length()).append(string2).append(l3).toString();
            }
            httpURLConnection.setRequestProperty("Range", (String)object);
        }
        httpURLConnection.setRequestProperty("User-Agent", this.zzapq);
        if (!bl) {
            httpURLConnection.setRequestProperty("Accept-Encoding", "identity");
        }
        return httpURLConnection;
    }

    private static long zzc(HttpURLConnection httpURLConnection) {
        Matcher matcher;
        String string2;
        long l = -1L;
        String string3 = httpURLConnection.getHeaderField("Content-Length");
        if (!TextUtils.isEmpty((CharSequence)string3)) {
            try {
                l = Long.parseLong(string3);
            }
            catch (NumberFormatException numberFormatException) {
                Log.e((String)"HttpDataSource", (String)new StringBuilder(28 + String.valueOf(string3).length()).append("Unexpected Content-Length [").append(string3).append("]").toString());
            }
        }
        if (!TextUtils.isEmpty((CharSequence)(string2 = httpURLConnection.getHeaderField("Content-Range"))) && (matcher = zzapl.matcher(string2)).find()) {
            try {
                long l2 = Long.parseLong(matcher.group(2)) - Long.parseLong(matcher.group(1)) + 1L;
                if (l < 0L) {
                    l = l2;
                } else if (l != l2) {
                    Log.w((String)"HttpDataSource", (String)new StringBuilder(26 + String.valueOf(string3).length() + String.valueOf(string2).length()).append("Inconsistent headers [").append(string3).append("] [").append(string2).append("]").toString());
                    l = Math.max(l, l2);
                }
            }
            catch (NumberFormatException numberFormatException) {
                Log.e((String)"HttpDataSource", (String)new StringBuilder(27 + String.valueOf(string2).length()).append("Unexpected Content-Range [").append(string2).append("]").toString());
            }
        }
        return l;
    }

    private final void closeConnection() {
        if (this.zzapu != null) {
            this.zzapu.disconnect();
            this.zzapu = null;
        }
    }
}

