/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.ActivityManager;
import android.app.KeyguardManager;
import android.content.Context;
import android.graphics.Rect;
import android.os.PowerManager;
import android.os.Process;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebView;
import android.widget.EditText;
import android.widget.TextView;
import androidx.annotation.Nullable;
import com.google.android.gms.ads.internal.zzk;
import com.google.android.gms.common.util.PlatformVersion;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.ads.zzacj;
import com.google.android.gms.internal.ads.zzacu;
import com.google.android.gms.internal.ads.zzard;
import com.google.android.gms.internal.ads.zzawz;
import com.google.android.gms.internal.ads.zzbgz;
import com.google.android.gms.internal.ads.zzuo;
import com.google.android.gms.internal.ads.zzup;
import com.google.android.gms.internal.ads.zzuv;
import com.google.android.gms.internal.ads.zzuw;
import com.google.android.gms.internal.ads.zzuy;
import com.google.android.gms.internal.ads.zzyt;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import org.json.JSONException;
import org.json.JSONObject;

@zzard
@ParametersAreNonnullByDefault
@TargetApi(value=14)
public final class zzuu
extends Thread {
    private boolean started = false;
    private boolean zzbuz = false;
    private boolean zzbva = false;
    private final Object lock;
    private final zzup zzbvb;
    private final int zzbvc;
    private final int zzbtz;
    private final int zzbvd;
    private final int zzbub;
    private final int zzbve;
    private final int zzbvf;
    private final int zzbvg;
    private final int zzbvh;
    private final String zzbvi;
    private final boolean zzbvj;
    private final boolean zzbuc;
    private final boolean zzbvk;

    public zzuu() {
        this(new zzup());
    }

    @VisibleForTesting
    private zzuu(zzup zzup2) {
        this.zzbvb = zzup2;
        this.lock = new Object();
        zzacj zzacj2 = zzacu.zzcnb;
        this.zzbtz = (Integer)zzyt.zzpe().zzd(zzacj2);
        zzacj2 = zzacu.zzcnc;
        this.zzbvd = (Integer)zzyt.zzpe().zzd(zzacj2);
        zzacj2 = zzacu.zzcnd;
        this.zzbub = (Integer)zzyt.zzpe().zzd(zzacj2);
        zzacj2 = zzacu.zzcne;
        this.zzbve = (Integer)zzyt.zzpe().zzd(zzacj2);
        zzacj2 = zzacu.zzcng;
        this.zzbvf = (Integer)zzyt.zzpe().zzd(zzacj2);
        zzacj2 = zzacu.zzcnh;
        this.zzbvg = (Integer)zzyt.zzpe().zzd(zzacj2);
        zzacj2 = zzacu.zzcni;
        this.zzbvh = (Integer)zzyt.zzpe().zzd(zzacj2);
        zzacj2 = zzacu.zzcnf;
        this.zzbvc = (Integer)zzyt.zzpe().zzd(zzacj2);
        zzacj2 = zzacu.zzcnk;
        this.zzbvi = (String)zzyt.zzpe().zzd(zzacj2);
        zzacj2 = zzacu.zzcnl;
        this.zzbvj = (Boolean)zzyt.zzpe().zzd(zzacj2);
        zzacj2 = zzacu.zzcnp;
        this.zzbuc = (Boolean)zzyt.zzpe().zzd(zzacj2);
        zzacj2 = zzacu.zzcnq;
        this.zzbvk = (Boolean)zzyt.zzpe().zzd(zzacj2);
        this.setName("ContentFetchTask");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzmv() {
        Object object = this.lock;
        synchronized (object) {
            if (this.started) {
                zzawz.zzdp((String)"Content hash thread already started, quiting...");
                return;
            }
            this.started = true;
        }
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        while (true) {
            Object object;
            try {
                if (zzuu.zzmw()) {
                    object = zzk.zzlj().getActivity();
                    if (object == null) {
                        zzawz.zzdp((String)"ContentFetchThread: no activity. Sleeping.");
                        this.zzmy();
                    } else {
                        Activity activity = object;
                        zzuu zzuu2 = this;
                        if (activity != null) {
                            View view = null;
                            try {
                                if (activity.getWindow() != null && activity.getWindow().getDecorView() != null) {
                                    view = activity.getWindow().getDecorView().findViewById(0x1020002);
                                }
                            }
                            catch (Exception exception) {
                                zzk.zzlk().zza(exception, "ContentFetchTask.extractContent");
                                zzawz.zzdp((String)"Failed getting root view of activity. Content not extracted.");
                            }
                            if (view != null) {
                                View view2 = view;
                                zzuu zzuu3 = zzuu2;
                                if (view2 != null) {
                                    view2.post((Runnable)new zzuv(zzuu3, view2));
                                }
                            }
                        }
                    }
                } else {
                    zzawz.zzdp((String)"ContentFetchTask: sleeping");
                    this.zzmy();
                }
                Thread.sleep(this.zzbvc * 1000);
            }
            catch (InterruptedException interruptedException) {
                zzawz.zzc((String)"Error in ContentFetchTask", (Throwable)interruptedException);
            }
            catch (Exception exception) {
                zzawz.zzc((String)"Error in ContentFetchTask", (Throwable)exception);
                zzk.zzlk().zza(exception, "ContentFetchTask.run");
            }
            object = this.lock;
            synchronized (object) {
                while (this.zzbuz) {
                    try {
                        zzawz.zzdp((String)"ContentFetchTask: waiting");
                        this.lock.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }

    @VisibleForTesting
    final void zzi(View view) {
        try {
            zzuo zzuo2 = new zzuo(this.zzbtz, this.zzbvd, this.zzbub, this.zzbve, this.zzbvf, this.zzbvg, this.zzbvh, this.zzbuc);
            Context context = zzk.zzlj().getContext();
            if (context != null && !TextUtils.isEmpty((CharSequence)this.zzbvi)) {
                zzacj zzacj2 = zzacu.zzcnj;
                int n = context.getResources().getIdentifier((String)zzyt.zzpe().zzd(zzacj2), "id", context.getPackageName());
                String string2 = (String)view.getTag(n);
                if (string2 != null && string2.equals(this.zzbvi)) {
                    return;
                }
            }
            zzuy zzuy2 = this.zza(view, zzuo2);
            zzuo2.zzmt();
            if (zzuy2.zzbvs == 0 && zzuy2.zzbvt == 0) {
                return;
            }
            if (zzuy2.zzbvt == 0 && zzuo2.zzmu() == 0) {
                return;
            }
            if (zzuy2.zzbvt == 0 && this.zzbvb.zza(zzuo2)) {
                return;
            }
            this.zzbvb.zzc(zzuo2);
            return;
        }
        catch (Exception exception) {
            zzawz.zzc((String)"Exception in fetchContentOnUIThread", (Throwable)exception);
            zzk.zzlk().zza(exception, "ContentFetchTask.fetchContent");
            return;
        }
    }

    @VisibleForTesting
    private static boolean zzmw() {
        try {
            Context context = zzk.zzlj().getContext();
            if (context == null) {
                return false;
            }
            ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
            KeyguardManager keyguardManager = (KeyguardManager)context.getSystemService("keyguard");
            if (activityManager == null || keyguardManager == null) {
                return false;
            }
            List list = activityManager.getRunningAppProcesses();
            if (list == null) {
                return false;
            }
            for (ActivityManager.RunningAppProcessInfo runningAppProcessInfo : list) {
                PowerManager powerManager;
                if (Process.myPid() != runningAppProcessInfo.pid) continue;
                if (runningAppProcessInfo.importance != 100 || keyguardManager.inKeyguardRestrictedInputMode() || !((powerManager = (PowerManager)context.getSystemService("power")) == null ? false : powerManager.isScreenOn())) break;
                return true;
            }
            return false;
        }
        catch (Throwable throwable) {
            zzk.zzlk().zza(throwable, "ContentFetchTask.isInForeground");
            return false;
        }
    }

    @VisibleForTesting
    private final zzuy zza(@Nullable View view, zzuo zzuo2) {
        if (view == null) {
            return new zzuy(this, 0, 0);
        }
        Rect rect = new Rect();
        boolean bl = view.getGlobalVisibleRect(rect);
        if (view instanceof TextView && !(view instanceof EditText)) {
            CharSequence charSequence = ((TextView)view).getText();
            if (!TextUtils.isEmpty((CharSequence)charSequence)) {
                String string2 = charSequence.toString();
                zzuo2.zzb(string2, bl, view.getX(), view.getY(), view.getWidth(), view.getHeight());
                return new zzuy(this, 1, 0);
            }
            return new zzuy(this, 0, 0);
        }
        if (view instanceof WebView && !(view instanceof zzbgz)) {
            boolean bl2;
            zzuo zzuo3 = zzuo2;
            WebView webView = (WebView)view;
            zzuu zzuu2 = this;
            if (!PlatformVersion.isAtLeastKitKat()) {
                bl2 = false;
            } else {
                zzuo3.zzmr();
                webView.post((Runnable)new zzuw(zzuu2, zzuo3, webView, bl));
                bl2 = true;
            }
            if (bl2) {
                return new zzuy(this, 0, 1);
            }
            return new zzuy(this, 0, 0);
        }
        if (view instanceof ViewGroup) {
            ViewGroup viewGroup = (ViewGroup)view;
            int n = 0;
            int n2 = 0;
            for (int i = 0; i < viewGroup.getChildCount(); ++i) {
                zzuy zzuy2 = this.zza(viewGroup.getChildAt(i), zzuo2);
                n += zzuy2.zzbvs;
                n2 += zzuy2.zzbvt;
            }
            return new zzuy(this, n, n2);
        }
        return new zzuy(this, 0, 0);
    }

    @VisibleForTesting
    final void zza(zzuo zzuo2, WebView webView, String string2, boolean bl) {
        zzuo2.zzmq();
        try {
            if (!TextUtils.isEmpty((CharSequence)string2)) {
                String string3 = new JSONObject(string2).optString("text");
                if (!this.zzbvj && !TextUtils.isEmpty((CharSequence)webView.getTitle())) {
                    String string4 = webView.getTitle();
                    zzuo2.zza(new StringBuilder(1 + String.valueOf(string4).length() + String.valueOf(string3).length()).append(string4).append("\n").append(string3).toString(), bl, webView.getX(), webView.getY(), webView.getWidth(), webView.getHeight());
                } else {
                    zzuo2.zza(string3, bl, webView.getX(), webView.getY(), webView.getWidth(), webView.getHeight());
                }
            }
            if (zzuo2.zzml()) {
                this.zzbvb.zzb(zzuo2);
            }
            return;
        }
        catch (JSONException jSONException) {
            zzawz.zzdp((String)"Json string may be malformed.");
            return;
        }
        catch (Throwable throwable) {
            zzawz.zzb((String)"Failed to get webview content.", (Throwable)throwable);
            zzk.zzlk().zza(throwable, "ContentFetchTask.processWebViewContent");
            return;
        }
    }

    public final zzuo zzmx() {
        return this.zzbvb.zzo(this.zzbvk);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void wakeup() {
        Object object = this.lock;
        synchronized (object) {
            this.zzbuz = false;
            this.lock.notifyAll();
            zzawz.zzdp((String)"ContentFetchThread: wakeup");
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zzmy() {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = this.zzbuz = true;
            zzawz.zzdp((String)new StringBuilder(42).append("ContentFetchThread: paused, mPause = ").append(bl).toString());
            return;
        }
    }

    public final boolean zzmz() {
        return this.zzbuz;
    }
}

