/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Bundle;
import android.os.RemoteException;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import androidx.annotation.Nullable;
import com.google.android.gms.ads.internal.zzk;
import com.google.android.gms.ads.internal.zzm;
import com.google.android.gms.ads.internal.zzn;
import com.google.android.gms.ads.internal.zzo;
import com.google.android.gms.ads.internal.zzp;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.ObjectWrapper;
import com.google.android.gms.internal.ads.zzaas;
import com.google.android.gms.internal.ads.zzabd;
import com.google.android.gms.internal.ads.zzapq;
import com.google.android.gms.internal.ads.zzapw;
import com.google.android.gms.internal.ads.zzasn;
import com.google.android.gms.internal.ads.zzawr;
import com.google.android.gms.internal.ads.zzazm;
import com.google.android.gms.internal.ads.zzazz;
import com.google.android.gms.internal.ads.zzbab;
import com.google.android.gms.internal.ads.zzdt;
import com.google.android.gms.internal.ads.zzdw;
import com.google.android.gms.internal.ads.zzrn;
import com.google.android.gms.internal.ads.zzuj;
import com.google.android.gms.internal.ads.zzum;
import com.google.android.gms.internal.ads.zzut;
import com.google.android.gms.internal.ads.zzvj;
import com.google.android.gms.internal.ads.zzvl;
import com.google.android.gms.internal.ads.zzvm;
import com.google.android.gms.internal.ads.zzvy;
import com.google.android.gms.internal.ads.zzwc;
import com.google.android.gms.internal.ads.zzwh;
import com.google.android.gms.internal.ads.zzwn;
import com.google.android.gms.internal.ads.zzxf;
import com.google.android.gms.internal.ads.zzxg;
import com.google.android.gms.internal.ads.zzxl;
import com.google.android.gms.internal.ads.zzxr;
import com.google.android.gms.internal.ads.zzze;
import java.util.Map;
import java.util.concurrent.Future;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public final class zzl
extends zzvy {
    private final zzazz zzbmo;
    private final zzum zzbmp;
    private final Future<zzdt> zzbmq;
    private final Context zzvf;
    private final zzo zzbmr;
    @Nullable
    private WebView zzbms;
    @Nullable
    private zzvm zzbmt;
    @Nullable
    private zzdt zzbmu;
    private AsyncTask<Void, Void, String> zzbmv;

    public zzl(Context context, zzum zzum2, String string2, zzazz zzazz2) {
        this.zzvf = context;
        this.zzbmo = zzazz2;
        this.zzbmp = zzum2;
        this.zzbms = new WebView(this.zzvf);
        zzl zzl2 = this;
        this.zzbmq = zzbab.zzdzr.zzd(new zzm(zzl2));
        this.zzbmr = new zzo(context, string2);
        zzl2 = this;
        zzl2.zzbn(0);
        zzl2.zzbms.setVerticalScrollBarEnabled(false);
        zzl2.zzbms.getSettings().setJavaScriptEnabled(true);
        zzl2.zzbms.setWebViewClient((WebViewClient)new zzk(zzl2));
        zzl2.zzbms.setOnTouchListener((View.OnTouchListener)new zzn(zzl2));
    }

    public final IObjectWrapper zzke() throws RemoteException {
        Preconditions.checkMainThread((String)"getAdFrame must be called on the main UI thread.");
        return ObjectWrapper.wrap((Object)this.zzbms);
    }

    public final void destroy() throws RemoteException {
        Preconditions.checkMainThread((String)"destroy must be called on the main UI thread.");
        this.zzbmv.cancel(true);
        this.zzbmq.cancel(true);
        this.zzbms.destroy();
        this.zzbms = null;
    }

    public final boolean isReady() throws RemoteException {
        return false;
    }

    public final boolean zza(zzuj zzuj2) throws RemoteException {
        Preconditions.checkNotNull((Object)this.zzbms, (Object)"This Search Ad has already been torn down");
        this.zzbmr.zza(zzuj2, this.zzbmo);
        this.zzbmv = new zzp(this, null).execute(new Void[0]);
        return true;
    }

    public final void pause() throws RemoteException {
        Preconditions.checkMainThread((String)"pause must be called on the main UI thread.");
    }

    public final void resume() throws RemoteException {
        Preconditions.checkMainThread((String)"resume must be called on the main UI thread.");
    }

    public final void zza(zzvm zzvm2) throws RemoteException {
        this.zzbmt = zzvm2;
    }

    public final void zza(zzwh zzwh2) throws RemoteException {
        throw new IllegalStateException("Unused method");
    }

    public final void zza(zzwc zzwc2) {
        throw new IllegalStateException("Unused method");
    }

    public final Bundle getAdMetadata() {
        throw new IllegalStateException("Unused method");
    }

    public final void showInterstitial() throws RemoteException {
        throw new IllegalStateException("Unused method");
    }

    public final void stopLoading() throws RemoteException {
    }

    public final void zzkf() throws RemoteException {
        throw new IllegalStateException("Unused method");
    }

    public final zzum zzkg() throws RemoteException {
        return this.zzbmp;
    }

    public final void zza(zzum zzum2) throws RemoteException {
        throw new IllegalStateException("AdSize must be set before initialization");
    }

    public final void zza(zzapq zzapq2) throws RemoteException {
        throw new IllegalStateException("Unused method");
    }

    public final void zza(zzapw zzapw2, String string2) throws RemoteException {
        throw new IllegalStateException("Unused method");
    }

    @Nullable
    public final String getMediationAdapterClassName() throws RemoteException {
        return null;
    }

    @Nullable
    public final String zzkh() throws RemoteException {
        return null;
    }

    @Nullable
    public final zzxg zzki() {
        return null;
    }

    public final String getAdUnitId() {
        throw new IllegalStateException("getAdUnitId not implemented");
    }

    public final zzwh zzkj() {
        throw new IllegalStateException("getIAppEventListener not implemented");
    }

    public final zzvm zzkk() {
        throw new IllegalStateException("getIAdListener not implemented");
    }

    public final void zza(zzaas zzaas2) throws RemoteException {
        throw new IllegalStateException("Unused method");
    }

    public final void zza(zzvl zzvl2) throws RemoteException {
        throw new IllegalStateException("Unused method");
    }

    public final void zza(zzwn zzwn2) throws RemoteException {
        throw new IllegalStateException("Unused method");
    }

    public final void setManualImpressionsEnabled(boolean bl) throws RemoteException {
    }

    public final boolean isLoading() throws RemoteException {
        return false;
    }

    public final void zza(zzasn zzasn2) throws RemoteException {
        throw new IllegalStateException("Unused method");
    }

    public final void setUserId(String string2) throws RemoteException {
        throw new IllegalStateException("Unused method");
    }

    public final void zzbn(String string2) {
        throw new IllegalStateException("Unused method");
    }

    @Nullable
    public final zzxl getVideoController() {
        return null;
    }

    public final void zza(zzze zzze2) {
        throw new IllegalStateException("Unused method");
    }

    public final void zza(zzxr zzxr2) {
        throw new IllegalStateException("Unused method");
    }

    public final void zza(zzut zzut2) {
        throw new IllegalStateException("Unused method");
    }

    public final void zza(zzrn zzrn2) throws RemoteException {
        throw new IllegalStateException("Unused method");
    }

    public final void setImmersiveMode(boolean bl) {
        throw new IllegalStateException("Unused method");
    }

    @VisibleForTesting
    final int zzbo(String string2) {
        String string3 = Uri.parse((String)string2).getQueryParameter("height");
        if (TextUtils.isEmpty((CharSequence)string3)) {
            return 0;
        }
        try {
            zzvj.zzpr();
            return zzazm.zzc((Context)this.zzvf, (int)Integer.parseInt(string3));
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    @VisibleForTesting
    final void zzbn(int n) {
        if (this.zzbms == null) {
            return;
        }
        ViewGroup.LayoutParams layoutParams = new ViewGroup.LayoutParams(-1, n);
        this.zzbms.setLayoutParams(layoutParams);
    }

    @VisibleForTesting
    final String zzkl() {
        String string22;
        Uri.Builder builder = new Uri.Builder();
        builder.scheme("https://").appendEncodedPath((String)zzabd.zzcvr.get());
        builder.appendQueryParameter("query", this.zzbmr.getQuery());
        builder.appendQueryParameter("pubId", this.zzbmr.zzko());
        Map<String, String> map = this.zzbmr.zzkp();
        for (String string22 : map.keySet()) {
            builder.appendQueryParameter(string22, map.get(string22));
        }
        Uri uri = builder.build();
        if (this.zzbmu != null) {
            try {
                uri = this.zzbmu.zza(uri, this.zzvf);
            }
            catch (zzdw zzdw2) {
                zzawr.zzd((String)"Unable to process ad data", (Throwable)zzdw2);
            }
        }
        string22 = this.zzkm();
        String string3 = uri.getEncodedQuery();
        return new StringBuilder(1 + String.valueOf(string22).length() + String.valueOf(string3).length()).append(string22).append("#").append(string3).toString();
    }

    @VisibleForTesting
    final String zzkm() {
        String string2 = this.zzbmr.zzkn();
        if (TextUtils.isEmpty((CharSequence)string2)) {
            string2 = "www.google.com";
        }
        String string3 = string2;
        String string4 = (String)zzabd.zzcvr.get();
        return new StringBuilder(8 + String.valueOf(string3).length() + String.valueOf(string4).length()).append("https://").append(string3).append(string4).toString();
    }

    private final String zzbp(String string2) {
        if (this.zzbmu == null) {
            return string2;
        }
        Uri uri = Uri.parse((String)string2);
        try {
            Context context = this.zzvf;
            Uri uri2 = uri;
            Context context2 = context;
            Uri uri3 = uri2;
            uri = this.zzbmu.zza(uri2, context2, null, null);
        }
        catch (zzdw zzdw2) {
            zzawr.zzd((String)"Unable to process ad data", (Throwable)zzdw2);
        }
        return uri.toString();
    }

    private final void zzbq(String string2) {
        Intent intent = new Intent("android.intent.action.VIEW");
        intent.setData(Uri.parse((String)string2));
        this.zzvf.startActivity(intent);
    }

    public final void zza(zzxf zzxf2) {
    }

    static /* synthetic */ zzvm zza(zzl zzl2) {
        return zzl2.zzbmt;
    }

    static /* synthetic */ String zza(zzl zzl2, String string2) {
        return zzl2.zzbp(string2);
    }

    static /* synthetic */ void zzb(zzl zzl2, String string2) {
        zzl2.zzbq(string2);
    }

    static /* synthetic */ zzdt zzb(zzl zzl2) {
        return zzl2.zzbmu;
    }

    static /* synthetic */ zzazz zzc(zzl zzl2) {
        return zzl2.zzbmo;
    }

    static /* synthetic */ Context zzd(zzl zzl2) {
        return zzl2.zzvf;
    }

    static /* synthetic */ zzdt zza(zzl zzl2, zzdt zzdt2) {
        zzl2.zzbmu = zzdt2;
        return zzl2.zzbmu;
    }

    static /* synthetic */ Future zze(zzl zzl2) {
        return zzl2.zzbmq;
    }

    static /* synthetic */ WebView zzf(zzl zzl2) {
        return zzl2.zzbms;
    }
}

