/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.os.SystemClock;
import android.text.TextUtils;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.internal.ads.zza;
import com.google.android.gms.internal.ads.zzag;
import com.google.android.gms.internal.ads.zzan;
import com.google.android.gms.internal.ads.zzao;
import com.google.android.gms.internal.ads.zzap;
import com.google.android.gms.internal.ads.zzaq;
import com.google.android.gms.internal.ads.zzd;
import com.google.android.gms.internal.ads.zzk;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public final class zzal
implements zza {
    private final Map<String, zzan> zzbx = new LinkedHashMap<String, zzan>(16, 0.75f, true);
    private long zzby = 0L;
    private final zzap zzbz;
    private final int zzca;

    public zzal(File file, int n) {
        this.zzbz = new zzao(this, file);
        this.zzca = 0x1400000;
    }

    private zzal(zzap zzap2, int n) {
        this.zzbz = zzap2;
        this.zzca = 0x500000;
    }

    public zzal(zzap zzap2) {
        this(zzap2, 0x500000);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final synchronized zzd zza(String string2) {
        zzan zzan2 = this.zzbx.get(string2);
        if (zzan2 == null) {
            return null;
        }
        File file = this.zze(string2);
        try (zzaq zzaq2 = new zzaq(new BufferedInputStream(zzal.zza(file)), file.length());){
            byte[] byArray;
            zzan zzan3 = zzan.zzc(zzaq2);
            if (!TextUtils.equals((CharSequence)string2, (CharSequence)zzan3.zzcc)) {
                zzag.d("%s: key=%s, found=%s", file.getAbsolutePath(), string2, zzan3.zzcc);
                this.removeEntry(string2);
                return null;
            }
            byte[] byArray2 = byArray = zzal.zza(zzaq2, zzaq2.zzp());
            zzan zzan4 = zzan2;
            zzd zzd2 = new zzd();
            new zzd().data = byArray2;
            zzd2.zzg = zzan4.zzg;
            zzd2.zzh = zzan4.zzh;
            zzd2.zzi = zzan4.zzi;
            zzd2.zzj = zzan4.zzj;
            zzd2.zzk = zzan4.zzk;
            List<zzk> list = zzan4.zzm;
            TreeMap<String, String> treeMap = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
            for (zzk zzk2 : list) {
                treeMap.put(zzk2.getName(), zzk2.getValue());
            }
            zzd2.zzl = treeMap;
            zzd2.zzm = Collections.unmodifiableList(zzan4.zzm);
            zzd zzd3 = zzd2;
            return zzd3;
        }
        catch (IOException iOException) {
            zzag.d("%s: %s", file.getAbsolutePath(), iOException.toString());
            this.remove(string2);
            return null;
        }
    }

    @Override
    public final synchronized void initialize() {
        File file = this.zzbz.zzo();
        if (!file.exists()) {
            if (!file.mkdirs()) {
                zzag.e("Unable to create cache dir %s", file.getAbsolutePath());
            }
            return;
        }
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return;
        }
        File[] fileArray2 = fileArray;
        int n = fileArray.length;
        for (int i = 0; i < n; ++i) {
            File file2 = fileArray2[i];
            try {
                long l = file2.length();
                try (zzaq zzaq2 = new zzaq(new BufferedInputStream(zzal.zza(file2)), l);){
                    zzan zzan2 = zzan.zzc(zzaq2);
                    zzan.zzc(zzaq2).zzcb = l;
                    this.zza(zzan2.zzcc, zzan2);
                    continue;
                }
            }
            catch (IOException iOException) {
                file2.delete();
            }
        }
    }

    @Override
    public final synchronized void zza(String string2, zzd zzd2) {
        if (this.zzby + (long)zzd2.data.length > (long)this.zzca && (float)zzd2.data.length > (float)this.zzca * 0.9f) {
            return;
        }
        File file = this.zze(string2);
        try {
            Object object = file;
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream((File)object));
            zzan zzan2 = new zzan(string2, zzd2);
            if (!zzan2.zza(bufferedOutputStream)) {
                bufferedOutputStream.close();
                zzag.d("Failed to write header for %s", file.getAbsolutePath());
                throw new IOException();
            }
            bufferedOutputStream.write(zzd2.data);
            bufferedOutputStream.close();
            zzan2.zzcb = file.length();
            this.zza(string2, zzan2);
            object = this;
            if (((zzal)object).zzby >= (long)((zzal)object).zzca) {
                if (zzag.DEBUG) {
                    zzag.v("Pruning old cache entries.", new Object[0]);
                }
                long l = ((zzal)object).zzby;
                int n = 0;
                long l2 = SystemClock.elapsedRealtime();
                Iterator<Map.Entry<String, zzan>> iterator = ((zzal)object).zzbx.entrySet().iterator();
                while (iterator.hasNext()) {
                    zzan zzan3 = iterator.next().getValue();
                    if (super.zze(zzan3.zzcc).delete()) {
                        ((zzal)object).zzby -= zzan3.zzcb;
                    } else {
                        zzag.d("Could not delete cache entry for key=%s, filename=%s", zzan3.zzcc, zzal.zzd(zzan3.zzcc));
                    }
                    iterator.remove();
                    ++n;
                    if (!((float)((zzal)object).zzby < (float)((zzal)object).zzca * 0.9f)) continue;
                }
                if (zzag.DEBUG) {
                    zzag.v("pruned %d files, %d bytes, %d ms", n, ((zzal)object).zzby - l, SystemClock.elapsedRealtime() - l2);
                }
            }
            return;
        }
        catch (IOException iOException) {
            if (!file.delete()) {
                zzag.d("Could not clean up file %s", file.getAbsolutePath());
            }
            return;
        }
    }

    private final synchronized void remove(String string2) {
        boolean bl = this.zze(string2).delete();
        this.removeEntry(string2);
        if (!bl) {
            zzag.d("Could not delete cache entry for key=%s, filename=%s", string2, zzal.zzd(string2));
        }
    }

    private static String zzd(String string2) {
        int n = string2.length() / 2;
        String string3 = String.valueOf(String.valueOf(string2.substring(0, n).hashCode()));
        String string4 = String.valueOf(String.valueOf(string2.substring(n).hashCode()));
        if (string4.length() != 0) {
            return string3.concat(string4);
        }
        return new String(string3);
    }

    private final File zze(String string2) {
        return new File(this.zzbz.zzo(), zzal.zzd(string2));
    }

    private final void zza(String string2, zzan zzan2) {
        if (!this.zzbx.containsKey(string2)) {
            this.zzby += zzan2.zzcb;
        } else {
            zzan zzan3 = this.zzbx.get(string2);
            this.zzby += zzan2.zzcb - zzan3.zzcb;
        }
        this.zzbx.put(string2, zzan2);
    }

    private final void removeEntry(String string2) {
        zzan zzan2 = this.zzbx.remove(string2);
        if (zzan2 != null) {
            this.zzby -= zzan2.zzcb;
        }
    }

    @VisibleForTesting
    private static byte[] zza(zzaq zzaq2, long l) throws IOException {
        long l2 = zzaq2.zzp();
        if (l < 0L || l > l2 || (long)((int)l) != l) {
            throw new IOException(new StringBuilder(73).append("streamToBytes length=").append(l).append(", maxLength=").append(l2).toString());
        }
        byte[] byArray = new byte[(int)l];
        new DataInputStream(zzaq2).readFully(byArray);
        return byArray;
    }

    @VisibleForTesting
    private static InputStream zza(File file) throws FileNotFoundException {
        return new FileInputStream(file);
    }

    private static int zza(InputStream inputStream) throws IOException {
        int n = inputStream.read();
        if (n == -1) {
            throw new EOFException();
        }
        return n;
    }

    static void zza(OutputStream outputStream, int n) throws IOException {
        outputStream.write(n & 0xFF);
        outputStream.write(n >> 8 & 0xFF);
        outputStream.write(n >> 16 & 0xFF);
        outputStream.write(n >>> 24);
    }

    static int zzb(InputStream inputStream) throws IOException {
        return 0 | zzal.zza(inputStream) | zzal.zza(inputStream) << 8 | zzal.zza(inputStream) << 16 | zzal.zza(inputStream) << 24;
    }

    static void zza(OutputStream outputStream, long l) throws IOException {
        outputStream.write((byte)l);
        outputStream.write((byte)(l >>> 8));
        outputStream.write((byte)(l >>> 16));
        outputStream.write((byte)(l >>> 24));
        outputStream.write((byte)(l >>> 32));
        outputStream.write((byte)(l >>> 40));
        outputStream.write((byte)(l >>> 48));
        outputStream.write((byte)(l >>> 56));
    }

    static long zzc(InputStream inputStream) throws IOException {
        return 0L | (long)zzal.zza(inputStream) & 0xFFL | ((long)zzal.zza(inputStream) & 0xFFL) << 8 | ((long)zzal.zza(inputStream) & 0xFFL) << 16 | ((long)zzal.zza(inputStream) & 0xFFL) << 24 | ((long)zzal.zza(inputStream) & 0xFFL) << 32 | ((long)zzal.zza(inputStream) & 0xFFL) << 40 | ((long)zzal.zza(inputStream) & 0xFFL) << 48 | ((long)zzal.zza(inputStream) & 0xFFL) << 56;
    }

    static void zza(OutputStream outputStream, String string2) throws IOException {
        byte[] byArray = string2.getBytes("UTF-8");
        zzal.zza(outputStream, (long)byArray.length);
        outputStream.write(byArray, 0, byArray.length);
    }

    static String zza(zzaq zzaq2) throws IOException {
        long l = zzal.zzc(zzaq2);
        byte[] byArray = zzal.zza(zzaq2, l);
        return new String(byArray, "UTF-8");
    }

    static List<zzk> zzb(zzaq zzaq2) throws IOException {
        int n = zzal.zzb((InputStream)zzaq2);
        if (n < 0) {
            throw new IOException(new StringBuilder(31).append("readHeaderList size=").append(n).toString());
        }
        ArrayList<zzk> arrayList = n == 0 ? Collections.emptyList() : new ArrayList<zzk>();
        for (int i = 0; i < n; ++i) {
            String string2 = zzal.zza(zzaq2).intern();
            String string3 = zzal.zza(zzaq2).intern();
            arrayList.add(new zzk(string2, string3));
        }
        return arrayList;
    }
}

