/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.app.Activity;
import android.content.Context;
import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;
import androidx.browser.customtabs.CustomTabsIntent;
import com.google.android.gms.ads.internal.overlay.AdOverlayInfoParcel;
import com.google.android.gms.ads.internal.overlay.zzd;
import com.google.android.gms.ads.internal.zzq;
import com.google.android.gms.ads.mediation.MediationAdRequest;
import com.google.android.gms.ads.mediation.MediationInterstitialAdapter;
import com.google.android.gms.ads.mediation.MediationInterstitialListener;
import com.google.android.gms.common.util.PlatformVersion;
import com.google.android.gms.internal.ads.zzaaw;
import com.google.android.gms.internal.ads.zzaok;
import com.google.android.gms.internal.ads.zzaon;
import com.google.android.gms.internal.ads.zzaxa;
import com.google.android.gms.internal.ads.zzazw;
import com.google.android.gms.internal.ads.zzazz;

public final class zzaol
implements MediationInterstitialAdapter {
    private Activity zzdia;
    private MediationInterstitialListener zzdib;
    private Uri uri;

    public final void requestInterstitialAd(Context context, MediationInterstitialListener mediationInterstitialListener, Bundle bundle, MediationAdRequest mediationAdRequest, Bundle bundle2) {
        this.zzdib = mediationInterstitialListener;
        if (this.zzdib == null) {
            zzazw.zzfc((String)"Listener not set for mediation. Returning.");
            return;
        }
        if (!(context instanceof Activity)) {
            zzazw.zzfc((String)"AdMobCustomTabs can only work with Activity context. Bailing out.");
            this.zzdib.onAdFailedToLoad((MediationInterstitialAdapter)this, 0);
            return;
        }
        Context context2 = context;
        if (!(PlatformVersion.isAtLeastIceCreamSandwichMR1() && zzaaw.zzj(context2))) {
            zzazw.zzfc((String)"Default browser does not support custom tabs. Bailing out.");
            this.zzdib.onAdFailedToLoad((MediationInterstitialAdapter)this, 0);
            return;
        }
        String string2 = bundle.getString("tab_url");
        if (TextUtils.isEmpty((CharSequence)string2)) {
            zzazw.zzfc((String)"The tab_url retrieved from mediation metadata is empty. Bailing out.");
            this.zzdib.onAdFailedToLoad((MediationInterstitialAdapter)this, 0);
            return;
        }
        this.zzdia = (Activity)context;
        this.uri = Uri.parse((String)string2);
        this.zzdib.onAdLoaded((MediationInterstitialAdapter)this);
    }

    public final void showInterstitial() {
        CustomTabsIntent customTabsIntent = new CustomTabsIntent.Builder().build();
        customTabsIntent.intent.setData(this.uri);
        zzd zzd2 = new zzd(customTabsIntent.intent);
        AdOverlayInfoParcel adOverlayInfoParcel = new AdOverlayInfoParcel(zzd2, null, new zzaok(this), null, new zzazz(0, 0, false));
        zzaxa.zzdwf.post((Runnable)new zzaon(this, adOverlayInfoParcel));
        zzq.zzla().zzvx();
    }

    public final void onDestroy() {
        zzazw.zzed((String)"Destroying AdMobCustomTabsAdapter adapter.");
    }

    public final void onPause() {
        zzazw.zzed((String)"Pausing AdMobCustomTabsAdapter adapter.");
    }

    public final void onResume() {
        zzazw.zzed((String)"Resuming AdMobCustomTabsAdapter adapter.");
    }

    static /* synthetic */ MediationInterstitialListener zza(zzaol zzaol2) {
        return zzaol2.zzdib;
    }

    static /* synthetic */ Activity zzb(zzaol zzaol2) {
        return zzaol2.zzdia;
    }
}

