/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.annotation.TargetApi;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.res.Resources;
import android.provider.CalendarContract;
import android.text.TextUtils;
import com.google.android.gms.ads.impl.R;
import com.google.android.gms.ads.internal.zzq;
import com.google.android.gms.internal.ads.zzaoo;
import com.google.android.gms.internal.ads.zzaop;
import com.google.android.gms.internal.ads.zzapb;
import com.google.android.gms.internal.ads.zzaxa;
import com.google.android.gms.internal.ads.zzbek;
import java.util.Map;

public final class zzaom
extends zzapb {
    private final Map<String, String> zzcux;
    private final Context zzvf;
    private String zzdic;
    private long zzdid;
    private long zzdie;
    private String zzdif;
    private String zzdig;

    public zzaom(zzbek zzbek2, Map<String, String> map) {
        super(zzbek2, "createCalendarEvent");
        this.zzcux = map;
        this.zzvf = zzbek2.zzzh();
        zzaom zzaom2 = this;
        zzaom2.zzdic = zzaom2.zzdt("description");
        zzaom2.zzdif = zzaom2.zzdt("summary");
        zzaom2.zzdid = zzaom2.zzdu("start_ticks");
        zzaom2.zzdie = zzaom2.zzdu("end_ticks");
        zzaom2.zzdig = zzaom2.zzdt("location");
    }

    private final String zzdt(String string2) {
        if (TextUtils.isEmpty((CharSequence)this.zzcux.get(string2))) {
            return "";
        }
        return this.zzcux.get(string2);
    }

    private final long zzdu(String string2) {
        String string3 = this.zzcux.get(string2);
        if (string3 == null) {
            return -1L;
        }
        try {
            return Long.parseLong(string3);
        }
        catch (NumberFormatException numberFormatException) {
            return -1L;
        }
    }

    public final void execute() {
        if (this.zzvf == null) {
            this.zzdv("Activity context is not available.");
            return;
        }
        zzq.zzkw();
        if (!zzaxa.zzas(this.zzvf).zzqy()) {
            this.zzdv("This feature is not available on the device.");
            return;
        }
        zzq.zzkw();
        AlertDialog.Builder builder = zzaxa.zzar(this.zzvf);
        Resources resources = zzq.zzla().getResources();
        builder.setTitle((CharSequence)(resources != null ? resources.getString(R.string.s5) : "Create calendar event"));
        builder.setMessage((CharSequence)(resources != null ? resources.getString(R.string.s6) : "Allow Ad to create a calendar event?"));
        builder.setPositiveButton((CharSequence)(resources != null ? resources.getString(R.string.s3) : "Accept"), (DialogInterface.OnClickListener)new zzaop(this));
        builder.setNegativeButton((CharSequence)(resources != null ? resources.getString(R.string.s4) : "Decline"), (DialogInterface.OnClickListener)new zzaoo(this));
        builder.create().show();
    }

    @TargetApi(value=14)
    final Intent createIntent() {
        Intent intent = new Intent("android.intent.action.EDIT").setData(CalendarContract.Events.CONTENT_URI);
        intent.putExtra("title", this.zzdic);
        intent.putExtra("eventLocation", this.zzdig);
        intent.putExtra("description", this.zzdif);
        if (this.zzdid > -1L) {
            intent.putExtra("beginTime", this.zzdid);
        }
        if (this.zzdie > -1L) {
            intent.putExtra("endTime", this.zzdie);
        }
        intent.setFlags(0x10000000);
        return intent;
    }

    static /* synthetic */ Context zza(zzaom zzaom2) {
        return zzaom2.zzvf;
    }
}

