/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.content.Context;
import android.graphics.Bitmap;
import android.view.View;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.ads.internal.zzq;
import com.google.android.gms.common.GoogleApiAvailabilityLight;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.PlatformVersion;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.internal.ads.zzabq;
import com.google.android.gms.internal.ads.zzaud;
import com.google.android.gms.internal.ads.zzauf;
import com.google.android.gms.internal.ads.zzaug;
import com.google.android.gms.internal.ads.zzauh;
import com.google.android.gms.internal.ads.zzaui;
import com.google.android.gms.internal.ads.zzaum;
import com.google.android.gms.internal.ads.zzaun;
import com.google.android.gms.internal.ads.zzauo;
import com.google.android.gms.internal.ads.zzaup;
import com.google.android.gms.internal.ads.zzaus;
import com.google.android.gms.internal.ads.zzawr;
import com.google.android.gms.internal.ads.zzaxa;
import com.google.android.gms.internal.ads.zzaym;
import com.google.android.gms.internal.ads.zzazz;
import com.google.android.gms.internal.ads.zzbab;
import com.google.android.gms.internal.ads.zzdqw;
import com.google.android.gms.internal.ads.zzdri;
import com.google.android.gms.internal.ads.zzeaq;
import com.google.android.gms.internal.ads.zzebd;
import com.google.android.gms.internal.ads.zzecd;
import com.google.android.gms.internal.ads.zzefy;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.GuardedBy;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@ParametersAreNonnullByDefault
public final class zzaue
implements zzaun {
    private static List<Future<Void>> zzdro = Collections.synchronizedList(new ArrayList());
    @GuardedBy(value="lock")
    private final zzefy.zzb.zzb zzdrp;
    @GuardedBy(value="lock")
    private final LinkedHashMap<String, zzefy.zzb.zzh.zzb> zzdrq;
    @GuardedBy(value="lock")
    private final List<String> zzdrr = new ArrayList<String>();
    @GuardedBy(value="lock")
    private final List<String> zzdrs = new ArrayList<String>();
    private final Context zzvf;
    private final zzaup zzdrt;
    @VisibleForTesting
    private boolean zzdru;
    private final zzaum zzdon;
    private final zzaus zzdrv;
    private final Object lock = new Object();
    private HashSet<String> zzdrw = new HashSet();
    private boolean zzdrx = false;
    private boolean zzdry = false;
    private boolean zzdrz = false;

    public zzaue(Context context, zzazz zzazz2, zzaum zzaum2, String string2, zzaup zzaup2) {
        long l;
        Preconditions.checkNotNull((Object)((Object)zzaum2), (Object)"SafeBrowsing config is not present.");
        this.zzvf = context.getApplicationContext() != null ? context.getApplicationContext() : context;
        this.zzdrq = new LinkedHashMap();
        this.zzdrt = zzaup2;
        this.zzdon = zzaum2;
        for (String string3 : this.zzdon.zzdsh) {
            this.zzdrw.add(string3.toLowerCase(Locale.ENGLISH));
        }
        this.zzdrw.remove("cookie".toLowerCase(Locale.ENGLISH));
        String string4 = string2;
        zzazz zzazz3 = zzazz2;
        zzaue zzaue2 = this;
        zzefy.zzb.zzb zzb2 = zzefy.zzb.zzbhu();
        zzb2.zzb(zzefy.zzb.zzg.zzihh);
        zzb2.zzhw(string4);
        zzb2.zzhx(string4);
        zzefy.zzb.zza.zza zza2 = zzefy.zzb.zza.zzbhw();
        if (zzaue2.zzdon.zzdsd != null) {
            zza2.zzhz(zzaue2.zzdon.zzdsd);
        }
        zzb2.zzb((zzefy.zzb.zza)((zzecd)zza2.zzbet()));
        zzefy.zzb.zzi.zza zza3 = zzefy.zzb.zzi.zzbil().zzbw(Wrappers.packageManager((Context)zzaue2.zzvf).isCallerInstantApp());
        if (zzazz3.zzbnd != null) {
            zza3.zzie(zzazz3.zzbnd);
        }
        if ((l = (long)GoogleApiAvailabilityLight.getInstance().getApkVersion(zzaue2.zzvf)) > 0L) {
            zza3.zzft(l);
        }
        zzb2.zzb((zzefy.zzb.zzi)((zzecd)zza3.zzbet()));
        this.zzdrp = zzb2;
        this.zzdrv = new zzaus(this.zzvf, this.zzdon.zzdsk, this);
    }

    @Override
    public final zzaum zzvf() {
        return this.zzdon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzdy(String string2) {
        Object object = this.lock;
        synchronized (object) {
            if (string2 == null) {
                this.zzdrp.zzbhy();
            } else {
                this.zzdrp.zzhy(string2);
            }
            return;
        }
    }

    @Override
    public final boolean zzvg() {
        return PlatformVersion.isAtLeastKitKat() && this.zzdon.zzdsf && !this.zzdry;
    }

    @Override
    public final void zzl(View view) {
        if (!this.zzdon.zzdsf) {
            return;
        }
        if (this.zzdry) {
            return;
        }
        zzq.zzkw();
        Bitmap bitmap = zzaxa.zzn(view);
        if (bitmap == null) {
            zzauo.zzed("Failed to capture the webview bitmap.");
            return;
        }
        this.zzdry = true;
        zzaxa.zzc(new zzaud(this, bitmap));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zza(String string2, Map<String, String> map, int n) {
        Object object = this.lock;
        synchronized (object) {
            if (n == 3) {
                this.zzdrz = true;
            }
            if (this.zzdrq.containsKey(string2)) {
                if (n == 3) {
                    this.zzdrq.get(string2).zzb(zzefy.zzb.zzh.zza.zzhq(n));
                }
                return;
            }
            zzefy.zzb.zzh.zzb zzb2 = zzefy.zzb.zzh.zzbij();
            zzefy.zzb.zzh.zza zza2 = zzefy.zzb.zzh.zza.zzhq(n);
            if (zza2 != null) {
                zzb2.zzb(zza2);
            }
            zzb2.zzhr(this.zzdrq.size());
            zzb2.zzic(string2);
            zzefy.zzb.zzd.zzb zzb3 = zzefy.zzb.zzd.zzbib();
            if (this.zzdrw.size() > 0 && map != null) {
                for (Map.Entry<String, String> entry : map.entrySet()) {
                    String string3;
                    String string4 = entry.getKey() != null ? entry.getKey() : "";
                    String string5 = string3 = entry.getValue() != null ? entry.getValue() : "";
                    String string6 = string4.toLowerCase(Locale.ENGLISH);
                    if (!this.zzdrw.contains(string6)) continue;
                    zzefy.zzb.zzc zzc2 = (zzefy.zzb.zzc)((zzecd)zzefy.zzb.zzc.zzbhz().zzao(zzeaq.zzhq((String)string4)).zzap(zzeaq.zzhq((String)string3)).zzbet());
                    zzb3.zzb(zzc2);
                }
            }
            zzb2.zzb((zzefy.zzb.zzd)((zzecd)zzb3.zzbet()));
            this.zzdrq.put(string2, zzb2);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void zzdz(String string2) {
        Object object = this.lock;
        synchronized (object) {
            this.zzdrr.add(string2);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void zzea(String string2) {
        Object object = this.lock;
        synchronized (object) {
            this.zzdrs.add(string2);
            return;
        }
    }

    @Override
    public final String[] zza(String[] stringArray) {
        return this.zzdrv.zzb(stringArray).toArray(new String[0]);
    }

    @Override
    public final void zzvh() {
        this.zzdrx = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private final zzefy.zzb.zzh.zzb zzeb(String string2) {
        Object object = this.lock;
        synchronized (object) {
            return this.zzdrq.get(string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzvi() {
        Object object = this.lock;
        synchronized (object) {
            zzdri zzdri2 = zzdqw.zzb(this.zzdrt.zza(this.zzvf, this.zzdrq.keySet()), new zzaug(this), (Executor)zzbab.zzdzw);
            zzdri zzdri3 = zzdqw.zza(zzdri2, 10L, TimeUnit.SECONDS, zzbab.zzdzu);
            zzdqw.zza(zzdri2, new zzauh(this, zzdri3), zzbab.zzdzw);
            zzdro.add(zzdri3);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    private final zzdri<Void> zzvj() {
        if (!(this.zzdru && this.zzdon.zzdsj || this.zzdrz && this.zzdon.zzdsi || !this.zzdru && this.zzdon.zzdsg)) {
            return zzdqw.zzag(null);
        }
        Object object = this.lock;
        synchronized (object) {
            for (zzefy.zzb.zzh.zzb object2 : this.zzdrq.values()) {
                this.zzdrp.zzb((zzefy.zzb.zzh)((zzecd)object2.zzbet()));
            }
            this.zzdrp.zzo(this.zzdrr);
            this.zzdrp.zzp(this.zzdrs);
            if (zzauo.isEnabled()) {
                String string2 = this.zzdrp.getUrl();
                String string3 = this.zzdrp.zzbhs();
                StringBuilder stringBuilder = new StringBuilder(new StringBuilder(53 + String.valueOf(string2).length() + String.valueOf(string3).length()).append("Sending SB report\n  url: ").append(string2).append("\n  clickUrl: ").append(string3).append("\n  resources: \n").toString());
                for (zzefy.zzb.zzh zzh2 : this.zzdrp.zzbhr()) {
                    stringBuilder.append("    [");
                    stringBuilder.append(zzh2.zzbii());
                    stringBuilder.append("] ");
                    stringBuilder.append(zzh2.getUrl());
                }
                zzauo.zzed(stringBuilder.toString());
            }
            String string4 = this.zzdon.zzdse;
            byte[] byArray = ((zzefy.zzb)((zzecd)this.zzdrp.zzbet())).toByteArray();
            zzaue zzaue2 = this;
            zzdri<String> zzdri2 = new zzaym(zzaue2.zzvf).zza(1, string4, null, byArray);
            if (zzauo.isEnabled()) {
                zzdri2.addListener(zzauf.zzdsa, zzbab.zzdzr);
            }
            return zzdqw.zzb(zzdri2, zzaui.zzdsc, (Executor)zzbab.zzdzw);
        }
    }

    static final /* synthetic */ Void zzec(String string2) {
        return null;
    }

    static final /* synthetic */ void zzvk() {
        zzauo.zzed("Pinged SB successfully.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final /* synthetic */ zzdri zzi(Map map) throws Exception {
        try {
            Map map2;
            Map map3 = map2 = map;
            zzaue zzaue2 = this;
            if (map3 != null) {
                for (String string2 : map3.keySet()) {
                    String string3 = (String)map3.get(string2);
                    JSONArray jSONArray = new JSONObject(string3).optJSONArray("matches");
                    if (jSONArray == null) continue;
                    Object object = zzaue2.lock;
                    synchronized (object) {
                        int n = jSONArray.length();
                        zzefy.zzb.zzh.zzb zzb2 = zzaue2.zzeb(string2);
                        if (zzb2 == null) {
                            String string4 = String.valueOf(string2);
                            zzauo.zzed(string4.length() != 0 ? "Cannot find the corresponding resource object for ".concat(string4) : new String("Cannot find the corresponding resource object for "));
                            continue;
                        }
                        for (int i = 0; i < n; ++i) {
                            zzb2.zzid(jSONArray.getJSONObject(i).getString("threat_type"));
                        }
                        zzaue2.zzdru = zzaue2.zzdru | n > 0;
                    }
                }
            }
            if (this.zzdru) {
                Object object = this.lock;
                synchronized (object) {
                    this.zzdrp.zzb(zzefy.zzb.zzg.zzihi);
                }
            }
            return this.zzvj();
        }
        catch (JSONException jSONException) {
            JSONException jSONException2 = jSONException;
            String string5 = "Failed to get SafeBrowsing metadata";
            if (((Boolean)zzabq.zzcxh.get()).booleanValue()) {
                zzawr.zzb((String)string5, (Throwable)jSONException2);
            }
            return zzdqw.immediateFailedFuture(new Exception("Safebrowsing report transmission failed."));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final /* synthetic */ void zza(Bitmap bitmap) {
        zzebd zzebd2 = zzeaq.zzbcr();
        bitmap.compress(Bitmap.CompressFormat.PNG, 0, (OutputStream)zzebd2);
        Object object = this.lock;
        synchronized (object) {
            this.zzdrp.zzb((zzefy.zzb.zzf)((zzecd)zzefy.zzb.zzf.zzbig().zzar(zzebd2.zzbce()).zzia("image/png").zzb(zzefy.zzb.zzf.zza.zzigx).zzbet()));
            return;
        }
    }

    static /* synthetic */ List zzvl() {
        return zzdro;
    }
}

