/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import androidx.annotation.Nullable;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.dynamite.DynamiteModule;
import com.google.android.gms.internal.ads.zzaut;
import com.google.android.gms.internal.ads.zzauv;
import com.google.android.gms.internal.ads.zzauw;
import com.google.android.gms.internal.ads.zzaux;
import com.google.android.gms.internal.ads.zzauy;
import com.google.android.gms.internal.ads.zzauz;
import com.google.android.gms.internal.ads.zzava;
import com.google.android.gms.internal.ads.zzavb;
import com.google.android.gms.internal.ads.zzavc;
import com.google.android.gms.internal.ads.zzavd;
import com.google.android.gms.internal.ads.zzave;
import com.google.android.gms.internal.ads.zzavf;
import com.google.android.gms.internal.ads.zzavg;
import com.google.android.gms.internal.ads.zzavh;
import com.google.android.gms.internal.ads.zzavi;
import com.google.android.gms.internal.ads.zzavk;
import com.google.android.gms.internal.ads.zzawr;
import com.google.android.gms.internal.ads.zzazm;
import com.google.android.gms.internal.ads.zzbgr;
import com.google.android.gms.internal.ads.zzuj;
import com.google.android.gms.internal.ads.zzvj;
import com.google.android.gms.internal.ads.zzyy;
import com.google.android.gms.internal.ads.zzzk;
import com.google.android.gms.internal.ads.zzzz;
import java.lang.reflect.Method;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.GuardedBy;

@ParametersAreNonnullByDefault
public final class zzauu {
    private final AtomicReference<ThreadPoolExecutor> zzdsp = new AtomicReference<Object>(null);
    private final Object zzdsq = new Object();
    @GuardedBy(value="gmpAppIdLock")
    @Nullable
    private String zzdsr = null;
    @GuardedBy(value="gmpAppIdLock")
    @Nullable
    private String zzdss = null;
    @VisibleForTesting
    private final AtomicBoolean zzdst = new AtomicBoolean(false);
    private final AtomicInteger zzdsu = new AtomicInteger(-1);
    private final AtomicReference<Object> zzdsv = new AtomicReference<Object>(null);
    private final AtomicReference<Object> zzdsw = new AtomicReference<Object>(null);
    private final ConcurrentMap<String, Method> zzdsx = new ConcurrentHashMap<String, Method>(9);
    private final AtomicReference<zzbgr> zzdsy = new AtomicReference<Object>(null);
    @GuardedBy(value="proxyReference")
    private final BlockingQueue<FutureTask<?>> zzdsz = new ArrayBlockingQueue(20);
    private final Object zzdta = new Object();

    /*
     * Unable to fully structure code
     */
    public final boolean zzab(Context var1_1) {
        block4: {
            var2_2 = zzzz.zzckm;
            if (!((Boolean)zzvj.zzpv().zzd(var2_2)).booleanValue() || this.zzdst.get()) {
                return false;
            }
            var2_2 = zzzz.zzckw;
            if (((Boolean)zzvj.zzpv().zzd(var2_2)).booleanValue()) {
                return true;
            }
            if (this.zzdsu.get() != -1) break block4;
            zzvj.zzpr();
            var3_3 = var1_1;
            if (zzazm.zzd((Context)var3_3, (int)12451000)) ** GOTO lbl-1000
            zzvj.zzpr();
            if (zzazm.zzbm((Context)var1_1)) {
                zzawr.zzfc((String)"Google Play Service is out of date, the Google Mobile Ads SDK will not integrate with Firebase. Admob/Firebase integration requires updated Google Play Service.");
                this.zzdsu.set(0);
            } else lbl-1000:
            // 2 sources

            {
                this.zzdsu.set(1);
            }
        }
        return this.zzdsu.get() == 1;
    }

    @VisibleForTesting
    private static boolean zzac(Context context) {
        zzzk zzzk2 = zzzz.zzckt;
        if (!((Boolean)zzvj.zzpv().zzd(zzzk2)).booleanValue()) {
            return false;
        }
        zzzk2 = zzzz.zzcku;
        if (DynamiteModule.getLocalVersion((Context)context, (String)"com.google.android.gms.ads.dynamite") < (Integer)zzvj.zzpv().zzd(zzzk2)) {
            return false;
        }
        zzzk2 = zzzz.zzckv;
        if (((Boolean)zzvj.zzpv().zzd(zzzk2)).booleanValue()) {
            try {
                context.getClassLoader().loadClass("com.google.firebase.analytics.FirebaseAnalytics");
                return false;
            }
            catch (ClassNotFoundException classNotFoundException) {
                return true;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zza(Context context, zzyy zzyy2) {
        zzzk zzzk2 = zzzz.zzckz;
        if (!(((Boolean)zzvj.zzpv().zzd(zzzk2)).booleanValue() && this.zzab(context) && zzauu.zzac(context))) {
            return;
        }
        Object object = this.zzdta;
        synchronized (object) {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zza(Context context, zzuj zzuj2) {
        zzzk zzzk2 = zzzz.zzckz;
        if (!(((Boolean)zzvj.zzpv().zzd(zzzk2)).booleanValue() && this.zzab(context) && zzauu.zzac(context))) {
            return;
        }
        Object object = this.zzdta;
        synchronized (object) {
            return;
        }
    }

    public final void zze(Context context, String string2) {
        if (!this.zzab(context)) {
            return;
        }
        if (zzauu.zzac(context)) {
            this.zza("beginAdUnitExposure", new zzaut(string2));
            return;
        }
        this.zza(context, string2, "beginAdUnitExposure");
    }

    public final void zzf(Context context, String string2) {
        if (!this.zzab(context)) {
            return;
        }
        if (zzauu.zzac(context)) {
            this.zza("endAdUnitExposure", new zzava(string2));
            return;
        }
        this.zza(context, string2, "endAdUnitExposure");
    }

    public final String zzad(Context context) {
        if (!this.zzab(context)) {
            return "";
        }
        if (zzauu.zzac(context)) {
            return this.zza("getCurrentScreenNameOrScreenClass", "", zzauz.zzdtc);
        }
        if (!this.zza(context, "com.google.android.gms.measurement.AppMeasurement", this.zzdsv, true)) {
            return "";
        }
        try {
            String string2 = (String)this.zzm(context, "getCurrentScreenName").invoke(this.zzdsv.get(), new Object[0]);
            if (string2 == null) {
                string2 = (String)this.zzm(context, "getCurrentScreenClass").invoke(this.zzdsv.get(), new Object[0]);
            }
            if (string2 != null) {
                return string2;
            }
            return "";
        }
        catch (Exception exception) {
            this.zza(exception, "getCurrentScreenName", false);
            return "";
        }
    }

    public final void zzg(Context context, String string2) {
        if (!this.zzab(context)) {
            return;
        }
        if (!(context instanceof Activity)) {
            return;
        }
        if (zzauu.zzac(context)) {
            this.zza("setScreenName", new zzavc(context, string2));
            return;
        }
        if (!this.zza(context, "com.google.firebase.analytics.FirebaseAnalytics", this.zzdsw, false)) {
            return;
        }
        Method method = this.zzn(context, "setCurrentScreen");
        try {
            Activity activity = (Activity)context;
            method.invoke(this.zzdsw.get(), activity, string2, context.getPackageName());
            return;
        }
        catch (Exception exception) {
            this.zza(exception, "setCurrentScreen", false);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final String zzae(Context context) {
        if (!this.zzab(context)) {
            return null;
        }
        Object object = this.zzdsq;
        synchronized (object) {
            if (this.zzdsr != null) {
                return this.zzdsr;
            }
            this.zzdsr = zzauu.zzac(context) ? this.zza("getGmpAppId", this.zzdsr, zzavb.zzdtc) : (String)this.zza("getGmpAppId", context);
            return this.zzdsr;
        }
    }

    @Nullable
    public final String zzaf(Context context) {
        if (!this.zzab(context)) {
            return null;
        }
        zzzk zzzk2 = zzzz.zzckr;
        long l = (Long)zzvj.zzpv().zzd(zzzk2);
        if (zzauu.zzac(context)) {
            try {
                if (l < 0L) {
                    return this.zza("getAppInstanceId", null, zzave.zzdtc);
                }
                return (String)this.zzvm().submit(new zzavd(this)).get(l, TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException timeoutException) {
                return "TIME_OUT";
            }
            catch (Exception exception) {
                return null;
            }
        }
        if (l < 0L) {
            return (String)this.zza("getAppInstanceId", context);
        }
        Future future = this.zzvm().submit(new zzavg(this, context));
        try {
            return (String)future.get(l, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException timeoutException) {
            return "TIME_OUT";
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Nullable
    public final String zzag(Context context) {
        if (!this.zzab(context)) {
            return null;
        }
        if (zzauu.zzac(context)) {
            Long l = this.zza("getAdEventId", null, zzavf.zzdtc);
            if (l != null) {
                return Long.toString(l);
            }
            return null;
        }
        Object object = this.zza("generateEventId", context);
        if (object != null) {
            return object.toString();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final String zzah(Context context) {
        if (!this.zzab(context)) {
            return null;
        }
        Object object = this.zzdsq;
        synchronized (object) {
            if (this.zzdss != null) {
                return this.zzdss;
            }
            this.zzdss = zzauu.zzac(context) ? this.zza("getAppIdOrigin", this.zzdss, zzauw.zzdtc) : "fa";
            return this.zzdss;
        }
    }

    public final void zzh(Context context, String string2) {
        this.zza(context, "_ac", string2, null);
    }

    public final void zzi(Context context, String string2) {
        this.zza(context, "_ai", string2, null);
    }

    public final void zzj(Context context, String string2) {
        this.zza(context, "_aq", string2, null);
    }

    public final void zzk(Context context, String string2) {
        this.zza(context, "_aa", string2, null);
    }

    public final void zza(Context context, String string2, String string3, String string4, int n) {
        if (!this.zzab(context)) {
            return;
        }
        Bundle bundle = new Bundle();
        bundle.putString("_ai", string3);
        bundle.putString("reward_type", string4);
        bundle.putInt("reward_value", n);
        this.zza(context, "_ar", string2, bundle);
        zzawr.zzeg(new StringBuilder(75 + String.valueOf(string4).length()).append("Log a Firebase reward video event, reward type: ").append(string4).append(", reward value: ").append(n).toString());
    }

    private final void zza(Context context, String string2, String string3, @Nullable Bundle bundle) {
        if (!this.zzab(context)) {
            return;
        }
        Bundle bundle2 = zzauu.zzl(string3, string2);
        if (bundle != null) {
            bundle2.putAll(bundle);
        }
        if (zzauu.zzac(context)) {
            this.zza("logEventInternal", new zzauv(string2, bundle2));
            return;
        }
        if (!this.zza(context, "com.google.android.gms.measurement.AppMeasurement", this.zzdsv, true)) {
            return;
        }
        Method method = this.zzai(context);
        try {
            method.invoke(this.zzdsv.get(), "am", string2, bundle2);
            return;
        }
        catch (Exception exception) {
            this.zza(exception, "logEventInternal", true);
            return;
        }
    }

    private static Bundle zzl(String string2, String string3) {
        Bundle bundle = new Bundle();
        try {
            bundle.putLong("_aeid", Long.parseLong(string2));
        }
        catch (NullPointerException | NumberFormatException runtimeException) {
            String string4 = String.valueOf(string2);
            zzawr.zzc((String)(string4.length() != 0 ? "Invalid event ID: ".concat(string4) : new String("Invalid event ID: ")), (Throwable)runtimeException);
        }
        if ("_ac".equals(string3)) {
            bundle.putInt("_r", 1);
        }
        return bundle;
    }

    @Nullable
    private final Method zzai(Context context) {
        Method method = (Method)this.zzdsx.get("logEventInternal");
        if (method != null) {
            return method;
        }
        try {
            method = context.getClassLoader().loadClass("com.google.android.gms.measurement.AppMeasurement").getDeclaredMethod("logEventInternal", String.class, String.class, Bundle.class);
            this.zzdsx.put("logEventInternal", method);
            return method;
        }
        catch (Exception exception) {
            this.zza(exception, "logEventInternal", true);
            return null;
        }
    }

    @Nullable
    private final Method zzl(Context context, String string2) {
        Method method = (Method)this.zzdsx.get(string2);
        if (method != null) {
            return method;
        }
        try {
            method = context.getClassLoader().loadClass("com.google.android.gms.measurement.AppMeasurement").getDeclaredMethod(string2, String.class);
            this.zzdsx.put(string2, method);
            return method;
        }
        catch (Exception exception) {
            this.zza(exception, string2, false);
            return null;
        }
    }

    @Nullable
    private final Method zzm(Context context, String string2) {
        Method method = (Method)this.zzdsx.get(string2);
        if (method != null) {
            return method;
        }
        try {
            method = context.getClassLoader().loadClass("com.google.android.gms.measurement.AppMeasurement").getDeclaredMethod(string2, new Class[0]);
            this.zzdsx.put(string2, method);
            return method;
        }
        catch (Exception exception) {
            this.zza(exception, string2, false);
            return null;
        }
    }

    private final Method zzn(Context context, String string2) {
        Method method = (Method)this.zzdsx.get(string2);
        if (method != null) {
            return method;
        }
        try {
            method = context.getClassLoader().loadClass("com.google.firebase.analytics.FirebaseAnalytics").getDeclaredMethod(string2, Activity.class, String.class, String.class);
            this.zzdsx.put(string2, method);
            return method;
        }
        catch (Exception exception) {
            this.zza(exception, string2, false);
            return null;
        }
    }

    private final void zza(Context context, String string2, String string3) {
        if (!this.zza(context, "com.google.android.gms.measurement.AppMeasurement", this.zzdsv, true)) {
            return;
        }
        Method method = this.zzl(context, string3);
        try {
            method.invoke(this.zzdsv.get(), string2);
            zzawr.zzeg(new StringBuilder(37 + String.valueOf(string3).length() + String.valueOf(string2).length()).append("Invoke Firebase method ").append(string3).append(", Ad Unit Id: ").append(string2).toString());
            return;
        }
        catch (Exception exception) {
            this.zza(exception, string3, false);
            return;
        }
    }

    private final Object zza(String string2, Context context) {
        if (!this.zza(context, "com.google.android.gms.measurement.AppMeasurement", this.zzdsv, true)) {
            return null;
        }
        Method method = this.zzm(context, string2);
        try {
            return method.invoke(this.zzdsv.get(), new Object[0]);
        }
        catch (Exception exception) {
            this.zza(exception, string2, true);
            return null;
        }
    }

    private final void zza(Exception exception, String string2, boolean bl) {
        if (!this.zzdst.get()) {
            zzawr.zzfc((String)new StringBuilder(30 + String.valueOf(string2).length()).append("Invoke Firebase method ").append(string2).append(" error.").toString());
            if (bl) {
                zzawr.zzfc((String)"The Google Mobile Ads SDK will not integrate with Firebase. Admob/Firebase integration requires the latest Firebase SDK jar, but Firebase SDK is either missing or out of date");
                this.zzdst.set(true);
            }
        }
    }

    private final ThreadPoolExecutor zzvm() {
        if (this.zzdsp.get() == null) {
            Object object = zzzz.zzcks;
            int n = (Integer)zzvj.zzpv().zzd(object);
            object = zzzz.zzcks;
            int n2 = (Integer)zzvj.zzpv().zzd(object);
            object = this;
            this.zzdsp.compareAndSet(null, new ThreadPoolExecutor(n, n2, 1L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>(), new zzavi((zzauu)object)));
        }
        return this.zzdsp.get();
    }

    private final boolean zza(Context context, String string2, AtomicReference<Object> atomicReference, boolean bl) {
        if (atomicReference.get() == null) {
            try {
                Method method = context.getClassLoader().loadClass(string2).getDeclaredMethod("getInstance", Context.class);
                atomicReference.compareAndSet(null, method.invoke(null, context));
            }
            catch (Exception exception) {
                this.zza(exception, "getInstance", bl);
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zza(String string2, zzavk zzavk2) {
        AtomicReference<zzbgr> atomicReference = this.zzdsy;
        synchronized (atomicReference) {
            FutureTask<Object> futureTask = new FutureTask<Object>(new zzauy(this, zzavk2, string2), null);
            if (this.zzdsy.get() != null) {
                futureTask.run();
            } else {
                this.zzdsz.offer(futureTask);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <T> T zza(String string2, @Nullable T t, zzavh<T> zzavh2) {
        AtomicReference<zzbgr> atomicReference = this.zzdsy;
        synchronized (atomicReference) {
            if (this.zzdsy.get() != null) {
                try {
                    return zzavh2.zzb(this.zzdsy.get());
                }
                catch (Exception exception) {
                    this.zza(exception, string2, false);
                }
            }
            return t;
        }
    }

    final /* synthetic */ void zza(zzavk zzavk2, String string2) {
        if (this.zzdsy.get() != null) {
            try {
                zzavk2.zza(this.zzdsy.get());
                return;
            }
            catch (Exception exception) {
                this.zza(exception, string2, false);
            }
        }
    }

    final /* synthetic */ String zzaj(Context context) throws Exception {
        return (String)this.zza("getAppInstanceId", context);
    }

    final /* synthetic */ String zzvn() throws Exception {
        return this.zza("getAppInstanceId", null, zzaux.zzdtc);
    }
}

