/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.graphics.PointF;
import android.net.Uri;
import android.os.Handler;
import android.text.TextUtils;
import android.view.MotionEvent;
import android.view.ViewConfiguration;
import android.view.WindowManager;
import androidx.annotation.Nullable;
import com.google.android.gms.ads.internal.zzq;
import com.google.android.gms.internal.ads.zzawr;
import com.google.android.gms.internal.ads.zzaxa;
import com.google.android.gms.internal.ads.zzaxt;
import com.google.android.gms.internal.ads.zzaxu;
import com.google.android.gms.internal.ads.zzaxv;
import com.google.android.gms.internal.ads.zzaxw;
import com.google.android.gms.internal.ads.zzaxx;
import com.google.android.gms.internal.ads.zzaxy;
import com.google.android.gms.internal.ads.zzbab;
import com.google.android.gms.internal.ads.zzvj;
import com.google.android.gms.internal.ads.zzzk;
import com.google.android.gms.internal.ads.zzzz;
import java.util.ArrayList;
import java.util.List;

public final class zzaxr {
    private final Context zzvf;
    private String zzdkz;
    private String zzbsc;
    private String zzbnd;
    @Nullable
    private String zzdoo;
    private int state = 0;
    private int zzdwo;
    private PointF zzdwp;
    private PointF zzdwq;
    private Handler handler;
    private Runnable zzdwr = new zzaxu(this);

    public zzaxr(Context context) {
        this.zzvf = context;
        ViewConfiguration viewConfiguration = ViewConfiguration.get((Context)context);
        this.zzdwo = viewConfiguration.getScaledTouchSlop();
        zzq.zzlk().zzxx();
        this.handler = zzq.zzlk().getHandler();
    }

    public zzaxr(Context context, String string2) {
        this(context);
        this.zzdkz = string2;
    }

    public final void zzd(MotionEvent motionEvent) {
        int n = motionEvent.getActionMasked();
        int n2 = motionEvent.getHistorySize();
        int n3 = motionEvent.getPointerCount();
        if (n == 0) {
            this.state = 0;
            this.zzdwp = new PointF(motionEvent.getX(0), motionEvent.getY(0));
            return;
        }
        if (this.state == -1) {
            return;
        }
        if (this.state == 0 && n == 5) {
            this.state = 5;
            this.zzdwq = new PointF(motionEvent.getX(1), motionEvent.getY(1));
            zzzk zzzk2 = zzzz.zzcqf;
            this.handler.postDelayed(this.zzdwr, ((Long)zzvj.zzpv().zzd(zzzk2)).longValue());
            return;
        }
        if (this.state == 5) {
            boolean bl = false;
            if (n3 != 2) {
                bl = true;
            } else if (n == 2) {
                for (int i = 0; i < n2; ++i) {
                    if (this.zza(motionEvent.getHistoricalX(0, i), motionEvent.getHistoricalY(0, i), motionEvent.getHistoricalX(1, i), motionEvent.getHistoricalY(1, i))) continue;
                    bl = true;
                }
                if (!this.zza(motionEvent.getX(), motionEvent.getY(), motionEvent.getX(1), motionEvent.getY(1))) {
                    bl = true;
                }
            }
            if (bl) {
                this.state = -1;
                this.handler.removeCallbacks(this.zzdwr);
            }
        }
    }

    private final boolean zza(float f, float f2, float f3, float f4) {
        return Math.abs(this.zzdwp.x - f) < (float)this.zzdwo && Math.abs(this.zzdwp.y - f2) < (float)this.zzdwo && Math.abs(this.zzdwq.x - f3) < (float)this.zzdwo && Math.abs(this.zzdwq.y - f4) < (float)this.zzdwo;
    }

    public final void showDialog() {
        try {
            zzaxr zzaxr2 = this;
            if (!(zzaxr2.zzvf instanceof Activity)) {
                zzawr.zzfb((String)"Can not create dialog without Activity Context");
                return;
            }
            String string2 = !TextUtils.isEmpty((CharSequence)zzq.zzlg().zzxt()) ? "Creative Preview (Enabled)" : "Creative Preview";
            String string3 = zzq.zzlg().zzxu() ? "Troubleshooting (Enabled)" : "Troubleshooting";
            ArrayList<String> arrayList = new ArrayList<String>();
            int n = zzaxr.zza(arrayList, "Ad Information", true);
            int n2 = zzaxr.zza(arrayList, string2, true);
            int n3 = zzaxr.zza(arrayList, string3, true);
            AlertDialog.Builder builder = new AlertDialog.Builder(zzaxr2.zzvf, zzq.zzky().zzxn());
            builder.setTitle((CharSequence)"Select a Debug Mode").setItems((CharSequence[])arrayList.toArray(new String[0]), (DialogInterface.OnClickListener)new zzaxt(zzaxr2, n, n2, n3));
            builder.create().show();
            return;
        }
        catch (WindowManager.BadTokenException badTokenException) {
            zzawr.zza("", badTokenException);
            return;
        }
    }

    public final void setAdUnitId(String string2) {
        this.zzbsc = string2;
    }

    public final void zzac(String string2) {
        this.zzbnd = string2;
    }

    public final void zzer(String string2) {
        this.zzdkz = string2;
    }

    public final void zzes(String string2) {
        this.zzdoo = string2;
    }

    private static int zza(List<String> list, String string2, boolean bl) {
        list.add(string2);
        return list.size() - 1;
    }

    public final String toString() {
        return new StringBuilder(100).append("{Dialog: ").append(this.zzdkz).append(",DebugSignal: ").append(this.zzdoo).append(",AFMA Version: ").append(this.zzbnd).append(",Ad Unit ID: ").append(this.zzbsc).append("}").toString();
    }

    final /* synthetic */ void zzxp() {
        zzq.zzlg().zza(this.zzvf, this.zzbsc, this.zzbnd, this.zzdoo);
    }

    final /* synthetic */ void zzxq() {
        zzq.zzlg().zze(this.zzvf, this.zzbsc, this.zzbnd);
    }

    final /* synthetic */ void zza(String string2, DialogInterface dialogInterface, int n) {
        zzq.zzkw();
        zzaxa.zza(this.zzvf, Intent.createChooser((Intent)new Intent("android.intent.action.SEND").setType("text/plain").putExtra("android.intent.extra.TEXT", string2), (CharSequence)"Share via"));
    }

    /*
     * Unable to fully structure code
     */
    final /* synthetic */ void zza(int var1_1, int var2_2, int var3_3, DialogInterface var4_4, int var5_5) {
        block6: {
            if (var5_5 != var1_1) break block6;
            var6_6 = this;
            if (!(var6_6.zzvf instanceof Activity)) {
                zzawr.zzfb((String)"Can not create dialog without Activity Context");
                return;
            }
            var9_9 = var6_6.zzdkz;
            if (TextUtils.isEmpty((CharSequence)var9_9)) ** GOTO lbl-1000
            var9_9 = var9_9.replaceAll("\\+", "%20");
            var10_10 = new Uri.Builder().encodedQuery(var9_9).build();
            var11_11 = new StringBuilder();
            zzq.zzkw();
            var12_12 = zzaxa.zzj(var10_10);
            for (String var14_14 : var12_12.keySet()) {
                var11_11.append(var14_14).append(" = ").append(var12_12.get(var14_14)).append("\n\n");
            }
            var13_13 = var11_11.toString().trim();
            if (!TextUtils.isEmpty((CharSequence)var13_13)) {
                v0 = var13_13;
            } else lbl-1000:
            // 2 sources

            {
                v0 = "No debug information";
            }
            var7_15 = v0;
            var8_16 = new AlertDialog.Builder(var6_6.zzvf);
            var8_16.setMessage((CharSequence)var7_15);
            var8_16.setTitle((CharSequence)"Ad Information");
            var8_16.setPositiveButton((CharSequence)"Share", (DialogInterface.OnClickListener)new zzaxw(var6_6, var7_15));
            var8_16.setNegativeButton((CharSequence)"Close", zzaxv.zzdww);
            var8_16.create().show();
            return;
        }
        if (var5_5 == var2_2) {
            var6_7 = this;
            zzawr.zzed((String)"Debug mode [Creative Preview] selected.");
            zzbab.zzdzr.execute(new zzaxy(var6_7));
            return;
        }
        if (var5_5 == var3_3) {
            var6_8 = this;
            zzawr.zzed((String)"Debug mode [Troubleshooting] selected.");
            zzbab.zzdzr.execute(new zzaxx(var6_8));
        }
    }

    final /* synthetic */ void zzxr() {
        this.state = 4;
        this.showDialog();
    }
}

