/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.content.Context;
import android.graphics.Point;
import android.graphics.Rect;
import android.view.MotionEvent;
import android.view.View;
import android.widget.TextView;
import androidx.annotation.Nullable;
import com.google.android.gms.ads.internal.zzq;
import com.google.android.gms.internal.ads.zzawr;
import com.google.android.gms.internal.ads.zzaxa;
import com.google.android.gms.internal.ads.zzvj;
import com.google.android.gms.internal.ads.zzzk;
import com.google.android.gms.internal.ads.zzzz;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public final class zzaza {
    public static boolean zzdb(int n) {
        block3: {
            block2: {
                zzzk zzzk2 = zzzz.zzcoj;
                if (!((Boolean)zzvj.zzpv().zzd(zzzk2)).booleanValue()) break block2;
                zzzk2 = zzzz.zzcok;
                if (!((Boolean)zzvj.zzpv().zzd(zzzk2)).booleanValue() && n > 15299999) break block3;
            }
            return true;
        }
        return false;
    }

    public static JSONObject zza(Context context, @Nullable View view) {
        JSONObject jSONObject;
        Object object;
        JSONObject jSONObject2 = new JSONObject();
        if (view == null) {
            return jSONObject2;
        }
        try {
            Object object2;
            object = zzaza.zzt(view);
            jSONObject = new JSONObject();
            jSONObject.put("width", zzaza.zzb(context, view.getMeasuredWidth()));
            jSONObject.put("height", zzaza.zzb(context, view.getMeasuredHeight()));
            jSONObject.put("x", zzaza.zzb(context, (int)object[0]));
            jSONObject.put("y", zzaza.zzb(context, (int)object[1]));
            jSONObject.put("relative_to", (Object)"window");
            jSONObject2.put("frame", (Object)jSONObject);
            Rect rect = new Rect();
            if (view.getGlobalVisibleRect(rect)) {
                object2 = zzaza.zza(context, rect);
            } else {
                object2 = new JSONObject();
                object2.put("width", 0);
                object2.put("height", 0);
                object2.put("x", zzaza.zzb(context, (int)object[0]));
                object2.put("y", zzaza.zzb(context, (int)object[1]));
                object2.put("relative_to", (Object)"window");
            }
            jSONObject2.put("visible_bounds", object2);
        }
        catch (Exception exception) {
            zzawr.zzfc((String)"Unable to get native ad view bounding box");
        }
        zzzk zzzk2 = zzzz.zzctb;
        if (((Boolean)zzvj.zzpv().zzd(zzzk2)).booleanValue()) {
            object = "";
            jSONObject = view.getParent();
            if (jSONObject != null) {
                try {
                    object = (String)jSONObject.getClass().getMethod("getTemplateTypeName", new Class[0]).invoke((Object)jSONObject, new Object[0]);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                }
                catch (IllegalAccessException | SecurityException | InvocationTargetException exception) {
                    zzawr.zzc((String)"Cannot access method getTemplateTypeName: ", (Throwable)exception);
                }
            }
            try {
                switch (object) {
                    case "small_template": {
                        jSONObject2.put("native_template_type", 1);
                        break;
                    }
                    case "medium_template": {
                        jSONObject2.put("native_template_type", 2);
                        break;
                    }
                    default: {
                        jSONObject2.put("native_template_type", 0);
                        break;
                    }
                }
            }
            catch (JSONException jSONException) {
                zzawr.zzc((String)"Could not log native template signal to JSON", (Throwable)jSONException);
            }
        }
        return jSONObject2;
    }

    public static JSONObject zzs(@Nullable View view) {
        JSONObject jSONObject = new JSONObject();
        if (view == null) {
            return jSONObject;
        }
        try {
            zzq.zzkw();
            int n = zzaxa.zzr(view);
            jSONObject.put("contained_in_scroll_view", n != -1);
        }
        catch (Exception exception) {}
        return jSONObject;
    }

    public static JSONObject zzb(Context context, @Nullable View view) {
        JSONObject jSONObject = new JSONObject();
        if (view == null) {
            return jSONObject;
        }
        try {
            zzq.zzkw();
            jSONObject.put("can_show_on_lock_screen", zzaxa.zzq(view));
            zzq.zzkw();
            jSONObject.put("is_keyguard_locked", zzaxa.zzax(context));
        }
        catch (JSONException jSONException) {
            zzawr.zzfc((String)"Unable to get lock screen information");
        }
        return jSONObject;
    }

    public static JSONObject zza(Context context, @Nullable Map<String, WeakReference<View>> map, @Nullable Map<String, WeakReference<View>> map2, @Nullable View view) {
        JSONObject jSONObject = new JSONObject();
        if (map == null || view == null) {
            return jSONObject;
        }
        int[] nArray = zzaza.zzt(view);
        for (Map.Entry<String, WeakReference<View>> entry : map.entrySet()) {
            View view2 = (View)entry.getValue().get();
            if (view2 == null) continue;
            int[] nArray2 = zzaza.zzt(view2);
            JSONObject jSONObject2 = new JSONObject();
            JSONObject jSONObject3 = new JSONObject();
            try {
                JSONObject jSONObject4;
                jSONObject3.put("width", zzaza.zzb(context, view2.getMeasuredWidth()));
                jSONObject3.put("height", zzaza.zzb(context, view2.getMeasuredHeight()));
                jSONObject3.put("x", zzaza.zzb(context, nArray2[0] - nArray[0]));
                jSONObject3.put("y", zzaza.zzb(context, nArray2[1] - nArray[1]));
                jSONObject3.put("relative_to", (Object)"ad_view");
                jSONObject2.put("frame", (Object)jSONObject3);
                Rect rect = new Rect();
                if (view2.getLocalVisibleRect(rect)) {
                    jSONObject4 = zzaza.zza(context, rect);
                } else {
                    jSONObject4 = new JSONObject();
                    jSONObject4.put("width", 0);
                    jSONObject4.put("height", 0);
                    jSONObject4.put("x", zzaza.zzb(context, nArray2[0] - nArray[0]));
                    jSONObject4.put("y", zzaza.zzb(context, nArray2[1] - nArray[1]));
                    jSONObject4.put("relative_to", (Object)"ad_view");
                }
                jSONObject2.put("visible_bounds", (Object)jSONObject4);
                if (view2 instanceof TextView) {
                    TextView textView = (TextView)view2;
                    jSONObject2.put("text_color", textView.getCurrentTextColor());
                    jSONObject2.put("font_size", (double)textView.getTextSize());
                    jSONObject2.put("text", (Object)textView.getText());
                }
                jSONObject2.put("is_clickable", map2 != null && map2.containsKey(entry.getKey()) && view2.isClickable());
                jSONObject.put(entry.getKey(), (Object)jSONObject2);
            }
            catch (JSONException jSONException) {
                zzawr.zzfc((String)"Unable to get asset views information");
            }
        }
        return jSONObject;
    }

    public static JSONObject zza(@Nullable String string2, Context context, Point point, Point point2) {
        JSONObject jSONObject = null;
        try {
            jSONObject = new JSONObject();
            jSONObject.put("click_point", (Object)zzaza.zza(context, point, point2));
            jSONObject.put("asset_id", (Object)string2);
        }
        catch (Exception exception) {
            zzawr.zzc((String)"Error occurred while grabbing click signals.", (Throwable)exception);
        }
        return jSONObject;
    }

    private static int[] zzt(@Nullable View view) {
        int[] nArray = new int[2];
        if (view != null) {
            view.getLocationOnScreen(nArray);
        }
        return nArray;
    }

    public static Point zza(MotionEvent motionEvent, @Nullable View view) {
        int[] nArray = zzaza.zzt(view);
        int n = (int)motionEvent.getRawX() - nArray[0];
        int n2 = (int)motionEvent.getRawY() - nArray[1];
        return new Point(n, n2);
    }

    @Nullable
    private static JSONObject zza(Context context, Point point, Point point2) {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("x", zzaza.zzb(context, point2.x));
            jSONObject.put("y", zzaza.zzb(context, point2.y));
            jSONObject.put("start_x", zzaza.zzb(context, point.x));
            jSONObject.put("start_y", zzaza.zzb(context, point.y));
            return jSONObject;
        }
        catch (JSONException jSONException) {
            zzawr.zzc((String)"Error occurred while putting signals into JSON object.", (Throwable)jSONException);
            return null;
        }
    }

    private static int zzb(Context context, int n) {
        return zzvj.zzpr().zzb(context, n);
    }

    private static JSONObject zza(Context context, Rect rect) throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("width", zzaza.zzb(context, rect.right - rect.left));
        jSONObject.put("height", zzaza.zzb(context, rect.bottom - rect.top));
        jSONObject.put("x", zzaza.zzb(context, rect.left));
        jSONObject.put("y", zzaza.zzb(context, rect.top));
        jSONObject.put("relative_to", (Object)"self");
        return jSONObject;
    }
}

