/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.SurfaceTexture;
import android.media.MediaPlayer;
import android.net.Uri;
import android.os.Build;
import android.view.Surface;
import android.view.TextureView;
import android.view.View;
import com.google.android.gms.ads.internal.zzq;
import com.google.android.gms.internal.ads.zzawr;
import com.google.android.gms.internal.ads.zzaxa;
import com.google.android.gms.internal.ads.zzbax;
import com.google.android.gms.internal.ads.zzbay;
import com.google.android.gms.internal.ads.zzbaz;
import com.google.android.gms.internal.ads.zzbba;
import com.google.android.gms.internal.ads.zzbbb;
import com.google.android.gms.internal.ads.zzbbc;
import com.google.android.gms.internal.ads.zzbbd;
import com.google.android.gms.internal.ads.zzbbe;
import com.google.android.gms.internal.ads.zzbbf;
import com.google.android.gms.internal.ads.zzbbg;
import com.google.android.gms.internal.ads.zzbbi;
import com.google.android.gms.internal.ads.zzbbv;
import com.google.android.gms.internal.ads.zzbby;
import com.google.android.gms.internal.ads.zzbca;
import com.google.android.gms.internal.ads.zzsf;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

@TargetApi(value=14)
public final class zzbav
extends zzbbi
implements MediaPlayer.OnBufferingUpdateListener,
MediaPlayer.OnCompletionListener,
MediaPlayer.OnErrorListener,
MediaPlayer.OnInfoListener,
MediaPlayer.OnPreparedListener,
MediaPlayer.OnVideoSizeChangedListener,
TextureView.SurfaceTextureListener {
    private static final Map<Integer, String> zzeaj = new HashMap<Integer, String>();
    private final zzbca zzeak;
    private final boolean zzeal;
    private int zzeam = 0;
    private int zzean = 0;
    private MediaPlayer zzeao;
    private Uri zzeap;
    private int zzeaq;
    private int zzear;
    private int zzeas;
    private int zzeat;
    private int zzeau;
    private zzbbv zzeav;
    private boolean zzeaw;
    private int zzeax;
    private zzbbf zzeay;

    public zzbav(Context context, boolean bl, boolean bl2, zzbby zzbby2, zzbca zzbca2) {
        super(context);
        this.setSurfaceTextureListener(this);
        this.zzeak = zzbca2;
        this.zzeaw = bl;
        this.zzeal = bl2;
        this.zzeak.zzb(this);
    }

    @Override
    public final String zzyk() {
        String string2 = String.valueOf(this.zzeaw ? " spherical" : "");
        if (string2.length() != 0) {
            return "MediaPlayer".concat(string2);
        }
        return new String("MediaPlayer");
    }

    @Override
    public final void zza(zzbbf zzbbf2) {
        this.zzeay = zzbbf2;
    }

    @Override
    public final void setVideoPath(String string2) {
        Uri uri = Uri.parse((String)string2);
        zzbav zzbav2 = this;
        zzsf zzsf2 = zzsf.zzd(uri);
        if (zzsf2 == null || zzsf2.url != null) {
            zzbav2.zzeap = zzsf2 == null ? uri : Uri.parse((String)zzsf2.url);
            zzbav2.zzeax = 0;
            zzbav2.zzyl();
            zzbav2.requestLayout();
            zzbav2.invalidate();
        }
    }

    @Override
    public final void stop() {
        zzawr.zzeg("AdMediaPlayerView stop");
        if (this.zzeao != null) {
            this.zzeao.stop();
            this.zzeao.release();
            this.zzeao = null;
            this.zzdc(0);
            this.zzean = 0;
        }
        this.zzeak.onStop();
    }

    public final void onVideoSizeChanged(MediaPlayer mediaPlayer, int n, int n2) {
        zzawr.zzeg(new StringBuilder(57).append("AdMediaPlayerView size changed: ").append(n).append(" x ").append(n2).toString());
        this.zzeaq = mediaPlayer.getVideoWidth();
        this.zzear = mediaPlayer.getVideoHeight();
        if (this.zzeaq != 0 && this.zzear != 0) {
            this.requestLayout();
        }
    }

    public final void onPrepared(MediaPlayer mediaPlayer) {
        zzawr.zzeg("AdMediaPlayerView prepared");
        this.zzdc(2);
        this.zzeak.zzfa();
        zzaxa.zzdwf.post((Runnable)new zzbax(this));
        this.zzeaq = mediaPlayer.getVideoWidth();
        this.zzear = mediaPlayer.getVideoHeight();
        if (this.zzeax != 0) {
            ((zzbbi)this).seekTo(this.zzeax);
        }
        this.zzym();
        int n = this.zzeaq;
        int n2 = this.zzear;
        zzawr.zzfb((String)new StringBuilder(62).append("AdMediaPlayerView stream dimensions: ").append(n).append(" x ").append(n2).toString());
        if (this.zzean == 3) {
            ((zzbbi)this).play();
        }
        ((zzbbi)this).zzyo();
    }

    public final void onCompletion(MediaPlayer mediaPlayer) {
        zzawr.zzeg("AdMediaPlayerView completion");
        this.zzdc(5);
        this.zzean = 5;
        zzaxa.zzdwf.post((Runnable)new zzbba(this));
    }

    public final boolean onInfo(MediaPlayer mediaPlayer, int n, int n2) {
        String string2 = zzeaj.get(n);
        String string3 = zzeaj.get(n2);
        zzawr.zzeg(new StringBuilder(37 + String.valueOf(string2).length() + String.valueOf(string3).length()).append("AdMediaPlayerView MediaPlayer info: ").append(string2).append(":").append(string3).toString());
        return true;
    }

    public final boolean onError(MediaPlayer mediaPlayer, int n, int n2) {
        String string2 = zzeaj.get(n);
        String string3 = zzeaj.get(n2);
        zzawr.zzfc((String)new StringBuilder(38 + String.valueOf(string2).length() + String.valueOf(string3).length()).append("AdMediaPlayerView MediaPlayer error: ").append(string2).append(":").append(string3).toString());
        this.zzdc(-1);
        this.zzean = -1;
        zzaxa.zzdwf.post((Runnable)new zzbaz(this, string2, string3));
        return true;
    }

    public final void onBufferingUpdate(MediaPlayer mediaPlayer, int n) {
        this.zzeas = n;
    }

    public final void onSurfaceTextureAvailable(SurfaceTexture surfaceTexture, int n, int n2) {
        zzawr.zzeg("AdMediaPlayerView surface created");
        this.zzyl();
        zzaxa.zzdwf.post((Runnable)new zzbbc(this));
    }

    public final void onSurfaceTextureSizeChanged(SurfaceTexture surfaceTexture, int n, int n2) {
        boolean bl;
        zzawr.zzeg("AdMediaPlayerView surface changed");
        boolean bl2 = this.zzean == 3;
        boolean bl3 = bl = this.zzeaq == n && this.zzear == n2;
        if (this.zzeao != null && bl2 && bl) {
            if (this.zzeax != 0) {
                ((zzbbi)this).seekTo(this.zzeax);
            }
            ((zzbbi)this).play();
        }
        if (this.zzeav != null) {
            this.zzeav.zzm(n, n2);
        }
        zzaxa.zzdwf.post((Runnable)new zzbbb(this, n, n2));
    }

    public final boolean onSurfaceTextureDestroyed(SurfaceTexture surfaceTexture) {
        zzawr.zzeg("AdMediaPlayerView surface destroyed");
        if (this.zzeao != null && this.zzeax == 0) {
            this.zzeax = this.zzeao.getCurrentPosition();
        }
        if (this.zzeav != null) {
            this.zzeav.zzzb();
        }
        zzaxa.zzdwf.post((Runnable)new zzbbe(this));
        this.zzat(true);
        return true;
    }

    public final void onSurfaceTextureUpdated(SurfaceTexture surfaceTexture) {
        this.zzeak.zzc(this);
        this.zzebg.zza(surfaceTexture, this.zzeay);
    }

    protected final void onWindowVisibilityChanged(int n) {
        zzawr.zzeg(new StringBuilder(58).append("AdMediaPlayerView window visibility changed to ").append(n).toString());
        zzaxa.zzdwf.post((Runnable)new zzbay(this, n));
        super.onWindowVisibilityChanged(n);
    }

    protected final void onMeasure(int n, int n2) {
        int n3 = zzbav.getDefaultSize((int)this.zzeaq, (int)n);
        int n4 = zzbav.getDefaultSize((int)this.zzear, (int)n2);
        if (this.zzeaq > 0 && this.zzear > 0 && this.zzeav == null) {
            int n5 = View.MeasureSpec.getMode((int)n);
            int n6 = View.MeasureSpec.getSize((int)n);
            int n7 = View.MeasureSpec.getMode((int)n2);
            int n8 = View.MeasureSpec.getSize((int)n2);
            if (n5 == 0x40000000 && n7 == 0x40000000) {
                n4 = n8;
                n3 = n6;
                if (this.zzeaq * n4 < n3 * this.zzear) {
                    n3 = n4 * this.zzeaq / this.zzear;
                } else if (this.zzeaq * n4 > n3 * this.zzear) {
                    n4 = n3 * this.zzear / this.zzeaq;
                }
            } else if (n5 == 0x40000000) {
                n3 = n6;
                n4 = n3 * this.zzear / this.zzeaq;
                if (n7 == Integer.MIN_VALUE && n4 > n8) {
                    n4 = n8;
                }
            } else if (n7 == 0x40000000) {
                n4 = n8;
                n3 = n4 * this.zzeaq / this.zzear;
                if (n5 == Integer.MIN_VALUE && n3 > n6) {
                    n3 = n6;
                }
            } else {
                n3 = this.zzeaq;
                n4 = this.zzear;
                if (n7 == Integer.MIN_VALUE && n4 > n8) {
                    n4 = n8;
                    n3 = n4 * this.zzeaq / this.zzear;
                }
                if (n5 == Integer.MIN_VALUE && n3 > n6) {
                    n3 = n6;
                    n4 = n3 * this.zzear / this.zzeaq;
                }
            }
        }
        this.setMeasuredDimension(n3, n4);
        if (this.zzeav != null) {
            this.zzeav.zzm(n3, n4);
        }
        if (Build.VERSION.SDK_INT == 16) {
            if (this.zzeat > 0 && this.zzeat != n3 || this.zzeau > 0 && this.zzeau != n4) {
                this.zzym();
            }
            this.zzeat = n3;
            this.zzeau = n4;
        }
    }

    public final String toString() {
        String string2 = this.getClass().getName();
        String string3 = Integer.toHexString(this.hashCode());
        return new StringBuilder(1 + String.valueOf(string2).length() + String.valueOf(string3).length()).append(string2).append("@").append(string3).toString();
    }

    private final void zzyl() {
        zzawr.zzeg("AdMediaPlayerView init MediaPlayer");
        SurfaceTexture surfaceTexture = this.getSurfaceTexture();
        if (this.zzeap == null || surfaceTexture == null) {
            return;
        }
        this.zzat(false);
        try {
            Surface surface;
            zzq.zzlm();
            this.zzeao = new MediaPlayer();
            this.zzeao.setOnBufferingUpdateListener((MediaPlayer.OnBufferingUpdateListener)this);
            this.zzeao.setOnCompletionListener((MediaPlayer.OnCompletionListener)this);
            this.zzeao.setOnErrorListener((MediaPlayer.OnErrorListener)this);
            this.zzeao.setOnInfoListener((MediaPlayer.OnInfoListener)this);
            this.zzeao.setOnPreparedListener((MediaPlayer.OnPreparedListener)this);
            this.zzeao.setOnVideoSizeChangedListener((MediaPlayer.OnVideoSizeChangedListener)this);
            this.zzeas = 0;
            if (this.zzeaw) {
                this.zzeav = new zzbbv(this.getContext());
                this.zzeav.zza(surfaceTexture, this.getWidth(), this.getHeight());
                this.zzeav.start();
                surface = this.zzeav.zzzc();
                if (surface != null) {
                    surfaceTexture = surface;
                } else {
                    this.zzeav.zzzb();
                    this.zzeav = null;
                }
            }
            this.zzeao.setDataSource(this.getContext(), this.zzeap);
            zzq.zzln();
            SurfaceTexture surfaceTexture2 = surfaceTexture;
            surface = new Surface(surfaceTexture2);
            this.zzeao.setSurface(surface);
            this.zzeao.setAudioStreamType(3);
            this.zzeao.setScreenOnWhilePlaying(true);
            this.zzeao.prepareAsync();
            this.zzdc(1);
            return;
        }
        catch (IOException | IllegalArgumentException | IllegalStateException exception) {
            String string2 = String.valueOf(this.zzeap);
            zzawr.zzd((String)new StringBuilder(36 + String.valueOf(string2).length()).append("Failed to initialize MediaPlayer at ").append(string2).toString(), (Throwable)exception);
            this.onError(this.zzeao, 1, 0);
            return;
        }
    }

    private final void zzym() {
        if (!this.zzeal) {
            return;
        }
        if (this.zzyn() && this.zzeao.getCurrentPosition() > 0 && this.zzean != 3) {
            zzawr.zzeg("AdMediaPlayerView nudging MediaPlayer");
            this.zzd(0.0f);
            this.zzeao.start();
            int n = this.zzeao.getCurrentPosition();
            long l = zzq.zzld().currentTimeMillis();
            while (this.zzyn() && this.zzeao.getCurrentPosition() == n && zzq.zzld().currentTimeMillis() - l <= 250L) {
            }
            this.zzeao.pause();
            ((zzbbi)this).zzyo();
        }
    }

    private final void zzat(boolean bl) {
        zzawr.zzeg("AdMediaPlayerView release");
        if (this.zzeav != null) {
            this.zzeav.zzzb();
            this.zzeav = null;
        }
        if (this.zzeao != null) {
            this.zzeao.reset();
            this.zzeao.release();
            this.zzeao = null;
            this.zzdc(0);
            if (bl) {
                this.zzean = 0;
                this.zzean = 0;
            }
        }
    }

    @Override
    public final void play() {
        zzawr.zzeg("AdMediaPlayerView play");
        if (this.zzyn()) {
            this.zzeao.start();
            this.zzdc(3);
            this.zzebg.zzyq();
            zzaxa.zzdwf.post((Runnable)new zzbbd(this));
        }
        this.zzean = 3;
    }

    @Override
    public final void pause() {
        zzawr.zzeg("AdMediaPlayerView pause");
        if (this.zzyn() && this.zzeao.isPlaying()) {
            this.zzeao.pause();
            this.zzdc(4);
            zzaxa.zzdwf.post((Runnable)new zzbbg(this));
        }
        this.zzean = 4;
    }

    @Override
    public final int getDuration() {
        if (this.zzyn()) {
            return this.zzeao.getDuration();
        }
        return -1;
    }

    @Override
    public final int getCurrentPosition() {
        if (this.zzyn()) {
            return this.zzeao.getCurrentPosition();
        }
        return 0;
    }

    @Override
    public final void seekTo(int n) {
        zzawr.zzeg(new StringBuilder(34).append("AdMediaPlayerView seek ").append(n).toString());
        if (this.zzyn()) {
            this.zzeao.seekTo(n);
            this.zzeax = 0;
            return;
        }
        this.zzeax = n;
    }

    private final boolean zzyn() {
        return this.zzeao != null && this.zzeam != -1 && this.zzeam != 0 && this.zzeam != 1;
    }

    @Override
    public final void zza(float f, float f2) {
        if (this.zzeav != null) {
            this.zzeav.zzb(f, f2);
        }
    }

    @Override
    public final int getVideoWidth() {
        if (this.zzeao != null) {
            return this.zzeao.getVideoWidth();
        }
        return 0;
    }

    @Override
    public final int getVideoHeight() {
        if (this.zzeao != null) {
            return this.zzeao.getVideoHeight();
        }
        return 0;
    }

    @Override
    public final void zzyo() {
        this.zzd(this.zzebh.getVolume());
    }

    private final void zzd(float f) {
        if (this.zzeao != null) {
            try {
                this.zzeao.setVolume(f, f);
                return;
            }
            catch (IllegalStateException illegalStateException) {
                return;
            }
        }
        zzawr.zzfc((String)"AdMediaPlayerView setMediaPlayerVolume() called before onPrepared().");
    }

    private final void zzdc(int n) {
        if (n == 3) {
            this.zzeak.zzzp();
            this.zzebh.zzzp();
        } else if (this.zzeam == 3) {
            this.zzeak.zzzq();
            this.zzebh.zzzq();
        }
        this.zzeam = n;
    }

    final /* synthetic */ void zzdd(int n) {
        if (this.zzeay != null) {
            this.zzeay.onWindowVisibilityChanged(n);
        }
    }

    static /* synthetic */ zzbbf zza(zzbav zzbav2) {
        return zzbav2.zzeay;
    }

    static {
        if (Build.VERSION.SDK_INT >= 17) {
            zzeaj.put(-1004, "MEDIA_ERROR_IO");
            zzeaj.put(-1007, "MEDIA_ERROR_MALFORMED");
            zzeaj.put(-1010, "MEDIA_ERROR_UNSUPPORTED");
            zzeaj.put(-110, "MEDIA_ERROR_TIMED_OUT");
            zzeaj.put(3, "MEDIA_INFO_VIDEO_RENDERING_START");
        }
        zzeaj.put(100, "MEDIA_ERROR_SERVER_DIED");
        zzeaj.put(1, "MEDIA_ERROR_UNKNOWN");
        zzeaj.put(1, "MEDIA_INFO_UNKNOWN");
        zzeaj.put(700, "MEDIA_INFO_VIDEO_TRACK_LAGGING");
        zzeaj.put(701, "MEDIA_INFO_BUFFERING_START");
        zzeaj.put(702, "MEDIA_INFO_BUFFERING_END");
        zzeaj.put(800, "MEDIA_INFO_BAD_INTERLEAVING");
        zzeaj.put(801, "MEDIA_INFO_NOT_SEEKABLE");
        zzeaj.put(802, "MEDIA_INFO_METADATA_UPDATE");
        if (Build.VERSION.SDK_INT >= 19) {
            zzeaj.put(901, "MEDIA_INFO_UNSUPPORTED_SUBTITLE");
            zzeaj.put(902, "MEDIA_INFO_SUBTITLE_TIMED_OUT");
        }
    }
}

