/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Bitmap;
import android.text.TextUtils;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.Nullable;
import com.google.android.gms.ads.internal.zzq;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.ads.zzaam;
import com.google.android.gms.internal.ads.zzawr;
import com.google.android.gms.internal.ads.zzaxa;
import com.google.android.gms.internal.ads.zzbab;
import com.google.android.gms.internal.ads.zzbbf;
import com.google.android.gms.internal.ads.zzbbi;
import com.google.android.gms.internal.ads.zzbbj;
import com.google.android.gms.internal.ads.zzbbl;
import com.google.android.gms.internal.ads.zzbbm;
import com.google.android.gms.internal.ads.zzbbn;
import com.google.android.gms.internal.ads.zzbbo;
import com.google.android.gms.internal.ads.zzbbx;
import com.google.android.gms.internal.ads.zzbby;
import com.google.android.gms.internal.ads.zzbbz;
import com.google.android.gms.internal.ads.zzvj;
import com.google.android.gms.internal.ads.zzzk;
import com.google.android.gms.internal.ads.zzzz;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public final class zzbbk
extends FrameLayout
implements zzbbf {
    private final zzbbx zzebj;
    private final FrameLayout zzebk;
    private final zzaam zzebl;
    private final zzbbz zzebm;
    private final long zzebn;
    @Nullable
    private zzbbi zzebo;
    private boolean zzebp;
    private boolean zzebq;
    private boolean zzebr;
    private boolean zzebs;
    private long zzebt;
    private long zzebu;
    private String zzebv;
    private String[] zzebw;
    private Bitmap zzebx;
    private ImageView zzeby;
    private boolean zzebz;

    public static void zzb(zzbbx zzbbx2) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("event", "no_video_view");
        zzbbx2.zza("onVideoEvent", hashMap);
    }

    public static void zza(zzbbx zzbbx2, Map<String, List<Map<String, Object>>> map) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("event", "decoderProps");
        hashMap.put("mimeTypes", map);
        zzbbx2.zza("onVideoEvent", hashMap);
    }

    public static void zza(zzbbx zzbbx2, String string2) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("event", "decoderProps");
        hashMap.put("error", string2);
        zzbbx2.zza("onVideoEvent", hashMap);
    }

    public zzbbk(Context context, zzbbx zzbbx2, int n, boolean bl, zzaam zzaam2, zzbby zzbby2) {
        super(context);
        zzzk zzzk2;
        this.zzebj = zzbbx2;
        this.zzebl = zzaam2;
        this.zzebk = new FrameLayout(context);
        this.addView((View)this.zzebk, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        Preconditions.checkNotNull((Object)zzbbx2.zzzi());
        this.zzebo = zzbbx2.zzzi().zzblq.zza(context, zzbbx2, n, bl, zzaam2, zzbby2);
        if (this.zzebo != null) {
            this.zzebk.addView((View)this.zzebo, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1, 17));
            zzzk2 = zzzz.zzcjp;
            if (((Boolean)zzvj.zzpv().zzd(zzzk2)).booleanValue()) {
                this.zzyw();
            }
        }
        this.zzeby = new ImageView(context);
        zzzk2 = zzzz.zzcjt;
        this.zzebn = (Long)zzvj.zzpv().zzd(zzzk2);
        zzzk2 = zzzz.zzcjr;
        this.zzebs = (Boolean)zzvj.zzpv().zzd(zzzk2);
        if (this.zzebl != null) {
            this.zzebl.zzh("spinner_used", this.zzebs ? "1" : "0");
        }
        this.zzebm = new zzbbz(this);
        if (this.zzebo != null) {
            this.zzebo.zza(this);
        }
        if (this.zzebo == null) {
            this.zzm("AdVideoUnderlay Error", "Allocating player failed.");
        }
    }

    public final void zzd(int n, int n2, int n3, int n4) {
        if (n3 == 0 || n4 == 0) {
            return;
        }
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(n3, n4);
        layoutParams.setMargins(n, n2, 0, 0);
        this.zzebk.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        this.requestLayout();
    }

    public final void zzc(String string2, String[] stringArray) {
        this.zzebv = string2;
        this.zzebw = stringArray;
    }

    public final void zza(float f, float f2) {
        if (this.zzebo != null) {
            this.zzebo.zza(f, f2);
        }
    }

    public final void zzhx() {
        if (this.zzebo == null) {
            return;
        }
        if (!TextUtils.isEmpty((CharSequence)this.zzebv)) {
            this.zzebo.zzb(this.zzebv, this.zzebw);
            return;
        }
        this.zzd("no_src", new String[0]);
    }

    public final void pause() {
        if (this.zzebo == null) {
            return;
        }
        this.zzebo.pause();
    }

    public final void play() {
        if (this.zzebo == null) {
            return;
        }
        this.zzebo.play();
    }

    public final void seekTo(int n) {
        if (this.zzebo == null) {
            return;
        }
        this.zzebo.seekTo(n);
    }

    public final void zzyu() {
        if (this.zzebo == null) {
            return;
        }
        zzbbi zzbbi2 = this.zzebo;
        zzbbi2.zzebh.setMuted(true);
        zzbbi2.zzyo();
    }

    public final void zzyv() {
        if (this.zzebo == null) {
            return;
        }
        zzbbi zzbbi2 = this.zzebo;
        zzbbi2.zzebh.setMuted(false);
        zzbbi2.zzyo();
    }

    public final void setVolume(float f) {
        if (this.zzebo == null) {
            return;
        }
        float f2 = f;
        zzbbi zzbbi2 = this.zzebo;
        zzbbi2.zzebh.setVolume(f2);
        zzbbi2.zzyo();
    }

    public final void zzde(int n) {
        this.zzebo.zzde(n);
    }

    public final void zzdf(int n) {
        this.zzebo.zzdf(n);
    }

    public final void zzdg(int n) {
        this.zzebo.zzdg(n);
    }

    public final void zzdh(int n) {
        this.zzebo.zzdh(n);
    }

    public final void zzdi(int n) {
        this.zzebo.zzdi(n);
    }

    @TargetApi(value=14)
    public final void zze(MotionEvent motionEvent) {
        if (this.zzebo == null) {
            return;
        }
        this.zzebo.dispatchTouchEvent(motionEvent);
    }

    @TargetApi(value=14)
    public final void zzyw() {
        if (this.zzebo == null) {
            return;
        }
        Context context = this.zzebo.getContext();
        TextView textView = new TextView(context);
        String string2 = String.valueOf(this.zzebo.zzyk());
        textView.setText((CharSequence)(string2.length() != 0 ? "AdMob - ".concat(string2) : new String("AdMob - ")));
        textView.setTextColor(-65536);
        textView.setBackgroundColor(-256);
        this.zzebk.addView((View)textView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -2, 17));
        this.zzebk.bringChildToFront((View)textView);
    }

    @Override
    public final void zzyp() {
        this.zzebm.resume();
        zzaxa.zzdwf.post((Runnable)new zzbbl(this));
    }

    @Override
    public final void zzfa() {
        if (this.zzebo == null) {
            return;
        }
        if (this.zzebu == 0L) {
            float f = (float)this.zzebo.getDuration() / 1000.0f;
            int n = this.zzebo.getVideoWidth();
            int n2 = this.zzebo.getVideoHeight();
            this.zzd("canplaythrough", "duration", String.valueOf(f), "videoWidth", String.valueOf(n), "videoHeight", String.valueOf(n2));
        }
    }

    @Override
    public final void zzyq() {
        zzbbk zzbbk2 = this;
        if (zzbbk2.zzebj.zzzh() != null && !zzbbk2.zzebq) {
            WindowManager.LayoutParams layoutParams = zzbbk2.zzebj.zzzh().getWindow().getAttributes();
            boolean bl = zzbbk2.zzebr = (layoutParams.flags & 0x80) != 0;
            if (!zzbbk2.zzebr) {
                zzbbk2.zzebj.zzzh().getWindow().addFlags(128);
                zzbbk2.zzebq = true;
            }
        }
        this.zzebp = true;
    }

    @Override
    public final void onPaused() {
        this.zzd("pause", new String[0]);
        this.zzyz();
        this.zzebp = false;
    }

    @Override
    public final void zzyr() {
        this.zzd("ended", new String[0]);
        this.zzyz();
    }

    @Override
    public final void zzm(String string2, @Nullable String string3) {
        this.zzd("error", "what", string2, "extra", string3);
    }

    @Override
    public final void zzys() {
        zzbbk zzbbk2 = this;
        if (zzbbk2.zzebz && zzbbk2.zzebx != null && !zzbbk2.zzyy()) {
            zzbbk2.zzeby.setImageBitmap(zzbbk2.zzebx);
            zzbbk2.zzeby.invalidate();
            zzbbk2.zzebk.addView((View)zzbbk2.zzeby, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
            zzbbk2.zzebk.bringChildToFront((View)zzbbk2.zzeby);
        }
        this.zzebm.pause();
        this.zzebu = this.zzebt;
        zzaxa.zzdwf.post((Runnable)new zzbbo(this));
    }

    public final void destroy() {
        this.zzebm.pause();
        if (this.zzebo != null) {
            this.zzebo.stop();
        }
        this.zzyz();
    }

    public final void finalize() throws Throwable {
        try {
            this.zzebm.pause();
            if (this.zzebo != null) {
                zzbbi zzbbi2;
                zzbbi zzbbi3 = zzbbi2 = this.zzebo;
                zzbbi3.getClass();
                zzbab.zzdzv.execute(zzbbj.zza(zzbbi3));
            }
            return;
        }
        finally {
            super.finalize();
        }
    }

    final void zzyx() {
        if (this.zzebo == null) {
            return;
        }
        long l = this.zzebo.getCurrentPosition();
        if (this.zzebt != l && l > 0L) {
            float f = (float)l / 1000.0f;
            this.zzd("timeupdate", "time", String.valueOf(f));
            this.zzebt = l;
        }
    }

    @Override
    public final void zzyt() {
        zzbbk zzbbk2;
        if (this.zzebp && (zzbbk2 = this).zzyy()) {
            zzbbk2.zzebk.removeView((View)zzbbk2.zzeby);
        }
        zzbbk2 = this;
        if (zzbbk2.zzebx != null) {
            long l = zzq.zzld().elapsedRealtime();
            if (zzbbk2.zzebo.getBitmap(zzbbk2.zzebx) != null) {
                zzbbk2.zzebz = true;
            }
            long l2 = zzq.zzld().elapsedRealtime() - l;
            if (zzawr.zzwo()) {
                zzawr.zzeg(new StringBuilder(46).append("Spinner frame grab took ").append(l2).append("ms").toString());
            }
            if (l2 > zzbbk2.zzebn) {
                zzawr.zzfc((String)"Spinner frame grab crossed jank threshold! Suspending spinner.");
                zzbbk2.zzebs = false;
                zzbbk2.zzebx = null;
                if (zzbbk2.zzebl != null) {
                    zzbbk2.zzebl.zzh("spinner_jank", Long.toString(l2));
                }
            }
        }
    }

    @Override
    public final void zzk(int n, int n2) {
        int n3 = n2;
        int n4 = n;
        zzbbk zzbbk2 = this;
        if (zzbbk2.zzebs) {
            zzzk zzzk2 = zzzz.zzcjs;
            n4 = Math.max(n4 / (Integer)zzvj.zzpv().zzd(zzzk2), 1);
            zzzk2 = zzzz.zzcjs;
            n3 = Math.max(n3 / (Integer)zzvj.zzpv().zzd(zzzk2), 1);
            if (zzbbk2.zzebx == null || zzbbk2.zzebx.getWidth() != n4 || zzbbk2.zzebx.getHeight() != n3) {
                zzbbk2.zzebx = Bitmap.createBitmap((int)n4, (int)n3, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                zzbbk2.zzebz = false;
            }
        }
    }

    public final void onWindowFocusChanged(boolean bl) {
        super.onWindowFocusChanged(bl);
        if (bl) {
            this.zzebm.resume();
        } else {
            this.zzebm.pause();
            this.zzebu = this.zzebt;
        }
        zzaxa.zzdwf.post((Runnable)new zzbbm(this, bl));
    }

    @Override
    public final void onWindowVisibilityChanged(int n) {
        boolean bl;
        super.onWindowVisibilityChanged(n);
        if (n == 0) {
            this.zzebm.resume();
            bl = true;
        } else {
            this.zzebm.pause();
            this.zzebu = this.zzebt;
            bl = false;
        }
        zzaxa.zzdwf.post((Runnable)new zzbbn(this, bl));
    }

    private final boolean zzyy() {
        return this.zzeby.getParent() != null;
    }

    private final void zzd(String string2, String ... stringArray) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("event", string2);
        String string3 = null;
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String string4 = stringArray2[i];
            if (string3 == null) {
                string3 = string4;
                continue;
            }
            hashMap.put(string3, string4);
            string3 = null;
        }
        this.zzebj.zza("onVideoEvent", hashMap);
    }

    private final void zzyz() {
        if (this.zzebj.zzzh() == null) {
            return;
        }
        if (this.zzebq && !this.zzebr) {
            this.zzebj.zzzh().getWindow().clearFlags(128);
            this.zzebq = false;
        }
    }

    final /* synthetic */ void zzau(boolean bl) {
        this.zzd("windowFocusChanged", "hasWindowFocus", String.valueOf(bl));
    }

    static /* synthetic */ void zza(zzbbk zzbbk2, String string2, String[] stringArray) {
        zzbbk2.zzd(string2, stringArray);
    }
}

