/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.SurfaceTexture;
import android.net.Uri;
import android.os.Build;
import android.view.Surface;
import android.view.TextureView;
import com.google.android.gms.ads.internal.zzq;
import com.google.android.gms.internal.ads.zzawr;
import com.google.android.gms.internal.ads.zzaxa;
import com.google.android.gms.internal.ads.zzbab;
import com.google.android.gms.internal.ads.zzbbf;
import com.google.android.gms.internal.ads.zzbbi;
import com.google.android.gms.internal.ads.zzbbv;
import com.google.android.gms.internal.ads.zzbbx;
import com.google.android.gms.internal.ads.zzbby;
import com.google.android.gms.internal.ads.zzbca;
import com.google.android.gms.internal.ads.zzbcd;
import com.google.android.gms.internal.ads.zzbcf;
import com.google.android.gms.internal.ads.zzbcg;
import com.google.android.gms.internal.ads.zzbch;
import com.google.android.gms.internal.ads.zzbci;
import com.google.android.gms.internal.ads.zzbcj;
import com.google.android.gms.internal.ads.zzbck;
import com.google.android.gms.internal.ads.zzbcl;
import com.google.android.gms.internal.ads.zzbcm;
import com.google.android.gms.internal.ads.zzbco;
import com.google.android.gms.internal.ads.zzbcu;
import com.google.android.gms.internal.ads.zzbdc;
import com.google.android.gms.internal.ads.zzbdl;
import com.google.android.gms.internal.ads.zzbdx;
import com.google.android.gms.internal.ads.zzbea;
import com.google.android.gms.internal.ads.zzgt;
import java.nio.ByteBuffer;
import java.util.Arrays;

@TargetApi(value=16)
public final class zzbce
extends zzbbi
implements TextureView.SurfaceTextureListener,
zzbdc {
    private final zzbbx zzebj;
    private final zzbca zzeak;
    private final boolean zzeal;
    private final zzbby zzeet;
    private zzbbf zzeay;
    private Surface zzbiu;
    private zzbcu zzeeu;
    private String zzeev;
    private String[] zzebw;
    private boolean zzeew;
    private int zzeex = 1;
    private zzbbv zzeav;
    private final boolean zzeaw;
    private boolean zzeey;
    private boolean zzeez;
    private int zzeaq;
    private int zzear;
    private int zzeat;
    private int zzeau;
    private float zzefa;

    public zzbce(Context context, zzbca zzbca2, zzbbx zzbbx2, boolean bl, boolean bl2, zzbby zzbby2) {
        super(context);
        this.zzeal = bl2;
        this.zzebj = zzbbx2;
        this.zzeak = zzbca2;
        this.zzeaw = bl;
        this.zzeet = zzbby2;
        this.setSurfaceTextureListener(this);
        this.zzeak.zzb(this);
    }

    private final zzbcu zzzs() {
        return new zzbcu(this.zzebj.getContext(), this.zzeet);
    }

    private final String zzzt() {
        return zzq.zzkw().zzr(this.zzebj.getContext(), this.zzebj.zzzk().zzbnd);
    }

    private final boolean zzzu() {
        return this.zzeeu != null && !this.zzeew;
    }

    private final boolean zzzv() {
        return this.zzzu() && this.zzeex != 1;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void zzzw() {
        block10: {
            block11: {
                if (this.zzeeu != null) {
                    return;
                }
                if (this.zzeev == null || this.zzbiu == null) {
                    return;
                }
                if (!this.zzeev.startsWith("cache:")) break block11;
                zzbdl zzbdl2 = this.zzebj.zzfh(this.zzeev);
                if (zzbdl2 instanceof zzbea) {
                    zzbea zzbea2 = (zzbea)zzbdl2;
                    this.zzeeu = zzbea2.zzaan();
                    if (this.zzeeu.zzaah() == null) {
                        zzawr.zzfc((String)"Precached video player has been released.");
                        return;
                    }
                    break block10;
                } else if (zzbdl2 instanceof zzbdx) {
                    zzbdx zzbdx2 = (zzbdx)zzbdl2;
                    String string2 = this.zzzt();
                    ByteBuffer byteBuffer = zzbdx2.getByteBuffer();
                    boolean bl = zzbdx2.zzaal();
                    String string3 = zzbdx2.getUrl();
                    if (string3 == null) {
                        zzawr.zzfc((String)"Stream cache URL is null.");
                        return;
                    }
                    this.zzeeu = this.zzzs();
                    this.zzeeu.zza(new Uri[]{Uri.parse((String)string3)}, string2, byteBuffer, bl);
                    break block10;
                } else {
                    String string4 = String.valueOf(this.zzeev);
                    zzawr.zzfc((String)(string4.length() != 0 ? "Stream cache miss: ".concat(string4) : new String("Stream cache miss: ")));
                    return;
                }
            }
            this.zzeeu = this.zzzs();
            String string5 = this.zzzt();
            Uri[] uriArray = new Uri[this.zzebw.length];
            for (int i = 0; i < this.zzebw.length; ++i) {
                uriArray[i] = Uri.parse((String)this.zzebw[i]);
            }
            this.zzeeu.zza(uriArray, string5);
        }
        this.zzeeu.zza(this);
        this.zza(this.zzbiu, false);
        this.zzeex = this.zzeeu.zzaah().getPlaybackState();
        if (this.zzeex == 3) {
            this.zzzx();
        }
    }

    private final void zza(Surface surface, boolean bl) {
        if (this.zzeeu != null) {
            this.zzeeu.zza(surface, bl);
            return;
        }
        zzawr.zzfc((String)"Trying to set surface before player is initalized.");
    }

    private final void zza(float f, boolean bl) {
        if (this.zzeeu != null) {
            this.zzeeu.zzb(f, bl);
            return;
        }
        zzawr.zzfc((String)"Trying to set volume before player is initalized.");
    }

    @Override
    public final void zzyo() {
        this.zza(this.zzebh.getVolume(), false);
    }

    private final void zzzx() {
        if (this.zzeey) {
            return;
        }
        this.zzeey = true;
        zzaxa.zzdwf.post((Runnable)new zzbcd(this));
        ((zzbbi)this).zzyo();
        this.zzeak.zzfa();
        if (this.zzeez) {
            ((zzbbi)this).play();
        }
    }

    @Override
    public final String zzyk() {
        String string2 = String.valueOf("ExoPlayer/3");
        String string3 = String.valueOf(this.zzeaw ? " spherical" : "");
        if (string3.length() != 0) {
            return string2.concat(string3);
        }
        return new String(string2);
    }

    @Override
    public final void zza(zzbbf zzbbf2) {
        this.zzeay = zzbbf2;
    }

    @Override
    public final void setVideoPath(String string2) {
        if (string2 != null) {
            this.zzeev = string2;
            this.zzebw = new String[]{string2};
            this.zzzw();
        }
    }

    @Override
    public final void zzb(String string2, String[] stringArray) {
        if (string2 != null) {
            if (stringArray == null) {
                ((zzbbi)this).setVideoPath(string2);
            }
            this.zzeev = string2;
            this.zzebw = Arrays.copyOf(stringArray, stringArray.length);
            this.zzzw();
        }
    }

    @Override
    public final void play() {
        if (this.zzzv()) {
            if (this.zzeet.zzedr) {
                this.zzzz();
            }
            this.zzeeu.zzaah().zzg(true);
            this.zzeak.zzzp();
            this.zzebh.zzzp();
            this.zzebg.zzyq();
            zzaxa.zzdwf.post((Runnable)new zzbci(this));
            return;
        }
        this.zzeez = true;
    }

    @Override
    public final void stop() {
        if (this.zzzu()) {
            this.zzeeu.zzaah().stop();
            zzbce zzbce2 = this;
            if (zzbce2.zzeeu != null) {
                zzbce2.zza(null, true);
                if (zzbce2.zzeeu != null) {
                    zzbce2.zzeeu.zza((zzbdc)null);
                    zzbce2.zzeeu.release();
                    zzbce2.zzeeu = null;
                }
                zzbce2.zzeex = 1;
                zzbce2.zzeew = false;
                zzbce2.zzeey = false;
                zzbce2.zzeez = false;
            }
        }
        this.zzeak.zzzq();
        this.zzebh.zzzq();
        this.zzeak.onStop();
    }

    @Override
    public final void pause() {
        if (this.zzzv()) {
            if (this.zzeet.zzedr) {
                this.zzaaa();
            }
            this.zzeeu.zzaah().zzg(false);
            this.zzeak.zzzq();
            this.zzebh.zzzq();
            zzaxa.zzdwf.post((Runnable)new zzbch(this));
        }
    }

    @Override
    public final void seekTo(int n) {
        if (this.zzzv()) {
            this.zzeeu.zzaah().seekTo(n);
        }
    }

    @Override
    public final void zzde(int n) {
        if (this.zzeeu != null) {
            this.zzeeu.zzaak().zzdl(n);
        }
    }

    @Override
    public final void zzdf(int n) {
        if (this.zzeeu != null) {
            this.zzeeu.zzaak().zzdm(n);
        }
    }

    @Override
    public final void zzdg(int n) {
        if (this.zzeeu != null) {
            this.zzeeu.zzaak().zzdg(n);
        }
    }

    @Override
    public final void zzdh(int n) {
        if (this.zzeeu != null) {
            this.zzeeu.zzaak().zzdh(n);
        }
    }

    @Override
    public final void zzdi(int n) {
        if (this.zzeeu != null) {
            this.zzeeu.zzdi(n);
        }
    }

    @Override
    public final void zza(float f, float f2) {
        if (this.zzeav != null) {
            this.zzeav.zzb(f, f2);
        }
    }

    @Override
    public final int getCurrentPosition() {
        if (this.zzzv()) {
            return (int)this.zzeeu.zzaah().zzem();
        }
        return 0;
    }

    @Override
    public final int getDuration() {
        if (this.zzzv()) {
            return (int)this.zzeeu.zzaah().getDuration();
        }
        return 0;
    }

    @Override
    public final int getVideoWidth() {
        return this.zzeaq;
    }

    @Override
    public final int getVideoHeight() {
        return this.zzear;
    }

    protected final void onMeasure(int n, int n2) {
        super.onMeasure(n, n2);
        int n3 = this.getMeasuredWidth();
        int n4 = this.getMeasuredHeight();
        if (this.zzefa != 0.0f && this.zzeav == null) {
            float f = (float)n3 / (float)n4;
            if (this.zzefa > f) {
                n4 = (int)((float)n3 / this.zzefa);
            }
            if (this.zzefa < f) {
                n3 = (int)((float)n4 * this.zzefa);
            }
        }
        this.setMeasuredDimension(n3, n4);
        if (this.zzeav != null) {
            this.zzeav.zzm(n3, n4);
        }
        if (Build.VERSION.SDK_INT == 16) {
            if (this.zzeat > 0 && this.zzeat != n3 || this.zzeau > 0 && this.zzeau != n4) {
                zzgt zzgt2;
                zzbce zzbce2 = this;
                if (zzbce2.zzeal && zzbce2.zzzu() && (zzgt2 = zzbce2.zzeeu.zzaah()).zzem() > 0L && !zzgt2.zzek()) {
                    zzbce2.zza(0.0f, true);
                    zzgt2.zzg(true);
                    long l = zzgt2.zzem();
                    long l2 = zzq.zzld().currentTimeMillis();
                    while (zzbce2.zzzu() && zzgt2.zzem() == l && zzq.zzld().currentTimeMillis() - l2 <= 250L) {
                    }
                    zzgt2.zzg(false);
                    ((zzbbi)zzbce2).zzyo();
                }
            }
            this.zzeat = n3;
            this.zzeau = n4;
        }
    }

    public final void onSurfaceTextureAvailable(SurfaceTexture surfaceTexture, int n, int n2) {
        if (this.zzeaw) {
            this.zzeav = new zzbbv(this.getContext());
            this.zzeav.zza(surfaceTexture, n, n2);
            this.zzeav.start();
            SurfaceTexture surfaceTexture2 = this.zzeav.zzzc();
            if (surfaceTexture2 != null) {
                surfaceTexture = surfaceTexture2;
            } else {
                this.zzeav.zzzb();
                this.zzeav = null;
            }
        }
        SurfaceTexture surfaceTexture3 = surfaceTexture;
        this.zzbiu = new Surface(surfaceTexture3);
        if (this.zzeeu == null) {
            this.zzzw();
        } else {
            this.zza(this.zzbiu, true);
            if (!this.zzeet.zzedr) {
                this.zzzz();
            }
        }
        if (this.zzeaq == 0 || this.zzear == 0) {
            this.zzo(n, n2);
        } else {
            this.zzzy();
        }
        zzaxa.zzdwf.post((Runnable)new zzbck(this));
    }

    public final void onSurfaceTextureSizeChanged(SurfaceTexture surfaceTexture, int n, int n2) {
        if (this.zzeav != null) {
            this.zzeav.zzm(n, n2);
        }
        zzaxa.zzdwf.post((Runnable)new zzbcj(this, n, n2));
    }

    public final void onSurfaceTextureUpdated(SurfaceTexture surfaceTexture) {
        this.zzeak.zzc(this);
        this.zzebg.zza(surfaceTexture, this.zzeay);
    }

    public final boolean onSurfaceTextureDestroyed(SurfaceTexture surfaceTexture) {
        ((zzbbi)this).pause();
        if (this.zzeav != null) {
            this.zzeav.zzzb();
            this.zzeav = null;
        }
        if (this.zzeeu != null) {
            this.zzaaa();
            if (this.zzbiu != null) {
                this.zzbiu.release();
            }
            this.zzbiu = null;
            this.zza(null, true);
        }
        zzaxa.zzdwf.post((Runnable)new zzbcm(this));
        return true;
    }

    protected final void onWindowVisibilityChanged(int n) {
        zzawr.zzeg(new StringBuilder(57).append("AdExoPlayerView3 window visibility changed to ").append(n).toString());
        zzaxa.zzdwf.post((Runnable)new zzbcl(this, n));
        super.onWindowVisibilityChanged(n);
    }

    @Override
    public final void zzb(boolean bl, long l) {
        if (this.zzebj != null) {
            zzbab.zzdzv.execute(new zzbco(this, bl, l));
        }
    }

    @Override
    public final void zzdj(int n) {
        if (this.zzeex != n) {
            this.zzeex = n;
            switch (n) {
                case 3: {
                    this.zzzx();
                    return;
                }
                case 4: {
                    zzbce zzbce2 = this;
                    if (zzbce2.zzeet.zzedr) {
                        zzbce2.zzaaa();
                    }
                    zzbce2.zzeak.zzzq();
                    zzbce2.zzebh.zzzq();
                    zzaxa.zzdwf.post((Runnable)new zzbcg(zzbce2));
                }
            }
        }
    }

    @Override
    public final void zzn(int n, int n2) {
        this.zzeaq = n;
        this.zzear = n2;
        this.zzzy();
    }

    @Override
    public final void zza(String string2, Exception exception) {
        Exception exception2 = exception;
        String string3 = string2;
        zzbce zzbce2 = this;
        String string4 = exception2.getClass().getCanonicalName();
        String string5 = exception2.getMessage();
        String string6 = new StringBuilder(2 + String.valueOf(string3).length() + String.valueOf(string4).length() + String.valueOf(string5).length()).append(string3).append("/").append(string4).append(":").append(string5).toString();
        String string7 = String.valueOf(string6);
        zzawr.zzfc((String)(string7.length() != 0 ? "ExoPlayerAdapter error: ".concat(string7) : new String("ExoPlayerAdapter error: ")));
        zzbce2.zzeew = true;
        if (zzbce2.zzeet.zzedr) {
            zzbce2.zzaaa();
        }
        zzaxa.zzdwf.post((Runnable)new zzbcf(zzbce2, string6));
    }

    private final void zzzy() {
        this.zzo(this.zzeaq, this.zzear);
    }

    private final void zzo(int n, int n2) {
        float f;
        float f2 = f = n2 > 0 ? (float)n / (float)n2 : 1.0f;
        if (this.zzefa != f) {
            this.zzefa = f;
            this.requestLayout();
        }
    }

    private final void zzzz() {
        if (this.zzeeu != null) {
            this.zzeeu.zzaw(true);
        }
    }

    private final void zzaaa() {
        if (this.zzeeu != null) {
            this.zzeeu.zzaw(false);
        }
    }

    final /* synthetic */ void zzc(boolean bl, long l) {
        this.zzebj.zza(bl, l);
    }

    final /* synthetic */ void zzdk(int n) {
        if (this.zzeay != null) {
            this.zzeay.onWindowVisibilityChanged(n);
        }
    }

    final /* synthetic */ void zzaab() {
        if (this.zzeay != null) {
            this.zzeay.zzys();
        }
    }

    final /* synthetic */ void zzp(int n, int n2) {
        if (this.zzeay != null) {
            this.zzeay.zzk(n, n2);
        }
    }

    final /* synthetic */ void zzaac() {
        if (this.zzeay != null) {
            this.zzeay.zzyp();
        }
    }

    final /* synthetic */ void zzaad() {
        if (this.zzeay != null) {
            this.zzeay.onPaused();
        }
    }

    final /* synthetic */ void zzaae() {
        if (this.zzeay != null) {
            this.zzeay.zzyq();
        }
    }

    final /* synthetic */ void zzfi(String string2) {
        if (this.zzeay != null) {
            this.zzeay.zzm("ExoPlayerAdapter error", string2);
        }
    }

    final /* synthetic */ void zzaaf() {
        if (this.zzeay != null) {
            this.zzeay.zzyr();
        }
    }

    final /* synthetic */ void zzaag() {
        if (this.zzeay != null) {
            this.zzeay.zzfa();
        }
    }
}

