/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.net.Uri;
import android.text.TextUtils;
import com.google.android.gms.internal.ads.zzawr;
import com.google.android.gms.internal.ads.zzbcq;
import com.google.android.gms.internal.ads.zznu;
import com.google.android.gms.internal.ads.zznv;
import com.google.android.gms.internal.ads.zznw;
import com.google.android.gms.internal.ads.zznz;
import com.google.android.gms.internal.ads.zzoa;
import com.google.android.gms.internal.ads.zzoc;
import com.google.android.gms.internal.ads.zzoh;
import com.google.android.gms.internal.ads.zzoi;
import com.google.android.gms.internal.ads.zzov;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.NoRouteToHostException;
import java.net.ProtocolException;
import java.net.Socket;
import java.net.SocketException;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;

final class zzbcn
implements zznu {
    private static final Pattern zzbfo = Pattern.compile("^bytes (\\d+)-(\\d+)/(\\d+)$");
    private static final AtomicReference<byte[]> zzbfp = new AtomicReference();
    private SSLSocketFactory zzefb = new zzbcq(this);
    private final int zzbfr;
    private final int zzbfs;
    private final String zzbft;
    private final zzoc zzbfw;
    private final zzoi<? super zzbcn> zzbfx;
    private zznv zzbfy;
    private HttpURLConnection zzbfz;
    private InputStream zzbga;
    private boolean zzbgb;
    private long zzbgc;
    private long zzbgd;
    private long zzbge;
    private long zzcf;
    private int zzefc;
    private Set<Socket> zzefd = new HashSet<Socket>();

    zzbcn(String string2, zzoi<? super zzbcn> zzoi2, int n, int n2, int n3) {
        this.zzbft = zzoh.checkNotEmpty(string2);
        this.zzbfx = zzoi2;
        this.zzbfw = new zzoc();
        this.zzbfr = n;
        this.zzbfs = n2;
        this.zzefc = n3;
    }

    @Override
    public final Uri getUri() {
        if (this.zzbfz == null) {
            return null;
        }
        return Uri.parse((String)this.zzbfz.getURL().toString());
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    @Override
    public final long zza(zznv var1_1) throws zzoa {
        this.zzbfy = var1_1;
        this.zzcf = 0L;
        this.zzbge = 0L;
        try {
            block20: {
                var6_2 = var1_1;
                var5_3 = this;
                var7_4 = new URL(var6_2.uri.toString());
                var8_5 = var6_2.zzbfm;
                var9_6 = var6_2.position;
                var11_7 = var6_2.zzce;
                var13_8 = var6_2.isFlagSet(1);
                var14_9 = 0;
                while (var14_9++ <= 20) {
                    var25_20 = var13_8;
                    var23_19 = var11_7;
                    var21_18 = var9_6;
                    var20_16 /* !! */  = var8_5;
                    var19_15 = var7_4;
                    var18_14 = var5_3;
                    var26_21 = (HttpURLConnection)var19_15.openConnection();
                    if (var26_21 instanceof HttpsURLConnection) {
                        ((HttpsURLConnection)var26_21).setSSLSocketFactory(var18_14.zzefb);
                    }
                    var26_21.setConnectTimeout(var18_14.zzbfr);
                    var26_21.setReadTimeout(var18_14.zzbfs);
                    for (Object var28_23 : var18_14.zzbfw.zzis().entrySet()) {
                        var26_21.setRequestProperty(var28_23.getKey(), var28_23.getValue());
                    }
                    if (var21_18 != 0L || var23_19 != -1L) {
                        var27_22 = new StringBuilder(27).append("bytes=").append(var21_18).append("-").toString();
                        if (var23_19 != -1L) {
                            var28_23 = String.valueOf(var27_22);
                            var29_24 = var21_18 + var23_19 - 1L;
                            var27_22 = new StringBuilder(20 + String.valueOf(var28_23).length()).append((String)var28_23).append(var29_24).toString();
                        }
                        var26_21.setRequestProperty("Range", (String)var27_22);
                    }
                    var26_21.setRequestProperty("User-Agent", var18_14.zzbft);
                    if (!var25_20) {
                        var26_21.setRequestProperty("Accept-Encoding", "identity");
                    }
                    var26_21.setInstanceFollowRedirects(false);
                    var26_21.setDoOutput(var20_16 /* !! */  != null);
                    if (var20_16 /* !! */  == null) ** GOTO lbl-1000
                    var26_21.setRequestMethod("POST");
                    if (var20_16 /* !! */ .length != 0) {
                        var26_21.setFixedLengthStreamingMode(var20_16 /* !! */ .length);
                        var26_21.connect();
                        var27_22 = var26_21.getOutputStream();
                        var27_22.write(var20_16 /* !! */ );
                        var27_22.close();
                    } else lbl-1000:
                    // 2 sources

                    {
                        var26_21.connect();
                    }
                    var15_10 = var26_21;
                    var16_12 = var15_10.getResponseCode();
                    if (var16_12 == 300 || var16_12 == 301 || var16_12 == 302 || var16_12 == 303 || var8_5 == null && (var16_12 == 307 || var16_12 == 308)) {
                        var8_5 = null;
                        var17_13 = var15_10.getHeaderField("Location");
                        var15_10.disconnect();
                        var19_15 = var17_13;
                        var18_14 = var7_4;
                        if (var19_15 == null) {
                            throw new ProtocolException("Null location redirect");
                        }
                        v0 = new URL((URL)var18_14, (String)var19_15);
                        var20_16 /* !! */  = (byte[])v0;
                        var21_17 = v0.getProtocol();
                        if (!"https".equals(var21_17) && !"http".equals(var21_17)) {
                            v1 = String.valueOf(var21_17);
                            throw new ProtocolException(v1.length() != 0 ? "Unsupported protocol redirect: ".concat(v1) : new String("Unsupported protocol redirect: "));
                        }
                        var7_4 = var20_16 /* !! */ ;
                        continue;
                    }
                    break block20;
                }
                var15_11 = var14_9;
                throw new NoRouteToHostException(new StringBuilder(31).append("Too many redirects: ").append(var15_11).toString());
            }
            this.zzbfz = var15_10;
        }
        catch (IOException var2_25) {
            v2 = String.valueOf(var1_1.uri.toString());
            throw new zzoa(v2.length() != 0 ? "Unable to connect to ".concat(v2) : new String("Unable to connect to "), var2_25, var1_1, 1);
        }
        try {
            var2_26 = this.zzbfz.getResponseCode();
        }
        catch (IOException var3_27) {
            this.zzip();
            v3 = String.valueOf(var1_1.uri.toString());
            throw new zzoa(v3.length() != 0 ? "Unable to connect to ".concat(v3) : new String("Unable to connect to "), var3_27, var1_1, 1);
        }
        if (var2_26 < 200 || var2_26 > 299) {
            var3_28 = this.zzbfz.getHeaderFields();
            this.zzip();
            var4_31 = new zznz(var2_26, var3_28, var1_1);
            if (var2_26 == 416) {
                var4_31.initCause(new zznw(0));
            }
            throw var4_31;
        }
        v4 = this.zzbgc = var2_26 == 200 && var1_1.position != 0L ? var1_1.position : 0L;
        this.zzbgd = !var1_1.isFlagSet(1) ? (var1_1.zzce != -1L ? var1_1.zzce : ((var3_29 = zzbcn.zzc(this.zzbfz)) != -1L ? var3_29 - this.zzbgc : -1L)) : var1_1.zzce;
        try {
            this.zzbga = this.zzbfz.getInputStream();
        }
        catch (IOException var3_30) {
            this.zzip();
            throw new zzoa(var3_30, var1_1, 1);
        }
        this.zzbgb = true;
        if (this.zzbfx != null) {
            this.zzbfx.zza(this, var1_1);
        }
        return this.zzbgd;
    }

    @Override
    public final int read(byte[] byArray, int n, int n2) throws zzoa {
        try {
            int n3;
            int n4;
            int n5;
            byte[] byArray2;
            zzbcn zzbcn2 = this;
            if (zzbcn2.zzbge != zzbcn2.zzbgc) {
                byArray2 = zzbfp.getAndSet(null);
                if (byArray2 == null) {
                    byArray2 = new byte[4096];
                }
                while (zzbcn2.zzbge != zzbcn2.zzbgc) {
                    n5 = (int)Math.min(zzbcn2.zzbgc - zzbcn2.zzbge, (long)byArray2.length);
                    n4 = zzbcn2.zzbga.read(byArray2, 0, n5);
                    if (Thread.interrupted()) {
                        throw new InterruptedIOException();
                    }
                    if (n4 == -1) {
                        throw new EOFException();
                    }
                    zzbcn2.zzbge += (long)n4;
                    if (zzbcn2.zzbfx == null) continue;
                    zzbcn2.zzbfx.zzc(zzbcn2, n4);
                }
                zzbfp.set(byArray2);
            }
            n4 = n2;
            n5 = n;
            byArray2 = byArray;
            zzbcn2 = this;
            if (n4 == 0) {
                return 0;
            }
            if (zzbcn2.zzbgd != -1L) {
                long l = zzbcn2.zzbgd - zzbcn2.zzcf;
                if (l == 0L) {
                    return -1;
                }
                n4 = (int)Math.min((long)n4, l);
            }
            if ((n3 = zzbcn2.zzbga.read(byArray2, n5, n4)) == -1) {
                if (zzbcn2.zzbgd != -1L) {
                    throw new EOFException();
                }
                return -1;
            }
            zzbcn2.zzcf += (long)n3;
            if (zzbcn2.zzbfx != null) {
                zzbcn2.zzbfx.zzc(zzbcn2, n3);
            }
            return n3;
        }
        catch (IOException iOException) {
            throw new zzoa(iOException, this.zzbfy, 2);
        }
    }

    @Override
    public final void close() throws zzoa {
        try {
            if (this.zzbga != null) {
                block13: {
                    Object object = this;
                    long l = ((zzbcn)object).zzbgd == -1L ? ((zzbcn)object).zzbgd : ((zzbcn)object).zzbgd - ((zzbcn)object).zzcf;
                    object = this.zzbfz;
                    if (zzov.SDK_INT == 19 || zzov.SDK_INT == 20) {
                        InputStream inputStream;
                        try {
                            inputStream = ((URLConnection)object).getInputStream();
                            if (l != -1L ? l <= 2048L : inputStream.read() == -1) break block13;
                        }
                        catch (Exception exception) {}
                        String string2 = inputStream.getClass().getName();
                        if (string2.equals("com.android.okhttp.internal.http.HttpTransport$ChunkedInputStream") || string2.equals("com.android.okhttp.internal.http.HttpTransport$FixedLengthInputStream")) {
                            Method method = inputStream.getClass().getSuperclass().getDeclaredMethod("unexpectedEndOfInput", new Class[0]);
                            method.setAccessible(true);
                            method.invoke((Object)inputStream, new Object[0]);
                        }
                    }
                }
                try {
                    this.zzbga.close();
                }
                catch (IOException iOException) {
                    throw new zzoa(iOException, this.zzbfy, 3);
                }
            }
            return;
        }
        finally {
            this.zzbga = null;
            this.zzip();
            if (this.zzbgb) {
                this.zzbgb = false;
                if (this.zzbfx != null) {
                    this.zzbfx.zze(this);
                }
            }
            this.zzefd.clear();
        }
    }

    final void setReceiveBufferSize(int n) {
        this.zzefc = n;
        for (Socket socket : this.zzefd) {
            if (socket.isClosed()) continue;
            try {
                socket.setReceiveBufferSize(this.zzefc);
            }
            catch (SocketException socketException) {
                zzawr.zzd((String)"Failed to update receive buffer size.", (Throwable)socketException);
            }
        }
    }

    private final void zza(Socket socket) {
        this.zzefd.add(socket);
    }

    private static long zzc(HttpURLConnection httpURLConnection) {
        Matcher matcher;
        String string2;
        long l = -1L;
        String string3 = httpURLConnection.getHeaderField("Content-Length");
        if (!TextUtils.isEmpty((CharSequence)string3)) {
            try {
                l = Long.parseLong(string3);
            }
            catch (NumberFormatException numberFormatException) {
                zzawr.zzfa((String)new StringBuilder(28 + String.valueOf(string3).length()).append("Unexpected Content-Length [").append(string3).append("]").toString());
            }
        }
        if (!TextUtils.isEmpty((CharSequence)(string2 = httpURLConnection.getHeaderField("Content-Range"))) && (matcher = zzbfo.matcher(string2)).find()) {
            try {
                long l2 = Long.parseLong(matcher.group(2)) - Long.parseLong(matcher.group(1)) + 1L;
                if (l < 0L) {
                    l = l2;
                } else if (l != l2) {
                    zzawr.zzfc((String)new StringBuilder(26 + String.valueOf(string3).length() + String.valueOf(string2).length()).append("Inconsistent headers [").append(string3).append("] [").append(string2).append("]").toString());
                    l = Math.max(l, l2);
                }
            }
            catch (NumberFormatException numberFormatException) {
                zzawr.zzfa((String)new StringBuilder(27 + String.valueOf(string2).length()).append("Unexpected Content-Range [").append(string2).append("]").toString());
            }
        }
        return l;
    }

    private final void zzip() {
        if (this.zzbfz != null) {
            try {
                this.zzbfz.disconnect();
            }
            catch (Exception exception) {
                zzawr.zzc((String)"Unexpected error while disconnecting", (Throwable)exception);
            }
            this.zzbfz = null;
        }
    }

    static /* synthetic */ int zza(zzbcn zzbcn2) {
        return zzbcn2.zzefc;
    }

    static /* synthetic */ void zza(zzbcn zzbcn2, Socket socket) {
        zzbcn2.zza(socket);
    }
}

