/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.content.Context;
import android.net.Uri;
import androidx.annotation.Nullable;
import com.google.android.gms.ads.internal.zzq;
import com.google.android.gms.common.util.IOUtils;
import com.google.android.gms.internal.ads.zzawr;
import com.google.android.gms.internal.ads.zzbcs;
import com.google.android.gms.internal.ads.zznu;
import com.google.android.gms.internal.ads.zznv;
import com.google.android.gms.internal.ads.zzoi;
import com.google.android.gms.internal.ads.zzse;
import com.google.android.gms.internal.ads.zzsf;
import com.google.android.gms.internal.ads.zzsu;
import com.google.android.gms.internal.ads.zzvj;
import com.google.android.gms.internal.ads.zzzk;
import com.google.android.gms.internal.ads.zzzz;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public final class zzbcp
implements zznu {
    private InputStream zzeff;
    private boolean isOpen;
    private final Context zzvf;
    private final zznu zzefg;
    @Nullable
    private final zzoi<zznu> zzefh;
    private final zzbcs zzefi;
    private Uri uri;

    public zzbcp(Context context, zznu zznu2, zzoi<zznu> zzoi2, zzbcs zzbcs2) {
        this.zzvf = context;
        this.zzefg = zznu2;
        this.zzefh = zzoi2;
        this.zzefi = zzbcs2;
    }

    @Override
    public final void close() throws IOException {
        if (!this.isOpen) {
            throw new IOException("Attempt to close an already closed CacheDataSource.");
        }
        this.isOpen = false;
        this.uri = null;
        if (this.zzeff != null) {
            IOUtils.closeQuietly((Closeable)this.zzeff);
            this.zzeff = null;
        } else {
            this.zzefg.close();
        }
        zzbcp zzbcp2 = this;
        if (zzbcp2.zzefh != null) {
            zzbcp2.zzefh.zze(zzbcp2);
        }
    }

    /*
     * Loose catch block
     */
    @Override
    public final long zza(zznv zznv2) throws IOException {
        if (this.isOpen) {
            throw new IOException("Attempt to open an already open CacheDataSource.");
        }
        this.isOpen = true;
        this.uri = zznv2.uri;
        zznv zznv3 = zznv2;
        zzbcp zzbcp2 = this;
        if (zzbcp2.zzefh != null) {
            zzbcp2.zzefh.zza(zzbcp2, zznv3);
        }
        zzsf zzsf2 = zzsf.zzd(zznv2.uri);
        zzbcp2 = zzzz.zzcpx;
        if (((Boolean)zzvj.zzpv().zzd((zzzk)zzbcp2)).booleanValue()) {
            if (zzsf2 != null) {
                long l;
                Long l2;
                zzsf2.zzbss = zznv2.position;
                if (zzsf2.zzbsr) {
                    zzbcp2 = zzzz.zzcpz;
                    l2 = (Long)zzvj.zzpv().zzd((zzzk)zzbcp2);
                } else {
                    zzbcp2 = zzzz.zzcpy;
                    l2 = (Long)zzvj.zzpv().zzd((zzzk)zzbcp2);
                }
                long l3 = l2;
                long l4 = zzq.zzld().elapsedRealtime();
                zzq.zzlq();
                Future<InputStream> future = zzsu.zza(this.zzvf, zzsf2);
                try {
                    this.zzeff = future.get(l3, TimeUnit.MILLISECONDS);
                    l = zzq.zzld().elapsedRealtime() - l4;
                    this.zzefi.zzb(true, l);
                }
                catch (ExecutionException | TimeoutException exception) {
                    future.cancel(true);
                }
                catch (InterruptedException interruptedException) {
                    future.cancel(true);
                    Thread.currentThread().interrupt();
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
                finally {
                    long l5 = zzq.zzld().elapsedRealtime() - l4;
                    this.zzefi.zzb(false, l5);
                    zzawr.zzeg(new StringBuilder(44).append("Cache connection took ").append(l5).append("ms").toString());
                }
                zzawr.zzeg(new StringBuilder(44).append("Cache connection took ").append(l).append("ms").toString());
                return -1L;
            }
        } else {
            zzse zzse2 = null;
            if (zzsf2 != null) {
                zzsf2.zzbss = zznv2.position;
                zzse2 = zzq.zzlc().zza(zzsf2);
            }
            if (zzse2 != null && zzse2.zzmv()) {
                this.zzeff = zzse2.zzmw();
                return -1L;
            }
        }
        if (zzsf2 != null) {
            zznv2 = new zznv(Uri.parse((String)zzsf2.url), zznv2.zzbfm, zznv2.zzbfn, zznv2.position, zznv2.zzce, zznv2.zzcc, zznv2.flags);
        }
        return this.zzefg.zza(zznv2);
    }

    @Override
    public final int read(byte[] byArray, int n, int n2) throws IOException {
        if (!this.isOpen) {
            throw new IOException("Attempt to read closed CacheDataSource.");
        }
        int n3 = this.zzeff != null ? this.zzeff.read(byArray, n, n2) : this.zzefg.read(byArray, n, n2);
        int n4 = n3;
        zzbcp zzbcp2 = this;
        if (zzbcp2.zzefh != null) {
            zzbcp2.zzefh.zzc(zzbcp2, n4);
        }
        return n3;
    }

    @Override
    public final Uri getUri() {
        return this.uri;
    }
}

