/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.content.Context;
import android.graphics.Color;
import android.os.SystemClock;
import android.text.TextUtils;
import android.view.MotionEvent;
import com.google.android.gms.internal.ads.zzaga;
import com.google.android.gms.internal.ads.zzawr;
import com.google.android.gms.internal.ads.zzazk;
import com.google.android.gms.internal.ads.zzazm;
import com.google.android.gms.internal.ads.zzbbk;
import com.google.android.gms.internal.ads.zzbbq;
import com.google.android.gms.internal.ads.zzbbx;
import com.google.android.gms.internal.ads.zzbby;
import com.google.android.gms.internal.ads.zzbfe;
import com.google.android.gms.internal.ads.zzvj;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class zzbdi
implements zzaga<zzbbx> {
    private boolean zzegl;

    private static int zza(Context context, Map<String, String> map, String string2, int n) {
        String string3 = map.get(string2);
        int n2 = n;
        if (string3 != null) {
            try {
                zzvj.zzpr();
                n2 = zzazm.zzc((Context)context, (int)Integer.parseInt(string3));
            }
            catch (NumberFormatException numberFormatException) {
                zzawr.zzfc((String)new StringBuilder(34 + String.valueOf(string2).length() + String.valueOf(string3).length()).append("Could not parse ").append(string2).append(" in a video GMSG: ").append(string3).toString());
            }
        }
        return n2;
    }

    private static void zza(zzbbk zzbbk2, Map<String, String> map) {
        String string2 = map.get("minBufferMs");
        String string3 = map.get("maxBufferMs");
        String string4 = map.get("bufferForPlaybackMs");
        String string5 = map.get("bufferForPlaybackAfterRebufferMs");
        String string6 = map.get("socketReceiveBufferSize");
        try {
            int n;
            if (string2 != null) {
                n = Integer.parseInt(string2);
                zzbbk2.zzde(n);
            }
            if (string3 != null) {
                n = Integer.parseInt(string3);
                zzbbk2.zzdf(n);
            }
            if (string4 != null) {
                n = Integer.parseInt(string4);
                zzbbk2.zzdg(n);
            }
            if (string5 != null) {
                n = Integer.parseInt(string5);
                zzbbk2.zzdh(n);
            }
            if (string6 != null) {
                n = Integer.parseInt(string6);
                zzbbk2.zzdi(n);
            }
            return;
        }
        catch (NumberFormatException numberFormatException) {
            zzawr.zzfc((String)String.format("Could not parse buffer parameters in loadControl video GMSG: (%s, %s)", string2, string3));
            return;
        }
    }

    @Override
    public final /* synthetic */ void zza(Object object, Map map) {
        zzbbk zzbbk2;
        Object object2;
        Object object3;
        Map map2 = map;
        zzbbx zzbbx2 = (zzbbx)object;
        zzbdi zzbdi2 = this;
        String string2 = (String)map2.get("action");
        if (string2 == null) {
            zzawr.zzfc((String)"Action missing from video GMSG.");
            return;
        }
        if (zzawr.isLoggable((int)3)) {
            object3 = new JSONObject(map2);
            object3.remove("google.afma.Notify_dt");
            object2 = object3.toString();
            zzawr.zzed((String)new StringBuilder(13 + String.valueOf(string2).length() + String.valueOf(object2).length()).append("Video GMSG: ").append(string2).append(" ").append((String)object2).toString());
        }
        if ("background".equals(string2)) {
            object3 = (String)map2.get("color");
            if (TextUtils.isEmpty((CharSequence)object3)) {
                zzawr.zzfc((String)"Color parameter missing from color video GMSG.");
                return;
            }
            try {
                int n = Color.parseColor((String)object3);
                zzbbx2.setBackgroundColor(n);
                return;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                zzawr.zzfc((String)"Invalid color parameter in video GMSG.");
                return;
            }
        }
        if ("decoderProps".equals(string2)) {
            object3 = (String)map2.get("mimeTypes");
            if (object3 == null) {
                zzawr.zzfc((String)"No MIME types specified for decoder properties inspection.");
                zzbbk.zza(zzbbx2, "missingMimeTypes");
                return;
            }
            object2 = new HashMap();
            for (String string3 : ((String)object3).split(",")) {
                object2.put(string3, zzazk.zzeu(string3.trim()));
            }
            zzbbk.zza(zzbbx2, (Map<String, List<Map<String, Object>>>)object2);
            return;
        }
        object3 = zzbbx2.zzze();
        if (object3 == null) {
            zzawr.zzfc((String)"Could not get underlay container for a video GMSG.");
            return;
        }
        boolean bl = "new".equals(string2);
        boolean bl2 = "position".equals(string2);
        if (bl || bl2) {
            int n;
            Context context = zzbbx2.getContext();
            int n2 = zzbdi.zza(context, map2, "x", 0);
            int n3 = zzbdi.zza(context, map2, "y", 0);
            int n4 = zzbdi.zza(context, map2, "w", -1);
            int n5 = zzbdi.zza(context, map2, "h", -1);
            n4 = Math.min(n4, zzbbx2.zzzm() - n2);
            n5 = Math.min(n5, zzbbx2.zzzl() - n3);
            try {
                n = Integer.parseInt((String)map2.get("player"));
            }
            catch (NumberFormatException numberFormatException) {
                n = 0;
            }
            boolean bl3 = Boolean.parseBoolean((String)map2.get("spherical"));
            if (bl && ((zzbbq)object3).zzza() == null) {
                zzbby zzbby2 = new zzbby((String)map2.get("flags"));
                ((zzbbq)object3).zza(n2, n3, n4, n5, n, bl3, zzbby2);
                zzbbk zzbbk3 = ((zzbbq)object3).zzza();
                if (zzbbk3 != null) {
                    zzbdi.zza(zzbbk3, map2);
                }
                return;
            }
            ((zzbbq)object3).zze(n2, n3, n4, n5);
            return;
        }
        zzbfe zzbfe2 = zzbbx2.zzzf();
        if (zzbfe2 != null) {
            if ("timeupdate".equals(string2)) {
                String string4 = (String)map2.get("currentTime");
                if (string4 == null) {
                    zzawr.zzfc((String)"currentTime parameter missing from timeupdate video GMSG.");
                    return;
                }
                try {
                    float f = Float.parseFloat(string4);
                    zzbfe2.zze(f);
                    return;
                }
                catch (NumberFormatException numberFormatException) {
                    String string5 = String.valueOf(string4);
                    zzawr.zzfc((String)(string5.length() != 0 ? "Could not parse currentTime parameter from timeupdate video GMSG: ".concat(string5) : new String("Could not parse currentTime parameter from timeupdate video GMSG: ")));
                    return;
                }
            }
            if ("skip".equals(string2)) {
                zzbfe2.zzacj();
                return;
            }
        }
        if ((zzbbk2 = ((zzbbq)object3).zzza()) == null) {
            zzbbk.zzb(zzbbx2);
            return;
        }
        if ("click".equals(string2)) {
            Context context = zzbbx2.getContext();
            int n = zzbdi.zza(context, map2, "x", 0);
            int n6 = zzbdi.zza(context, map2, "y", 0);
            long l = SystemClock.uptimeMillis();
            MotionEvent motionEvent = MotionEvent.obtain((long)l, (long)l, (int)0, (float)n, (float)n6, (int)0);
            zzbbk2.zze(motionEvent);
            motionEvent.recycle();
            return;
        }
        if ("currentTime".equals(string2)) {
            String string6 = (String)map2.get("time");
            if (string6 == null) {
                zzawr.zzfc((String)"Time parameter missing from currentTime video GMSG.");
                return;
            }
            try {
                int n = (int)(Float.parseFloat(string6) * 1000.0f);
                zzbbk2.seekTo(n);
                return;
            }
            catch (NumberFormatException numberFormatException) {
                String string7 = String.valueOf(string6);
                zzawr.zzfc((String)(string7.length() != 0 ? "Could not parse time parameter from currentTime video GMSG: ".concat(string7) : new String("Could not parse time parameter from currentTime video GMSG: ")));
                return;
            }
        }
        if ("hide".equals(string2)) {
            zzbbk2.setVisibility(4);
            return;
        }
        if ("load".equals(string2)) {
            zzbbk2.zzhx();
            return;
        }
        if ("loadControl".equals(string2)) {
            zzbdi.zza(zzbbk2, map2);
            return;
        }
        if ("muted".equals(string2)) {
            if (Boolean.parseBoolean((String)map2.get("muted"))) {
                zzbbk2.zzyu();
                return;
            }
            zzbbk2.zzyv();
            return;
        }
        if ("pause".equals(string2)) {
            zzbbk2.pause();
            return;
        }
        if ("play".equals(string2)) {
            zzbbk2.play();
            return;
        }
        if ("show".equals(string2)) {
            zzbbk2.setVisibility(0);
            return;
        }
        if ("src".equals(string2)) {
            String string8 = (String)map2.get("src");
            String[] stringArray = new String[]{string8};
            String string9 = (String)map2.get("demuxed");
            if (string9 != null) {
                try {
                    JSONArray jSONArray = new JSONArray(string9);
                    stringArray = new String[jSONArray.length()];
                    for (int i = 0; i < jSONArray.length(); ++i) {
                        stringArray[i] = jSONArray.getString(i);
                    }
                }
                catch (JSONException jSONException) {
                    String string10 = String.valueOf(string9);
                    zzawr.zzfc((String)(string10.length() != 0 ? "Malformed demuxed URL list for playback: ".concat(string10) : new String("Malformed demuxed URL list for playback: ")));
                    stringArray = new String[]{string8};
                }
            }
            zzbbk2.zzc(string8, stringArray);
            return;
        }
        if ("touchMove".equals(string2)) {
            Context context = zzbbx2.getContext();
            int n = zzbdi.zza(context, map2, "dx", 0);
            int n7 = zzbdi.zza(context, map2, "dy", 0);
            zzbbk2.zza(n, n7);
            if (!zzbdi2.zzegl) {
                zzbbx2.zzun();
                zzbdi2.zzegl = true;
            }
            return;
        }
        if ("volume".equals(string2)) {
            String string11 = (String)map2.get("volume");
            if (string11 == null) {
                zzawr.zzfc((String)"Level parameter missing from volume video GMSG.");
                return;
            }
            try {
                float f = Float.parseFloat(string11);
                zzbbk2.setVolume(f);
                return;
            }
            catch (NumberFormatException numberFormatException) {
                String string12 = String.valueOf(string11);
                zzawr.zzfc((String)(string12.length() != 0 ? "Could not parse volume parameter from volume video GMSG: ".concat(string12) : new String("Could not parse volume parameter from volume video GMSG: ")));
                return;
            }
        }
        if ("watermark".equals(string2)) {
            zzbbk2.zzyw();
            return;
        }
        String string13 = String.valueOf(string2);
        zzawr.zzfc((String)(string13.length() != 0 ? "Unknown video action: ".concat(string13) : new String("Unknown video action: ")));
    }
}

