/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.annotation.TargetApi;
import android.content.Context;
import android.net.Uri;
import com.google.android.gms.ads.internal.zzq;
import com.google.android.gms.common.util.Clock;
import com.google.android.gms.internal.ads.zzawr;
import com.google.android.gms.internal.ads.zzbab;
import com.google.android.gms.internal.ads.zzbbx;
import com.google.android.gms.internal.ads.zzbby;
import com.google.android.gms.internal.ads.zzbcu;
import com.google.android.gms.internal.ads.zzbdc;
import com.google.android.gms.internal.ads.zzbdl;
import com.google.android.gms.internal.ads.zzbdz;
import com.google.android.gms.internal.ads.zzgt;
import com.google.android.gms.internal.ads.zzvj;
import com.google.android.gms.internal.ads.zzzk;
import com.google.android.gms.internal.ads.zzzz;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

@TargetApi(value=16)
public final class zzbea
extends zzbdl
implements zzbdc {
    private zzbcu zzehl;
    private String zzebv;
    private boolean zzehc;
    private Exception zzehm;
    private boolean zzehn;

    public zzbea(zzbbx zzbbx2, zzbby zzbby2) {
        super(zzbbx2);
        zzbby zzbby3 = zzbby2;
        Context context = zzbbx2.getContext();
        this.zzehl = new zzbcu(context, zzbby3);
        this.zzehl.zza(this);
    }

    @Override
    public final void zzb(boolean bl, long l) {
        zzbbx zzbbx2 = (zzbbx)this.zzego.get();
        if (zzbbx2 != null) {
            zzbab.zzdzv.execute(new zzbdz(zzbbx2, bl, l));
        }
    }

    @Override
    public final void zzdj(int n) {
    }

    @Override
    public final void zzn(int n, int n2) {
    }

    @Override
    public final void zza(String string2, Exception exception) {
        zzzk zzzk2 = zzzz.zzcjf;
        String string3 = (String)zzvj.zzpv().zzd(zzzk2);
        if (string3 != null) {
            List<String> list = Arrays.asList(string3.split(","));
            if (list.contains("all")) {
                return;
            }
            String string4 = exception.getClass().getCanonicalName();
            if (list.contains(string4)) {
                return;
            }
        }
        this.zzehm = exception;
        zzawr.zzd((String)"Precache error", (Throwable)exception);
        this.zzfo(string2);
    }

    @Override
    public final void zzdf(int n) {
        this.zzehl.zzaak().zzdm(n);
    }

    @Override
    public final void zzde(int n) {
        this.zzehl.zzaak().zzdl(n);
    }

    @Override
    public final void zzdg(int n) {
        this.zzehl.zzaak().zzdg(n);
    }

    @Override
    public final void zzdh(int n) {
        this.zzehl.zzaak().zzdh(n);
    }

    @Override
    public final void release() {
        if (this.zzehl != null) {
            this.zzehl.zza((zzbdc)null);
            this.zzehl.release();
        }
        super.release();
    }

    @Override
    protected final String zzfm(String string2) {
        String string3 = String.valueOf("cache:");
        String string4 = String.valueOf(super.zzfm(string2));
        if (string4.length() != 0) {
            return string3.concat(string4);
        }
        return new String(string3);
    }

    @Override
    public final boolean zzfl(String string2) {
        return ((zzbdl)this).zze(string2, new String[]{string2});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final boolean zze(String string2, String[] stringArray) {
        this.zzebv = string2;
        String string3 = ((zzbdl)this).zzfm(string2);
        String string4 = "error";
        try {
            Uri[] uriArray = new Uri[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                uriArray[i] = Uri.parse((String)stringArray[i]);
            }
            this.zzehl.zza(uriArray, this.zzdym);
            zzbbx zzbbx2 = (zzbbx)this.zzego.get();
            if (zzbbx2 != null) {
                zzbbx2.zza(string3, this);
            }
            Clock clock = zzq.zzld();
            long l = clock.currentTimeMillis();
            zzzk zzzk2 = zzzz.zzcjl;
            long l2 = (Long)zzvj.zzpv().zzd(zzzk2);
            zzzk2 = zzzz.zzcjk;
            long l3 = (Long)zzvj.zzpv().zzd(zzzk2) * 1000L;
            zzzk2 = zzzz.zzcjj;
            long l4 = ((Integer)zzvj.zzpv().zzd(zzzk2)).intValue();
            long l5 = -1L;
            while (true) {
                zzbea zzbea2 = this;
                synchronized (zzbea2) {
                    if (clock.currentTimeMillis() - l > l3) {
                        string4 = "downloadTimeout";
                        throw new IOException(new StringBuilder(47).append("Timeout reached. Limit: ").append(l3).append(" ms").toString());
                    }
                    if (this.zzehc) {
                        if (this.zzehm != null) {
                            string4 = "badUrl";
                            throw this.zzehm;
                        }
                        string4 = "externalAbort";
                        throw new IOException("Abort requested before buffering finished. ");
                    }
                    if (this.zzehn) {
                        return true;
                    }
                    zzgt zzgt2 = this.zzehl.zzaah();
                    if (zzgt2 == null) {
                        string4 = "exoPlayerReleased";
                        throw new IOException("ExoPlayer was released during preloading.");
                    }
                    long l6 = zzgt2.getDuration();
                    if (l6 > 0L) {
                        long l7 = zzgt2.getBufferedPosition();
                        if (l7 != l5) {
                            boolean bl = l7 > 0L;
                            this.zza(string2, string3, l7, l6, bl, zzbcu.zzaai(), zzbcu.zzaaj());
                            l5 = l7;
                        }
                        if (l7 >= l6) {
                            this.zzb(string2, string3, l6);
                            return true;
                        }
                        if (this.zzehl.getBytesTransferred() >= l4 && l7 > 0L) {
                            return true;
                        }
                    }
                    try {
                        this.wait(l2);
                    }
                    catch (InterruptedException interruptedException) {
                        string4 = "interrupted";
                        throw new IOException("Wait interrupted.");
                    }
                }
            }
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            String string5 = exception.getMessage();
            zzawr.zzfc((String)new StringBuilder(34 + String.valueOf(string2).length() + String.valueOf(string5).length()).append("Failed to preload url ").append(string2).append(" Exception: ").append(string5).toString());
            ((zzbdl)this).release();
            string5 = zzbea.zzb(string4, exception2);
            this.zza(string2, string3, string4, string5);
            return false;
        }
    }

    @Override
    public final void abort() {
        this.zzfo(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zzfo(String string2) {
        Object object = this;
        synchronized (object) {
            this.zzehc = true;
            this.notify();
            ((zzbdl)this).release();
        }
        if (this.zzebv != null) {
            object = ((zzbdl)this).zzfm(this.zzebv);
            if (this.zzehm != null) {
                this.zza(this.zzebv, (String)object, "badUrl", zzbea.zzb(string2, this.zzehm));
                return;
            }
            this.zza(this.zzebv, (String)object, "externalAbort", "Programmatic precache abort.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final zzbcu zzaan() {
        Object object = this;
        synchronized (object) {
            this.zzehn = true;
            this.notify();
        }
        this.zzehl.zza((zzbdc)null);
        object = this.zzehl;
        this.zzehl = null;
        return object;
    }

    private static String zzb(String string2, Exception exception) {
        String string3 = exception.getClass().getCanonicalName();
        String string4 = exception.getMessage();
        return new StringBuilder(2 + String.valueOf(string2).length() + String.valueOf(string3).length() + String.valueOf(string4).length()).append(string2).append("/").append(string3).append(":").append(string4).toString();
    }
}

