/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Message;
import android.view.View;
import android.view.WindowManager;
import android.webkit.ConsoleMessage;
import android.webkit.GeolocationPermissions;
import android.webkit.JsPromptResult;
import android.webkit.JsResult;
import android.webkit.PermissionRequest;
import android.webkit.WebChromeClient;
import android.webkit.WebStorage;
import android.webkit.WebView;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.google.android.gms.ads.internal.overlay.zzc;
import com.google.android.gms.ads.internal.zzq;
import com.google.android.gms.common.util.PlatformVersion;
import com.google.android.gms.internal.ads.zzabz;
import com.google.android.gms.internal.ads.zzawr;
import com.google.android.gms.internal.ads.zzaxa;
import com.google.android.gms.internal.ads.zzbeb;
import com.google.android.gms.internal.ads.zzbed;
import com.google.android.gms.internal.ads.zzbee;
import com.google.android.gms.internal.ads.zzbef;
import com.google.android.gms.internal.ads.zzbeg;
import com.google.android.gms.internal.ads.zzbei;
import com.google.android.gms.internal.ads.zzbek;

@TargetApi(value=11)
public final class zzbec
extends WebChromeClient {
    private final zzbek zzdce;

    public zzbec(zzbek zzbek2) {
        this.zzdce = zzbek2;
    }

    private final boolean zza(Context context, String string2, String string3, String string4, String string5, JsResult jsResult, JsPromptResult jsPromptResult, boolean bl) {
        try {
            Object object;
            if (this.zzdce != null && this.zzdce.zzabj() != null && this.zzdce.zzabj().zzaao() != null && (object = this.zzdce.zzabj().zzaao()) != null && !((com.google.android.gms.ads.internal.zzc)object).zzjx()) {
                ((com.google.android.gms.ads.internal.zzc)object).zzbm(new StringBuilder(11 + String.valueOf(string2).length() + String.valueOf(string4).length()).append("window.").append(string2).append("('").append(string4).append("')").toString());
                return false;
            }
            object = new AlertDialog.Builder(context);
            object.setTitle((CharSequence)string3);
            if (bl) {
                JsPromptResult jsPromptResult2 = jsPromptResult;
                String string6 = string5;
                String string7 = string4;
                AlertDialog.Builder builder = object;
                Context context2 = context;
                LinearLayout linearLayout = new LinearLayout(context2);
                linearLayout.setOrientation(1);
                TextView textView = new TextView(context2);
                textView.setText((CharSequence)string7);
                EditText editText = new EditText(context2);
                editText.setText((CharSequence)string6);
                linearLayout.addView((View)textView);
                linearLayout.addView((View)editText);
                builder.setView((View)linearLayout).setPositiveButton(17039370, (DialogInterface.OnClickListener)new zzbei(jsPromptResult2, editText)).setNegativeButton(0x1040000, (DialogInterface.OnClickListener)new zzbef(jsPromptResult2)).setOnCancelListener((DialogInterface.OnCancelListener)new zzbeg(jsPromptResult2)).create().show();
            } else {
                JsResult jsResult2 = jsResult;
                String string8 = string4;
                object.setMessage((CharSequence)string8).setPositiveButton(17039370, (DialogInterface.OnClickListener)new zzbed(jsResult2)).setNegativeButton(0x1040000, (DialogInterface.OnClickListener)new zzbee(jsResult2)).setOnCancelListener((DialogInterface.OnCancelListener)new zzbeb(jsResult2)).create().show();
            }
        }
        catch (WindowManager.BadTokenException badTokenException) {
            zzawr.zzd((String)"Fail to display Dialog.", (Throwable)badTokenException);
        }
        return true;
    }

    public final boolean onCreateWindow(WebView webView, boolean bl, boolean bl2, Message message) {
        WebView.WebViewTransport webViewTransport = (WebView.WebViewTransport)message.obj;
        WebView webView2 = new WebView(webView.getContext());
        if (this.zzdce.zzabk() != null) {
            webView2.setWebViewClient(this.zzdce.zzabk());
        }
        webViewTransport.setWebView(webView2);
        message.sendToTarget();
        return true;
    }

    public final void onCloseWindow(WebView webView) {
        if (!(webView instanceof zzbek)) {
            zzawr.zzfc((String)"Tried to close a WebView that wasn't an AdWebView.");
            return;
        }
        zzc zzc2 = ((zzbek)webView).zzabf();
        if (zzc2 == null) {
            zzawr.zzfc((String)"Tried to close an AdWebView not associated with an overlay.");
            return;
        }
        zzc2.close();
    }

    public final boolean onConsoleMessage(ConsoleMessage consoleMessage) {
        String string2 = consoleMessage.message();
        String string3 = consoleMessage.sourceId();
        int n = consoleMessage.lineNumber();
        String string4 = new StringBuilder(19 + String.valueOf(string2).length() + String.valueOf(string3).length()).append("JS: ").append(string2).append(" (").append(string3).append(":").append(n).append(")").toString();
        if (string4.contains("Application Cache")) {
            return super.onConsoleMessage(consoleMessage);
        }
        switch (consoleMessage.messageLevel()) {
            case ERROR: {
                zzawr.zzfa((String)string4);
                break;
            }
            case WARNING: {
                zzawr.zzfc((String)string4);
                break;
            }
            case LOG: 
            case TIP: {
                zzawr.zzfb((String)string4);
                break;
            }
            case DEBUG: {
                zzawr.zzed((String)string4);
                break;
            }
            default: {
                zzawr.zzfb((String)string4);
            }
        }
        return super.onConsoleMessage(consoleMessage);
    }

    public final void onExceededDatabaseQuota(String string2, String string3, long l, long l2, long l3, WebStorage.QuotaUpdater quotaUpdater) {
        long l4;
        long l5 = 0x500000L - l3;
        if (l5 <= 0L) {
            quotaUpdater.updateQuota(l);
            return;
        }
        if (l == 0L) {
            l4 = l2 <= l5 && l2 <= 0x100000L ? l2 : 0L;
        } else {
            long l6;
            long l7;
            if (l2 == 0L) {
                l7 = Math.min(131072L, l5);
                l6 = Math.min(l + l7, 0x100000L);
            } else {
                l7 = Math.min(0x100000L - l, l5);
                l6 = l2 <= l7 ? l + l2 : l;
            }
            l4 = l6;
        }
        quotaUpdater.updateQuota(l4);
    }

    public final void onHideCustomView() {
        zzc zzc2 = this.zzdce.zzabf();
        if (zzc2 == null) {
            zzawr.zzfc((String)"Could not get ad overlay when hiding custom view.");
            return;
        }
        zzc2.zzuf();
    }

    private static Context zza(WebView webView) {
        if (!(webView instanceof zzbek)) {
            return webView.getContext();
        }
        zzbek zzbek2 = (zzbek)webView;
        Activity activity = zzbek2.zzzh();
        if (activity != null) {
            return activity;
        }
        return zzbek2.getContext();
    }

    public final boolean onJsAlert(WebView webView, String string2, String string3, JsResult jsResult) {
        return this.zza(zzbec.zza(webView), "alert", string2, string3, null, jsResult, null, false);
    }

    public final boolean onJsBeforeUnload(WebView webView, String string2, String string3, JsResult jsResult) {
        return this.zza(zzbec.zza(webView), "onBeforeUnload", string2, string3, null, jsResult, null, false);
    }

    public final boolean onJsConfirm(WebView webView, String string2, String string3, JsResult jsResult) {
        return this.zza(zzbec.zza(webView), "confirm", string2, string3, null, jsResult, null, false);
    }

    public final boolean onJsPrompt(WebView webView, String string2, String string3, String string4, JsPromptResult jsPromptResult) {
        return this.zza(zzbec.zza(webView), "prompt", string2, string3, string4, null, jsPromptResult, true);
    }

    public final void onReachedMaxAppCacheSize(long l, long l2, WebStorage.QuotaUpdater quotaUpdater) {
        long l3 = 0x500000L - l2;
        long l4 = l + 131072L;
        if (l3 < l4) {
            quotaUpdater.updateQuota(0L);
            return;
        }
        quotaUpdater.updateQuota(l4);
    }

    public final void onShowCustomView(View view, WebChromeClient.CustomViewCallback customViewCallback) {
        this.onShowCustomView(view, -1, customViewCallback);
    }

    @Deprecated
    public final void onShowCustomView(View view, int n, WebChromeClient.CustomViewCallback customViewCallback) {
        zzc zzc2 = this.zzdce.zzabf();
        if (zzc2 == null) {
            zzawr.zzfc((String)"Could not get ad overlay when showing custom view.");
            customViewCallback.onCustomViewHidden();
            return;
        }
        zzc2.zza(view, customViewCallback);
        zzc2.setRequestedOrientation(n);
    }

    /*
     * Unable to fully structure code
     */
    public final void onGeolocationPermissionsShowPrompt(String var1_1, GeolocationPermissions.Callback var2_2) {
        block2: {
            if (var2_2 == null) break block2;
            var3_3 = this;
            zzq.zzkw();
            if (zzaxa.zzq(var3_3.zzdce.getContext(), "android.permission.ACCESS_FINE_LOCATION")) ** GOTO lbl-1000
            zzq.zzkw();
            if (zzaxa.zzq(var3_3.zzdce.getContext(), "android.permission.ACCESS_COARSE_LOCATION")) lbl-1000:
            // 2 sources

            {
                v0 = true;
            } else {
                v0 = false;
            }
            var2_2.invoke(var1_1, v0, true);
        }
    }

    @TargetApi(value=21)
    public final void onPermissionRequest(PermissionRequest permissionRequest) {
        if (!PlatformVersion.isAtLeastLollipop() || ((Boolean)zzabz.zzcya.get()).booleanValue()) {
            super.onPermissionRequest(permissionRequest);
            return;
        }
        if (this.zzdce == null || this.zzdce.zzabj() == null || this.zzdce.zzabj().zzabb() == null) {
            super.onPermissionRequest(permissionRequest);
            return;
        }
        String[] stringArray = this.zzdce.zzabj().zzabb().zza(permissionRequest.getResources());
        if (stringArray.length > 0) {
            permissionRequest.grant(stringArray);
            return;
        }
        permissionRequest.deny();
    }
}

