/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.annotation.TargetApi;
import android.graphics.Bitmap;
import android.net.Uri;
import android.view.KeyEvent;
import android.view.View;
import android.view.ViewTreeObserver;
import android.webkit.RenderProcessGoneDetail;
import android.webkit.WebResourceResponse;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import androidx.annotation.Nullable;
import androidx.core.view.ViewCompat;
import com.google.android.gms.ads.internal.overlay.AdOverlayInfoParcel;
import com.google.android.gms.ads.internal.overlay.zzd;
import com.google.android.gms.ads.internal.overlay.zzn;
import com.google.android.gms.ads.internal.overlay.zzo;
import com.google.android.gms.ads.internal.overlay.zzt;
import com.google.android.gms.ads.internal.zzc;
import com.google.android.gms.ads.internal.zzq;
import com.google.android.gms.common.util.Predicate;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.ads.zzabi;
import com.google.android.gms.internal.ads.zzafg;
import com.google.android.gms.internal.ads.zzafi;
import com.google.android.gms.internal.ads.zzafj;
import com.google.android.gms.internal.ads.zzafl;
import com.google.android.gms.internal.ads.zzafn;
import com.google.android.gms.internal.ads.zzaga;
import com.google.android.gms.internal.ads.zzagc;
import com.google.android.gms.internal.ads.zzagd;
import com.google.android.gms.internal.ads.zzage;
import com.google.android.gms.internal.ads.zzagf;
import com.google.android.gms.internal.ads.zzaor;
import com.google.android.gms.internal.ads.zzaoy;
import com.google.android.gms.internal.ads.zzapa;
import com.google.android.gms.internal.ads.zzaun;
import com.google.android.gms.internal.ads.zzavj;
import com.google.android.gms.internal.ads.zzawr;
import com.google.android.gms.internal.ads.zzaxa;
import com.google.android.gms.internal.ads.zzazq;
import com.google.android.gms.internal.ads.zzbab;
import com.google.android.gms.internal.ads.zzbdu;
import com.google.android.gms.internal.ads.zzbek;
import com.google.android.gms.internal.ads.zzbel;
import com.google.android.gms.internal.ads.zzbem;
import com.google.android.gms.internal.ads.zzben;
import com.google.android.gms.internal.ads.zzbeo;
import com.google.android.gms.internal.ads.zzbep;
import com.google.android.gms.internal.ads.zzbeq;
import com.google.android.gms.internal.ads.zzbfv;
import com.google.android.gms.internal.ads.zzbfw;
import com.google.android.gms.internal.ads.zzbfx;
import com.google.android.gms.internal.ads.zzbfy;
import com.google.android.gms.internal.ads.zzdqw;
import com.google.android.gms.internal.ads.zzdt;
import com.google.android.gms.internal.ads.zzdw;
import com.google.android.gms.internal.ads.zzrv;
import com.google.android.gms.internal.ads.zzse;
import com.google.android.gms.internal.ads.zzsf;
import com.google.android.gms.internal.ads.zzst;
import com.google.android.gms.internal.ads.zzsv;
import com.google.android.gms.internal.ads.zzub;
import com.google.android.gms.internal.ads.zzvj;
import com.google.android.gms.internal.ads.zzzg;
import com.google.android.gms.internal.ads.zzzk;
import com.google.android.gms.internal.ads.zzzz;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.GuardedBy;

@ParametersAreNonnullByDefault
@VisibleForTesting
public class zzbej
extends WebViewClient
implements zzbfw {
    protected zzbek zzehs;
    @Nullable
    private final zzst zzeht;
    private final HashMap<String, List<zzaga<? super zzbek>>> zzehu = new HashMap();
    private final Object lock = new Object();
    private zzub zzceb;
    private zzo zzdkt;
    private zzbfv zzehv;
    private zzbfy zzehw;
    private zzafj zzczu;
    private zzafl zzczw;
    private zzbfx zzehx;
    private boolean zzehy = false;
    @GuardedBy(value="lock")
    private boolean zzbne;
    @GuardedBy(value="lock")
    private boolean zzehz;
    @GuardedBy(value="lock")
    private boolean zzeia;
    @GuardedBy(value="lock")
    private boolean zzeib;
    private zzt zzdkx;
    private final zzaoy zzeic;
    private zzc zzdas;
    private zzaor zzdat;
    @Nullable
    protected zzaun zzeid;
    private boolean zzeie;
    private boolean zzeif;
    private int zzeig;
    private boolean zzdov;
    private View.OnAttachStateChangeListener zzeih;

    public zzbej(zzbek zzbek2, zzst zzst2, boolean bl) {
        this(zzbek2, zzst2, bl, new zzaoy(zzbek2, zzbek2.zzabe(), new zzzg(zzbek2.getContext())), null);
    }

    @VisibleForTesting
    private zzbej(zzbek zzbek2, zzst zzst2, boolean bl, zzaoy zzaoy2, zzaor zzaor2) {
        this.zzeht = zzst2;
        this.zzehs = zzbek2;
        this.zzbne = bl;
        this.zzeic = zzaoy2;
        this.zzdat = null;
    }

    @Override
    public final void zza(int n, int n2, boolean bl) {
        this.zzeic.zzj(n, n2);
        if (this.zzdat != null) {
            this.zzdat.zza(n, n2, false);
        }
    }

    @Override
    public final void zza(zzub zzub2, zzafj zzafj2, zzo zzo2, zzafl zzafl2, zzt zzt2, boolean bl, @Nullable zzagd zzagd2, zzc zzc2, zzapa zzapa2, @Nullable zzaun zzaun2) {
        boolean bl2;
        if (zzc2 == null) {
            zzc2 = new zzc(this.zzehs.getContext(), zzaun2, null);
        }
        this.zzdat = new zzaor(this.zzehs, zzapa2);
        this.zzeid = zzaun2;
        zzzk zzzk2 = zzzz.zzclm;
        if (((Boolean)zzvj.zzpv().zzd(zzzk2)).booleanValue()) {
            this.zza("/adMetadata", new zzafg(zzafj2));
        }
        this.zza("/appEvent", new zzafi(zzafl2));
        this.zza("/backButton", zzafn.zzdah);
        this.zza("/refresh", zzafn.zzdai);
        this.zza("/canOpenURLs", zzafn.zzczy);
        this.zza("/canOpenIntents", zzafn.zzczz);
        this.zza("/click", zzafn.zzdaa);
        this.zza("/close", zzafn.zzdab);
        this.zza("/customClose", zzafn.zzdac);
        this.zza("/instrument", zzafn.zzdal);
        this.zza("/delayPageLoaded", zzafn.zzdan);
        this.zza("/delayPageClosed", zzafn.zzdao);
        this.zza("/getLocationInfo", zzafn.zzdap);
        this.zza("/httpTrack", zzafn.zzdad);
        this.zza("/log", zzafn.zzdae);
        this.zza("/mraid", new zzagf(zzc2, this.zzdat, zzapa2));
        this.zza("/mraidLoaded", this.zzeic);
        this.zza("/open", new zzage(zzc2, this.zzdat));
        this.zza("/precache", new zzbdu());
        this.zza("/touch", zzafn.zzdag);
        this.zza("/video", zzafn.zzdaj);
        this.zza("/videoMeta", zzafn.zzdak);
        if (zzq.zzlu().zzab(this.zzehs.getContext())) {
            this.zza("/logScionEvent", new zzagc(this.zzehs.getContext()));
        }
        this.zzceb = zzub2;
        this.zzdkt = zzo2;
        this.zzczu = zzafj2;
        this.zzczw = zzafl2;
        this.zzdkx = zzt2;
        this.zzdas = zzc2;
        this.zzehy = bl2 = bl;
    }

    @Override
    public final zzc zzaao() {
        return this.zzdas;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean zzaap() {
        Object object = this.lock;
        synchronized (object) {
            return this.zzbne;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean zzaaq() {
        Object object = this.lock;
        synchronized (object) {
            return this.zzehz;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean zzaar() {
        Object object = this.lock;
        synchronized (object) {
            return this.zzeia;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ViewTreeObserver.OnGlobalLayoutListener zzaas() {
        Object object = this.lock;
        synchronized (object) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ViewTreeObserver.OnScrollChangedListener zzaat() {
        Object object = this.lock;
        synchronized (object) {
            return null;
        }
    }

    public void onPageStarted(WebView webView, String string2, Bitmap bitmap) {
        zzrv zzrv2 = this.zzehs.zzabz();
        if (zzrv2 != null && webView == zzrv2.getWebView()) {
            zzrv2.onPageStarted(webView, string2, bitmap);
        }
        super.onPageStarted(webView, string2, bitmap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onPageFinished(WebView webView, String string2) {
        Object object = this.lock;
        synchronized (object) {
            if (this.zzehs.isDestroyed()) {
                zzawr.zzeg("Blank page loaded, 1...");
                this.zzehs.zzabp();
                return;
            }
        }
        this.zzeie = true;
        zzbej zzbej2 = this;
        if (zzbej2.zzehw != null) {
            zzbej2.zzehw.zzsw();
            zzbej2.zzehw = null;
        }
        this.zzaaz();
    }

    private final void zza(View view, zzaun zzaun2, int n) {
        if (zzaun2.zzvg() && n > 0) {
            zzaun2.zzl(view);
            if (zzaun2.zzvg()) {
                zzaxa.zzdwf.postDelayed((Runnable)new zzbeo(this, view, zzaun2, n), 100L);
            }
        }
    }

    private final void zzaau() {
        if (this.zzeih == null) {
            return;
        }
        this.zzehs.getView().removeOnAttachStateChangeListener(this.zzeih);
    }

    @Override
    public final void zzaav() {
        zzaun zzaun2 = this.zzeid;
        if (zzaun2 != null) {
            WebView webView = this.zzehs.getWebView();
            if (ViewCompat.isAttachedToWindow((View)webView)) {
                this.zza((View)webView, zzaun2, 10);
                return;
            }
            zzaun zzaun3 = zzaun2;
            zzbej zzbej2 = this;
            zzbej2.zzaau();
            zzbej2.zzeih = new zzben(zzbej2, zzaun3);
            zzbej2.zzehs.getView().addOnAttachStateChangeListener(zzbej2.zzeih);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzaaw() {
        Object object = this.lock;
        synchronized (object) {
            this.zzeib = true;
        }
        ++this.zzeig;
        this.zzaaz();
    }

    @Override
    public final void zzaax() {
        --this.zzeig;
        this.zzaaz();
    }

    @Override
    public final void zzaay() {
        if (this.zzeht != null) {
            this.zzeht.zza(zzsv.zza.zza.zzbvd);
        }
        this.zzeif = true;
        this.zzaaz();
        zzzk zzzk2 = zzzz.zzcrz;
        if (((Boolean)zzvj.zzpv().zzd(zzzk2)).booleanValue()) {
            this.zzehs.destroy();
        }
    }

    private final void zzaaz() {
        if (this.zzehv != null && (this.zzeie && this.zzeig <= 0 || this.zzeif)) {
            this.zzehv.zzak(!this.zzeif);
            this.zzehv = null;
        }
        this.zzehs.zzabt();
    }

    public final void zza(zzd zzd2) {
        boolean bl = this.zzehs.zzabo();
        this.zza(new AdOverlayInfoParcel(zzd2, (zzub)(bl && !this.zzehs.zzabh().zzaco() ? null : this.zzceb), bl ? null : this.zzdkt, this.zzdkx, this.zzehs.zzzk()));
    }

    public final void zzb(boolean bl, int n) {
        boolean bl2 = this.zzehs.zzabo();
        this.zza(new AdOverlayInfoParcel((zzub)(bl2 && !this.zzehs.zzabh().zzaco() ? null : this.zzceb), this.zzdkt, this.zzdkx, this.zzehs, bl, n, this.zzehs.zzzk()));
    }

    public final void zza(boolean bl, int n, String string2) {
        boolean bl2 = this.zzehs.zzabo();
        this.zza(new AdOverlayInfoParcel((zzub)(bl2 && !this.zzehs.zzabh().zzaco() ? null : this.zzceb), (zzo)(bl2 ? null : new zzbep(this.zzehs, this.zzdkt)), this.zzczu, this.zzczw, this.zzdkx, this.zzehs, bl, n, string2, this.zzehs.zzzk()));
    }

    public final void zza(boolean bl, int n, String string2, String string3) {
        boolean bl2 = this.zzehs.zzabo();
        this.zza(new AdOverlayInfoParcel((zzub)(bl2 && !this.zzehs.zzabh().zzaco() ? null : this.zzceb), bl2 ? null : new zzbep(this.zzehs, this.zzdkt), this.zzczu, this.zzczw, this.zzdkx, this.zzehs, bl, n, string2, string3, this.zzehs.zzzk()));
    }

    private final void zza(AdOverlayInfoParcel adOverlayInfoParcel) {
        boolean bl = false;
        if (this.zzdat != null) {
            bl = this.zzdat.zzub();
        }
        zzq.zzkv();
        zzn.zza(this.zzehs.getContext(), adOverlayInfoParcel, !bl);
        if (this.zzeid != null) {
            String string2 = adOverlayInfoParcel.url;
            if (string2 == null && adOverlayInfoParcel.zzdks != null) {
                string2 = adOverlayInfoParcel.zzdks.url;
            }
            this.zzeid.zzdy(string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zza(String string2, zzaga<? super zzbek> zzaga2) {
        Object object = this.lock;
        synchronized (object) {
            List<zzaga<? super zzbek>> list = this.zzehu.get(string2);
            if (list == null) {
                list = new CopyOnWriteArrayList<zzaga<? super zzbek>>();
                this.zzehu.put(string2, list);
            }
            list.add(zzaga2);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzb(String string2, zzaga<? super zzbek> zzaga2) {
        Object object = this.lock;
        synchronized (object) {
            List<zzaga<? super zzbek>> list = this.zzehu.get(string2);
            if (list == null) {
                return;
            }
            list.remove(zzaga2);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zza(String string2, Predicate<zzaga<? super zzbek>> predicate) {
        Object object = this.lock;
        synchronized (object) {
            List<zzaga<? super zzbek>> list = this.zzehu.get(string2);
            if (list == null) {
                return;
            }
            ArrayList<zzaga<? super zzbek>> arrayList = new ArrayList<zzaga<? super zzbek>>();
            for (zzaga<? super zzbek> zzaga2 : list) {
                if (!predicate.apply(zzaga2)) continue;
                arrayList.add(zzaga2);
            }
            list.removeAll(arrayList);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void reset() {
        if (this.zzeid != null) {
            this.zzeid.zzvi();
            this.zzeid = null;
        }
        this.zzaau();
        Object object = this.lock;
        synchronized (object) {
            this.zzehu.clear();
            this.zzceb = null;
            this.zzdkt = null;
            this.zzehv = null;
            this.zzehw = null;
            this.zzczu = null;
            this.zzczw = null;
            this.zzehy = false;
            this.zzbne = false;
            this.zzehz = false;
            this.zzeib = false;
            this.zzdkx = null;
            this.zzehx = null;
            if (this.zzdat != null) {
                this.zzdat.zzac(true);
                this.zzdat = null;
            }
            return;
        }
    }

    @Override
    public final void zza(zzbfv zzbfv2) {
        this.zzehv = zzbfv2;
    }

    @Override
    public final void zza(zzbfy zzbfy2) {
        this.zzehw = zzbfy2;
    }

    public final void onLoadResource(WebView webView, String string2) {
        String string3 = String.valueOf(string2);
        zzawr.zzeg(string3.length() != 0 ? "Loading resource: ".concat(string3) : new String("Loading resource: "));
        Uri uri = Uri.parse((String)string2);
        if ("gmsg".equalsIgnoreCase(uri.getScheme()) && "mobileads.google.com".equalsIgnoreCase(uri.getHost())) {
            this.zzh(uri);
        }
    }

    public final boolean shouldOverrideUrlLoading(WebView webView, String string2) {
        String string3 = String.valueOf(string2);
        zzawr.zzeg(string3.length() != 0 ? "AdWebView shouldOverrideUrlLoading: ".concat(string3) : new String("AdWebView shouldOverrideUrlLoading: "));
        Uri uri = Uri.parse((String)string2);
        if ("gmsg".equalsIgnoreCase(uri.getScheme()) && "mobileads.google.com".equalsIgnoreCase(uri.getHost())) {
            this.zzh(uri);
        } else {
            String string4;
            if (this.zzehy && webView == this.zzehs.getWebView() && ("http".equalsIgnoreCase(string4 = uri.getScheme()) || "https".equalsIgnoreCase(string4))) {
                if (this.zzceb != null) {
                    this.zzceb.onAdClicked();
                    if (this.zzeid != null) {
                        this.zzeid.zzdy(string2);
                    }
                    this.zzceb = null;
                }
                return super.shouldOverrideUrlLoading(webView, string2);
            }
            if (!this.zzehs.getWebView().willNotDraw()) {
                try {
                    zzdt zzdt2 = this.zzehs.zzabm();
                    if (zzdt2 != null && zzdt2.zzb(uri)) {
                        uri = zzdt2.zza(uri, this.zzehs.getContext(), this.zzehs.getView(), this.zzehs.zzzh());
                    }
                }
                catch (zzdw zzdw2) {
                    String string5 = String.valueOf(string2);
                    zzawr.zzfc((String)(string5.length() != 0 ? "Unable to append parameter to URL: ".concat(string5) : new String("Unable to append parameter to URL: ")));
                }
                if (this.zzdas == null || this.zzdas.zzjx()) {
                    this.zza(new zzd("android.intent.action.VIEW", uri.toString(), null, null, null, null, null));
                } else {
                    this.zzdas.zzbm(string2);
                }
            } else {
                String string6 = String.valueOf(string2);
                zzawr.zzfc((String)(string6.length() != 0 ? "AdWebView unable to handle URL: ".concat(string6) : new String("AdWebView unable to handle URL: ")));
            }
        }
        return true;
    }

    @TargetApi(value=11)
    @Nullable
    public WebResourceResponse shouldInterceptRequest(WebView webView, String string2) {
        return this.zzd(string2, Collections.emptyMap());
    }

    @Nullable
    protected final WebResourceResponse zzd(String string2, Map<String, String> map) {
        try {
            zzse zzse2;
            String string3 = zzavj.zzc(string2, this.zzehs.getContext(), this.zzdov);
            if (!string3.equals(string2)) {
                return this.zze(string3, map);
            }
            zzsf zzsf2 = zzsf.zzbu(string2);
            if (zzsf2 != null && (zzse2 = zzq.zzlc().zza(zzsf2)) != null && zzse2.zzmv()) {
                return new WebResourceResponse("", "", zzse2.zzmw());
            }
            if (zzazq.isEnabled() && ((Boolean)zzabi.zzcwi.get()).booleanValue()) {
                return this.zze(string2, map);
            }
            return null;
        }
        catch (Exception | NoClassDefFoundError throwable) {
            zzq.zzla().zza(throwable, "AdWebViewClient.interceptRequest");
            return zzbej.zzaba();
        }
    }

    private static WebResourceResponse zzaba() {
        zzzk zzzk2 = zzzz.zzclc;
        if (((Boolean)zzvj.zzpv().zzd(zzzk2)).booleanValue()) {
            return new WebResourceResponse("", "", (InputStream)new ByteArrayInputStream(new byte[0]));
        }
        return null;
    }

    private final WebResourceResponse zze(String string2, Map<String, String> map) throws IOException {
        URL uRL = new URL(string2);
        int n = 0;
        while (++n <= 20) {
            URLConnection uRLConnection = uRL.openConnection();
            uRLConnection.setConnectTimeout(10000);
            uRLConnection.setReadTimeout(10000);
            for (Map.Entry<String, String> entry : map.entrySet()) {
                uRLConnection.addRequestProperty(entry.getKey(), entry.getValue());
            }
            if (!(uRLConnection instanceof HttpURLConnection)) {
                throw new IOException("Invalid protocol.");
            }
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
            zzq.zzkw().zza(this.zzehs.getContext(), this.zzehs.zzzk().zzbnd, false, httpURLConnection);
            zzazq zzazq22 = new zzazq();
            zzazq22.zza(httpURLConnection, null);
            int n2 = httpURLConnection.getResponseCode();
            zzazq22.zza(httpURLConnection, n2);
            if (n2 >= 300 && n2 < 400) {
                String string3 = httpURLConnection.getHeaderField("Location");
                if (string3 == null) {
                    throw new IOException("Missing Location header in redirect");
                }
                if (string3.startsWith("tel:")) {
                    return null;
                }
                String string4 = (uRL = new URL(uRL, string3)).getProtocol();
                if (string4 == null) {
                    zzawr.zzfc((String)"Protocol is null");
                    return zzbej.zzaba();
                }
                if (!string4.equals("http") && !string4.equals("https")) {
                    String string5 = String.valueOf(string4);
                    zzawr.zzfc((String)(string5.length() != 0 ? "Unsupported scheme: ".concat(string5) : new String("Unsupported scheme: ")));
                    return zzbej.zzaba();
                }
                String string6 = String.valueOf(string3);
                zzawr.zzed((String)(string6.length() != 0 ? "Redirecting to ".concat(string6) : new String("Redirecting to ")));
                httpURLConnection.disconnect();
                continue;
            }
            zzq.zzkw();
            return zzaxa.zzd(httpURLConnection);
        }
        throw new IOException(new StringBuilder(32).append("Too many redirects (20)").toString());
    }

    public final void zzav(boolean bl) {
        this.zzehy = bl;
    }

    @Override
    public final zzaun zzabb() {
        return this.zzeid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzui() {
        Object object = this.lock;
        synchronized (object) {
            this.zzehy = false;
            this.zzbne = true;
            zzbab.zzdzv.execute(new zzbem(this));
            return;
        }
    }

    public final void zzax(boolean bl) {
        this.zzdov = bl;
    }

    @Override
    public final void zzi(int n, int n2) {
        if (this.zzdat != null) {
            this.zzdat.zzi(n, n2);
        }
    }

    public boolean shouldOverrideKeyEvent(WebView webView, KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 79: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 222: {
                return true;
            }
        }
        return false;
    }

    @Override
    public final void zzh(Uri uri) {
        String string2 = uri.getPath();
        List<zzaga<? super zzbek>> list = this.zzehu.get(string2);
        if (list != null) {
            zzzk zzzk2 = zzzz.zzcrv;
            if (!((Boolean)zzvj.zzpv().zzd(zzzk2)).booleanValue()) {
                zzq.zzkw();
                Map<String, String> map = zzaxa.zzj(uri);
                this.zza(map, list, string2);
                return;
            }
            zzdqw.zza(zzq.zzkw().zzi(uri), new zzbeq(this, list, string2), zzbab.zzdzw);
            return;
        }
        String string3 = String.valueOf(uri);
        zzawr.zzeg(new StringBuilder(32 + String.valueOf(string3).length()).append("No GMSG handler found for GMSG: ").append(string3).toString());
        zzzk zzzk3 = zzzz.zzctz;
        if (!((Boolean)zzvj.zzpv().zzd(zzzk3)).booleanValue() || zzq.zzla().zzvv() == null) {
            return;
        }
        zzbab.zzdzr.execute(new zzbel(string2));
    }

    private final void zza(Map<String, String> map, List<zzaga<? super zzbek>> list, String string2) {
        if (zzawr.isLoggable((int)2)) {
            String string3 = String.valueOf(string2);
            zzawr.zzeg(string3.length() != 0 ? "Received GMSG: ".concat(string3) : new String("Received GMSG: "));
            for (String string4 : map.keySet()) {
                String string5 = map.get(string4);
                zzawr.zzeg(new StringBuilder(4 + String.valueOf(string4).length() + String.valueOf(string5).length()).append("  ").append(string4).append(": ").append(string5).toString());
            }
        }
        Iterator<Object> iterator = list.iterator();
        while (iterator.hasNext()) {
            iterator.next().zza(this.zzehs, map);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzay(boolean bl) {
        Object object = this.lock;
        synchronized (object) {
            this.zzehz = true;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzaz(boolean bl) {
        Object object = this.lock;
        synchronized (object) {
            this.zzeia = bl;
            return;
        }
    }

    @TargetApi(value=26)
    public boolean onRenderProcessGone(WebView webView, RenderProcessGoneDetail renderProcessGoneDetail) {
        return this.zzehs.zzc(renderProcessGoneDetail.didCrash(), renderProcessGoneDetail.rendererPriorityAtExit());
    }

    static /* synthetic */ void zza(zzbej zzbej2, View view, zzaun zzaun2, int n) {
        zzbej2.zza(view, zzaun2, n);
    }

    static /* synthetic */ void zza(zzbej zzbej2, Map map, List list, String string2) {
        zzbej2.zza(map, list, string2);
    }
}

