/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.annotation.TargetApi;
import android.graphics.Bitmap;
import android.net.Uri;
import android.view.View;
import android.view.ViewTreeObserver;
import android.webkit.RenderProcessGoneDetail;
import android.webkit.WebResourceResponse;
import android.webkit.WebView;
import androidx.annotation.Nullable;
import androidx.core.view.ViewCompat;
import com.google.android.gms.ads.internal.overlay.AdOverlayInfoParcel;
import com.google.android.gms.ads.internal.overlay.zzd;
import com.google.android.gms.ads.internal.overlay.zzn;
import com.google.android.gms.ads.internal.overlay.zzo;
import com.google.android.gms.ads.internal.overlay.zzt;
import com.google.android.gms.ads.internal.zzc;
import com.google.android.gms.ads.internal.zzq;
import com.google.android.gms.common.util.Predicate;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.ads.zzabi;
import com.google.android.gms.internal.ads.zzafg;
import com.google.android.gms.internal.ads.zzafi;
import com.google.android.gms.internal.ads.zzafj;
import com.google.android.gms.internal.ads.zzafl;
import com.google.android.gms.internal.ads.zzafn;
import com.google.android.gms.internal.ads.zzaga;
import com.google.android.gms.internal.ads.zzagc;
import com.google.android.gms.internal.ads.zzagd;
import com.google.android.gms.internal.ads.zzage;
import com.google.android.gms.internal.ads.zzagf;
import com.google.android.gms.internal.ads.zzair;
import com.google.android.gms.internal.ads.zzaor;
import com.google.android.gms.internal.ads.zzaoy;
import com.google.android.gms.internal.ads.zzapa;
import com.google.android.gms.internal.ads.zzaun;
import com.google.android.gms.internal.ads.zzavj;
import com.google.android.gms.internal.ads.zzawr;
import com.google.android.gms.internal.ads.zzaxa;
import com.google.android.gms.internal.ads.zzazq;
import com.google.android.gms.internal.ads.zzbab;
import com.google.android.gms.internal.ads.zzbdu;
import com.google.android.gms.internal.ads.zzbek;
import com.google.android.gms.internal.ads.zzbfv;
import com.google.android.gms.internal.ads.zzbfw;
import com.google.android.gms.internal.ads.zzbfx;
import com.google.android.gms.internal.ads.zzbfy;
import com.google.android.gms.internal.ads.zzbgb;
import com.google.android.gms.internal.ads.zzbgd;
import com.google.android.gms.internal.ads.zzbge;
import com.google.android.gms.internal.ads.zzbgg;
import com.google.android.gms.internal.ads.zzbgl;
import com.google.android.gms.internal.ads.zzbgo;
import com.google.android.gms.internal.ads.zzdt;
import com.google.android.gms.internal.ads.zzdw;
import com.google.android.gms.internal.ads.zzrv;
import com.google.android.gms.internal.ads.zzse;
import com.google.android.gms.internal.ads.zzsf;
import com.google.android.gms.internal.ads.zzub;
import com.google.android.gms.internal.ads.zzvj;
import com.google.android.gms.internal.ads.zzzg;
import com.google.android.gms.internal.ads.zzzk;
import com.google.android.gms.internal.ads.zzzz;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.GuardedBy;

@ParametersAreNonnullByDefault
@VisibleForTesting
public final class zzbgc
extends zzbgl
implements zzbfw {
    protected zzbek zzehs;
    private final zzair<zzbek> zzell;
    private final Object lock = new Object();
    private zzub zzceb;
    private zzo zzdkt;
    private zzbfv zzehv;
    private zzbfy zzehw;
    private zzafj zzczu;
    private zzafl zzczw;
    private zzbfx zzehx;
    private boolean zzehy = false;
    private volatile boolean zzbne;
    @GuardedBy(value="lock")
    private boolean zzehz;
    @GuardedBy(value="lock")
    private boolean zzeia;
    @GuardedBy(value="lock")
    private boolean zzeib;
    private zzt zzdkx;
    private zzaoy zzeic;
    private zzc zzdas;
    private zzaor zzdat;
    @Nullable
    private zzaun zzeid;
    private boolean zzeie;
    private boolean zzeif;
    private int zzeig;
    private boolean zzdov;
    private View.OnAttachStateChangeListener zzeih;

    public zzbgc() {
        this.zzell = new zzair();
    }

    final void zza(zzbek zzbek2, boolean bl) {
        zzaoy zzaoy2 = new zzaoy(zzbek2, zzbek2.zzabe(), new zzzg(zzbek2.getContext()));
        boolean bl2 = bl;
        zzbek zzbek3 = zzbek2;
        zzbgc zzbgc2 = this;
        this.zzehs = zzbek3;
        zzbgc2.zzbne = bl2;
        zzbgc2.zzeic = zzaoy2;
        zzbgc2.zzdat = null;
        zzbgc2.zzell.zzg(zzbek3);
    }

    @Override
    public final void zza(int n, int n2, boolean bl) {
        this.zzeic.zzj(n, n2);
        if (this.zzdat != null) {
            this.zzdat.zza(n, n2, false);
        }
    }

    public final void zza(String string2, zzaga<? super zzbek> zzaga2) {
        this.zzell.zza(string2, zzaga2);
    }

    public final void zzb(String string2, zzaga<? super zzbek> zzaga2) {
        this.zzell.zzb(string2, zzaga2);
    }

    public final void zza(String string2, Predicate<zzaga<? super zzbek>> predicate) {
        this.zzell.zza(string2, predicate);
    }

    @Override
    public final void zza(zzub zzub2, zzafj zzafj2, zzo zzo2, zzafl zzafl2, zzt zzt2, boolean bl, @Nullable zzagd zzagd2, zzc zzc2, zzapa zzapa2, @Nullable zzaun zzaun2) {
        boolean bl2;
        if (zzc2 == null) {
            zzc2 = new zzc(this.zzehs.getContext(), zzaun2, null);
        }
        this.zzdat = new zzaor(this.zzehs, zzapa2);
        this.zzeid = zzaun2;
        zzzk zzzk2 = zzzz.zzclm;
        if (((Boolean)zzvj.zzpv().zzd(zzzk2)).booleanValue()) {
            this.zza("/adMetadata", new zzafg(zzafj2));
        }
        this.zza("/appEvent", new zzafi(zzafl2));
        this.zza("/backButton", zzafn.zzdah);
        this.zza("/refresh", zzafn.zzdai);
        this.zza("/canOpenURLs", zzafn.zzczy);
        this.zza("/canOpenIntents", zzafn.zzczz);
        this.zza("/click", zzafn.zzdaa);
        this.zza("/close", zzafn.zzdab);
        this.zza("/customClose", zzafn.zzdac);
        this.zza("/instrument", zzafn.zzdal);
        this.zza("/delayPageLoaded", zzafn.zzdan);
        this.zza("/delayPageClosed", zzafn.zzdao);
        this.zza("/getLocationInfo", zzafn.zzdap);
        this.zza("/httpTrack", zzafn.zzdad);
        this.zza("/log", zzafn.zzdae);
        this.zza("/mraid", new zzagf(zzc2, this.zzdat, zzapa2));
        this.zza("/mraidLoaded", this.zzeic);
        this.zza("/open", new zzage(zzc2, this.zzdat));
        this.zza("/precache", new zzbdu());
        this.zza("/touch", zzafn.zzdag);
        this.zza("/video", zzafn.zzdaj);
        this.zza("/videoMeta", zzafn.zzdak);
        if (zzq.zzlu().zzab(this.zzehs.getContext())) {
            this.zza("/logScionEvent", new zzagc(this.zzehs.getContext()));
        }
        this.zzceb = zzub2;
        this.zzdkt = zzo2;
        this.zzczu = zzafj2;
        this.zzczw = zzafl2;
        this.zzdkx = zzt2;
        this.zzdas = zzc2;
        this.zzehy = bl2 = bl;
    }

    @Override
    public final zzc zzaao() {
        return this.zzdas;
    }

    @Override
    public final boolean zzaap() {
        return this.zzbne;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean zzaaq() {
        Object object = this.lock;
        synchronized (object) {
            return this.zzehz;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean zzaar() {
        Object object = this.lock;
        synchronized (object) {
            return this.zzeia;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ViewTreeObserver.OnGlobalLayoutListener zzaas() {
        Object object = this.lock;
        synchronized (object) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ViewTreeObserver.OnScrollChangedListener zzaat() {
        Object object = this.lock;
        synchronized (object) {
            return null;
        }
    }

    public final void onPageStarted(WebView webView, String string2, Bitmap bitmap) {
        zzrv zzrv2 = this.zzehs.zzabz();
        if (zzrv2 != null && webView == zzrv2.getWebView()) {
            zzrv2.onPageStarted(webView, string2, bitmap);
        }
        super.onPageStarted(webView, string2, bitmap);
    }

    @Override
    public final void zza(zzbgo zzbgo2) {
        this.zzeie = true;
        zzbgc zzbgc2 = this;
        if (zzbgc2.zzehw != null) {
            zzbgc2.zzehw.zzsw();
            zzbgc2.zzehw = null;
        }
        this.zzaaz();
    }

    private final void zza(View view, zzaun zzaun2, int n) {
        if (zzaun2.zzvg() && n > 0) {
            zzaun2.zzl(view);
            if (zzaun2.zzvg()) {
                zzaxa.zzdwf.postDelayed((Runnable)new zzbge(this, view, zzaun2, n), 100L);
            }
        }
    }

    private final void zzaau() {
        if (this.zzeih == null) {
            return;
        }
        this.zzehs.getView().removeOnAttachStateChangeListener(this.zzeih);
    }

    @Override
    public final void zzaav() {
        zzaun zzaun2 = this.zzeid;
        if (zzaun2 != null) {
            WebView webView = this.zzehs.getWebView();
            if (ViewCompat.isAttachedToWindow((View)webView)) {
                this.zza((View)webView, zzaun2, 10);
                return;
            }
            zzaun zzaun3 = zzaun2;
            zzbgc zzbgc2 = this;
            zzbgc2.zzaau();
            zzbgc2.zzeih = new zzbgd(zzbgc2, zzaun3);
            zzbgc2.zzehs.getView().addOnAttachStateChangeListener(zzbgc2.zzeih);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzaaw() {
        Object object = this.lock;
        synchronized (object) {
            this.zzeib = true;
        }
        ++this.zzeig;
        this.zzaaz();
    }

    @Override
    public final void zzaax() {
        --this.zzeig;
        this.zzaaz();
    }

    @Override
    public final void zzaay() {
        this.zzeif = true;
        this.zzaaz();
    }

    private final void zzaaz() {
        if (this.zzehv != null && (this.zzeie && this.zzeig <= 0 || this.zzeif)) {
            this.zzehv.zzak(!this.zzeif);
            this.zzehv = null;
        }
        this.zzehs.zzabt();
    }

    public final void zza(zzd zzd2) {
        boolean bl = this.zzehs.zzabo();
        this.zza(new AdOverlayInfoParcel(zzd2, (zzub)(bl && !this.zzehs.zzabh().zzaco() ? null : this.zzceb), bl ? null : this.zzdkt, this.zzdkx, this.zzehs.zzzk()));
    }

    public final void zzb(boolean bl, int n) {
        boolean bl2 = this.zzehs.zzabo();
        this.zza(new AdOverlayInfoParcel((zzub)(bl2 && !this.zzehs.zzabh().zzaco() ? null : this.zzceb), this.zzdkt, this.zzdkx, this.zzehs, bl, n, this.zzehs.zzzk()));
    }

    public final void zza(boolean bl, int n, String string2) {
        boolean bl2 = this.zzehs.zzabo();
        this.zza(new AdOverlayInfoParcel((zzub)(bl2 && !this.zzehs.zzabh().zzaco() ? null : this.zzceb), (zzo)(bl2 ? null : new zzbgg(this.zzehs, this.zzdkt)), this.zzczu, this.zzczw, this.zzdkx, this.zzehs, bl, n, string2, this.zzehs.zzzk()));
    }

    public final void zza(boolean bl, int n, String string2, String string3) {
        boolean bl2 = this.zzehs.zzabo();
        this.zza(new AdOverlayInfoParcel((zzub)(bl2 && !this.zzehs.zzabh().zzaco() ? null : this.zzceb), bl2 ? null : new zzbgg(this.zzehs, this.zzdkt), this.zzczu, this.zzczw, this.zzdkx, this.zzehs, bl, n, string2, string3, this.zzehs.zzzk()));
    }

    private final void zza(AdOverlayInfoParcel adOverlayInfoParcel) {
        boolean bl = false;
        if (this.zzdat != null) {
            bl = this.zzdat.zzub();
        }
        zzq.zzkv();
        zzn.zza(this.zzehs.getContext(), adOverlayInfoParcel, !bl);
        if (this.zzeid != null) {
            String string2 = adOverlayInfoParcel.url;
            if (string2 == null && adOverlayInfoParcel.zzdks != null) {
                string2 = adOverlayInfoParcel.zzdks.url;
            }
            this.zzeid.zzdy(string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void destroy() {
        if (this.zzeid != null) {
            this.zzeid.zzvi();
            this.zzeid = null;
        }
        this.zzaau();
        this.zzell.reset();
        this.zzell.zzg((zzbek)null);
        Object object = this.lock;
        synchronized (object) {
            this.zzceb = null;
            this.zzdkt = null;
            this.zzehv = null;
            this.zzehw = null;
            this.zzczu = null;
            this.zzczw = null;
            this.zzdkx = null;
            this.zzehx = null;
            if (this.zzdat != null) {
                this.zzdat.zzac(true);
                this.zzdat = null;
            }
            return;
        }
    }

    @Override
    public final void zza(zzbfv zzbfv2) {
        this.zzehv = zzbfv2;
    }

    @Override
    public final void zza(zzbfy zzbfy2) {
        this.zzehw = zzbfy2;
    }

    @Override
    public final void zzb(zzbgo zzbgo2) {
        this.zzell.zzg(zzbgo2.uri);
    }

    @Override
    public final boolean zzc(zzbgo zzbgo2) {
        String string2;
        String string3 = String.valueOf(zzbgo2.url);
        zzawr.zzeg(string3.length() != 0 ? "AdWebView shouldOverrideUrlLoading: ".concat(string3) : new String("AdWebView shouldOverrideUrlLoading: "));
        Uri uri = zzbgo2.uri;
        if (this.zzell.zzg(uri)) {
            return true;
        }
        if (this.zzehy && ("http".equalsIgnoreCase(string2 = uri.getScheme()) || "https".equalsIgnoreCase(string2))) {
            if (this.zzceb != null) {
                this.zzceb.onAdClicked();
                if (this.zzeid != null) {
                    this.zzeid.zzdy(zzbgo2.url);
                }
                this.zzceb = null;
            }
            return false;
        }
        if (!this.zzehs.getWebView().willNotDraw()) {
            try {
                zzdt zzdt2 = this.zzehs.zzabm();
                if (zzdt2 != null && zzdt2.zzb(uri)) {
                    uri = zzdt2.zza(uri, this.zzehs.getContext(), this.zzehs.getView(), this.zzehs.zzzh());
                }
            }
            catch (zzdw zzdw2) {
                String string4 = String.valueOf(zzbgo2.url);
                zzawr.zzfc((String)(string4.length() != 0 ? "Unable to append parameter to URL: ".concat(string4) : new String("Unable to append parameter to URL: ")));
            }
            if (this.zzdas == null || this.zzdas.zzjx()) {
                this.zza(new zzd("android.intent.action.VIEW", uri.toString(), null, null, null, null, null));
            } else {
                this.zzdas.zzbm(zzbgo2.url);
            }
        } else {
            String string5 = String.valueOf(zzbgo2.url);
            zzawr.zzfc((String)(string5.length() != 0 ? "AdWebView unable to handle URL: ".concat(string5) : new String("AdWebView unable to handle URL: ")));
        }
        return true;
    }

    @Override
    @Nullable
    public final WebResourceResponse zzd(zzbgo zzbgo2) {
        WebResourceResponse webResourceResponse;
        WebResourceResponse webResourceResponse2;
        if (this.zzeid != null) {
            this.zzeid.zza(zzbgo2.url, zzbgo2.zzab, 1);
        }
        zzbgo zzbgo3 = zzbgo2;
        zzbgc zzbgc2 = this;
        String string2 = new File(zzbgo3.url).getName();
        if (!"mraid.js".equalsIgnoreCase(string2)) {
            webResourceResponse2 = null;
        } else {
            String string3;
            zzbgc2.zzui();
            if (zzbgc2.zzehs.zzabh().zzaco()) {
                zzzk zzzk2 = zzzz.zzcka;
                string3 = (String)zzvj.zzpv().zzd(zzzk2);
            } else if (zzbgc2.zzehs.zzabo()) {
                zzzk zzzk3 = zzzz.zzcjz;
                string3 = (String)zzvj.zzpv().zzd(zzzk3);
            } else {
                zzzk zzzk4 = zzzz.zzcjy;
                string3 = (String)zzvj.zzpv().zzd(zzzk4);
            }
            zzq.zzkw();
            webResourceResponse2 = webResourceResponse = zzaxa.zzd(zzbgc2.zzehs.getContext(), zzbgc2.zzehs.zzzk().zzbnd, string3);
        }
        if (webResourceResponse2 != null) {
            return webResourceResponse;
        }
        try {
            zzse zzse2;
            if (!zzavj.zzc(zzbgo2.url, this.zzehs.getContext(), this.zzdov).equals(zzbgo2.url)) {
                return this.zze(zzbgo2);
            }
            zzsf zzsf2 = zzsf.zzbu(zzbgo2.url);
            if (zzsf2 != null && (zzse2 = zzq.zzlc().zza(zzsf2)) != null && zzse2.zzmv()) {
                return new WebResourceResponse("", "", zzse2.zzmw());
            }
            if (zzazq.isEnabled() && ((Boolean)zzabi.zzcwi.get()).booleanValue()) {
                return this.zze(zzbgo2);
            }
            return null;
        }
        catch (Exception | NoClassDefFoundError throwable) {
            zzq.zzla().zza(throwable, "AdWebViewClient.interceptRequest");
            return zzbgc.zzaba();
        }
    }

    private static WebResourceResponse zzaba() {
        zzzk zzzk2 = zzzz.zzclc;
        if (((Boolean)zzvj.zzpv().zzd(zzzk2)).booleanValue()) {
            return new WebResourceResponse("", "", (InputStream)new ByteArrayInputStream(new byte[0]));
        }
        return null;
    }

    private final WebResourceResponse zze(zzbgo zzbgo2) throws IOException {
        URL uRL = new URL(zzbgo2.url);
        int n = 0;
        while (++n <= 20) {
            URLConnection uRLConnection = uRL.openConnection();
            uRLConnection.setConnectTimeout(10000);
            uRLConnection.setReadTimeout(10000);
            for (Map.Entry<String, String> entry : zzbgo2.zzab.entrySet()) {
                uRLConnection.addRequestProperty(entry.getKey(), entry.getValue());
            }
            if (!(uRLConnection instanceof HttpURLConnection)) {
                throw new IOException("Invalid protocol.");
            }
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
            zzq.zzkw().zza(this.zzehs.getContext(), this.zzehs.zzzk().zzbnd, false, httpURLConnection);
            zzazq zzazq22 = new zzazq();
            zzazq22.zza(httpURLConnection, null);
            int n2 = httpURLConnection.getResponseCode();
            zzazq22.zza(httpURLConnection, n2);
            if (n2 >= 300 && n2 < 400) {
                String string2 = httpURLConnection.getHeaderField("Location");
                if (string2 == null) {
                    throw new IOException("Missing Location header in redirect");
                }
                if (string2.startsWith("tel:")) {
                    return null;
                }
                String string3 = (uRL = new URL(uRL, string2)).getProtocol();
                if (string3 == null) {
                    zzawr.zzfc((String)"Protocol is null");
                    return zzbgc.zzaba();
                }
                if (!string3.equals("http") && !string3.equals("https")) {
                    String string4 = String.valueOf(string3);
                    zzawr.zzfc((String)(string4.length() != 0 ? "Unsupported scheme: ".concat(string4) : new String("Unsupported scheme: ")));
                    return zzbgc.zzaba();
                }
                String string5 = String.valueOf(string2);
                zzawr.zzed((String)(string5.length() != 0 ? "Redirecting to ".concat(string5) : new String("Redirecting to ")));
                httpURLConnection.disconnect();
                continue;
            }
            zzq.zzkw();
            return zzaxa.zzd(httpURLConnection);
        }
        throw new IOException(new StringBuilder(32).append("Too many redirects (20)").toString());
    }

    public final void zzav(boolean bl) {
        this.zzehy = bl;
    }

    @Override
    public final zzaun zzabb() {
        return this.zzeid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzui() {
        Object object = this.lock;
        synchronized (object) {
            this.zzehy = false;
            this.zzbne = true;
            zzbab.zzdzv.execute(new zzbgb(this));
            return;
        }
    }

    public final void zzax(boolean bl) {
        this.zzdov = bl;
    }

    @Override
    public final void zzi(int n, int n2) {
        if (this.zzdat != null) {
            this.zzdat.zzi(n, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzay(boolean bl) {
        Object object = this.lock;
        synchronized (object) {
            this.zzehz = true;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzaz(boolean bl) {
        Object object = this.lock;
        synchronized (object) {
            this.zzeia = bl;
            return;
        }
    }

    @Override
    public final void zzh(Uri uri) {
        this.zzell.zzh(uri);
    }

    @TargetApi(value=26)
    public final boolean onRenderProcessGone(WebView webView, RenderProcessGoneDetail renderProcessGoneDetail) {
        return this.zzehs.zzc(renderProcessGoneDetail.didCrash(), renderProcessGoneDetail.rendererPriorityAtExit());
    }

    static /* synthetic */ void zza(zzbgc zzbgc2, View view, zzaun zzaun2, int n) {
        zzbgc2.zza(view, zzaun2, n);
    }
}

