/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.graphics.Canvas;
import android.net.Uri;
import android.os.Build;
import android.util.DisplayMetrics;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.WindowManager;
import android.webkit.DownloadListener;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import androidx.annotation.Nullable;
import com.google.android.gms.ads.internal.overlay.zzc;
import com.google.android.gms.ads.internal.overlay.zzd;
import com.google.android.gms.ads.internal.zza;
import com.google.android.gms.ads.internal.zzi;
import com.google.android.gms.ads.internal.zzq;
import com.google.android.gms.common.util.PlatformVersion;
import com.google.android.gms.common.util.Predicate;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.internal.ads.zzaah;
import com.google.android.gms.internal.ads.zzaak;
import com.google.android.gms.internal.ads.zzaam;
import com.google.android.gms.internal.ads.zzaan;
import com.google.android.gms.internal.ads.zzacf;
import com.google.android.gms.internal.ads.zzacg;
import com.google.android.gms.internal.ads.zzaga;
import com.google.android.gms.internal.ads.zzaim;
import com.google.android.gms.internal.ads.zzain;
import com.google.android.gms.internal.ads.zzapb;
import com.google.android.gms.internal.ads.zzawr;
import com.google.android.gms.internal.ads.zzaxa;
import com.google.android.gms.internal.ads.zzaxs;
import com.google.android.gms.internal.ads.zzazj;
import com.google.android.gms.internal.ads.zzazm;
import com.google.android.gms.internal.ads.zzazz;
import com.google.android.gms.internal.ads.zzbbq;
import com.google.android.gms.internal.ads.zzbdl;
import com.google.android.gms.internal.ads.zzbdm;
import com.google.android.gms.internal.ads.zzbek;
import com.google.android.gms.internal.ads.zzbfe;
import com.google.android.gms.internal.ads.zzbff;
import com.google.android.gms.internal.ads.zzbfp;
import com.google.android.gms.internal.ads.zzbfw;
import com.google.android.gms.internal.ads.zzbfz;
import com.google.android.gms.internal.ads.zzbga;
import com.google.android.gms.internal.ads.zzbgc;
import com.google.android.gms.internal.ads.zzbgj;
import com.google.android.gms.internal.ads.zzbgk;
import com.google.android.gms.internal.ads.zzbgm;
import com.google.android.gms.internal.ads.zzbgn;
import com.google.android.gms.internal.ads.zzdt;
import com.google.android.gms.internal.ads.zzecd;
import com.google.android.gms.internal.ads.zzqa;
import com.google.android.gms.internal.ads.zzrh;
import com.google.android.gms.internal.ads.zzrv;
import com.google.android.gms.internal.ads.zzst;
import com.google.android.gms.internal.ads.zzsv;
import com.google.android.gms.internal.ads.zztf;
import com.google.android.gms.internal.ads.zzvj;
import com.google.android.gms.internal.ads.zzzk;
import com.google.android.gms.internal.ads.zzzz;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.GuardedBy;
import org.json.JSONObject;

@ParametersAreNonnullByDefault
@VisibleForTesting
final class zzbgh
extends zzbgn
implements ViewTreeObserver.OnGlobalLayoutListener,
DownloadListener,
zzain,
zzbek {
    private final zzbga zzejk;
    private final zzbgc zzeln;
    @Nullable
    private final zzdt zzejl;
    private final zzazz zzbmo;
    private final zzi zzejm;
    private final zza zzejn;
    private final DisplayMetrics zzwz;
    private final zzst zzeht;
    @Nullable
    private final zzrv zzejp;
    private final boolean zzejq;
    @GuardedBy(value="this")
    private zzc zzeju;
    @GuardedBy(value="this")
    private zzbfz zzejw;
    @GuardedBy(value="this")
    private String zzacf;
    @GuardedBy(value="this")
    private boolean zzdkv;
    @GuardedBy(value="this")
    private boolean zzejy;
    @GuardedBy(value="this")
    private boolean zzejz;
    @GuardedBy(value="this")
    private int zzeka;
    @GuardedBy(value="this")
    private boolean zzekb = true;
    @GuardedBy(value="this")
    private boolean zzekc = false;
    @GuardedBy(value="this")
    private String zzdmh = "";
    @GuardedBy(value="this")
    private zzbfe zzekd;
    @GuardedBy(value="this")
    private boolean zzeke;
    @GuardedBy(value="this")
    private boolean zzekf;
    @GuardedBy(value="this")
    private zzacg zzekg;
    @GuardedBy(value="this")
    private zzacf zzekh;
    @GuardedBy(value="this")
    private zzrh zzeki;
    @GuardedBy(value="this")
    private int zzekj;
    @GuardedBy(value="this")
    private int zzekk;
    private zzaak zzekl;
    private zzaak zzeec;
    private zzaak zzekm;
    private zzaan zzekn;
    private WeakReference<View.OnClickListener> zzeko;
    @GuardedBy(value="this")
    private zzc zzekp;
    private zzazj zzekr;
    private final AtomicReference<IObjectWrapper> zzelo = new AtomicReference();
    private int zzdjj = -1;
    private int zzdji = -1;
    private int maxWidth = -1;
    private int maxHeight = -1;
    private Map<String, zzbdl> zzeks;
    private final WindowManager zzboo;

    @VisibleForTesting
    protected zzbgh(zzbga zzbga2, zzbgc zzbgc2, zzbfz zzbfz2, String string2, boolean bl, boolean bl2, @Nullable zzdt zzdt2, zzazz zzazz2, zzaam zzaam2, zzi zzi2, zza zza2, zzst zzst2, zzrv zzrv2, boolean bl3) {
        super((Context)zzbga2, zzbgc2);
        this.zzejk = zzbga2;
        this.zzeln = zzbgc2;
        this.zzejw = zzbfz2;
        this.zzacf = string2;
        this.zzejy = bl;
        this.zzeka = -1;
        this.zzejl = zzdt2;
        this.zzbmo = zzazz2;
        this.zzejm = zzi2;
        this.zzejn = zza2;
        this.zzboo = (WindowManager)this.getContext().getSystemService("window");
        zzq.zzkw();
        this.zzwz = zzaxa.zza(this.zzboo);
        this.zzeht = zzst2;
        this.zzejp = zzrv2;
        this.zzejq = bl3;
        this.zzekr = new zzazj(this.zzejk.zzzh(), (View)this, this, null);
        zzq.zzkw().zza((Context)zzbga2, zzazz2.zzbnd, this.getSettings());
        this.setDownloadListener(this);
        this.zzace();
        if (PlatformVersion.isAtLeastJellyBeanMR1()) {
            ((zzbgm)this).addJavascriptInterface(zzbff.zzc(this), "googleAdsJsInterface");
        }
        zzaam zzaam3 = zzaam2;
        zzbgh zzbgh2 = this;
        zzbgh2.zzaci();
        zzbgh2.zzekn = new zzaan(new zzaam(true, "make_wv", zzbgh2.zzacf));
        zzbgh2.zzekn.zzrn().zzc(zzaam3);
        zzbgh2.zzeec = zzaah.zzb(zzbgh2.zzekn.zzrn());
        zzbgh2.zzekn.zza("native:view_create", zzbgh2.zzeec);
        zzbgh2.zzekm = null;
        zzbgh2.zzekl = null;
        zzq.zzky().zzbe((Context)zzbga2);
    }

    @Override
    public final WebView getWebView() {
        return this;
    }

    @Override
    public final View getView() {
        return this;
    }

    @Override
    public final zza zzzi() {
        return this.zzejn;
    }

    private final boolean zzacb() {
        int n;
        int n2;
        if (!this.zzeln.zzaap() && !this.zzeln.zzaaq()) {
            return false;
        }
        zzvj.zzpr();
        int n3 = zzazm.zzb((DisplayMetrics)this.zzwz, (int)this.zzwz.widthPixels);
        zzvj.zzpr();
        int n4 = zzazm.zzb((DisplayMetrics)this.zzwz, (int)this.zzwz.heightPixels);
        Activity activity = this.zzejk.zzzh();
        if (activity == null || activity.getWindow() == null) {
            n2 = n3;
            n = n4;
        } else {
            zzq.zzkw();
            int[] nArray = zzaxa.zzd(activity);
            zzvj.zzpr();
            n2 = zzazm.zzb((DisplayMetrics)this.zzwz, (int)nArray[0]);
            zzvj.zzpr();
            n = zzazm.zzb((DisplayMetrics)this.zzwz, (int)nArray[1]);
        }
        if (this.zzdji == n3 && this.zzdjj == n4 && this.maxWidth == n2 && this.maxHeight == n) {
            return false;
        }
        boolean bl = this.zzdji != n3 || this.zzdjj != n4;
        this.zzdji = n3;
        this.zzdjj = n4;
        this.maxWidth = n2;
        this.maxHeight = n;
        new zzapb(this).zza(n3, n4, n2, n, this.zzwz.density, this.zzboo.getDefaultDisplay().getRotation());
        return bl;
    }

    @Override
    public final synchronized void zzb(String string2, String string3, @Nullable String string4) {
        super.loadDataWithBaseURL(string2, zzbfp.zzf(string3, zzbfp.zzack()), "text/html", "UTF-8", string4);
    }

    @Override
    public final synchronized void zzda(String string2) {
        if (!this.isDestroyed()) {
            super.zzda(string2);
            return;
        }
        zzawr.zzfc((String)"The webview is destroyed. Ignoring action.");
    }

    @Override
    public final void zzabc() {
        this.zzacd();
        HashMap<String, String> hashMap = new HashMap<String, String>(1);
        hashMap.put("version", this.zzbmo.zzbnd);
        HashMap<String, String> hashMap2 = hashMap;
        String string2 = "onhide";
        zzaim.zza((zzain)this, "onhide", hashMap2);
    }

    @Override
    public final void zzdn(int n) {
        if (n == 0) {
            zzbgh zzbgh2 = this;
            zzaah.zza(zzbgh2.zzekn.zzrn(), zzbgh2.zzeec, "aebb2");
        }
        this.zzacd();
        if (this.zzekn.zzrn() != null) {
            this.zzekn.zzrn().zzh("close_type", String.valueOf(n));
        }
        HashMap<String, String> hashMap = new HashMap<String, String>(2);
        hashMap.put("closetype", String.valueOf(n));
        hashMap.put("version", this.zzbmo.zzbnd);
        HashMap<String, String> hashMap2 = hashMap;
        String string2 = "onhide";
        zzaim.zza((zzain)this, "onhide", hashMap2);
    }

    private final void zzacd() {
        zzaah.zza(this.zzekn.zzrn(), this.zzeec, "aeh2");
    }

    @Override
    public final void zzum() {
        if (this.zzekl == null) {
            zzaah.zza(this.zzekn.zzrn(), this.zzeec, "aes2");
            this.zzekl = zzaah.zzb(this.zzekn.zzrn());
            this.zzekn.zza("native:view_show", this.zzekl);
        }
        HashMap<String, String> hashMap = new HashMap<String, String>(1);
        hashMap.put("version", this.zzbmo.zzbnd);
        HashMap<String, String> hashMap2 = hashMap;
        String string2 = "onshow";
        zzaim.zza((zzain)this, "onshow", hashMap2);
    }

    @Override
    public final void zzabd() {
        HashMap<String, String> hashMap = new HashMap<String, String>(3);
        hashMap.put("app_muted", String.valueOf(zzq.zzlb().zzqc()));
        hashMap.put("app_volume", String.valueOf(zzq.zzlb().zzqb()));
        hashMap.put("device_volume", String.valueOf(zzaxs.zzbg(this.getContext())));
        HashMap<String, String> hashMap2 = hashMap;
        String string2 = "volume";
        zzaim.zza((zzain)this, "volume", hashMap2);
    }

    @Override
    public final void zza(boolean bl, long l) {
        HashMap<String, String> hashMap = new HashMap<String, String>(2);
        hashMap.put("success", bl ? "1" : "0");
        hashMap.put("duration", Long.toString(l));
        HashMap<String, String> hashMap2 = hashMap;
        String string2 = "onCacheAccessComplete";
        zzaim.zza((zzain)this, "onCacheAccessComplete", hashMap2);
    }

    @Override
    public final synchronized zzc zzabf() {
        return this.zzeju;
    }

    @Override
    public final IObjectWrapper zzabn() {
        return this.zzelo.get();
    }

    @Override
    public final synchronized zzc zzabg() {
        return this.zzekp;
    }

    @Override
    public final synchronized zzbfz zzabh() {
        return this.zzejw;
    }

    @Override
    public final synchronized String zzabi() {
        return this.zzacf;
    }

    @Override
    public final WebViewClient zzabk() {
        return this.zzeln;
    }

    @Override
    public final synchronized boolean zzabl() {
        return this.zzdkv;
    }

    @Override
    public final zzdt zzabm() {
        return this.zzejl;
    }

    @Override
    public final zzazz zzzk() {
        return this.zzbmo;
    }

    @Override
    public final synchronized boolean zzabo() {
        return this.zzejy;
    }

    public final void onDownloadStart(String string2, String string3, String string4, String string5, long l) {
        try {
            Intent intent = new Intent("android.intent.action.VIEW");
            intent.setDataAndType(Uri.parse((String)string2), string5);
            zzq.zzkw();
            zzaxa.zza(this.getContext(), intent);
            return;
        }
        catch (ActivityNotFoundException activityNotFoundException) {
            zzawr.zzed((String)new StringBuilder(51 + String.valueOf(string2).length() + String.valueOf(string5).length()).append("Couldn't find an Activity to view url/mimetype: ").append(string2).append(" / ").append(string5).toString());
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean onTouchEvent(MotionEvent motionEvent) {
        if (this.zzeln.zzaaq() && !this.zzeln.zzaar()) {
            zzbgh zzbgh2 = this;
            synchronized (zzbgh2) {
                if (this.zzekg != null) {
                    this.zzekg.zzc(motionEvent);
                }
            }
        } else if (this.zzejl != null) {
            this.zzejl.zza(motionEvent);
        }
        return super.onTouchEvent(motionEvent);
    }

    public final boolean onGenericMotionEvent(MotionEvent motionEvent) {
        float f = motionEvent.getAxisValue(9);
        float f2 = motionEvent.getAxisValue(10);
        if (motionEvent.getActionMasked() == 8 && (f > 0.0f && !this.canScrollVertically(-1) || f < 0.0f && !this.canScrollVertically(1) || f2 > 0.0f && !this.canScrollHorizontally(-1) || f2 < 0.0f && !this.canScrollHorizontally(1))) {
            return false;
        }
        return super.onGenericMotionEvent(motionEvent);
    }

    @SuppressLint(value={"DrawAllocation"})
    protected final synchronized void onMeasure(int n, int n2) {
        int n3;
        int n4;
        if (this.isDestroyed()) {
            this.setMeasuredDimension(0, 0);
            return;
        }
        if (this.isInEditMode() || this.zzejy || this.zzejw.zzacp()) {
            super.onMeasure(n, n2);
            return;
        }
        if (this.zzejw.zzacr()) {
            super.onMeasure(n, n2);
            return;
        }
        if (this.zzejw.zzacq()) {
            zzzk zzzk2 = zzzz.zzcpa;
            if (((Boolean)zzvj.zzpv().zzd(zzzk2)).booleanValue()) {
                super.onMeasure(n, n2);
                return;
            }
            float f = 0.0f;
            zzbfe zzbfe2 = this.zzzf();
            if (zzbfe2 != null) {
                f = zzbfe2.getAspectRatio();
            }
            if (f == 0.0f) {
                super.onMeasure(n, n2);
                return;
            }
            int n5 = View.MeasureSpec.getSize((int)n);
            int n6 = View.MeasureSpec.getSize((int)n2);
            int n7 = (int)((float)n6 * f);
            int n8 = (int)((float)n5 / f);
            if (n6 == 0 && n8 != 0) {
                n6 = n8;
                n7 = (int)((float)n6 * f);
            } else if (n5 == 0 && n7 != 0) {
                n5 = n7;
                n8 = (int)((float)n5 / f);
            }
            int n9 = Math.min(n7, n5);
            int n10 = Math.min(n8, n6);
            this.setMeasuredDimension(n9, n10);
            return;
        }
        if (this.zzejw.isFluid()) {
            int n11;
            Object object = zzzz.zzcpd;
            if (((Boolean)zzvj.zzpv().zzd(object)).booleanValue() || !PlatformVersion.isAtLeastJellyBeanMR1()) {
                super.onMeasure(n, n2);
                return;
            }
            object = this;
            this.zza("/contentHeight", new zzbgj((zzbgh)object));
            String string2 = "(function() {  var height = -1;  if (document.body) {    height = document.body.offsetHeight;  } else if (document.documentElement) {    height = document.documentElement.offsetHeight;  }  var url = 'gmsg://mobileads.google.com/contentHeight?';  url += 'height=' + height;  try {    window.googleAdsJsInterface.notify(url);  } catch (e) {    var frame = document.getElementById('afma-notify-fluid');    if (!frame) {      frame = document.createElement('IFRAME');      frame.id = 'afma-notify-fluid';      frame.style.display = 'none';      var body = document.body || document.documentElement;      body.appendChild(frame);    }    frame.src = url;  }})();";
            ((zzbgm)this).zzda(string2);
            int n12 = View.MeasureSpec.getSize((int)n);
            switch (this.zzekk) {
                case -1: {
                    n11 = View.MeasureSpec.getSize((int)n2);
                    break;
                }
                default: {
                    n11 = (int)((float)this.zzekk * this.zzwz.density);
                }
            }
            this.setMeasuredDimension(n12, n11);
            return;
        }
        if (this.zzejw.zzaco()) {
            this.setMeasuredDimension(this.zzwz.widthPixels, this.zzwz.heightPixels);
            return;
        }
        int n13 = View.MeasureSpec.getMode((int)n);
        int n14 = View.MeasureSpec.getSize((int)n);
        int n15 = View.MeasureSpec.getMode((int)n2);
        int n16 = View.MeasureSpec.getSize((int)n2);
        int n17 = Integer.MAX_VALUE;
        if (n13 == Integer.MIN_VALUE || n13 == 0x40000000) {
            n17 = n14;
        }
        int n18 = Integer.MAX_VALUE;
        if (n15 == Integer.MIN_VALUE || n15 == 0x40000000) {
            n18 = n16;
        }
        int n19 = this.zzejw.widthPixels > n17 || this.zzejw.heightPixels > n18 ? 1 : 0;
        zzzk zzzk3 = zzzz.zzcrk;
        if (((Boolean)zzvj.zzpv().zzd(zzzk3)).booleanValue()) {
            int n20 = n4 = !((float)this.zzejw.widthPixels / this.zzwz.density > (float)n17 / this.zzwz.density) && !((float)this.zzejw.heightPixels / this.zzwz.density > (float)n18 / this.zzwz.density) ? 1 : 0;
            n3 = n19 != 0 ? n4 : n19;
        } else {
            n3 = n19;
        }
        if (n3 != 0) {
            n4 = (int)((float)this.zzejw.widthPixels / this.zzwz.density);
            int n21 = (int)((float)this.zzejw.heightPixels / this.zzwz.density);
            int n22 = (int)((float)n14 / this.zzwz.density);
            int n23 = (int)((float)n16 / this.zzwz.density);
            zzawr.zzfc((String)new StringBuilder(103).append("Not enough space to show ad. Needs ").append(n4).append("x").append(n21).append(" dp, but only has ").append(n22).append("x").append(n23).append(" dp.").toString());
            if (this.getVisibility() != 8) {
                this.setVisibility(4);
            }
            this.setMeasuredDimension(0, 0);
            return;
        }
        if (this.getVisibility() != 8) {
            this.setVisibility(0);
        }
        this.setMeasuredDimension(this.zzejw.widthPixels, this.zzejw.heightPixels);
    }

    public final void onGlobalLayout() {
        boolean bl = this.zzacb();
        zzc zzc2 = this.zzabf();
        if (zzc2 != null && bl) {
            zzc2.zzul();
        }
    }

    @Override
    public final synchronized void zza(zzc zzc2) {
        this.zzeju = zzc2;
    }

    @Override
    public final void zzap(IObjectWrapper iObjectWrapper) {
        this.zzelo.set(iObjectWrapper);
    }

    @Override
    public final synchronized void zzb(zzc zzc2) {
        this.zzekp = zzc2;
    }

    @Override
    public final synchronized void zza(zzbfz zzbfz2) {
        this.zzejw = zzbfz2;
        this.requestLayout();
    }

    @Override
    public final synchronized void zzba(boolean bl) {
        boolean bl2 = bl != this.zzejy;
        this.zzejy = bl;
        this.zzace();
        if (bl2) {
            zzzk zzzk2 = zzzz.zzckc;
            if (!((Boolean)zzvj.zzpv().zzd(zzzk2)).booleanValue() || !this.zzejw.zzaco()) {
                new zzapb(this).zzdx(bl ? "expanded" : "default");
            }
        }
    }

    @Override
    public final void zzabs() {
        this.zzekr.zzxz();
    }

    protected final synchronized void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (!this.isDestroyed()) {
            this.zzekr.onAttachedToWindow();
        }
        boolean bl = this.zzeke;
        if (this.zzeln != null && this.zzeln.zzaaq()) {
            bl = true;
            if (!this.zzekf) {
                this.zzeln.zzaas();
                this.zzeln.zzaat();
                this.zzekf = true;
            }
            this.zzacb();
        }
        this.zzbd(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void onDetachedFromWindow() {
        zzbgh zzbgh2 = this;
        synchronized (zzbgh2) {
            if (!this.isDestroyed()) {
                this.zzekr.onDetachedFromWindow();
            }
            super.onDetachedFromWindow();
            if (this.zzekf && this.zzeln != null && this.zzeln.zzaaq() && this.getViewTreeObserver() != null && this.getViewTreeObserver().isAlive()) {
                this.zzeln.zzaas();
                this.zzeln.zzaat();
                this.zzekf = false;
            }
        }
        this.zzbd(false);
    }

    @Override
    public final void zzbt(Context context) {
        this.zzejk.setBaseContext(context);
        this.zzekr.zzh(this.zzejk.zzzh());
    }

    @Override
    public final synchronized void zzal(boolean bl) {
        if (this.zzeju != null) {
            this.zzeju.zza(this.zzeln.zzaap(), bl);
            return;
        }
        this.zzdkv = bl;
    }

    @Override
    public final void zzabp() {
    }

    @Override
    public final synchronized void setRequestedOrientation(int n) {
        this.zzeka = n;
        if (this.zzeju != null) {
            this.zzeju.setRequestedOrientation(this.zzeka);
        }
    }

    @Override
    public final Activity zzzh() {
        return this.zzejk.zzzh();
    }

    @Override
    public final Context zzabe() {
        return this.zzejk.zzabe();
    }

    private final synchronized void zzace() {
        if (this.zzejy || this.zzejw.zzaco()) {
            zzawr.zzed((String)"Enabling hardware acceleration on an overlay.");
            this.zzacg();
            return;
        }
        if (Build.VERSION.SDK_INT < 18) {
            zzawr.zzed((String)"Disabling hardware acceleration on an AdView.");
            this.zzacf();
            return;
        }
        zzawr.zzed((String)"Enabling hardware acceleration on an AdView.");
        this.zzacg();
    }

    private final synchronized void zzacf() {
        if (!this.zzejz) {
            zzq.zzky();
            this.setLayerType(1, null);
        }
        this.zzejz = true;
    }

    private final synchronized void zzacg() {
        if (this.zzejz) {
            zzq.zzky();
            this.setLayerType(0, null);
        }
        this.zzejz = false;
    }

    @Override
    protected final synchronized void zzbe(boolean bl) {
        if (!bl) {
            this.zzaci();
            this.zzekr.zzya();
            if (this.zzeju != null) {
                this.zzeju.close();
                this.zzeju.onDestroy();
                this.zzeju = null;
            }
        }
        this.zzelo.set(null);
        this.zzeln.destroy();
        zzq.zzls();
        zzbdm.zzc(this);
        this.zzach();
    }

    @Override
    @TargetApi(value=21)
    protected final void onDraw(Canvas canvas) {
        if (Build.VERSION.SDK_INT == 21 && canvas.isHardwareAccelerated() && !this.isAttachedToWindow()) {
            return;
        }
        super.onDraw(canvas);
        if (this.zzeln != null) {
            // empty if block
        }
    }

    @Override
    public final void zzabt() {
        if (this.zzekm == null) {
            this.zzekm = zzaah.zzb(this.zzekn.zzrn());
            this.zzekn.zza("native:view_load", this.zzekm);
        }
    }

    @Override
    public final void onPause() {
        try {
            super.onPause();
            return;
        }
        catch (Exception exception) {
            zzawr.zzc((String)"Could not pause webview.", (Throwable)exception);
            return;
        }
    }

    @Override
    public final void onResume() {
        try {
            super.onResume();
            return;
        }
        catch (Exception exception) {
            zzawr.zzc((String)"Could not resume webview.", (Throwable)exception);
            return;
        }
    }

    @Override
    public final void zzabw() {
        zzawr.zzeg("Cannot add text view to inner AdWebView");
    }

    @Override
    public final void zzax(boolean bl) {
        this.zzeln.zzax(bl);
    }

    @Override
    public final void stopLoading() {
        try {
            super.stopLoading();
            return;
        }
        catch (Exception exception) {
            zzawr.zzc((String)"Could not stop loading webview.", (Throwable)exception);
            return;
        }
    }

    @Override
    public final synchronized void zzbb(boolean bl) {
        this.zzekb = bl;
    }

    @Override
    public final synchronized boolean zzabq() {
        return this.zzekb;
    }

    @Override
    public final synchronized void zzkc() {
        this.zzekc = true;
        if (this.zzejm != null) {
            this.zzejm.zzkc();
        }
    }

    @Override
    public final synchronized void zzkd() {
        this.zzekc = false;
        if (this.zzejm != null) {
            this.zzejm.zzkd();
        }
    }

    private final synchronized void zzach() {
        if (this.zzeks != null) {
            Iterator<zzbdl> iterator = this.zzeks.values().iterator();
            while (iterator.hasNext()) {
                iterator.next().release();
            }
        }
        this.zzeks = null;
    }

    @Override
    public final synchronized void zza(String string2, zzbdl zzbdl2) {
        if (this.zzeks == null) {
            this.zzeks = new HashMap<String, zzbdl>();
        }
        this.zzeks.put(string2, zzbdl2);
    }

    @Override
    public final synchronized zzbdl zzfh(String string2) {
        if (this.zzeks == null) {
            return null;
        }
        return this.zzeks.get(string2);
    }

    @Override
    public final synchronized String getRequestId() {
        return this.zzdmh;
    }

    @Override
    public final zzbbq zzze() {
        return null;
    }

    @Override
    public final zzaak zzzg() {
        return this.zzeec;
    }

    @Override
    public final zzaan zzzj() {
        return this.zzekn;
    }

    @Override
    public final void setOnClickListener(View.OnClickListener onClickListener) {
        this.zzeko = new WeakReference<View.OnClickListener>(onClickListener);
        super.setOnClickListener(onClickListener);
    }

    @Override
    public final synchronized void zza(zzacg zzacg2) {
        this.zzekg = zzacg2;
    }

    @Override
    public final synchronized zzacg zzabu() {
        return this.zzekg;
    }

    @Override
    public final synchronized void zzzn() {
        if (this.zzekh != null) {
            this.zzekh.zzrw();
        }
    }

    @Override
    public final synchronized void zza(zzacf zzacf2) {
        this.zzekh = zzacf2;
    }

    @Override
    public final synchronized void zza(zzrh zzrh2) {
        this.zzeki = zzrh2;
    }

    @Override
    public final synchronized zzrh zzabx() {
        return this.zzeki;
    }

    @Override
    public final synchronized zzbfe zzzf() {
        return this.zzekd;
    }

    @Override
    public final synchronized void zza(zzbfe zzbfe2) {
        if (this.zzekd != null) {
            zzawr.zzfa((String)"Attempt to create multiple AdWebViewVideoControllers.");
            return;
        }
        this.zzekd = zzbfe2;
    }

    @Override
    public final synchronized boolean zzabr() {
        return this.zzekj > 0;
    }

    @Override
    public final synchronized void zzbc(boolean bl) {
        this.zzekj += bl ? 1 : -1;
        if (this.zzekj <= 0 && this.zzeju != null) {
            this.zzeju.zzuo();
        }
    }

    private final void zzaci() {
        if (this.zzekn == null) {
            return;
        }
        zzaam zzaam2 = this.zzekn.zzrn();
        if (zzaam2 != null && zzq.zzla().zzvv() != null) {
            zzq.zzla().zzvv().zza(zzaam2);
        }
    }

    @Override
    public final void zzabv() {
        this.setBackgroundColor(0);
    }

    @Override
    public final void zzav(boolean bl) {
        this.zzeln.zzav(bl);
    }

    @Override
    public final void zzun() {
        zzc zzc2 = this.zzabf();
        if (zzc2 != null) {
            zzc2.zzun();
        }
    }

    @Override
    public final int zzzl() {
        return this.getMeasuredHeight();
    }

    @Override
    public final int zzzm() {
        return this.getMeasuredWidth();
    }

    @Override
    public final void zza(zzd zzd2) {
        this.zzeln.zza(zzd2);
    }

    @Override
    public final void zzb(boolean bl, int n) {
        this.zzeln.zzb(bl, n);
    }

    @Override
    public final void zza(boolean bl, int n, String string2) {
        this.zzeln.zza(bl, n, string2);
    }

    @Override
    public final void zza(boolean bl, int n, String string2, String string3) {
        this.zzeln.zza(bl, n, string2, string3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zza(zzqa zzqa2) {
        zzbgh zzbgh2 = this;
        synchronized (zzbgh2) {
            this.zzeke = zzqa2.zzbot;
        }
        this.zzbd(zzqa2.zzbot);
    }

    private final void zzbd(boolean bl) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("isVisible", bl ? "1" : "0");
        HashMap<String, String> hashMap2 = hashMap;
        String string2 = "onAdVisibilityChanged";
        zzaim.zza((zzain)this, "onAdVisibilityChanged", hashMap2);
    }

    @Override
    public final void zza(String string2, zzaga<? super zzbek> zzaga2) {
        if (this.zzeln != null) {
            this.zzeln.zza(string2, zzaga2);
        }
    }

    @Override
    public final void zzb(String string2, zzaga<? super zzbek> zzaga2) {
        if (this.zzeln != null) {
            this.zzeln.zzb(string2, zzaga2);
        }
    }

    @Override
    public final void zza(String string2, Predicate<zzaga<? super zzbek>> predicate) {
        if (this.zzeln != null) {
            this.zzeln.zza(string2, predicate);
        }
    }

    @Override
    public final boolean zzc(boolean bl, int n) {
        this.destroy();
        this.zzeht.zza(new zzbgk(bl, n));
        this.zzeht.zza(zzsv.zza.zza.zzbvb);
        return true;
    }

    @Override
    public final boolean zzaby() {
        return false;
    }

    @Override
    public final void zza(ViewGroup viewGroup, Activity activity, String string2, String string3) {
        if (!this.zzaca()) {
            zzawr.zzeg("AR ad is not enabled or the ad from the server is not an AR ad.");
            return;
        }
        if (this.getParent() instanceof ViewGroup) {
            zzbgh zzbgh2 = this;
            if (zzbgh2 == null) {
                throw null;
            }
            ((ViewGroup)this.getParent()).removeView((View)zzbgh2);
        }
        zzawr.zzeg("Initializing ArWebView object.");
        zzbgh zzbgh3 = this;
        if (zzbgh3 == null) {
            throw null;
        }
        this.zzejp.zza(activity, zzbgh3);
        this.zzejp.zzc(string2, string3);
        if (viewGroup != null) {
            viewGroup.addView(this.zzejp.getView());
            return;
        }
        zzawr.zzfa((String)"The FrameLayout object cannot be null.");
    }

    @Override
    public final zzrv zzabz() {
        return this.zzejp;
    }

    @Override
    public final boolean zzaca() {
        zzzk zzzk2 = zzzz.zzcte;
        return (Boolean)zzvj.zzpv().zzd(zzzk2) != false && this.zzejp != null && this.zzejq;
    }

    @Override
    public final /* synthetic */ zzbfw zzabj() {
        return this.zzeln;
    }

    static final /* synthetic */ void zza(boolean bl, int n, zztf.zzi.zza zza2) {
        zztf.zzae.zza zza3 = zztf.zzae.zzpe();
        if (zza3.zzpd() != bl) {
            zza3.zzw(bl);
        }
        zza2.zzb((zztf.zzae)((zzecd)zza3.zzcr(n).zzbet()));
    }

    static /* synthetic */ int zza(zzbgh zzbgh2) {
        return zzbgh2.zzekk;
    }

    static /* synthetic */ int zza(zzbgh zzbgh2, int n) {
        zzbgh2.zzekk = n;
        return zzbgh2.zzekk;
    }

    @Override
    public final void zza(String string2, JSONObject jSONObject) {
        zzaim.zza((zzain)this, string2, jSONObject);
    }

    @Override
    public final void zzj(String string2, String string3) {
        zzaim.zza((zzain)this, string2, string3);
    }

    @Override
    public final void zzb(String string2, JSONObject jSONObject) {
        zzaim.zzb(this, string2, jSONObject);
    }

    public final void zza(String string2, Map map) {
        zzaim.zza((zzain)this, string2, map);
    }
}

