/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Canvas;
import android.view.MotionEvent;
import android.webkit.ValueCallback;
import android.webkit.WebViewClient;
import com.google.android.gms.ads.internal.zzq;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.ads.zzawr;
import com.google.android.gms.internal.ads.zzbab;
import com.google.android.gms.internal.ads.zzbgl;
import com.google.android.gms.internal.ads.zzbgm;
import com.google.android.gms.internal.ads.zzbgo;
import com.google.android.gms.internal.ads.zzbgq;
import com.google.android.gms.internal.ads.zzbgs;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.GuardedBy;

@ParametersAreNonnullByDefault
public class zzbgn
extends zzbgm
implements zzbgs {
    private final zzbgl zzelt;
    @GuardedBy(value="this")
    private boolean zzejx;
    @GuardedBy(value="this")
    private boolean zzekq;

    public zzbgn(Context context, zzbgl zzbgl2) {
        super(context);
        zzq.zzla().zzvy();
        this.zzelt = zzbgl2;
        super.setWebViewClient((WebViewClient)zzbgl2);
    }

    public final synchronized boolean isDestroyed() {
        return this.zzejx;
    }

    @GuardedBy(value="this")
    protected void zzbe(boolean bl) {
    }

    public synchronized void destroy() {
        if (this.zzejx) {
            return;
        }
        this.zzejx = true;
        this.zzelt.zza(this);
        this.zzbe(false);
        zzawr.zzeg("Initiating WebView self destruct sequence in 3...");
        zzawr.zzeg("Loading blank page in WebView, 2...");
        try {
            super.loadUrl("about:blank");
            return;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            zzq.zzla().zza(unsatisfiedLinkError, "AdWebViewImpl.loadUrlUnsafe");
            zzawr.zze((String)"#007 Could not call remote method.", (Throwable)unsatisfiedLinkError);
            return;
        }
    }

    @Override
    public final synchronized void zza(zzbgo zzbgo2) {
        zzawr.zzeg("Blank page loaded, 1...");
        this.zzabp();
    }

    @VisibleForTesting
    protected synchronized void zzabp() {
        zzawr.zzeg("Destroying WebView!");
        this.zzvz();
        zzbab.zzdzv.execute(new zzbgq(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            zzbgn zzbgn2 = this;
            synchronized (zzbgn2) {
                if (!this.isDestroyed()) {
                    this.zzbe(true);
                }
                this.zzvz();
            }
            return;
        }
        finally {
            super.finalize();
        }
    }

    private final synchronized void zzvz() {
        if (!this.zzekq) {
            this.zzekq = true;
            zzq.zzla().zzvz();
        }
    }

    @TargetApi(value=19)
    public synchronized void evaluateJavascript(String string2, ValueCallback<String> valueCallback) {
        if (this.isDestroyed()) {
            zzawr.zzfc((String)"#004 The webview is destroyed. Ignoring action.");
            if (valueCallback != null) {
                valueCallback.onReceiveValue(null);
            }
            return;
        }
        super.evaluateJavascript(string2, valueCallback);
    }

    @Override
    public synchronized void loadUrl(String string2) {
        if (!this.isDestroyed()) {
            super.loadUrl(string2);
            return;
        }
        zzawr.zzfc((String)"#004 The webview is destroyed. Ignoring action.");
    }

    public synchronized void loadData(String string2, String string3, String string4) {
        if (!this.isDestroyed()) {
            super.loadData(string2, string3, string4);
            return;
        }
        zzawr.zzfc((String)"#004 The webview is destroyed. Ignoring action.");
    }

    public synchronized void loadDataWithBaseURL(String string2, String string3, String string4, String string5, String string6) {
        if (!this.isDestroyed()) {
            super.loadDataWithBaseURL(string2, string3, string4, string5, string6);
            return;
        }
        zzawr.zzfc((String)"#004 The webview is destroyed. Ignoring action.");
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        return !this.isDestroyed() && super.onTouchEvent(motionEvent);
    }

    @TargetApi(value=21)
    protected void onDraw(Canvas canvas) {
        if (this.isDestroyed()) {
            return;
        }
        super.onDraw(canvas);
    }

    public void onPause() {
        if (this.isDestroyed()) {
            return;
        }
        super.onPause();
    }

    public void onResume() {
        if (this.isDestroyed()) {
            return;
        }
        super.onResume();
    }

    public void stopLoading() {
        if (this.isDestroyed()) {
            return;
        }
        super.stopLoading();
    }

    public void setWebViewClient(WebViewClient webViewClient) {
    }

    final /* synthetic */ void zzacs() {
        super.destroy();
    }
}

