/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.content.Context;
import android.graphics.Point;
import android.os.Bundle;
import android.os.RemoteException;
import android.view.MotionEvent;
import android.view.View;
import androidx.annotation.Nullable;
import com.google.android.gms.ads.internal.zzq;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.Clock;
import com.google.android.gms.internal.ads.zzaer;
import com.google.android.gms.internal.ads.zzawr;
import com.google.android.gms.internal.ads.zzaza;
import com.google.android.gms.internal.ads.zzazw;
import com.google.android.gms.internal.ads.zzazz;
import com.google.android.gms.internal.ads.zzbaf;
import com.google.android.gms.internal.ads.zzbkp;
import com.google.android.gms.internal.ads.zzbqw;
import com.google.android.gms.internal.ads.zzbro;
import com.google.android.gms.internal.ads.zzbvs;
import com.google.android.gms.internal.ads.zzbyy;
import com.google.android.gms.internal.ads.zzbyz;
import com.google.android.gms.internal.ads.zzbzx;
import com.google.android.gms.internal.ads.zzcae;
import com.google.android.gms.internal.ads.zzcaf;
import com.google.android.gms.internal.ads.zzcaw;
import com.google.android.gms.internal.ads.zzcdt;
import com.google.android.gms.internal.ads.zzdgo;
import com.google.android.gms.internal.ads.zzdhe;
import com.google.android.gms.internal.ads.zzdld;
import com.google.android.gms.internal.ads.zzdt;
import com.google.android.gms.internal.ads.zzvj;
import com.google.android.gms.internal.ads.zzws;
import com.google.android.gms.internal.ads.zzww;
import com.google.android.gms.internal.ads.zzzk;
import com.google.android.gms.internal.ads.zzzz;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import org.json.JSONException;
import org.json.JSONObject;

@ParametersAreNonnullByDefault
public final class zzbyx
implements zzcaf {
    private final Context zzvf;
    private final zzcae zzfjb;
    private final JSONObject zzfpz;
    private final zzcdt zzfqa;
    private final zzbzx zzfqb;
    private final zzdt zzejl;
    private final zzbro zzfqc;
    private final zzbqw zzfqd;
    private final zzdgo zzfkd;
    private final zzazz zzbmo;
    private final zzdhe zzfll;
    private final zzbkp zzfqe;
    private final zzcaw zzfqf;
    private final Clock zzbnt;
    private final zzbvs zzfqg;
    private final zzdld zzfgl;
    private boolean zzfqh = false;
    private boolean zzfqi;
    private boolean zzfqj = false;
    private boolean zzfqk = false;
    private Point zzfql = new Point();
    private Point zzfqm = new Point();
    private long zzfqn = 0L;
    private long zzfqo = 0L;
    private zzws zzfqp;

    public zzbyx(Context context, zzcae zzcae2, JSONObject jSONObject, zzcdt zzcdt2, zzbzx zzbzx2, zzdt zzdt2, zzbro zzbro2, zzbqw zzbqw2, zzdgo zzdgo2, zzazz zzazz2, zzdhe zzdhe2, zzbkp zzbkp2, zzcaw zzcaw2, Clock clock, zzbvs zzbvs2, zzdld zzdld2) {
        this.zzvf = context;
        this.zzfjb = zzcae2;
        this.zzfpz = jSONObject;
        this.zzfqa = zzcdt2;
        this.zzfqb = zzbzx2;
        this.zzejl = zzdt2;
        this.zzfqc = zzbro2;
        this.zzfqd = zzbqw2;
        this.zzfkd = zzdgo2;
        this.zzbmo = zzazz2;
        this.zzfll = zzdhe2;
        this.zzfqe = zzbkp2;
        this.zzfqf = zzcaw2;
        this.zzbnt = clock;
        this.zzfqg = zzbvs2;
        this.zzfgl = zzdld2;
    }

    @Override
    public final void zza(View view, @Nullable Map<String, WeakReference<View>> map, @Nullable Map<String, WeakReference<View>> map2, View.OnTouchListener onTouchListener, View.OnClickListener onClickListener) {
        View view2;
        Iterator<Map.Entry<String, WeakReference<View>>> iterator;
        this.zzfql = new Point();
        this.zzfqm = new Point();
        if (!this.zzfqi) {
            this.zzfqg.zzu(view);
            this.zzfqi = true;
        }
        view.setOnTouchListener(onTouchListener);
        view.setClickable(true);
        view.setOnClickListener(onClickListener);
        this.zzfqe.zzo(this);
        boolean bl = zzaza.zzdb(this.zzbmo.zzdzo);
        if (map != null) {
            iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                view2 = (View)iterator.next().getValue().get();
                if (view2 == null) continue;
                if (bl) {
                    view2.setOnTouchListener(onTouchListener);
                }
                view2.setClickable(true);
                view2.setOnClickListener(onClickListener);
            }
        }
        if (map2 != null) {
            iterator = map2.entrySet().iterator();
            while (iterator.hasNext()) {
                view2 = (View)iterator.next().getValue().get();
                if (view2 == null) continue;
                if (bl) {
                    view2.setOnTouchListener(onTouchListener);
                }
                view2.setClickable(false);
            }
        }
    }

    @Override
    public final void zza(View view, @Nullable Map<String, WeakReference<View>> map) {
        this.zzfql = new Point();
        this.zzfqm = new Point();
        this.zzfqg.zzv(view);
        this.zzfqi = false;
    }

    private final boolean zzfw(String string2) {
        JSONObject jSONObject = this.zzfpz.optJSONObject("allow_pub_event_reporting");
        return jSONObject != null && jSONObject.optBoolean(string2, false);
    }

    @Override
    public final void zza(View view, @Nullable View view2, @Nullable Map<String, WeakReference<View>> map, @Nullable Map<String, WeakReference<View>> map2, boolean bl) {
        JSONObject jSONObject = zzaza.zza(this.zzvf, map, map2, view2);
        JSONObject jSONObject2 = zzaza.zza(this.zzvf, view2);
        JSONObject jSONObject3 = zzaza.zzs(view2);
        JSONObject jSONObject4 = zzaza.zzb(this.zzvf, view2);
        String string2 = this.zzb(view, map);
        JSONObject jSONObject5 = zzaza.zza(string2, this.zzvf, this.zzfqm, this.zzfql);
        this.zza(view, jSONObject2, jSONObject, jSONObject3, jSONObject4, string2, jSONObject5, null, bl, false);
    }

    @Nullable
    private final String zzb(@Nullable View view, @Nullable Map<String, WeakReference<View>> map) {
        if (map != null && view != null) {
            for (Map.Entry<String, WeakReference<View>> entry : map.entrySet()) {
                View view2 = (View)entry.getValue().get();
                if (!view.equals(view2)) continue;
                return entry.getKey();
            }
        }
        switch (this.zzfqb.zzakw()) {
            case 2: {
                return "2099";
            }
            case 1: {
                return "1099";
            }
            case 3: {
                return null;
            }
            case 6: {
                return "3099";
            }
        }
        return null;
    }

    @Override
    public final void zzfx(String string2) {
        this.zza(null, null, null, null, null, string2, null, null, false, false);
    }

    @Override
    public final void zzg(@Nullable Bundle bundle) {
        if (bundle == null) {
            zzawr.zzed((String)"Click data is null. No click is reported.");
            return;
        }
        if (!this.zzfw("click_reporting")) {
            zzawr.zzfa((String)"The ad slot cannot handle external click events. You must be whitelisted to be able to report your click events.");
            return;
        }
        Bundle bundle2 = bundle.getBundle("click_signal");
        String string2 = bundle2 != null ? bundle2.getString("asset_id") : null;
        JSONObject jSONObject = zzq.zzkw().zza(bundle, null);
        this.zza(null, null, null, null, null, string2, null, jSONObject, false, false);
    }

    @Override
    public final void zza(@Nullable View view, @Nullable Map<String, WeakReference<View>> map, @Nullable Map<String, WeakReference<View>> map2, boolean bl) {
        if (!this.zzfqk) {
            zzawr.zzed((String)"Custom click reporting failed. enableCustomClickGesture is not set.");
            return;
        }
        if (!this.zzakk()) {
            zzawr.zzed((String)"Custom click reporting failed. Ad unit id not whitelisted.");
            return;
        }
        JSONObject jSONObject = zzaza.zza(this.zzvf, map, map2, view);
        JSONObject jSONObject2 = zzaza.zza(this.zzvf, view);
        JSONObject jSONObject3 = zzaza.zzs(view);
        JSONObject jSONObject4 = zzaza.zzb(this.zzvf, view);
        String string2 = this.zzb(null, map);
        JSONObject jSONObject5 = zzaza.zza(string2, this.zzvf, this.zzfqm, this.zzfql);
        this.zza(view, jSONObject2, jSONObject, jSONObject3, jSONObject4, string2, jSONObject5, null, bl, true);
    }

    private final boolean zzakk() {
        return this.zzfpz.optBoolean("allow_custom_click_gesture", false);
    }

    @Override
    public final void zzsk() {
        this.zzfqk = true;
    }

    @Override
    public final boolean isCustomClickGestureEnabled() {
        return this.zzakk();
    }

    private final void zza(@Nullable View view, @Nullable JSONObject jSONObject, @Nullable JSONObject jSONObject2, @Nullable JSONObject jSONObject3, @Nullable JSONObject jSONObject4, @Nullable String string2, @Nullable JSONObject jSONObject5, @Nullable JSONObject jSONObject6, boolean bl, boolean bl2) {
        Preconditions.checkMainThread((String)"performClick must be called on the main UI thread.");
        try {
            JSONObject jSONObject7 = new JSONObject();
            jSONObject7.put("ad", (Object)this.zzfpz);
            jSONObject7.put("asset_view_signal", (Object)jSONObject2);
            jSONObject7.put("ad_view_signal", (Object)jSONObject);
            jSONObject7.put("click_signal", (Object)jSONObject5);
            jSONObject7.put("scroll_view_signal", (Object)jSONObject3);
            jSONObject7.put("lock_screen_signal", (Object)jSONObject4);
            jSONObject7.put("has_custom_click_handler", this.zzfjb.zzgc(this.zzfqb.getCustomTemplateId()) != null);
            jSONObject7.put("provided_signals", (Object)jSONObject6);
            JSONObject jSONObject8 = new JSONObject();
            jSONObject8.put("asset_id", (Object)string2);
            jSONObject8.put("template", this.zzfqb.zzakw());
            jSONObject8.put("view_aware_api_used", bl);
            zzbyx zzbyx2 = this;
            jSONObject8.put("custom_mute_requested", zzbyx2.zzfll.zzdhc != null && zzbyx2.zzfll.zzdhc.zzblc);
            zzbyx2 = this;
            jSONObject8.put("custom_mute_enabled", !zzbyx2.zzfqb.getMuteThisAdReasons().isEmpty() && zzbyx2.zzfqb.zzakz() != null);
            JSONObject jSONObject9 = jSONObject8;
            zzbyx2 = this;
            if (zzbyx2.zzfqf.zzamf() != null && zzbyx2.zzfpz.optBoolean("custom_one_point_five_click_enabled", false)) {
                jSONObject9.put("custom_one_point_five_click_eligible", true);
            }
            jSONObject9.put("timestamp", zzbyx2.zzbnt.currentTimeMillis());
            boolean bl3 = bl2;
            jSONObject9 = jSONObject8;
            zzbyx2 = this;
            if (zzbyx2.zzfqk && zzbyx2.zzakk()) {
                jSONObject9.put("custom_click_gesture_eligible", true);
            }
            if (bl3) {
                jSONObject9.put("is_custom_click_gesture", true);
            }
            jSONObject8.put("has_custom_click_handler", this.zzfjb.zzgc(this.zzfqb.getCustomTemplateId()) != null);
            jSONObject8.put("click_signals", (Object)this.zzw(view));
            jSONObject7.put("click", (Object)jSONObject8);
            JSONObject jSONObject10 = new JSONObject();
            long l = this.zzbnt.currentTimeMillis();
            jSONObject10.put("time_from_last_touch_down", l - this.zzfqn);
            jSONObject10.put("time_from_last_touch", l - this.zzfqo);
            jSONObject7.put("touch_signal", (Object)jSONObject10);
            zzbaf.zza(this.zzfqa.zzc("google.afma.nativeAds.handleClick", jSONObject7), "Error during performing handleClick");
            return;
        }
        catch (JSONException jSONException) {
            zzawr.zzc((String)"Unable to create click JSON.", (Throwable)jSONException);
            return;
        }
    }

    @Override
    public final void zza(@Nullable View view, MotionEvent motionEvent, @Nullable View view2) {
        long l;
        this.zzfql = zzaza.zza(motionEvent, view2);
        this.zzfqo = l = this.zzbnt.currentTimeMillis();
        if (motionEvent.getAction() == 0) {
            this.zzfqn = l;
            this.zzfqm = this.zzfql;
        }
        MotionEvent motionEvent2 = MotionEvent.obtain((MotionEvent)motionEvent);
        motionEvent2.setLocation((float)this.zzfql.x, (float)this.zzfql.y);
        this.zzejl.zza(motionEvent2);
        motionEvent2.recycle();
    }

    @Override
    public final void zzh(@Nullable Bundle bundle) {
        if (bundle == null) {
            zzawr.zzed((String)"Touch event data is null. No touch event is reported.");
            return;
        }
        if (!this.zzfw("touch_reporting")) {
            zzawr.zzfa((String)"The ad slot cannot handle external touch events. You must be whitelisted to be able to report your touch events.");
            return;
        }
        int n = (int)bundle.getFloat("x");
        int n2 = (int)bundle.getFloat("y");
        int n3 = bundle.getInt("duration_ms");
        this.zzejl.zzcb().zza(n, n2, n3);
    }

    @Override
    public final void zzakl() {
        this.zza(null, null, null, null, null, null);
    }

    @Override
    public final void setClickConfirmingView(View view) {
        if (!this.zzfpz.optBoolean("custom_one_point_five_click_enabled", false)) {
            zzawr.zzfc((String)"setClickConfirmingView: Your account need to be whitelisted to use this feature.\nContact your account manager for more information.");
            return;
        }
        View view2 = view;
        zzcaw zzcaw2 = this.zzfqf;
        if (view2 != null) {
            view2.setOnClickListener((View.OnClickListener)zzcaw2);
            view2.setClickable(true);
            zzcaw2.zzftz = new WeakReference<View>(view2);
        }
    }

    @Override
    public final void zza(zzaer zzaer2) {
        if (!this.zzfpz.optBoolean("custom_one_point_five_click_enabled", false)) {
            zzawr.zzfc((String)"setUnconfirmedClickListener: Your account need to be whitelisted to use this feature.\nContact your account manager for more information.");
            return;
        }
        this.zzfqf.zza(zzaer2);
    }

    @Override
    public final void cancelUnconfirmedClick() {
        if (!this.zzfpz.optBoolean("custom_one_point_five_click_enabled", false)) {
            return;
        }
        this.zzfqf.cancelUnconfirmedClick();
    }

    @Override
    public final void zza(@Nullable zzww zzww2) {
        try {
            if (this.zzfqj) {
                return;
            }
            if (zzww2 == null && this.zzfqb.zzakz() != null) {
                this.zzfqj = true;
                this.zzfgl.zzeq(this.zzfqb.zzakz().zzqe());
                this.zzakm();
                return;
            }
            this.zzfqj = true;
            this.zzfgl.zzeq(zzww2.zzqe());
            this.zzakm();
            return;
        }
        catch (RemoteException remoteException) {
            zzawr.zze((String)"#007 Could not call remote method.", (Throwable)remoteException);
            return;
        }
    }

    @Override
    public final void zza(zzws zzws2) {
        this.zzfqp = zzws2;
    }

    @Override
    public final void zzakm() {
        try {
            if (this.zzfqp != null) {
                this.zzfqp.onAdMuted();
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzawr.zze((String)"#007 Could not call remote method.", (Throwable)remoteException);
            return;
        }
    }

    @Override
    public final void zza(@Nullable View view, @Nullable Map<String, WeakReference<View>> map, @Nullable Map<String, WeakReference<View>> map2) {
        JSONObject jSONObject = zzaza.zza(this.zzvf, map, map2, view);
        JSONObject jSONObject2 = zzaza.zza(this.zzvf, view);
        JSONObject jSONObject3 = zzaza.zzs(view);
        JSONObject jSONObject4 = zzaza.zzb(this.zzvf, view);
        String string2 = this.zzx(view);
        this.zza(jSONObject2, jSONObject, jSONObject3, jSONObject4, string2, null);
    }

    @Override
    public final void zzakn() {
        Preconditions.checkMainThread((String)"recordDownloadedImpression must be called on the main UI thread.");
        try {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("ad", (Object)this.zzfpz);
            zzbaf.zza(this.zzfqa.zzc("google.afma.nativeAds.handleDownloadedImpression", jSONObject), "Error during performing handleDownloadedImpression");
            return;
        }
        catch (JSONException jSONException) {
            zzazw.zzc((String)"", (Throwable)jSONException);
            return;
        }
    }

    @Override
    public final boolean zzi(Bundle bundle) {
        if (!this.zzfw("impression_reporting")) {
            zzawr.zzfa((String)"The ad slot cannot handle external impression events. You must be whitelisted to whitelisted to be able to report your impression events.");
            return false;
        }
        JSONObject jSONObject = zzq.zzkw().zza(bundle, null);
        return this.zza(null, null, null, null, null, jSONObject);
    }

    private final boolean zza(@Nullable JSONObject jSONObject, @Nullable JSONObject jSONObject2, @Nullable JSONObject jSONObject3, @Nullable JSONObject jSONObject4, @Nullable String string2, @Nullable JSONObject jSONObject5) {
        Preconditions.checkMainThread((String)"recordImpression must be called on the main UI thread.");
        try {
            JSONObject jSONObject6 = new JSONObject();
            jSONObject6.put("ad", (Object)this.zzfpz);
            jSONObject6.put("asset_view_signal", (Object)jSONObject2);
            jSONObject6.put("ad_view_signal", (Object)jSONObject);
            jSONObject6.put("scroll_view_signal", (Object)jSONObject3);
            jSONObject6.put("lock_screen_signal", (Object)jSONObject4);
            jSONObject6.put("provided_signals", (Object)jSONObject5);
            zzzk zzzk2 = zzzz.zzcol;
            if (((Boolean)zzvj.zzpv().zzd(zzzk2)).booleanValue()) {
                jSONObject6.put("view_signals", (Object)string2);
            }
            this.zzfqa.zza("/logScionEvent", new zzbyz(this, null));
            this.zzfqa.zza("/nativeImpression", new zzbyy(this, null));
            zzbaf.zza(this.zzfqa.zzc("google.afma.nativeAds.handleImpression", jSONObject6), "Error during performing handleImpression");
        }
        catch (JSONException jSONException) {
            zzawr.zzc((String)"Unable to create impression JSON.", (Throwable)jSONException);
            return false;
        }
        if (!this.zzfqh && this.zzfkd.zzgtw != null) {
            this.zzfqh |= zzq.zzlg().zzb(this.zzvf, this.zzbmo.zzbnd, this.zzfkd.zzgtw.toString(), this.zzfll.zzgux);
        }
        return true;
    }

    private final String zzw(View view) {
        try {
            JSONObject jSONObject = this.zzfpz.optJSONObject("tracking_urls_and_actions");
            if (jSONObject == null) {
                jSONObject = new JSONObject();
            }
            String string2 = jSONObject.optString("click_string");
            return this.zzejl.zzcb().zza(this.zzvf, string2, view);
        }
        catch (Exception exception) {
            zzawr.zzc((String)"Exception obtaining click signals", (Throwable)exception);
            return null;
        }
    }

    private final String zzx(View view) {
        zzzk zzzk2 = zzzz.zzcol;
        if (!((Boolean)zzvj.zzpv().zzd(zzzk2)).booleanValue()) {
            return null;
        }
        try {
            return this.zzejl.zzcb().zza(this.zzvf, view, null);
        }
        catch (Exception exception) {
            zzawr.zzfa((String)"Exception getting data.");
            return null;
        }
    }

    @Override
    public final void destroy() {
        this.zzfqa.destroy();
    }

    static /* synthetic */ zzbro zza(zzbyx zzbyx2) {
        return zzbyx2.zzfqc;
    }

    static /* synthetic */ zzbqw zzb(zzbyx zzbyx2) {
        return zzbyx2.zzfqd;
    }
}

