/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.content.Context;
import android.graphics.Color;
import android.net.Uri;
import android.text.TextUtils;
import androidx.annotation.Nullable;
import com.google.android.gms.ads.internal.zza;
import com.google.android.gms.ads.internal.zzq;
import com.google.android.gms.internal.ads.zzacd;
import com.google.android.gms.internal.ads.zzace;
import com.google.android.gms.internal.ads.zzaci;
import com.google.android.gms.internal.ads.zzawr;
import com.google.android.gms.internal.ads.zzayu;
import com.google.android.gms.internal.ads.zzazz;
import com.google.android.gms.internal.ads.zzbab;
import com.google.android.gms.internal.ads.zzbak;
import com.google.android.gms.internal.ads.zzbek;
import com.google.android.gms.internal.ads.zzbes;
import com.google.android.gms.internal.ads.zzbfz;
import com.google.android.gms.internal.ads.zzcbv;
import com.google.android.gms.internal.ads.zzccc;
import com.google.android.gms.internal.ads.zzccd;
import com.google.android.gms.internal.ads.zzccf;
import com.google.android.gms.internal.ads.zzccg;
import com.google.android.gms.internal.ads.zzcch;
import com.google.android.gms.internal.ads.zzcci;
import com.google.android.gms.internal.ads.zzccj;
import com.google.android.gms.internal.ads.zzccr;
import com.google.android.gms.internal.ads.zzdhe;
import com.google.android.gms.internal.ads.zzdqw;
import com.google.android.gms.internal.ads.zzdri;
import com.google.android.gms.internal.ads.zzdt;
import com.google.android.gms.internal.ads.zzst;
import com.google.android.gms.internal.ads.zzvj;
import com.google.android.gms.internal.ads.zzye;
import com.google.android.gms.internal.ads.zzzk;
import com.google.android.gms.internal.ads.zzzz;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class zzcca {
    private final Context zzvf;
    private final zzcbv zzfve;
    private final zzdt zzejl;
    private final zzazz zzbmo;
    private final zza zzfvf;
    private final zzst zzeht;
    private final Executor executor;
    private final zzaci zzdhc;
    private final zzccr zzfvg;
    private final ScheduledExecutorService zzfky;

    public zzcca(Context context, zzcbv zzcbv2, zzdt zzdt2, zzazz zzazz2, zza zza2, zzst zzst2, Executor executor, zzdhe zzdhe2, zzccr zzccr2, ScheduledExecutorService scheduledExecutorService) {
        this.zzvf = context;
        this.zzfve = zzcbv2;
        this.zzejl = zzdt2;
        this.zzbmo = zzazz2;
        this.zzfvf = zza2;
        this.zzeht = zzst2;
        this.executor = executor;
        this.zzdhc = zzdhe2.zzdhc;
        this.zzfvg = zzccr2;
        this.zzfky = scheduledExecutorService;
    }

    public static List<zzye> zzj(JSONObject jSONObject) {
        JSONObject jSONObject2 = jSONObject.optJSONObject("mute");
        if (jSONObject2 == null) {
            return Collections.emptyList();
        }
        JSONArray jSONArray = jSONObject2.optJSONArray("reasons");
        if (jSONArray == null || jSONArray.length() <= 0) {
            return Collections.emptyList();
        }
        ArrayList<zzye> arrayList = new ArrayList<zzye>();
        for (int i = 0; i < jSONArray.length(); ++i) {
            zzye zzye2 = zzcca.zzl(jSONArray.optJSONObject(i));
            if (zzye2 == null) continue;
            arrayList.add(zzye2);
        }
        return arrayList;
    }

    @Nullable
    public static zzye zzk(JSONObject jSONObject) {
        JSONObject jSONObject2 = jSONObject.optJSONObject("mute");
        if (jSONObject2 == null) {
            return null;
        }
        JSONObject jSONObject3 = jSONObject2.optJSONObject("default_reason");
        if (jSONObject3 == null) {
            return null;
        }
        return zzcca.zzl(jSONObject3);
    }

    @Nullable
    private static zzye zzl(@Nullable JSONObject jSONObject) {
        if (jSONObject == null) {
            return null;
        }
        String string2 = jSONObject.optString("reason");
        String string3 = jSONObject.optString("ping_url");
        if (TextUtils.isEmpty((CharSequence)string2) || TextUtils.isEmpty((CharSequence)string3)) {
            return null;
        }
        return new zzye(string2, string3);
    }

    public final zzdri<zzace> zzc(JSONObject jSONObject, String string2) {
        return this.zza(jSONObject.optJSONObject(string2), this.zzdhc.zzcyt);
    }

    public final zzdri<List<zzace>> zzd(JSONObject jSONObject, String string2) {
        return this.zza(jSONObject.optJSONArray(string2), this.zzdhc.zzcyt, this.zzdhc.zzbkz);
    }

    private final zzdri<List<zzace>> zza(@Nullable JSONArray jSONArray, boolean bl, boolean bl2) {
        if (jSONArray == null || jSONArray.length() <= 0) {
            return zzdqw.zzag(Collections.emptyList());
        }
        ArrayList<zzdri<zzace>> arrayList = new ArrayList<zzdri<zzace>>();
        int n = bl2 ? jSONArray.length() : 1;
        for (int i = 0; i < n; ++i) {
            arrayList.add(this.zza(jSONArray.optJSONObject(i), bl));
        }
        return zzdqw.zzb(zzdqw.zzi(arrayList), zzccd.zzdsc, this.executor);
    }

    private final zzdri<zzace> zza(@Nullable JSONObject jSONObject, boolean bl) {
        if (jSONObject == null) {
            return zzdqw.zzag(null);
        }
        String string2 = jSONObject.optString("url");
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return zzdqw.zzag(null);
        }
        double d = jSONObject.optDouble("scale", 1.0);
        boolean bl2 = jSONObject.optBoolean("is_transparent", true);
        int n = jSONObject.optInt("width", -1);
        int n2 = jSONObject.optInt("height", -1);
        if (bl) {
            return zzdqw.zzag(new zzace(null, Uri.parse((String)string2), d, n, n2));
        }
        zzdri zzdri2 = zzdqw.zzb(this.zzfve.zza(string2, d, bl2), new zzccc(string2, d, n, n2), this.executor);
        return zzcca.zza(jSONObject.optBoolean("require"), zzdri2, null);
    }

    public final zzdri<zzacd> zze(JSONObject jSONObject, String string2) {
        JSONObject jSONObject2 = jSONObject.optJSONObject(string2);
        if (jSONObject2 == null) {
            return zzdqw.zzag(null);
        }
        JSONArray jSONArray = jSONObject2.optJSONArray("images");
        JSONObject jSONObject3 = jSONObject2.optJSONObject("image");
        if (jSONArray == null && jSONObject3 != null) {
            jSONArray = new JSONArray();
            jSONArray.put((Object)jSONObject3);
        }
        zzdri zzdri2 = zzdqw.zzb(this.zza(jSONArray, false, true), new zzccf(this, jSONObject2), this.executor);
        return zzcca.zza(jSONObject2.optBoolean("require"), zzdri2, null);
    }

    private static Integer zzf(JSONObject jSONObject, String string2) {
        try {
            JSONObject jSONObject2 = jSONObject.getJSONObject(string2);
            return Color.rgb((int)jSONObject2.getInt("r"), (int)jSONObject2.getInt("g"), (int)jSONObject2.getInt("b"));
        }
        catch (JSONException jSONException) {
            return null;
        }
    }

    public final zzdri<zzbek> zzm(JSONObject jSONObject) {
        JSONObject jSONObject2 = zzayu.zza(jSONObject, "html_containers", "instream");
        if (jSONObject2 == null) {
            JSONObject jSONObject3 = jSONObject;
            zzcca zzcca2 = this;
            JSONObject jSONObject4 = jSONObject3.optJSONObject("video");
            if (jSONObject4 == null) {
                return zzdqw.zzag(null);
            }
            if (TextUtils.isEmpty((CharSequence)jSONObject4.optString("vast_xml"))) {
                zzawr.zzfc((String)"Required field 'vast_xml' is missing");
                return zzdqw.zzag(null);
            }
            zzzk zzzk2 = zzzz.zzcot;
            return zzcca.zza(zzdqw.zza(zzcca2.zzfvg.zzn(jSONObject4), ((Integer)zzvj.zzpv().zzd(zzzk2)).intValue(), TimeUnit.SECONDS, zzcca2.zzfky), null);
        }
        JSONObject jSONObject5 = jSONObject2;
        zzdri<zzbek> zzdri2 = this.zzfvg.zzo(jSONObject5.optString("base_url"), jSONObject5.optString("html"));
        return zzdqw.zzb(zzdri2, new zzcch(zzdri2), (Executor)zzbab.zzdzw);
    }

    private static <T> zzdri<T> zza(zzdri<T> zzdri2, T t) {
        return zzdqw.zzb(zzdri2, Exception.class, new zzccg(null), zzbab.zzdzw);
    }

    private static <T> zzdri<T> zza(boolean bl, zzdri<T> zzdri2, T t) {
        if (bl) {
            zzdri<T> zzdri3 = zzdri2;
            return zzdqw.zzb(zzdri3, new zzccj(zzdri3), (Executor)zzbab.zzdzw);
        }
        return zzcca.zza(zzdri2, null);
    }

    final /* synthetic */ zzdri zzb(String string2, Object object) throws Exception {
        zzq.zzkx();
        zzbek zzbek2 = zzbes.zza(this.zzvf, zzbfz.zzacl(), "native-omid", false, false, this.zzejl, this.zzbmo, null, null, this.zzfvf, this.zzeht, null, false);
        zzbak<zzbek> zzbak2 = zzbak.zzl(zzbek2);
        zzbek2.zzabj().zza(new zzcci(zzbak2));
        zzbek2.loadData(string2, "text/html", "UTF-8");
        return zzbak2;
    }

    final /* synthetic */ zzacd zza(JSONObject jSONObject, List list) {
        List list2 = list;
        JSONObject jSONObject2 = jSONObject;
        zzcca zzcca2 = this;
        if (list2 == null || list2.isEmpty()) {
            return null;
        }
        String string2 = jSONObject2.optString("text");
        Integer n = zzcca.zzf(jSONObject2, "bg_color");
        Integer n2 = zzcca.zzf(jSONObject2, "text_color");
        int n3 = jSONObject2.optInt("text_size", -1);
        boolean bl = jSONObject2.optBoolean("allow_pub_rendering");
        int n4 = jSONObject2.optInt("animation_ms", 1000);
        int n5 = jSONObject2.optInt("presentation_ms", 4000);
        return new zzacd(string2, list2, n, n2, n3 > 0 ? Integer.valueOf(n3) : null, n5 + n4, zzcca2.zzdhc.zzbla, bl);
    }
}

