/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.FrameLayout;
import android.widget.PopupWindow;
import androidx.annotation.Nullable;
import com.google.android.gms.common.util.PlatformVersion;
import com.google.android.gms.internal.ads.zzawr;

@TargetApi(value=19)
public final class zzcfo {
    @Nullable
    private Context zzvf;
    @Nullable
    private PopupWindow zzfxm;

    public final void zzc(Context context, View view) {
        if (!PlatformVersion.isAtLeastKitKat() || PlatformVersion.isAtLeastLollipop()) {
            return;
        }
        this.zzfxm = zzcfo.zzd(context, view);
        this.zzvf = this.zzfxm != null ? context : null;
    }

    public final void zzamy() {
        if (this.zzvf == null || this.zzfxm == null) {
            return;
        }
        if (this.zzvf instanceof Activity && ((Activity)this.zzvf).isDestroyed()) {
            this.zzvf = null;
            this.zzfxm = null;
            return;
        }
        if (this.zzfxm.isShowing()) {
            this.zzfxm.dismiss();
        }
        this.zzvf = null;
        this.zzfxm = null;
    }

    private static PopupWindow zzd(Context context, View view) {
        Window window = null;
        if (context instanceof Activity) {
            window = ((Activity)context).getWindow();
        }
        if (window == null || window.getDecorView() == null) {
            return null;
        }
        if (((Activity)context).isDestroyed()) {
            return null;
        }
        FrameLayout frameLayout = new FrameLayout(context);
        frameLayout.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
        frameLayout.addView(view, -1, -1);
        PopupWindow popupWindow = new PopupWindow((View)frameLayout, 1, 1, false);
        popupWindow.setOutsideTouchable(true);
        popupWindow.setClippingEnabled(false);
        zzawr.zzed((String)"Displaying the 1x1 popup off the screen.");
        try {
            popupWindow.showAtLocation(window.getDecorView(), 0, -1, -1);
            return popupWindow;
        }
        catch (Exception exception) {
            return null;
        }
    }
}

