/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.content.Context;
import android.graphics.Point;
import android.net.Uri;
import android.os.RemoteException;
import android.text.TextUtils;
import android.view.MotionEvent;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.ObjectWrapper;
import com.google.android.gms.internal.ads.zzapx;
import com.google.android.gms.internal.ads.zzaqh;
import com.google.android.gms.internal.ads.zzavm;
import com.google.android.gms.internal.ads.zzavq;
import com.google.android.gms.internal.ads.zzavt;
import com.google.android.gms.internal.ads.zzawr;
import com.google.android.gms.internal.ads.zzaza;
import com.google.android.gms.internal.ads.zzazw;
import com.google.android.gms.internal.ads.zzazz;
import com.google.android.gms.internal.ads.zzbgy;
import com.google.android.gms.internal.ads.zzbqj;
import com.google.android.gms.internal.ads.zzbuj;
import com.google.android.gms.internal.ads.zzcdt;
import com.google.android.gms.internal.ads.zzcug;
import com.google.android.gms.internal.ads.zzcui;
import com.google.android.gms.internal.ads.zzcuj;
import com.google.android.gms.internal.ads.zzcuk;
import com.google.android.gms.internal.ads.zzcul;
import com.google.android.gms.internal.ads.zzcum;
import com.google.android.gms.internal.ads.zzcun;
import com.google.android.gms.internal.ads.zzcuo;
import com.google.android.gms.internal.ads.zzcup;
import com.google.android.gms.internal.ads.zzcuq;
import com.google.android.gms.internal.ads.zzcur;
import com.google.android.gms.internal.ads.zzcus;
import com.google.android.gms.internal.ads.zzcut;
import com.google.android.gms.internal.ads.zzcuu;
import com.google.android.gms.internal.ads.zzdhg;
import com.google.android.gms.internal.ads.zzdhp;
import com.google.android.gms.internal.ads.zzdqr;
import com.google.android.gms.internal.ads.zzdqw;
import com.google.android.gms.internal.ads.zzdrh;
import com.google.android.gms.internal.ads.zzdri;
import com.google.android.gms.internal.ads.zzdt;
import com.google.android.gms.internal.ads.zzdw;
import com.google.android.gms.internal.ads.zzui;
import com.google.android.gms.internal.ads.zzuj;
import com.google.android.gms.internal.ads.zzum;
import com.google.android.gms.internal.ads.zzvj;
import com.google.android.gms.internal.ads.zzzk;
import com.google.android.gms.internal.ads.zzzz;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.json.JSONObject;

public final class zzcuh
extends zzavq {
    private static final List<String> zzgkq = new ArrayList<String>(Arrays.asList("/aclk", "/pcs/click"));
    private static final List<String> zzgkr = new ArrayList<String>(Arrays.asList(".doubleclick.net", ".googleadservices.com"));
    private static final List<String> zzgks = new ArrayList<String>(Arrays.asList("/pagead/adview", "/pcs/view", "/pagead/conversion"));
    private static final List<String> zzgkt = new ArrayList<String>(Arrays.asList(".doubleclick.net", ".googleadservices.com", ".googlesyndication.com"));
    private zzbgy zzgku;
    private Context zzvf;
    private zzdt zzfgm;
    private zzazz zzbml;
    private zzdhp<zzcdt> zzgga;
    private final zzdrh zzfur;
    private final ScheduledExecutorService zzfky;
    @Nullable
    private zzaqh zzgkv;
    private Point zzfql = new Point();
    private Point zzfqm = new Point();

    public zzcuh(zzbgy zzbgy2, Context context, zzdt zzdt2, zzazz zzazz2, zzdhp<zzcdt> zzdhp2, zzdrh zzdrh2, ScheduledExecutorService scheduledExecutorService) {
        this.zzgku = zzbgy2;
        this.zzvf = context;
        this.zzfgm = zzdt2;
        this.zzbml = zzazz2;
        this.zzgga = zzdhp2;
        this.zzfur = zzdrh2;
        this.zzfky = scheduledExecutorService;
    }

    public final void zza(IObjectWrapper iObjectWrapper, zzavt zzavt2, zzavm zzavm2) {
        this.zzvf = (Context)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper);
        zzuj zzuj2 = zzavt2.zzdtg;
        zzum zzum2 = zzavt2.zzdtf;
        String string2 = zzavt2.zzbna;
        String string3 = zzavt2.zzbsc;
        Context context = this.zzvf;
        zzcuu.zza zza2 = new zzcuu.zza().zzgq(string2);
        zzdqw.zza(this.zzgku.zzadj().zzf(new zzbqj.zza().zzcb(context).zza(new zzdhg().zzgr(string3 == null ? "adUnitId" : string3).zzh(zzuj2 == null ? new zzui().zzpg() : zzuj2).zzd(zzum2 == null ? new zzum() : zzum2).zzasc()).zzair()).zza(new zzcuu(zza2, null)).zzf(new zzbuj.zza().zzajm()).zzafv().zzagb(), new zzcuq(this, zzavm2), this.zzgku.zzacv());
    }

    public final void zzan(IObjectWrapper iObjectWrapper) {
        zzzk zzzk2 = zzzz.zzcue;
        if (!((Boolean)zzvj.zzpv().zzd(zzzk2)).booleanValue()) {
            return;
        }
        MotionEvent motionEvent = (MotionEvent)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper);
        this.zzfql = zzaza.zza(motionEvent, this.zzgkv == null ? null : this.zzgkv.zzaae);
        if (motionEvent.getAction() == 0) {
            this.zzfqm = this.zzfql;
        }
        MotionEvent motionEvent2 = MotionEvent.obtain((MotionEvent)motionEvent);
        motionEvent2.setLocation((float)this.zzfql.x, (float)this.zzfql.y);
        this.zzfgm.zza(motionEvent2);
        motionEvent2.recycle();
    }

    public final IObjectWrapper zzb(IObjectWrapper iObjectWrapper, IObjectWrapper iObjectWrapper2) {
        return null;
    }

    public final IObjectWrapper zzao(IObjectWrapper iObjectWrapper) {
        return null;
    }

    public final void zza(zzaqh zzaqh2) {
        this.zzgkv = zzaqh2;
        this.zzgga.zzdw(1);
    }

    public final void zza(List<Uri> list, IObjectWrapper iObjectWrapper, zzapx zzapx2) {
        zzzk zzzk2 = zzzz.zzcue;
        if (!((Boolean)zzvj.zzpv().zzd(zzzk2)).booleanValue()) {
            try {
                zzapx2.onError("The updating URL feature is not enabled.");
                return;
            }
            catch (RemoteException remoteException) {
                zzazw.zzc((String)"", (Throwable)remoteException);
                return;
            }
        }
        zzdri<Object> zzdri2 = this.zzfur.zzd(new zzcug(this, list, iObjectWrapper));
        if (this.zzapw()) {
            zzdri2 = zzdqw.zzb(zzdri2, new zzcuj(this), (Executor)this.zzfur);
        } else {
            zzawr.zzfb((String)"Asset view map is empty.");
        }
        zzdqw.zza(zzdri2, new zzcut(this, zzapx2), this.zzgku.zzacv());
    }

    public final void zzb(List<Uri> list, IObjectWrapper iObjectWrapper, zzapx zzapx2) {
        Uri uri;
        try {
            zzzk zzzk2 = zzzz.zzcue;
            if (!((Boolean)zzvj.zzpv().zzd(zzzk2)).booleanValue()) {
                zzapx2.onError("The updating URL feature is not enabled.");
                return;
            }
            if (list.size() != 1) {
                zzapx2.onError("There should be only 1 click URL.");
                return;
            }
            uri = list.get(0);
            if (!zzcuh.zza(uri, zzgkq, zzgkr)) {
                String string2 = String.valueOf(uri);
                zzawr.zzfc((String)new StringBuilder(18 + String.valueOf(string2).length()).append("Not a Google URL: ").append(string2).toString());
                zzapx2.onSuccess(list);
                return;
            }
        }
        catch (RemoteException remoteException) {
            zzazw.zzc((String)"", (Throwable)remoteException);
            return;
        }
        zzdri<Object> zzdri2 = this.zzfur.zzd(new zzcui(this, uri, iObjectWrapper));
        if (this.zzapw()) {
            zzdri2 = zzdqw.zzb(zzdri2, new zzcul(this), (Executor)this.zzfur);
        } else {
            zzawr.zzfb((String)"Asset view map is empty.");
        }
        zzdqw.zza(zzdri2, new zzcus(this, zzapx2), this.zzgku.zzacv());
    }

    @VisibleForTesting
    private static boolean zzk(@NonNull Uri uri) {
        return zzcuh.zza(uri, zzgks, zzgkt);
    }

    private final Uri zza(Uri uri, IObjectWrapper iObjectWrapper) throws Exception {
        Uri uri2 = uri;
        try {
            uri2 = this.zzfgm.zza(uri2, this.zzvf, (View)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper), null);
        }
        catch (zzdw zzdw2) {
            zzazw.zzd((String)"", (Throwable)zzdw2);
        }
        if (uri2.getQueryParameter("ms") == null) {
            throw new Exception("Failed to append spam signals to click url.");
        }
        return uri2;
    }

    private static boolean zza(@NonNull Uri uri, List<String> list, List<String> list2) {
        String string2 = uri.getHost();
        String string3 = uri.getPath();
        if (string2 == null || string3 == null) {
            return false;
        }
        for (String string4 : list) {
            if (!string3.contains(string4)) continue;
            for (String string5 : list2) {
                if (!string2.endsWith(string5)) continue;
                return true;
            }
        }
        return false;
    }

    private final zzdri<String> zzgp(String string2) {
        String string3 = string2;
        zzcuh zzcuh2 = this;
        zzcdt[] zzcdtArray = new zzcdt[1];
        zzdri zzdri2 = zzdqw.zzb(zzcuh2.zzgga.zzasg(), new zzcuo(zzcuh2, zzcdtArray, string3), (Executor)zzcuh2.zzfur);
        zzdri2.addListener(new zzcur(zzcuh2, zzcdtArray), zzcuh2.zzfur);
        zzcuh2 = zzzz.zzcuf;
        return zzdqr.zzg(zzdri2).zza(((Integer)zzvj.zzpv().zzd((zzzk)zzcuh2)).intValue(), TimeUnit.MILLISECONDS, this.zzfky).zza(zzcum.zzdsc, this.zzfur).zza(Exception.class, zzcup.zzdsc, this.zzfur);
    }

    private static Uri zza(Uri uri, String string2, String string3) {
        String string4 = uri.toString();
        int n = string4.indexOf("&adurl=");
        if (n == -1) {
            n = string4.indexOf("?adurl=");
        }
        if (n != -1) {
            return Uri.parse((String)(string4.substring(0, n + 1) + string2 + "=" + string3 + "&" + string4.substring(n + 1)));
        }
        return uri.buildUpon().appendQueryParameter(string2, string3).build();
    }

    private final boolean zzapw() {
        return this.zzgkv != null && this.zzgkv.zzdli != null && !this.zzgkv.zzdli.isEmpty();
    }

    final /* synthetic */ void zza(zzcdt[] zzcdtArray) {
        if (zzcdtArray[0] != null) {
            this.zzgga.zzd(zzdqw.zzag(zzcdtArray[0]));
        }
    }

    final /* synthetic */ zzdri zza(zzcdt[] zzcdtArray, String string2, zzcdt zzcdt2) throws Exception {
        zzcdtArray[0] = zzcdt2;
        String string3 = string2;
        zzcuh zzcuh2 = this;
        JSONObject jSONObject = zzaza.zza(zzcuh2.zzvf, zzcuh2.zzgkv.zzdli, zzcuh2.zzgkv.zzdli, zzcuh2.zzgkv.zzaae);
        JSONObject jSONObject2 = zzaza.zza(zzcuh2.zzvf, zzcuh2.zzgkv.zzaae);
        JSONObject jSONObject3 = zzaza.zzs(zzcuh2.zzgkv.zzaae);
        JSONObject jSONObject4 = zzaza.zzb(zzcuh2.zzvf, zzcuh2.zzgkv.zzaae);
        JSONObject jSONObject5 = new JSONObject();
        jSONObject5.put("asset_view_signal", (Object)jSONObject);
        jSONObject5.put("ad_view_signal", (Object)jSONObject2);
        jSONObject5.put("scroll_view_signal", (Object)jSONObject3);
        jSONObject5.put("lock_screen_signal", (Object)jSONObject4);
        if (string3 == "google.afma.nativeAds.getPublisherCustomRenderedClickSignals") {
            JSONObject jSONObject6 = zzaza.zza(null, zzcuh2.zzvf, zzcuh2.zzfqm, zzcuh2.zzfql);
            jSONObject5.put("click_signal", (Object)jSONObject6);
        }
        return zzcdt2.zzc(string2, jSONObject5);
    }

    static final /* synthetic */ String zza(Exception exception) {
        Exception exception2 = exception;
        zzazw.zzc((String)"", (Throwable)exception2);
        return null;
    }

    static final /* synthetic */ String zzp(JSONObject jSONObject) {
        return jSONObject.optString("nas");
    }

    static /* synthetic */ Uri zzc(Uri uri, String string2) {
        Uri uri2 = uri;
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            uri2 = zzcuh.zza(uri2, "nas", string2);
        }
        return uri2;
    }

    static /* synthetic */ ArrayList zza(List list, String string2) {
        ArrayList<Uri> arrayList = new ArrayList<Uri>();
        for (Uri uri : list) {
            if (!zzcuh.zzk(uri) || TextUtils.isEmpty((CharSequence)string2)) {
                arrayList.add(uri);
                continue;
            }
            arrayList.add(zzcuh.zza(uri, "nas", string2));
        }
        return arrayList;
    }

    final /* synthetic */ zzdri zzl(Uri uri) throws Exception {
        Uri uri2 = uri;
        zzcuh zzcuh2 = this;
        return zzdqw.zzb(zzcuh2.zzgp("google.afma.nativeAds.getPublisherCustomRenderedClickSignals"), new zzcun(zzcuh2, uri2), (Executor)zzcuh2.zzfur);
    }

    final /* synthetic */ Uri zzb(Uri uri, IObjectWrapper iObjectWrapper) throws Exception {
        return this.zza(uri, iObjectWrapper);
    }

    final /* synthetic */ zzdri zzb(ArrayList arrayList) throws Exception {
        ArrayList arrayList2 = arrayList;
        zzcuh zzcuh2 = this;
        return zzdqw.zzb(zzcuh2.zzgp("google.afma.nativeAds.getPublisherCustomRenderedImpressionSignals"), new zzcuk(zzcuh2, arrayList2), (Executor)zzcuh2.zzfur);
    }

    final /* synthetic */ ArrayList zza(List list, IObjectWrapper iObjectWrapper) throws Exception {
        IObjectWrapper iObjectWrapper2 = iObjectWrapper;
        List list2 = list;
        zzcuh zzcuh2 = this;
        String string2 = "";
        if (zzcuh2.zzfgm.zzcb() != null) {
            string2 = zzcuh2.zzfgm.zzcb().zza(zzcuh2.zzvf, (View)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper2), null);
        }
        if (TextUtils.isEmpty((CharSequence)string2)) {
            throw new Exception("Failed to get view signals.");
        }
        ArrayList<Uri> arrayList = new ArrayList<Uri>();
        for (Uri uri : list2) {
            if (!zzcuh.zzk(uri)) {
                String string3 = String.valueOf(uri);
                zzawr.zzfc((String)new StringBuilder(18 + String.valueOf(string3).length()).append("Not a Google URL: ").append(string3).toString());
                arrayList.add(uri);
                continue;
            }
            arrayList.add(zzcuh.zza(uri, "ms", string2));
        }
        if (arrayList.isEmpty()) {
            throw new Exception("Empty impression URLs result.");
        }
        return arrayList;
    }

    static /* synthetic */ zzazz zza(zzcuh zzcuh2) {
        return zzcuh2.zzbml;
    }
}

