/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.content.Context;
import android.os.Bundle;
import android.os.RemoteException;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;
import androidx.annotation.Nullable;
import com.google.android.gms.ads.internal.overlay.zzp;
import com.google.android.gms.ads.internal.overlay.zzq;
import com.google.android.gms.ads.internal.overlay.zzy;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.ObjectWrapper;
import com.google.android.gms.internal.ads.zzaas;
import com.google.android.gms.internal.ads.zzapq;
import com.google.android.gms.internal.ads.zzapw;
import com.google.android.gms.internal.ads.zzasn;
import com.google.android.gms.internal.ads.zzawr;
import com.google.android.gms.internal.ads.zzaxa;
import com.google.android.gms.internal.ads.zzazz;
import com.google.android.gms.internal.ads.zzbgy;
import com.google.android.gms.internal.ads.zzblc;
import com.google.android.gms.internal.ads.zzblr;
import com.google.android.gms.internal.ads.zzbsr;
import com.google.android.gms.internal.ads.zzctw;
import com.google.android.gms.internal.ads.zzdcz;
import com.google.android.gms.internal.ads.zzddh;
import com.google.android.gms.internal.ads.zzddi;
import com.google.android.gms.internal.ads.zzddj;
import com.google.android.gms.internal.ads.zzddk;
import com.google.android.gms.internal.ads.zzddn;
import com.google.android.gms.internal.ads.zzdhh;
import com.google.android.gms.internal.ads.zzrh;
import com.google.android.gms.internal.ads.zzrn;
import com.google.android.gms.internal.ads.zzuj;
import com.google.android.gms.internal.ads.zzum;
import com.google.android.gms.internal.ads.zzut;
import com.google.android.gms.internal.ads.zzvj;
import com.google.android.gms.internal.ads.zzvl;
import com.google.android.gms.internal.ads.zzvm;
import com.google.android.gms.internal.ads.zzvy;
import com.google.android.gms.internal.ads.zzwc;
import com.google.android.gms.internal.ads.zzwh;
import com.google.android.gms.internal.ads.zzwn;
import com.google.android.gms.internal.ads.zzxf;
import com.google.android.gms.internal.ads.zzxg;
import com.google.android.gms.internal.ads.zzxl;
import com.google.android.gms.internal.ads.zzxr;
import com.google.android.gms.internal.ads.zzze;
import com.google.android.gms.internal.ads.zzzk;
import com.google.android.gms.internal.ads.zzzz;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.concurrent.GuardedBy;

public final class zzddf
extends zzvy
implements zzy,
zzbsr,
zzrh {
    private final zzbgy zzggh;
    private final Context zzgiz;
    private final ViewGroup zzfiv;
    private AtomicBoolean zzgqi = new AtomicBoolean();
    private final String zzbsc;
    private final zzdcz zzgqj;
    private final zzddn zzgqk;
    private final zzazz zzbml;
    private long zzgql;
    @Nullable
    private zzblc zzgqm;
    @GuardedBy(value="this")
    @Nullable
    protected zzblr zzgqn;

    public zzddf(zzbgy zzbgy2, Context context, String string2, zzdcz zzdcz2, zzddn zzddn2, zzazz zzazz2) {
        this.zzfiv = new FrameLayout(context);
        this.zzggh = zzbgy2;
        this.zzgiz = context;
        this.zzbsc = string2;
        this.zzgqj = zzdcz2;
        this.zzgqk = zzddn2;
        zzddn2.zza(this);
        this.zzbml = zzazz2;
    }

    public final IObjectWrapper zzke() {
        Preconditions.checkMainThread((String)"getAdFrame must be called on the main UI thread.");
        return ObjectWrapper.wrap((Object)this.zzfiv);
    }

    public final void zza(zzut zzut2) {
        this.zzgqj.zza(zzut2);
    }

    public final synchronized boolean zza(zzuj zzuj2) throws RemoteException {
        Preconditions.checkMainThread((String)"loadAd must be called on the main UI thread.");
        com.google.android.gms.ads.internal.zzq.zzkw();
        if (zzaxa.zzbd(this.zzgiz) && zzuj2.zzceu == null) {
            zzawr.zzfa((String)"Failed to load the ad because app ID is missing.");
            this.zzgqk.onAdFailedToLoad(8);
            return false;
        }
        if (this.isLoading()) {
            return false;
        }
        this.zzgqi = new AtomicBoolean();
        zzddk zzddk2 = new zzddk(this);
        return this.zzgqj.zza(zzuj2, this.zzbsc, (zzctw)zzddk2, new zzddj(this));
    }

    private final zzq zza(zzblr zzblr2) {
        boolean bl = zzblr2.zzaap();
        zzzk zzzk2 = zzzz.zzcqp;
        int n = (Integer)zzvj.zzpv().zzd(zzzk2);
        zzp zzp2 = new zzp();
        new zzp().size = 50;
        zzp2.paddingLeft = bl ? n : 0;
        zzp2.paddingRight = bl ? 0 : n;
        zzp2.paddingTop = 0;
        zzp2.paddingBottom = n;
        return new zzq(this.zzgiz, zzp2, this);
    }

    private static RelativeLayout.LayoutParams zzb(zzblr zzblr2) {
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-2, -2);
        layoutParams.addRule(10);
        int n = zzblr2.zzaap() ? 11 : 9;
        layoutParams.addRule(n);
        return layoutParams;
    }

    private final void zzc(zzblr zzblr2) {
        zzblr2.zza(this);
    }

    @Override
    public final void zzug() {
        this.zzarf();
    }

    @Override
    public final void zzms() {
        this.zzarf();
    }

    @Override
    public final void zzait() {
        if (this.zzgqn == null) {
            return;
        }
        this.zzgql = com.google.android.gms.ads.internal.zzq.zzld().elapsedRealtime();
        int n = this.zzgqn.zzagv();
        if (n <= 0) {
            return;
        }
        this.zzgqm = new zzblc(this.zzggh.zzacw(), com.google.android.gms.ads.internal.zzq.zzld());
        this.zzgqm.zza(n, new zzddh(this));
    }

    private final void zzarf() {
        if (this.zzgqi.compareAndSet(false, true)) {
            if (this.zzgqn != null && this.zzgqn.zzahg() != null) {
                this.zzgqk.zzb(this.zzgqn.zzahg());
            }
            this.zzgqk.onAdClosed();
            this.zzfiv.removeAllViews();
            if (this.zzgqm != null) {
                zzblc zzblc2 = this.zzgqm;
                com.google.android.gms.ads.internal.zzq.zzkz().zzb(zzblc2);
            }
            if (this.zzgqn != null) {
                this.zzgqn.zzfd(com.google.android.gms.ads.internal.zzq.zzld().elapsedRealtime() - this.zzgql);
            }
            this.destroy();
        }
    }

    private final zzum zzarg() {
        return zzdhh.zzb(this.zzgiz, Collections.singletonList(this.zzgqn.zzahd()));
    }

    public final synchronized void destroy() {
        Preconditions.checkMainThread((String)"destroy must be called on the main UI thread.");
        if (this.zzgqn != null) {
            this.zzgqn.destroy();
        }
    }

    public final synchronized void pause() {
        Preconditions.checkMainThread((String)"pause must be called on the main UI thread.");
    }

    public final synchronized void resume() {
        Preconditions.checkMainThread((String)"resume must be called on the main UI thread.");
    }

    public final void zza(zzrn zzrn2) {
        this.zzgqk.zzb(zzrn2);
    }

    public final synchronized zzum zzkg() {
        Preconditions.checkMainThread((String)"getAdSize must be called on the main UI thread.");
        if (this.zzgqn != null) {
            return zzdhh.zzb(this.zzgiz, Collections.singletonList(this.zzgqn.zzahd()));
        }
        return null;
    }

    public final synchronized void zza(zzum zzum2) {
        Preconditions.checkMainThread((String)"setAdSize must be called on the main UI thread.");
    }

    public final synchronized String getMediationAdapterClassName() {
        return null;
    }

    public final synchronized String zzkh() {
        return null;
    }

    public final synchronized zzxg zzki() {
        return null;
    }

    public final synchronized boolean isLoading() {
        return this.zzgqj.isLoading();
    }

    public final synchronized String getAdUnitId() {
        return this.zzbsc;
    }

    public final void zza(zzvl zzvl2) {
    }

    public final void zza(zzvm zzvm2) {
    }

    public final zzvm zzkk() {
        return null;
    }

    public final void zza(zzwh zzwh2) {
    }

    public final zzwh zzkj() {
        return null;
    }

    public final synchronized void zzkf() {
    }

    public final synchronized void zza(zzwn zzwn2) {
    }

    public final synchronized void setManualImpressionsEnabled(boolean bl) {
    }

    public final synchronized zzxl getVideoController() {
        return null;
    }

    public final synchronized void zza(zzze zzze2) {
    }

    public final synchronized void zza(zzaas zzaas2) {
    }

    public final void zza(zzwc zzwc2) {
    }

    public final Bundle getAdMetadata() {
        return new Bundle();
    }

    public final boolean isReady() {
        return false;
    }

    public final void showInterstitial() {
    }

    public final void stopLoading() {
    }

    public final void zza(zzapq zzapq2) {
    }

    public final void zza(zzapw zzapw2, String string2) {
    }

    public final void zza(zzasn zzasn2) {
    }

    public final void setUserId(String string2) {
    }

    public final void zzbn(String string2) {
    }

    public final void zza(zzxr zzxr2) {
    }

    public final void setImmersiveMode(boolean bl) {
    }

    public final void zza(zzxf zzxf2) {
    }

    final /* synthetic */ void zzarh() {
        zzddf zzddf2 = this;
        zzddf2.zzggh.zzacv().execute(new zzddi(zzddf2));
    }

    final /* synthetic */ void zzari() {
        this.zzarf();
    }

    static /* synthetic */ ViewGroup zza(zzddf zzddf2) {
        return zzddf2.zzfiv;
    }

    static /* synthetic */ zzazz zzb(zzddf zzddf2) {
        return zzddf2.zzbml;
    }

    static /* synthetic */ zzq zza(zzddf zzddf2, zzblr zzblr2) {
        return zzddf2.zza(zzblr2);
    }

    static /* synthetic */ RelativeLayout.LayoutParams zzd(zzblr zzblr2) {
        return zzddf.zzb(zzblr2);
    }

    static /* synthetic */ void zzb(zzddf zzddf2, zzblr zzblr2) {
        zzddf2.zzc(zzblr2);
    }

    static /* synthetic */ zzum zzc(zzddf zzddf2) {
        return zzddf2.zzarg();
    }

    static /* synthetic */ zzddn zzd(zzddf zzddf2) {
        return zzddf2.zzgqk;
    }
}

