/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import com.google.android.gms.internal.ads.zzdoj;
import com.google.android.gms.internal.ads.zzdot;
import com.google.android.gms.internal.ads.zzdpp;
import com.google.android.gms.internal.ads.zzdqc;
import com.google.android.gms.internal.ads.zzdqe;
import com.google.android.gms.internal.ads.zzdqg;
import com.google.android.gms.internal.ads.zzdqp;
import com.google.android.gms.internal.ads.zzdqw;
import com.google.android.gms.internal.ads.zzdri;
import com.google.android.gms.internal.ads.zzdrz;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

abstract class zzdqd<InputT, OutputT>
extends zzdqg<OutputT> {
    private static final Logger logger = Logger.getLogger(zzdqd.class.getName());
    @NullableDecl
    private zzdot<? extends zzdri<? extends InputT>> zzhhe;
    private final boolean zzhhf;
    private final boolean zzhhg;

    zzdqd(zzdot<? extends zzdri<? extends InputT>> zzdot2, boolean bl, boolean bl2) {
        super(zzdot2.size());
        this.zzhhe = (zzdot)zzdoj.checkNotNull(zzdot2);
        this.zzhhf = bl;
        this.zzhhg = bl2;
    }

    @Override
    protected final void afterDone() {
        super.afterDone();
        zzdot<? extends zzdri<? extends InputT>> zzdot2 = this.zzhhe;
        this.zza(zza.zzhhh);
        if (this.isCancelled() & zzdot2 != null) {
            boolean bl = this.wasInterrupted();
            zzdpp zzdpp2 = (zzdpp)zzdot2.iterator();
            while (zzdpp2.hasNext()) {
                ((Future)zzdpp2.next()).cancel(bl);
            }
        }
    }

    @Override
    protected final String pendingToString() {
        zzdot<? extends zzdri<? extends InputT>> zzdot2 = this.zzhhe;
        if (zzdot2 != null) {
            String string2 = String.valueOf(zzdot2);
            return new StringBuilder(8 + String.valueOf(string2).length()).append("futures=").append(string2).toString();
        }
        return super.pendingToString();
    }

    final void zzawi() {
        if (this.zzhhe.isEmpty()) {
            this.zzawj();
            return;
        }
        if (this.zzhhf) {
            int n = 0;
            zzdpp zzdpp2 = (zzdpp)this.zzhhe.iterator();
            while (zzdpp2.hasNext()) {
                zzdri zzdri2 = (zzdri)zzdpp2.next();
                int n2 = n++;
                zzdri2.addListener(new zzdqc(this, zzdri2, n2), zzdqp.zzhhu);
            }
            return;
        }
        zzdot<? extends zzdri<? extends InputT>> zzdot2 = this.zzhhg ? this.zzhhe : null;
        zzdqe zzdqe2 = new zzdqe(this, zzdot2);
        zzdpp zzdpp3 = (zzdpp)this.zzhhe.iterator();
        while (zzdpp3.hasNext()) {
            ((zzdri)zzdpp3.next()).addListener(zzdqe2, zzdqp.zzhhu);
        }
    }

    private final void zzi(Throwable throwable) {
        zzdoj.checkNotNull((Object)throwable);
        if (this.zzhhf && !this.setException(throwable) && zzdqd.zza(this.zzawk(), throwable)) {
            zzdqd.zzj(throwable);
            return;
        }
        if (throwable instanceof Error) {
            zzdqd.zzj(throwable);
        }
    }

    private static void zzj(Throwable throwable) {
        String string2 = throwable instanceof Error ? "Input Future failed with Error" : "Got more than one input Future failure. Logging failures after the first";
        logger.logp(Level.SEVERE, "com.google.common.util.concurrent.AggregateFuture", "log", string2, throwable);
    }

    @Override
    final void zzh(Set<Throwable> set) {
        zzdoj.checkNotNull(set);
        if (!this.isCancelled()) {
            zzdqd.zza(set, ((zzdrz)this).zzawf());
        }
    }

    private final void zza(int n, Future<? extends InputT> future) {
        try {
            this.zzb(n, zzdqw.zza(future));
            return;
        }
        catch (ExecutionException executionException) {
            this.zzi(executionException.getCause());
            return;
        }
        catch (Throwable throwable) {
            this.zzi(throwable);
            return;
        }
    }

    private final void zza(@NullableDecl zzdot<? extends Future<? extends InputT>> zzdot2) {
        int n = this.zzawl();
        boolean bl = n >= 0;
        zzdot<? extends Future<? extends InputT>> zzdot3 = "Less than 0 remaining futures";
        if (!bl) {
            throw new IllegalStateException(String.valueOf(zzdot3));
        }
        if (n == 0) {
            zzdot3 = zzdot2;
            zzdqd zzdqd2 = this;
            if (zzdot3 != null) {
                int n2 = 0;
                zzdpp zzdpp2 = (zzdpp)zzdot3.iterator();
                while (zzdpp2.hasNext()) {
                    Future future = (Future)zzdpp2.next();
                    if (!future.isCancelled()) {
                        zzdqd2.zza(n2, future);
                    }
                    ++n2;
                }
            }
            zzdqd2.zzawm();
            zzdqd2.zzawj();
            zzdqd2.zza(zza.zzhhi);
        }
    }

    void zza(zza zza2) {
        zzdoj.checkNotNull((Object)((Object)zza2));
        this.zzhhe = null;
    }

    abstract void zzb(int var1, @NullableDecl InputT var2);

    abstract void zzawj();

    private static boolean zza(Set<Throwable> set, Throwable throwable) {
        while (throwable != null) {
            if (!set.add(throwable)) {
                return false;
            }
            throwable = throwable.getCause();
        }
        return true;
    }

    static /* synthetic */ zzdot zza(zzdqd zzdqd2, zzdot zzdot2) {
        zzdqd2.zzhhe = null;
        return null;
    }

    static /* synthetic */ void zza(zzdqd zzdqd2, int n, Future future) {
        zzdqd2.zza(n, future);
    }

    static /* synthetic */ void zzb(zzdqd zzdqd2, zzdot zzdot2) {
        zzdqd2.zza(zzdot2);
    }

    static final class zza
    extends Enum<zza> {
        public static final /* enum */ zza zzhhh = new zza();
        public static final /* enum */ zza zzhhi = new zza();
        private static final /* synthetic */ zza[] zzhhj;

        public static zza[] values() {
            return (zza[])zzhhj.clone();
        }

        static {
            zzhhj = new zza[]{zzhhh, zzhhi};
        }
    }
}

