/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import com.google.android.gms.internal.ads.zzdss;
import com.google.android.gms.internal.ads.zzdyp;
import com.google.android.gms.internal.ads.zzdys;
import com.google.android.gms.internal.ads.zzdzi;
import com.google.android.gms.internal.ads.zzdzy;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public final class zzdyi
implements zzdss {
    private final SecretKey zzhqc;
    private final int zzhqd;
    private byte[] zzhqe;
    private byte[] zzhqf;

    private static Cipher zzbbv() throws GeneralSecurityException {
        return zzdzi.zzhrs.zzho("AES/ECB/NoPadding");
    }

    public zzdyi(byte[] byArray, int n) throws GeneralSecurityException {
        zzdzy.zzfj(byArray.length);
        if (n < 10) {
            throw new InvalidAlgorithmParameterException("tag size too small, min is 10 bytes");
        }
        if (n > 16) {
            throw new InvalidAlgorithmParameterException("tag size too large, max is 16 bytes");
        }
        this.zzhqc = new SecretKeySpec(byArray, "AES");
        this.zzhqd = n;
        zzdyi zzdyi2 = this;
        Cipher cipher = zzdyi.zzbbv();
        cipher.init(1, zzdyi2.zzhqc);
        byte[] byArray2 = new byte[16];
        byte[] byArray3 = cipher.doFinal(byArray2);
        zzdyi2.zzhqe = zzdyp.zzq(byArray3);
        zzdyi2.zzhqf = zzdyp.zzq(zzdyi2.zzhqe);
    }

    @Override
    public final byte[] zzm(byte[] byArray) throws GeneralSecurityException {
        byte[] byArray2;
        byte[] byArray3;
        Cipher cipher = zzdyi.zzbbv();
        cipher.init(1, this.zzhqc);
        int n = Math.max(1, (int)Math.ceil((double)byArray.length / 16.0));
        if (n << 4 == byArray.length) {
            byArray3 = zzdys.zza(byArray, n - 1 << 4, this.zzhqe, 0, 16);
        } else {
            byte[] byArray4 = Arrays.copyOfRange(byArray, n - 1 << 4, byArray.length);
            if (byArray4.length >= 16) {
                throw new IllegalArgumentException("x must be smaller than a block.");
            }
            byte[] byArray5 = Arrays.copyOf(byArray4, 16);
            byte[] byArray6 = byArray5;
            byArray5[byArray4.length] = -128;
            byArray3 = zzdys.zzd(byArray6, this.zzhqf);
        }
        byte[] byArray7 = new byte[16];
        for (int i = 0; i < n - 1; ++i) {
            byArray2 = zzdys.zza(byArray7, 0, byArray, i << 4, 16);
            byArray7 = cipher.doFinal(byArray2);
        }
        byArray2 = zzdys.zzd(byArray3, byArray7);
        byte[] byArray8 = new byte[this.zzhqd];
        System.arraycopy(cipher.doFinal(byArray2), 0, byArray8, 0, this.zzhqd);
        return byArray8;
    }
}

