/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import com.google.android.gms.internal.ads.zzdsb;
import com.google.android.gms.internal.ads.zzdyl;
import com.google.android.gms.internal.ads.zzdyo;
import com.google.android.gms.internal.ads.zzdzt;
import com.google.android.gms.internal.ads.zzdzy;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public final class zzdym
implements zzdsb {
    private static final ThreadLocal<Cipher> zzhqk = new zzdyl();
    private static final ThreadLocal<Cipher> zzhql = new zzdyo();
    private final byte[] zzhqm;
    private final byte[] zzhqn;
    private final SecretKeySpec zzhqh;
    private final int zzhqo;

    public zzdym(byte[] byArray, int n) throws GeneralSecurityException {
        if (n != 12 && n != 16) {
            throw new IllegalArgumentException("IV size should be either 12 or 16 bytes");
        }
        this.zzhqo = n;
        zzdzy.zzfj(byArray.length);
        this.zzhqh = new SecretKeySpec(byArray, "AES");
        Cipher cipher = zzhqk.get();
        cipher.init(1, this.zzhqh);
        byte[] byArray2 = cipher.doFinal(new byte[16]);
        this.zzhqm = zzdym.zzp(byArray2);
        this.zzhqn = zzdym.zzp(this.zzhqm);
    }

    private static byte[] zzd(byte[] byArray, byte[] byArray2) {
        int n = byArray.length;
        byte[] byArray3 = new byte[n];
        for (int i = 0; i < n; ++i) {
            byArray3[i] = (byte)(byArray[i] ^ byArray2[i]);
        }
        return byArray3;
    }

    private static byte[] zzp(byte[] byArray) {
        byte[] byArray2 = new byte[16];
        for (int i = 0; i < 15; ++i) {
            byArray2[i] = (byte)(byArray[i] << 1 ^ (byArray[i + 1] & 0xFF) >>> 7);
        }
        byArray2[15] = (byte)(byArray[15] << 1 ^ ((byArray[0] & 0x80) == 0 ? 0 : 135));
        return byArray2;
    }

    private final byte[] zza(Cipher cipher, int n, byte[] byArray, int n2, int n3) throws IllegalBlockSizeException, BadPaddingException {
        byte[] byArray2;
        byte[] byArray3 = new byte[16];
        byte[] byArray4 = byArray3;
        byArray3[15] = (byte)n;
        if (n3 == 0) {
            return cipher.doFinal(zzdym.zzd(byArray4, this.zzhqm));
        }
        byArray4 = cipher.doFinal(byArray4);
        int n4 = 0;
        while (n3 - n4 > 16) {
            for (int i = 0; i < 16; ++i) {
                int n5 = i;
                byArray4[n5] = (byte)(byArray4[n5] ^ byArray[n2 + n4 + i]);
            }
            byArray4 = cipher.doFinal(byArray4);
            n4 += 16;
        }
        byte[] byArray5 = Arrays.copyOfRange(byArray, n2 + n4, n2 + n3);
        zzdym zzdym2 = this;
        if (byArray5.length == 16) {
            byArray2 = zzdym.zzd(byArray5, zzdym2.zzhqm);
        } else {
            byte[] byArray6 = Arrays.copyOf(zzdym2.zzhqn, 16);
            for (int i = 0; i < byArray5.length; ++i) {
                int n6 = i;
                byArray6[n6] = (byte)(byArray6[n6] ^ byArray5[i]);
            }
            byArray6[byArray5.length] = (byte)(byArray6[byArray5.length] ^ 0x80);
            byArray2 = byArray6;
        }
        byte[] byArray7 = byArray2;
        byArray4 = zzdym.zzd(byArray4, byArray7);
        return cipher.doFinal(byArray4);
    }

    @Override
    public final byte[] zzc(byte[] byArray, byte[] byArray2) throws GeneralSecurityException {
        if (byArray.length > Integer.MAX_VALUE - this.zzhqo - 16) {
            throw new GeneralSecurityException("plaintext too long");
        }
        byte[] byArray3 = new byte[this.zzhqo + byArray.length + 16];
        byte[] byArray4 = zzdzt.zzfi(this.zzhqo);
        System.arraycopy(byArray4, 0, byArray3, 0, this.zzhqo);
        Cipher cipher = zzhqk.get();
        cipher.init(1, this.zzhqh);
        byte[] byArray5 = this.zza(cipher, 0, byArray4, 0, byArray4.length);
        byte[] byArray6 = byArray2;
        if (byArray2 == null) {
            byArray6 = new byte[]{};
        }
        byte[] byArray7 = this.zza(cipher, 1, byArray6, 0, byArray6.length);
        Cipher cipher2 = zzhql.get();
        cipher2.init(1, (Key)this.zzhqh, new IvParameterSpec(byArray5));
        cipher2.doFinal(byArray, 0, byArray.length, byArray3, this.zzhqo);
        byte[] byArray8 = this.zza(cipher, 2, byArray3, this.zzhqo, byArray.length);
        int n = byArray.length + this.zzhqo;
        for (int i = 0; i < 16; ++i) {
            byArray3[n + i] = (byte)(byArray7[i] ^ byArray5[i] ^ byArray8[i]);
        }
        return byArray3;
    }
}

