/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import com.google.android.gms.internal.ads.zzdsb;
import com.google.android.gms.internal.ads.zzdyq;
import com.google.android.gms.internal.ads.zzdzt;
import com.google.android.gms.internal.ads.zzdzv;
import com.google.android.gms.internal.ads.zzdzy;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public final class zzdyn
implements zzdsb {
    private static final ThreadLocal<Cipher> zzhqg = new zzdyq();
    private final SecretKey zzhqc;

    public zzdyn(byte[] byArray) throws GeneralSecurityException {
        zzdzy.zzfj(byArray.length);
        this.zzhqc = new SecretKeySpec(byArray, "AES");
    }

    @Override
    public final byte[] zzc(byte[] byArray, byte[] byArray2) throws GeneralSecurityException {
        int n;
        if (byArray.length > 2147483619) {
            throw new GeneralSecurityException("plaintext too long");
        }
        byte[] byArray3 = new byte[12 + byArray.length + 16];
        byte[] byArray4 = zzdzt.zzfi(12);
        System.arraycopy(byArray4, 0, byArray3, 0, 12);
        byte[] byArray5 = byArray4;
        AlgorithmParameterSpec algorithmParameterSpec = zzdyn.zzf(byArray4, 0, byArray5.length);
        zzhqg.get().init(1, (Key)this.zzhqc, algorithmParameterSpec);
        if (byArray2 != null && byArray2.length != 0) {
            zzhqg.get().updateAAD(byArray2);
        }
        if ((n = zzhqg.get().doFinal(byArray, 0, byArray.length, byArray3, 12)) != byArray.length + 16) {
            int n2 = n - byArray.length;
            throw new GeneralSecurityException(String.format("encryption failed; GCM tag must be %s bytes, but got only %s bytes", 16, n2));
        }
        return byArray3;
    }

    private static AlgorithmParameterSpec zzf(byte[] byArray, int n, int n2) throws GeneralSecurityException {
        try {
            Class.forName("javax.crypto.spec.GCMParameterSpec");
            return new GCMParameterSpec(128, byArray, 0, n2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (zzdzv.zzbcc()) {
                return new IvParameterSpec(byArray, 0, n2);
            }
            throw new GeneralSecurityException("cannot use AES-GCM: javax.crypto.spec.GCMParameterSpec not found");
        }
    }
}

