/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import com.google.android.gms.internal.ads.zzdys;
import com.google.android.gms.internal.ads.zzdzb;
import com.google.android.gms.internal.ads.zzdzc;
import com.google.android.gms.internal.ads.zzdze;
import com.google.android.gms.internal.ads.zzdzg;
import com.google.android.gms.internal.ads.zzdzi;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.EllipticCurve;
import java.util.Arrays;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public final class zzdyz {
    private ECPublicKey zzhrb;

    public zzdyz(ECPublicKey eCPublicKey) {
        this.zzhrb = eCPublicKey;
    }

    public final zzdzc zza(String string2, byte[] byArray, byte[] byArray2, int n, zzdzg zzdzg2) throws GeneralSecurityException {
        byte[] byArray3;
        byte[] byArray4;
        byte[] byArray5;
        KeyPair keyPair = zzdzb.zza(this.zzhrb.getParams());
        ECPublicKey eCPublicKey = (ECPublicKey)keyPair.getPublic();
        Object object = this.zzhrb;
        Object object2 = (ECPrivateKey)keyPair.getPrivate();
        ECPrivateKey eCPrivateKey = object2;
        ECPublicKey eCPublicKey2 = object;
        try {
            ECParameterSpec eCParameterSpec;
            ECParameterSpec eCParameterSpec2 = eCPublicKey2.getParams();
            ECParameterSpec eCParameterSpec3 = eCParameterSpec = eCPrivateKey.getParams();
            ECParameterSpec eCParameterSpec4 = eCParameterSpec2;
            if (!(eCParameterSpec4.getCurve().equals(eCParameterSpec3.getCurve()) && eCParameterSpec4.getGenerator().equals(eCParameterSpec3.getGenerator()) && eCParameterSpec4.getOrder().equals(eCParameterSpec3.getOrder()) && eCParameterSpec4.getCofactor() == eCParameterSpec3.getCofactor())) {
                throw new GeneralSecurityException("invalid public key spec");
            }
        }
        catch (IllegalArgumentException | NullPointerException runtimeException) {
            throw new GeneralSecurityException(runtimeException.toString());
        }
        byte[] byArray6 = zzdzb.zza((ECPrivateKey)object2, object.getW());
        Object object3 = eCPublicKey.getW();
        object = zzdzg2;
        object2 = eCPublicKey.getParams().getCurve();
        zzdzb.zza((ECPoint)object3, (EllipticCurve)object2);
        int n2 = (zzdzb.zza((EllipticCurve)object2).subtract(BigInteger.ONE).bitLength() + 7) / 8;
        switch (zzdze.zzhri[((Enum)object).ordinal()]) {
            case 1: {
                byArray5 = new byte[2 * n2 + 1];
                byte[] byArray7 = ((ECPoint)object3).getAffineX().toByteArray();
                byArray4 = ((ECPoint)object3).getAffineY().toByteArray();
                System.arraycopy(byArray4, 0, byArray5, 1 + 2 * n2 - byArray4.length, byArray4.length);
                System.arraycopy(byArray7, 0, byArray5, n2 + 1 - byArray7.length, byArray7.length);
                byArray5[0] = 4;
                byArray3 = byArray5;
                break;
            }
            case 2: {
                byArray5 = new byte[2 * n2];
                byte[] byArray7 = ((ECPoint)object3).getAffineX().toByteArray();
                if (byArray7.length > n2) {
                    byArray7 = Arrays.copyOfRange(byArray7, byArray7.length - n2, byArray7.length);
                }
                if ((byArray4 = ((ECPoint)object3).getAffineY().toByteArray()).length > n2) {
                    byArray4 = Arrays.copyOfRange(byArray4, byArray4.length - n2, byArray4.length);
                }
                System.arraycopy(byArray4, 0, byArray5, 2 * n2 - byArray4.length, byArray4.length);
                System.arraycopy(byArray7, 0, byArray5, n2 - byArray7.length, byArray7.length);
                byArray3 = byArray5;
                break;
            }
            case 3: {
                byArray5 = new byte[n2 + 1];
                byte[] byArray7 = ((ECPoint)object3).getAffineX().toByteArray();
                System.arraycopy(byArray7, 0, byArray5, n2 + 1 - byArray7.length, byArray7.length);
                byArray5[0] = (byte)(((ECPoint)object3).getAffineY().testBit(0) ? 3 : 2);
                byArray3 = byArray5;
                break;
            }
            default: {
                String string3 = String.valueOf(object);
                throw new GeneralSecurityException(new StringBuilder(15 + String.valueOf(string3).length()).append("invalid format:").append(string3).toString());
            }
        }
        byte[] byArray8 = byArray3;
        int n3 = n;
        byArray5 = byArray2;
        byte[] byArray9 = byArray;
        object3 = string2;
        object = byArray6;
        object2 = byArray3;
        byArray4 = zzdys.zza((byte[])object2, (byte[])object);
        int n4 = n3;
        byte[] byArray10 = byArray5;
        byte[] byArray11 = byArray9;
        byte[] byArray12 = byArray4;
        Object object4 = object3;
        Mac mac = zzdzi.zzhrt.zzho((String)object4);
        if (n4 > 255 * mac.getMacLength()) {
            throw new GeneralSecurityException("size too large");
        }
        if (byArray11 == null || byArray11.length == 0) {
            mac.init(new SecretKeySpec(new byte[mac.getMacLength()], (String)object4));
        } else {
            mac.init(new SecretKeySpec(byArray11, (String)object4));
        }
        byte[] byArray13 = mac.doFinal(byArray12);
        byte[] byArray14 = new byte[n4];
        int n5 = 1;
        int n6 = 0;
        mac.init(new SecretKeySpec(byArray13, (String)object4));
        byte[] byArray15 = new byte[]{};
        while (true) {
            mac.update(byArray15);
            mac.update(byArray10);
            mac.update((byte)n5);
            byArray15 = mac.doFinal();
            if (n6 + byArray15.length >= n4) break;
            System.arraycopy(byArray15, 0, byArray14, n6, byArray15.length);
            n6 += byArray15.length;
            ++n5;
        }
        System.arraycopy(byArray15, 0, byArray14, n6, n4 - n6);
        byte[] byArray16 = byArray14;
        return new zzdzc(byArray8, byArray16);
    }
}

