/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.media.AudioAttributes;
import android.media.AudioFormat;
import android.media.AudioTrack;
import android.os.ConditionVariable;
import android.os.SystemClock;
import android.util.Log;
import com.google.android.gms.internal.ads.zzgr;
import com.google.android.gms.internal.ads.zzhl;
import com.google.android.gms.internal.ads.zzhs;
import com.google.android.gms.internal.ads.zzht;
import com.google.android.gms.internal.ads.zzhu;
import com.google.android.gms.internal.ads.zzhv;
import com.google.android.gms.internal.ads.zzie;
import com.google.android.gms.internal.ads.zzig;
import com.google.android.gms.internal.ads.zzih;
import com.google.android.gms.internal.ads.zzii;
import com.google.android.gms.internal.ads.zzij;
import com.google.android.gms.internal.ads.zzik;
import com.google.android.gms.internal.ads.zzil;
import com.google.android.gms.internal.ads.zzim;
import com.google.android.gms.internal.ads.zzin;
import com.google.android.gms.internal.ads.zzip;
import com.google.android.gms.internal.ads.zzit;
import com.google.android.gms.internal.ads.zziv;
import com.google.android.gms.internal.ads.zzoh;
import com.google.android.gms.internal.ads.zzov;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.LinkedList;

public final class zzif {
    private static boolean zzaiv = false;
    private static boolean zzaiw = false;
    private final zzhs zzaix = null;
    private final zzim zzaiy;
    private final zziv zzaiz;
    private final zzhv[] zzaja;
    private final zzil zzajb;
    private final ConditionVariable zzajc;
    private final long[] zzajd;
    private final zzih zzaje;
    private final LinkedList<zzik> zzajf;
    private AudioTrack zzajg;
    private int zzagt;
    private int zzajh;
    private int zzaji;
    private int zzajj;
    private int streamType;
    private boolean zzajk;
    private int zzajl;
    private long zzajm;
    private zzhl zzajn;
    private zzhl zzaek;
    private long zzajo;
    private long zzajp;
    private ByteBuffer zzajq;
    private int zzajr;
    private int zzajs;
    private int zzajt;
    private long zzaju;
    private long zzajv;
    private boolean zzajw;
    private long zzajx;
    private Method zzajy;
    private int zzajz;
    private long zzaka;
    private long zzakb;
    private int zzakc;
    private long zzakd;
    private long zzake;
    private int zzakf;
    private int zzakg;
    private long zzakh;
    private long zzaki;
    private long zzakj;
    private float zzcy;
    private zzhv[] zzakk;
    private ByteBuffer[] zzakl;
    private ByteBuffer zzakm;
    private ByteBuffer zzakn;
    private byte[] zzako;
    private int zzakp;
    private int zzakq;
    private boolean zzakr;
    private boolean zzaks;
    private int zzakt;
    private boolean zzaku;
    private boolean zzakv;
    private long zzakw;

    public zzif(zzhs zzhs2, zzhv[] zzhvArray, zzil zzil2) {
        this.zzajb = zzil2;
        this.zzajc = new ConditionVariable(true);
        if (zzov.SDK_INT >= 18) {
            try {
                this.zzajy = AudioTrack.class.getMethod("getLatency", null);
            }
            catch (NoSuchMethodException noSuchMethodException) {}
        }
        this.zzaje = zzov.SDK_INT >= 19 ? new zzig() : new zzih(null);
        this.zzaiy = new zzim();
        this.zzaiz = new zziv();
        this.zzaja = new zzhv[3 + zzhvArray.length];
        this.zzaja[0] = new zzit();
        this.zzaja[1] = this.zzaiy;
        System.arraycopy(zzhvArray, 0, this.zzaja, 2, zzhvArray.length);
        this.zzaja[2 + zzhvArray.length] = this.zzaiz;
        this.zzajd = new long[10];
        this.zzcy = 1.0f;
        this.zzakg = 0;
        this.streamType = 3;
        this.zzakt = 0;
        this.zzaek = zzhl.zzahe;
        this.zzakq = -1;
        this.zzakk = new zzhv[0];
        this.zzakl = new ByteBuffer[0];
        this.zzajf = new LinkedList();
    }

    public final boolean zzaw(String string2) {
        return this.zzaix != null && this.zzaix.zzs(zzif.zzax(string2));
    }

    public final long zzj(boolean bl) {
        long l;
        long l2;
        zzif zzif2 = this;
        if (!(zzif2.isInitialized() && zzif2.zzakg != 0)) {
            return Long.MIN_VALUE;
        }
        if (this.zzajg.getPlayState() == 3) {
            zzif2 = this;
            l2 = zzif2.zzaje.zzgb();
            if (l2 != 0L) {
                long l3 = System.nanoTime() / 1000L;
                if (l3 - zzif2.zzajv >= 30000L) {
                    zzif2.zzajd[zzif2.zzajs] = l2 - l3;
                    zzif2.zzajs = (zzif2.zzajs + 1) % 10;
                    if (zzif2.zzajt < 10) {
                        ++zzif2.zzajt;
                    }
                    zzif2.zzajv = l3;
                    zzif2.zzaju = 0L;
                    for (int i = 0; i < zzif2.zzajt; ++i) {
                        zzif2.zzaju += zzif2.zzajd[i] / (long)zzif2.zzajt;
                    }
                }
                if (!zzif2.zzfw() && l3 - zzif2.zzajx >= 500000L) {
                    zzif2.zzajw = zzif2.zzaje.zzfx();
                    if (zzif2.zzajw) {
                        String string2;
                        long l4 = zzif2.zzaje.zzfy() / 1000L;
                        long l5 = zzif2.zzaje.zzfz();
                        if (l4 < zzif2.zzaki) {
                            zzif2.zzajw = false;
                        } else if (Math.abs(l4 - l3) > 5000000L) {
                            string2 = new StringBuilder(136).append("Spurious audio timestamp (system clock mismatch): ").append(l5).append(", ").append(l4).append(", ").append(l3).append(", ").append(l2).toString();
                            Log.w((String)"AudioTrack", (String)string2);
                            zzif2.zzajw = false;
                        } else if (Math.abs(zzif2.zzdw(l5) - l2) > 5000000L) {
                            string2 = new StringBuilder(138).append("Spurious audio timestamp (frame position mismatch): ").append(l5).append(", ").append(l4).append(", ").append(l3).append(", ").append(l2).toString();
                            Log.w((String)"AudioTrack", (String)string2);
                            zzif2.zzajw = false;
                        }
                    }
                    if (zzif2.zzajy != null && !zzif2.zzajk) {
                        try {
                            zzif2.zzakj = (long)((Integer)zzif2.zzajy.invoke((Object)zzif2.zzajg, null)).intValue() * 1000L - zzif2.zzajm;
                            zzif2.zzakj = Math.max(zzif2.zzakj, 0L);
                            if (zzif2.zzakj > 5000000L) {
                                long l6 = zzif2.zzakj;
                                Log.w((String)"AudioTrack", (String)new StringBuilder(61).append("Ignoring impossibly large audio latency: ").append(l6).toString());
                                zzif2.zzakj = 0L;
                            }
                        }
                        catch (Exception exception) {
                            zzif2.zzajy = null;
                        }
                    }
                    zzif2.zzajx = l3;
                }
            }
        }
        long l7 = System.nanoTime() / 1000L;
        if (this.zzajw) {
            long l8 = l7 - this.zzaje.zzfy() / 1000L;
            long l9 = this.zzdx(l8);
            long l10 = this.zzaje.zzfz() + l9;
            l = this.zzdw(l10);
        } else {
            l = this.zzajt == 0 ? this.zzaje.zzgb() : l7 + this.zzaju;
            if (!bl) {
                l -= this.zzakj;
            }
        }
        l2 = l;
        zzif2 = this;
        while (!zzif2.zzajf.isEmpty() && l2 >= zzik.zzb(zzif2.zzajf.getFirst())) {
            zzik zzik2 = zzif2.zzajf.remove();
            zzif2.zzaek = zzik.zza(zzik2);
            zzif2.zzajp = zzik.zzb(zzik2);
            zzif2.zzajo = zzik.zzc(zzik2) - zzif2.zzakh;
        }
        return this.zzakh + (zzif2.zzaek.zzahf == 1.0f ? l2 + zzif2.zzajo - zzif2.zzajp : (zzif2.zzajf.isEmpty() && zzif2.zzaiz.zzgk() >= 1024L ? zzif2.zzajo + zzov.zza(l2 - zzif2.zzajp, zzif2.zzaiz.zzgj(), zzif2.zzaiz.zzgk()) : zzif2.zzajo + (long)((double)zzif2.zzaek.zzahf * (double)(l2 - zzif2.zzajp))));
    }

    public final void zza(String string2, int n, int n2, int n3, int n4, int[] nArray) throws zzij {
        int n5;
        zzif zzif2;
        int n6;
        int n7;
        int n8;
        boolean bl = !"audio/raw".equals(string2);
        int n9 = bl ? zzif.zzax(string2) : n3;
        boolean bl2 = false;
        if (!bl) {
            this.zzajz = zzov.zzg(n3, n);
            this.zzaiy.zzb(nArray);
            zzhv[] zzhvArray = this.zzaja;
            n8 = this.zzaja.length;
            for (n7 = 0; n7 < n8; ++n7) {
                zzhv zzhv2 = zzhvArray[n7];
                try {
                    bl2 |= zzhv2.zzb(n2, n, n9);
                }
                catch (zzhu zzhu2) {
                    throw new zzij(zzhu2);
                }
                if (!zzhv2.isActive()) continue;
                n = zzhv2.zzfi();
                n9 = zzhv2.zzfj();
            }
            if (bl2) {
                this.zzfm();
            }
        }
        switch (n) {
            case 1: {
                n6 = 4;
                break;
            }
            case 2: {
                n6 = 12;
                break;
            }
            case 3: {
                n6 = 28;
                break;
            }
            case 4: {
                n6 = 204;
                break;
            }
            case 5: {
                n6 = 220;
                break;
            }
            case 6: {
                n6 = 252;
                break;
            }
            case 7: {
                n6 = 1276;
                break;
            }
            case 8: {
                n6 = zzgr.CHANNEL_OUT_7POINT1_SURROUND;
                break;
            }
            default: {
                n8 = n;
                throw new zzij(new StringBuilder(38).append("Unsupported channel count: ").append(n8).toString());
            }
        }
        if (zzov.SDK_INT <= 23 && "foster".equals(zzov.DEVICE) && "NVIDIA".equals(zzov.MANUFACTURER)) {
            switch (n) {
                case 7: {
                    n6 = zzgr.CHANNEL_OUT_7POINT1_SURROUND;
                    break;
                }
                case 3: 
                case 5: {
                    n6 = 252;
                }
            }
        }
        if (zzov.SDK_INT <= 25 && "fugu".equals(zzov.DEVICE) && bl && n == 1) {
            n6 = 12;
        }
        if (!bl2 && this.isInitialized() && this.zzaji == n9 && this.zzagt == n2 && this.zzajh == n6) {
            return;
        }
        this.reset();
        this.zzaji = n9;
        this.zzajk = bl;
        this.zzagt = n2;
        this.zzajh = n6;
        this.zzajj = bl ? n9 : 2;
        this.zzakc = zzov.zzg(2, n);
        if (bl) {
            if (this.zzajj == 5 || this.zzajj == 6) {
                zzif2 = this;
                n5 = 20480;
            } else {
                zzif2 = this;
                n5 = 49152;
            }
        } else {
            n8 = AudioTrack.getMinBufferSize((int)n2, (int)n6, (int)this.zzajj);
            zzoh.checkState(n8 != -2);
            n7 = n8 << 2;
            int n10 = (int)this.zzdx(250000L) * this.zzakc;
            int n11 = (int)Math.max((long)n8, this.zzdx(750000L) * (long)this.zzakc);
            zzif2 = this;
            n5 = n7 < n10 ? n10 : (n7 > n11 ? n11 : n7);
        }
        zzif2.zzajl = n5;
        this.zzajm = bl ? -9223372036854775807L : this.zzdw(this.zzajl / this.zzakc);
        this.zzb(this.zzaek);
    }

    private final void zzfm() {
        ArrayList<zzhv> arrayList = new ArrayList<zzhv>();
        zzhv[] zzhvArray = this.zzaja;
        int n = this.zzaja.length;
        for (int i = 0; i < n; ++i) {
            zzhv zzhv2 = zzhvArray[i];
            if (zzhv2.isActive()) {
                arrayList.add(zzhv2);
                continue;
            }
            zzhv2.flush();
        }
        int n2 = arrayList.size();
        this.zzakk = arrayList.toArray(new zzhv[n2]);
        this.zzakl = new ByteBuffer[n2];
        for (n = 0; n < n2; ++n) {
            zzhv zzhv3 = this.zzakk[n];
            zzhv3.flush();
            this.zzakl[n] = zzhv3.zzfl();
        }
    }

    public final void play() {
        this.zzaks = true;
        if (this.isInitialized()) {
            this.zzaki = System.nanoTime() / 1000L;
            this.zzajg.play();
        }
    }

    public final void zzfn() {
        if (this.zzakg == 1) {
            this.zzakg = 2;
        }
    }

    public final boolean zza(ByteBuffer byteBuffer, long l) throws zzii, zzin {
        long l2;
        zzif zzif2;
        zzoh.checkArgument(this.zzakm == null || byteBuffer == this.zzakm);
        if (!this.isInitialized()) {
            int n;
            zzif2 = this;
            zzif2.zzajc.block();
            if (zzif2.zzaku) {
                int n2 = zzif2.zzakt;
                int n3 = zzif2.zzajl;
                int n4 = zzif2.zzajj;
                n = zzif2.zzajh;
                int n5 = zzif2.zzagt;
                AudioAttributes audioAttributes = new AudioAttributes.Builder().setUsage(1).setContentType(3).setFlags(16).build();
                AudioFormat audioFormat = new AudioFormat.Builder().setChannelMask(n).setEncoding(n4).setSampleRate(n5).build();
                zzif2.zzajg = new AudioTrack(audioAttributes, audioFormat, n3, 1, n2);
            } else {
                zzif2.zzajg = zzif2.zzakt == 0 ? new AudioTrack(zzif2.streamType, zzif2.zzagt, zzif2.zzajh, zzif2.zzajj, zzif2.zzajl, 1) : new AudioTrack(zzif2.streamType, zzif2.zzagt, zzif2.zzajh, zzif2.zzajj, zzif2.zzajl, 1, zzif2.zzakt);
            }
            zzif zzif3 = zzif2;
            n = zzif3.zzajg.getState();
            if (n != 1) {
                try {
                    zzif3.zzajg.release();
                }
                catch (Exception exception) {
                }
                finally {
                    zzif3.zzajg = null;
                }
                throw new zzii(n, zzif3.zzagt, zzif3.zzajh, zzif3.zzajl);
            }
            int n6 = zzif2.zzajg.getAudioSessionId();
            if (zzif2.zzakt != n6) {
                zzif2.zzakt = n6;
                zzif2.zzajb.zzu(n6);
            }
            zzif2.zzaje.zza(zzif2.zzajg, zzif2.zzfw());
            zzif2.zzft();
            zzif2.zzakv = false;
            if (this.zzaks) {
                this.play();
            }
        }
        if (this.zzfw()) {
            if (this.zzajg.getPlayState() == 2) {
                this.zzakv = false;
                return false;
            }
            if (this.zzajg.getPlayState() == 1 && this.zzaje.zzga() != 0L) {
                return false;
            }
        }
        boolean bl = this.zzakv;
        this.zzakv = this.zzfq();
        if (bl && !this.zzakv && this.zzajg.getPlayState() != 1) {
            l2 = SystemClock.elapsedRealtime() - this.zzakw;
            this.zzajb.zzc(this.zzajl, zzgr.zzdo(this.zzajm), l2);
        }
        if (this.zzakm == null) {
            if (!byteBuffer.hasRemaining()) {
                return true;
            }
            if (this.zzajk && this.zzakf == 0) {
                int n;
                ByteBuffer byteBuffer2 = byteBuffer;
                int n7 = this.zzajj;
                if (n7 == 7 || n7 == 8) {
                    n = zzip.zzj(byteBuffer2);
                } else if (n7 == 5) {
                    n = zzht.zzfh();
                } else if (n7 == 6) {
                    n = zzht.zzh(byteBuffer2);
                } else {
                    throw new IllegalStateException(new StringBuilder(38).append("Unexpected audio encoding: ").append(n7).toString());
                }
                this.zzakf = n;
            }
            if (this.zzajn != null) {
                if (!this.zzfp()) {
                    return false;
                }
                this.zzajf.add(new zzik(this.zzajn, Math.max(0L, l), this.zzdw(this.zzfu()), null));
                this.zzajn = null;
                this.zzfm();
            }
            if (this.zzakg == 0) {
                this.zzakh = Math.max(0L, l);
                this.zzakg = 1;
            } else {
                zzif2 = this;
                l2 = this.zzakh + this.zzdw(zzif2.zzajk ? zzif2.zzakb : zzif2.zzaka / (long)zzif2.zzajz);
                if (this.zzakg == 1 && Math.abs(l2 - l) > 200000L) {
                    Log.e((String)"AudioTrack", (String)new StringBuilder(80).append("Discontinuity detected [expected ").append(l2).append(", got ").append(l).append("]").toString());
                    this.zzakg = 2;
                }
                if (this.zzakg == 2) {
                    this.zzakh += l - l2;
                    this.zzakg = 1;
                    this.zzajb.zzej();
                }
            }
            if (this.zzajk) {
                this.zzakb += (long)this.zzakf;
            } else {
                this.zzaka += (long)byteBuffer.remaining();
            }
            this.zzakm = byteBuffer;
        }
        if (this.zzajk) {
            this.zzb(this.zzakm, l);
        } else {
            this.zzdv(l);
        }
        if (!this.zzakm.hasRemaining()) {
            this.zzakm = null;
            return true;
        }
        return false;
    }

    private final void zzdv(long l) throws zzin {
        int n;
        int n2 = n = this.zzakk.length;
        while (n2 >= 0) {
            ByteBuffer byteBuffer;
            ByteBuffer byteBuffer2 = n2 > 0 ? this.zzakl[n2 - 1] : (byteBuffer = this.zzakm != null ? this.zzakm : zzhv.zzaig);
            if (n2 == n) {
                this.zzb(byteBuffer, l);
            } else {
                ByteBuffer byteBuffer3;
                zzhv zzhv2 = this.zzakk[n2];
                zzhv2.zzi(byteBuffer);
                this.zzakl[n2] = byteBuffer3 = zzhv2.zzfl();
                if (byteBuffer3.hasRemaining()) {
                    ++n2;
                    continue;
                }
            }
            if (byteBuffer.hasRemaining()) {
                return;
            }
            --n2;
        }
    }

    /*
     * Unable to fully structure code
     */
    private final boolean zzb(ByteBuffer var1_1, long var2_2) throws zzin {
        block19: {
            block20: {
                block18: {
                    if (!var1_1.hasRemaining()) {
                        return true;
                    }
                    if (this.zzakn != null) {
                        zzoh.checkArgument(this.zzakn == var1_1);
                    } else {
                        this.zzakn = var1_1;
                        if (zzov.SDK_INT < 21) {
                            var4_3 = var1_1.remaining();
                            if (this.zzako == null || this.zzako.length < var4_3) {
                                this.zzako = new byte[var4_3];
                            }
                            var5_4 = var1_1.position();
                            var1_1.get(this.zzako, 0, var4_3);
                            var1_1.position(var5_4);
                            this.zzakp = 0;
                        }
                    }
                    var4_3 = var1_1.remaining();
                    var5_4 = 0;
                    if (zzov.SDK_INT >= 21) break block18;
                    var6_5 = (int)(this.zzakd - this.zzaje.zzga() * (long)this.zzakc);
                    var7_6 = this.zzajl - var6_5;
                    if (var7_6 > 0 && (var5_4 = this.zzajg.write(this.zzako, this.zzakp, var7_6 = Math.min(var4_3, var7_6))) > 0) {
                        this.zzakp += var5_4;
                        var1_1.position(var1_1.position() + var5_4);
                    }
                    break block19;
                }
                if (!this.zzaku) break block20;
                zzoh.checkState(var2_2 != -9223372036854775807L);
                var11_7 = var2_2;
                var10_8 = var1_1;
                var9_9 = this.zzajg;
                var8_11 = this;
                if (var8_11.zzajq == null) {
                    var8_11.zzajq = ByteBuffer.allocate(16);
                    var8_11.zzajq.order(ByteOrder.BIG_ENDIAN);
                    var8_11.zzajq.putInt(0x55550001);
                }
                if (var8_11.zzajr == 0) {
                    var8_11.zzajq.putInt(4, var4_3);
                    var8_11.zzajq.putLong(8, var11_7 * 1000L);
                    var8_11.zzajq.position(0);
                    var8_11.zzajr = var4_3;
                }
                if ((var13_12 = var8_11.zzajq.remaining()) <= 0) ** GOTO lbl-1000
                var14_13 = var9_9.write(var8_11.zzajq, var13_12, 1);
                if (var14_13 < 0) {
                    var8_11.zzajr = 0;
                    v0 = var14_13;
                } else if (var14_13 < var13_12) {
                    v0 = 0;
                } else if ((var14_13 = var9_9.write(var15_14 = var10_8, var4_3, 1)) < 0) {
                    var8_11.zzajr = 0;
                    v0 = var14_13;
                } else {
                    var8_11.zzajr -= var14_13;
                    v0 = var14_13;
                }
                var5_4 = v0;
                break block19;
            }
            var9_10 = var1_1;
            var5_4 = this.zzajg.write(var9_10, var4_3, 1);
        }
        this.zzakw = SystemClock.elapsedRealtime();
        if (var5_4 < 0) {
            throw new zzin(var5_4);
        }
        if (!this.zzajk) {
            this.zzakd += (long)var5_4;
        }
        if (var5_4 == var4_3) {
            if (this.zzajk) {
                this.zzake += (long)this.zzakf;
            }
            this.zzakn = null;
            return true;
        }
        return false;
    }

    public final void zzfo() throws zzin {
        if (this.zzakr || !this.isInitialized()) {
            return;
        }
        if (this.zzfp()) {
            this.zzaje.zzdy(this.zzfu());
            this.zzajr = 0;
            this.zzakr = true;
        }
    }

    private final boolean zzfp() throws zzin {
        boolean bl = false;
        if (this.zzakq == -1) {
            this.zzakq = this.zzajk ? this.zzakk.length : 0;
            bl = true;
        }
        while (this.zzakq < this.zzakk.length) {
            zzhv zzhv2 = this.zzakk[this.zzakq];
            if (bl) {
                zzhv2.zzfk();
            }
            this.zzdv(-9223372036854775807L);
            if (!zzhv2.zzfd()) {
                return false;
            }
            bl = true;
            ++this.zzakq;
        }
        if (this.zzakn != null) {
            this.zzb(this.zzakn, -9223372036854775807L);
            if (this.zzakn != null) {
                return false;
            }
        }
        this.zzakq = -1;
        return true;
    }

    public final boolean zzfd() {
        return !this.isInitialized() || this.zzakr && !this.zzfq();
    }

    public final boolean zzfq() {
        zzif zzif2;
        return this.isInitialized() && (this.zzfu() > this.zzaje.zzga() || (zzif2 = this).zzfw() && zzif2.zzajg.getPlayState() == 2 && zzif2.zzajg.getPlaybackHeadPosition() == 0);
    }

    public final zzhl zzb(zzhl zzhl2) {
        zzhl zzhl3;
        if (this.zzajk) {
            this.zzaek = zzhl.zzahe;
            return this.zzaek;
        }
        zzhl2 = new zzhl(this.zzaiz.zzb(zzhl2.zzahf), this.zzaiz.zzc(zzhl2.zzahg));
        zzhl zzhl4 = this.zzajn != null ? this.zzajn : (zzhl3 = !this.zzajf.isEmpty() ? zzik.zza(this.zzajf.getLast()) : this.zzaek);
        if (!zzhl2.equals(zzhl3)) {
            if (this.isInitialized()) {
                this.zzajn = zzhl2;
            } else {
                this.zzaek = zzhl2;
            }
        }
        return this.zzaek;
    }

    public final zzhl zzfr() {
        return this.zzaek;
    }

    public final void setStreamType(int n) {
        if (this.streamType == n) {
            return;
        }
        this.streamType = n;
        if (this.zzaku) {
            return;
        }
        this.reset();
        this.zzakt = 0;
    }

    public final void zzv(int n) {
        zzoh.checkState(zzov.SDK_INT >= 21);
        if (!this.zzaku || this.zzakt != n) {
            this.zzaku = true;
            this.zzakt = n;
            this.reset();
        }
    }

    public final void zzfs() {
        if (this.zzaku) {
            this.zzaku = false;
            this.zzakt = 0;
            this.reset();
        }
    }

    public final void setVolume(float f) {
        if (this.zzcy != f) {
            this.zzcy = f;
            this.zzft();
        }
    }

    private final void zzft() {
        if (this.isInitialized()) {
            if (zzov.SDK_INT >= 21) {
                float f = this.zzcy;
                this.zzajg.setVolume(f);
                return;
            }
            float f = this.zzcy;
            this.zzajg.setStereoVolume(f, f);
        }
    }

    public final void pause() {
        this.zzaks = false;
        if (this.isInitialized()) {
            this.zzfv();
            this.zzaje.pause();
        }
    }

    public final void reset() {
        if (this.isInitialized()) {
            zzhv zzhv2;
            this.zzaka = 0L;
            this.zzakb = 0L;
            this.zzakd = 0L;
            this.zzake = 0L;
            this.zzakf = 0;
            if (this.zzajn != null) {
                this.zzaek = this.zzajn;
                this.zzajn = null;
            } else if (!this.zzajf.isEmpty()) {
                this.zzaek = zzik.zza(this.zzajf.getLast());
            }
            this.zzajf.clear();
            this.zzajo = 0L;
            this.zzajp = 0L;
            this.zzakm = null;
            this.zzakn = null;
            for (int i = 0; i < this.zzakk.length; ++i) {
                zzhv2 = this.zzakk[i];
                zzhv2.flush();
                this.zzakl[i] = zzhv2.zzfl();
            }
            this.zzakr = false;
            this.zzakq = -1;
            this.zzajq = null;
            this.zzajr = 0;
            this.zzakg = 0;
            this.zzakj = 0L;
            this.zzfv();
            if (this.zzajg.getPlayState() == 3) {
                this.zzajg.pause();
            }
            zzhv2 = this.zzajg;
            this.zzajg = null;
            this.zzaje.zza(null, false);
            this.zzajc.close();
            new zzie(this, (AudioTrack)zzhv2).start();
        }
    }

    public final void release() {
        this.reset();
        zzhv[] zzhvArray = this.zzaja;
        int n = this.zzaja.length;
        for (int i = 0; i < n; ++i) {
            zzhvArray[i].reset();
        }
        this.zzakt = 0;
        this.zzaks = false;
    }

    private final boolean isInitialized() {
        return this.zzajg != null;
    }

    private final long zzdw(long l) {
        return l * 1000000L / (long)this.zzagt;
    }

    private final long zzdx(long l) {
        return l * (long)this.zzagt / 1000000L;
    }

    private final long zzfu() {
        if (this.zzajk) {
            return this.zzake;
        }
        return this.zzakd / (long)this.zzakc;
    }

    private final void zzfv() {
        this.zzaju = 0L;
        this.zzajt = 0;
        this.zzajs = 0;
        this.zzajv = 0L;
        this.zzajw = false;
        this.zzajx = 0L;
    }

    private final boolean zzfw() {
        return zzov.SDK_INT < 23 && (this.zzajj == 5 || this.zzajj == 6);
    }

    private static int zzax(String string2) {
        switch (string2) {
            case "audio/ac3": {
                return 5;
            }
            case "audio/eac3": {
                return 6;
            }
            case "audio/vnd.dts": {
                return 7;
            }
            case "audio/vnd.dts.hd": {
                return 8;
            }
        }
        return 0;
    }

    static /* synthetic */ ConditionVariable zza(zzif zzif2) {
        return zzif2.zzajc;
    }
}

