/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.annotation.TargetApi;
import android.graphics.Point;
import android.media.MediaCodecInfo;
import android.util.Log;
import android.util.Pair;
import com.google.android.gms.internal.ads.zzlf;
import com.google.android.gms.internal.ads.zzoh;
import com.google.android.gms.internal.ads.zzov;

@TargetApi(value=16)
public final class zzlc {
    public final String name;
    public final boolean zzbaa;
    public final boolean zzaku;
    public final boolean zzbab;
    private final String mimeType;
    private final MediaCodecInfo.CodecCapabilities zzbac;

    public static zzlc zzaz(String string2) {
        return new zzlc(string2, null, null, false, false);
    }

    public static zzlc zza(String string2, String string3, MediaCodecInfo.CodecCapabilities codecCapabilities, boolean bl, boolean bl2) {
        return new zzlc(string2, string3, codecCapabilities, bl, bl2);
    }

    /*
     * Unable to fully structure code
     */
    private zzlc(String var1_1, String var2_2, MediaCodecInfo.CodecCapabilities var3_3, boolean var4_4, boolean var5_5) {
        super();
        this.name = zzoh.checkNotNull(var1_1);
        this.mimeType = var2_2;
        this.zzbac = var3_3;
        if (var4_4 || var3_3 == null) ** GOTO lbl-1000
        var6_6 = var3_3;
        if (zzov.SDK_INT >= 19 && var6_6.isFeatureSupported("adaptive-playback") != false) {
            v0 = true;
        } else lbl-1000:
        // 2 sources

        {
            v0 = this.zzbaa = false;
        }
        if (var3_3 == null) ** GOTO lbl-1000
        var6_6 = var3_3;
        if (zzov.SDK_INT >= 21 && var6_6.isFeatureSupported("tunneled-playback") != false) {
            v1 = true;
        } else lbl-1000:
        // 2 sources

        {
            v1 = this.zzaku = false;
        }
        if (var5_5) ** GOTO lbl-1000
        if (var3_3 != null) {
            var6_6 = var3_3;
            ** if (!(zzov.SDK_INT >= 21 && var6_6.isFeatureSupported((String)"secure-playback") != false)) goto lbl-1000
        }
        ** GOTO lbl-1000
lbl-1000:
        // 2 sources

        {
            v2 = true;
            ** GOTO lbl25
        }
lbl-1000:
        // 2 sources

        {
            v2 = false;
        }
lbl25:
        // 2 sources

        this.zzbab = v2;
    }

    public final MediaCodecInfo.CodecProfileLevel[] zzhh() {
        if (this.zzbac == null || this.zzbac.profileLevels == null) {
            return new MediaCodecInfo.CodecProfileLevel[0];
        }
        return this.zzbac.profileLevels;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean zzba(String string2) {
        String string3;
        if (string2 == null) return true;
        if (this.mimeType == null) {
            return true;
        }
        String string4 = string2;
        if (string4 == null) return true;
        if ((string4 = string4.trim()).startsWith("avc1") || string4.startsWith("avc3")) {
            string3 = "video/avc";
        } else if (string4.startsWith("hev1") || string4.startsWith("hvc1")) {
            string3 = "video/hevc";
        } else if (string4.startsWith("vp9")) {
            string3 = "video/x-vnd.on2.vp9";
        } else if (string4.startsWith("vp8")) {
            string3 = "video/x-vnd.on2.vp8";
        } else if (string4.startsWith("mp4a")) {
            string3 = "audio/mp4a-latm";
        } else if (string4.startsWith("ac-3") || string4.startsWith("dac3")) {
            string3 = "audio/ac3";
        } else if (string4.startsWith("ec-3") || string4.startsWith("dec3")) {
            string3 = "audio/eac3";
        } else if (string4.startsWith("dtsc") || string4.startsWith("dtse")) {
            string3 = "audio/vnd.dts";
        } else if (string4.startsWith("dtsh") || string4.startsWith("dtsl")) {
            string3 = "audio/vnd.dts.hd";
        } else if (string4.startsWith("opus")) {
            string3 = "audio/opus";
        } else {
            if (!string4.startsWith("vorbis")) return true;
            string3 = "audio/vorbis";
        }
        String string5 = string3;
        if (string3 == null) {
            return true;
        }
        if (!this.mimeType.equals(string5)) {
            this.zzbb(new StringBuilder(13 + String.valueOf(string2).length() + String.valueOf(string5).length()).append("codec.mime ").append(string2).append(", ").append(string5).toString());
            return false;
        }
        Pair<Integer, Integer> pair = zzlf.zzbc(string2);
        if (pair == null) {
            return true;
        }
        for (MediaCodecInfo.CodecProfileLevel codecProfileLevel : this.zzhh()) {
            if (codecProfileLevel.profile != (Integer)pair.first || codecProfileLevel.level < (Integer)pair.second) continue;
            return true;
        }
        this.zzbb(new StringBuilder(22 + String.valueOf(string2).length() + String.valueOf(string5).length()).append("codec.profileLevel, ").append(string2).append(", ").append(string5).toString());
        return false;
    }

    @TargetApi(value=21)
    public final boolean zza(int n, int n2, double d) {
        if (this.zzbac == null) {
            this.zzbb("sizeAndRate.caps");
            return false;
        }
        MediaCodecInfo.VideoCapabilities videoCapabilities = this.zzbac.getVideoCapabilities();
        if (videoCapabilities == null) {
            this.zzbb("sizeAndRate.vCaps");
            return false;
        }
        if (!zzlc.zza(videoCapabilities, n, n2, d)) {
            if (n >= n2 || !zzlc.zza(videoCapabilities, n2, n, d)) {
                this.zzbb(new StringBuilder(69).append("sizeAndRate.support, ").append(n).append("x").append(n2).append("x").append(d).toString());
                return false;
            }
            String string2 = new StringBuilder(69).append("sizeAndRate.rotated, ").append(n).append("x").append(n2).append("x").append(d).toString();
            zzlc zzlc2 = this;
            String string3 = zzlc2.name;
            String string4 = zzlc2.mimeType;
            String string5 = zzov.zzbhv;
            Log.d((String)"MediaCodecInfo", (String)new StringBuilder(25 + String.valueOf(string2).length() + String.valueOf(string3).length() + String.valueOf(string4).length() + String.valueOf(string5).length()).append("AssumedSupport [").append(string2).append("] [").append(string3).append(", ").append(string4).append("] [").append(string5).append("]").toString());
        }
        return true;
    }

    @TargetApi(value=21)
    public final Point zzd(int n, int n2) {
        if (this.zzbac == null) {
            this.zzbb("align.caps");
            return null;
        }
        MediaCodecInfo.VideoCapabilities videoCapabilities = this.zzbac.getVideoCapabilities();
        if (videoCapabilities == null) {
            this.zzbb("align.vCaps");
            return null;
        }
        int n3 = videoCapabilities.getWidthAlignment();
        int n4 = videoCapabilities.getHeightAlignment();
        return new Point(zzov.zzf(n, n3) * n3, zzov.zzf(n2, n4) * n4);
    }

    @TargetApi(value=21)
    public final boolean zzas(int n) {
        if (this.zzbac == null) {
            this.zzbb("sampleRate.caps");
            return false;
        }
        MediaCodecInfo.AudioCapabilities audioCapabilities = this.zzbac.getAudioCapabilities();
        if (audioCapabilities == null) {
            this.zzbb("sampleRate.aCaps");
            return false;
        }
        if (!audioCapabilities.isSampleRateSupported(n)) {
            this.zzbb(new StringBuilder(31).append("sampleRate.support, ").append(n).toString());
            return false;
        }
        return true;
    }

    @TargetApi(value=21)
    public final boolean zzat(int n) {
        if (this.zzbac == null) {
            this.zzbb("channelCount.caps");
            return false;
        }
        MediaCodecInfo.AudioCapabilities audioCapabilities = this.zzbac.getAudioCapabilities();
        if (audioCapabilities == null) {
            this.zzbb("channelCount.aCaps");
            return false;
        }
        if (audioCapabilities.getMaxInputChannelCount() < n) {
            this.zzbb(new StringBuilder(33).append("channelCount.support, ").append(n).toString());
            return false;
        }
        return true;
    }

    private final void zzbb(String string2) {
        String string3 = this.name;
        String string4 = this.mimeType;
        String string5 = zzov.zzbhv;
        Log.d((String)"MediaCodecInfo", (String)new StringBuilder(20 + String.valueOf(string2).length() + String.valueOf(string3).length() + String.valueOf(string4).length() + String.valueOf(string5).length()).append("NoSupport [").append(string2).append("] [").append(string3).append(", ").append(string4).append("] [").append(string5).append("]").toString());
    }

    @TargetApi(value=21)
    private static boolean zza(MediaCodecInfo.VideoCapabilities videoCapabilities, int n, int n2, double d) {
        if (d == -1.0 || d <= 0.0) {
            return videoCapabilities.isSizeSupported(n, n2);
        }
        return videoCapabilities.areSizeAndRateSupported(n, n2, d);
    }
}

