/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.net.Uri;
import com.google.android.gms.internal.ads.zznu;
import com.google.android.gms.internal.ads.zznv;
import com.google.android.gms.internal.ads.zzoh;
import java.io.IOException;

public final class zznr
implements zznu {
    private final byte[] data;
    private Uri uri;
    private int zzbfk;
    private int zzbfl;

    public zznr(byte[] byArray) {
        zzoh.checkNotNull(byArray);
        zzoh.checkArgument(byArray.length > 0);
        this.data = byArray;
    }

    @Override
    public final long zza(zznv zznv2) throws IOException {
        this.uri = zznv2.uri;
        this.zzbfk = (int)zznv2.position;
        this.zzbfl = (int)(zznv2.zzce == -1L ? (long)this.data.length - zznv2.position : zznv2.zzce);
        if (this.zzbfl <= 0 || this.zzbfk + this.zzbfl > this.data.length) {
            int n = this.zzbfk;
            long l = zznv2.zzce;
            int n2 = this.data.length;
            throw new IOException(new StringBuilder(77).append("Unsatisfiable range: [").append(n).append(", ").append(l).append("], length: ").append(n2).toString());
        }
        return this.zzbfl;
    }

    @Override
    public final int read(byte[] byArray, int n, int n2) throws IOException {
        if (n2 == 0) {
            return 0;
        }
        if (this.zzbfl == 0) {
            return -1;
        }
        n2 = Math.min(n2, this.zzbfl);
        System.arraycopy(this.data, this.zzbfk, byArray, n, n2);
        this.zzbfk += n2;
        this.zzbfl -= n2;
        return n2;
    }

    @Override
    public final Uri getUri() {
        return this.uri;
    }

    @Override
    public final void close() throws IOException {
        this.uri = null;
    }
}

