/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.annotation.SuppressLint;
import android.os.Looper;
import android.os.Message;
import android.os.SystemClock;
import android.util.Log;
import com.google.android.gms.internal.ads.zzdns;
import com.google.android.gms.internal.ads.zzob;
import com.google.android.gms.internal.ads.zzoe;
import com.google.android.gms.internal.ads.zzof;
import com.google.android.gms.internal.ads.zzog;
import com.google.android.gms.internal.ads.zzoh;
import com.google.android.gms.internal.ads.zzow;
import java.io.IOException;

@SuppressLint(value={"HandlerLeak"})
final class zzod<T extends zzog>
extends zzdns
implements Runnable {
    private final T zzbgt;
    private final zzoe<T> zzbgu;
    public final int zzbgv;
    private final long zzbgw;
    private IOException zzbgx;
    private int zzbgy;
    private volatile Thread zzbgz;
    private volatile boolean zzaez;
    private final /* synthetic */ zzob zzbha;

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    public zzod(zzob zzob2, Looper looper, zzog zzog2, zzoe zzoe2, int n, long l) {
        this.zzbha = zzob2;
        super(looper);
        this.zzbgt = zzog2;
        this.zzbgu = zzoe2;
        this.zzbgv = n;
        this.zzbgw = l;
    }

    public final void zzbd(int n) throws IOException {
        if (this.zzbgx != null && this.zzbgy > n) {
            throw this.zzbgx;
        }
    }

    public final void zzek(long l) {
        zzoh.checkState(zzob.zza(this.zzbha) == null);
        zzob.zza(this.zzbha, this);
        if (l > 0L) {
            this.sendEmptyMessageDelayed(0, l);
            return;
        }
        this.execute();
    }

    public final void zzl(boolean bl) {
        this.zzaez = bl;
        this.zzbgx = null;
        if (this.hasMessages(0)) {
            this.removeMessages(0);
            if (!bl) {
                this.sendEmptyMessage(1);
            }
        } else {
            this.zzbgt.cancelLoad();
            if (this.zzbgz != null) {
                this.zzbgz.interrupt();
            }
        }
        if (bl) {
            this.finish();
            long l = SystemClock.elapsedRealtime();
            this.zzbgu.zza(this.zzbgt, l, l - this.zzbgw, true);
        }
    }

    @Override
    public final void run() {
        try {
            this.zzbgz = Thread.currentThread();
            if (!this.zzbgt.zzhw()) {
                String string2 = String.valueOf(this.zzbgt.getClass().getSimpleName());
                zzow.beginSection(string2.length() != 0 ? "load:".concat(string2) : new String("load:"));
                try {
                    this.zzbgt.zzhx();
                }
                finally {
                    zzow.endSection();
                }
            }
            if (!this.zzaez) {
                this.sendEmptyMessage(2);
            }
            return;
        }
        catch (IOException iOException) {
            if (!this.zzaez) {
                this.obtainMessage(3, iOException).sendToTarget();
            }
            return;
        }
        catch (InterruptedException interruptedException) {
            zzoh.checkState(this.zzbgt.zzhw());
            if (!this.zzaez) {
                this.sendEmptyMessage(2);
            }
            return;
        }
        catch (Exception exception) {
            Log.e((String)"LoadTask", (String)"Unexpected exception loading stream", (Throwable)exception);
            if (!this.zzaez) {
                this.obtainMessage(3, new zzof(exception)).sendToTarget();
            }
            return;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            Log.e((String)"LoadTask", (String)"OutOfMemory error loading stream", (Throwable)outOfMemoryError);
            if (!this.zzaez) {
                this.obtainMessage(3, new zzof(outOfMemoryError)).sendToTarget();
            }
            return;
        }
        catch (Error error) {
            Log.e((String)"LoadTask", (String)"Unexpected error loading stream", (Throwable)error);
            if (!this.zzaez) {
                this.obtainMessage(4, error).sendToTarget();
            }
            throw error;
        }
    }

    public final void handleMessage(Message message) {
        if (this.zzaez) {
            return;
        }
        if (message.what == 0) {
            this.execute();
            return;
        }
        if (message.what == 4) {
            throw (Error)message.obj;
        }
        this.finish();
        long l = SystemClock.elapsedRealtime();
        long l2 = l - this.zzbgw;
        if (this.zzbgt.zzhw()) {
            this.zzbgu.zza(this.zzbgt, l, l2, false);
            return;
        }
        switch (message.what) {
            case 1: {
                this.zzbgu.zza(this.zzbgt, l, l2, false);
                return;
            }
            case 2: {
                this.zzbgu.zza(this.zzbgt, l, l2);
                return;
            }
            case 3: {
                this.zzbgx = (IOException)message.obj;
                int n = this.zzbgu.zza(this.zzbgt, l, l2, this.zzbgx);
                if (n == 3) {
                    zzob.zza(this.zzbha, this.zzbgx);
                    return;
                }
                if (n == 2) break;
                this.zzbgy = n == 1 ? 1 : this.zzbgy + 1;
                this.zzek(Math.min((this.zzbgy - 1) * 1000, 5000));
            }
        }
    }

    private final void execute() {
        this.zzbgx = null;
        zzob.zzb(this.zzbha).execute(zzob.zza(this.zzbha));
    }

    private final void finish() {
        zzob.zza(this.zzbha, null);
    }
}

