/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Point;
import android.media.MediaCodec;
import android.media.MediaCrypto;
import android.media.MediaFormat;
import android.os.SystemClock;
import android.util.Log;
import android.view.Surface;
import com.google.android.gms.internal.ads.zzdns;
import com.google.android.gms.internal.ads.zzgq;
import com.google.android.gms.internal.ads.zzhf;
import com.google.android.gms.internal.ads.zzja;
import com.google.android.gms.internal.ads.zzjb;
import com.google.android.gms.internal.ads.zzjf;
import com.google.android.gms.internal.ads.zzjh;
import com.google.android.gms.internal.ads.zzlb;
import com.google.android.gms.internal.ads.zzlc;
import com.google.android.gms.internal.ads.zzld;
import com.google.android.gms.internal.ads.zzlf;
import com.google.android.gms.internal.ads.zzlj;
import com.google.android.gms.internal.ads.zzoh;
import com.google.android.gms.internal.ads.zzoo;
import com.google.android.gms.internal.ads.zzov;
import com.google.android.gms.internal.ads.zzow;
import com.google.android.gms.internal.ads.zzpc;
import com.google.android.gms.internal.ads.zzph;
import com.google.android.gms.internal.ads.zzpi;
import com.google.android.gms.internal.ads.zzpk;
import com.google.android.gms.internal.ads.zzpl;
import com.google.android.gms.internal.ads.zzpm;
import java.nio.ByteBuffer;

@TargetApi(value=16)
public final class zzpg
extends zzlb {
    private static final int[] zzbil = new int[]{1920, 1600, 1440, 1280, 960, 854, 640, 540, 480};
    private final Context zzvf;
    private final zzpk zzbim;
    private final zzpl zzbin;
    private final long zzbio;
    private final int zzbip;
    private final boolean zzbiq;
    private final long[] zzbir;
    private zzhf[] zzbis;
    private zzpi zzbit;
    private Surface zzbiu;
    private Surface zzbiv;
    private int zzbiw;
    private boolean zzbix;
    private long zzbiy;
    private long zzbiz;
    private int zzbja;
    private int zzbjb;
    private int zzbjc;
    private float zzbjd;
    private int zzbje;
    private int zzbjf;
    private int zzbjg;
    private float zzbjh;
    private int zzbji;
    private int zzbjj;
    private int zzbjk;
    private float zzbjl;
    private boolean zzaku;
    private int zzahj;
    zzph zzbjm;
    private long zzbjn;
    private int zzbjo;

    public zzpg(Context context, zzld zzld2, long l, zzdns zzdns2, zzpm zzpm2, int n) {
        this(context, zzld2, 0L, null, false, zzdns2, zzpm2, -1);
    }

    private zzpg(Context context, zzld zzld2, long l, zzjf<zzjh> zzjf2, boolean bl, zzdns zzdns2, zzpm zzpm2, int n) {
        super(2, zzld2, null, false);
        this.zzbio = 0L;
        this.zzbip = -1;
        this.zzvf = context.getApplicationContext();
        this.zzbim = new zzpk(context);
        this.zzbin = new zzpl(zzdns2, zzpm2);
        this.zzbiq = zzov.SDK_INT <= 22 && "foster".equals(zzov.DEVICE) && "NVIDIA".equals(zzov.MANUFACTURER);
        this.zzbir = new long[10];
        this.zzbjn = -9223372036854775807L;
        this.zzbiy = -9223372036854775807L;
        this.zzbje = -1;
        this.zzbjf = -1;
        this.zzbjh = -1.0f;
        this.zzbjd = -1.0f;
        this.zzbiw = 1;
        this.zzjj();
    }

    @Override
    protected final int zza(zzld zzld2, zzhf zzhf2) throws zzlj {
        int n;
        int n2;
        zzlc zzlc2;
        String string2 = zzhf2.zzagi;
        if (!zzoo.zzbe(string2)) {
            return 0;
        }
        boolean bl = false;
        zzja zzja2 = zzhf2.zzagl;
        if (zzja2 != null) {
            for (int i = 0; i < zzja2.zzann; ++i) {
                bl |= zzja2.zzaa((int)i).zzanq;
            }
        }
        if ((zzlc2 = zzld2.zzb(string2, bl)) == null) {
            return 1;
        }
        boolean bl2 = zzlc2.zzba(zzhf2.zzagf);
        if (bl2 && zzhf2.width > 0 && zzhf2.height > 0) {
            if (zzov.SDK_INT >= 21) {
                bl2 = zzlc2.zza(zzhf2.width, zzhf2.height, zzhf2.zzagm);
            } else {
                bl2 = zzhf2.width * zzhf2.height <= zzlf.zzhj();
                if (!bl2) {
                    n2 = zzhf2.width;
                    n = zzhf2.height;
                    String string3 = zzov.zzbhv;
                    Log.d((String)"MediaCodecVideoRenderer", (String)new StringBuilder(56 + String.valueOf(string3).length()).append("FalseCheck [legacyFrameSize, ").append(n2).append("x").append(n).append("] [").append(string3).append("]").toString());
                }
            }
        }
        n2 = zzlc2.zzbaa ? 8 : 4;
        n = zzlc2.zzaku ? 16 : 0;
        int n3 = bl2 ? 3 : 2;
        return n2 | n | n3;
    }

    @Override
    protected final void zze(boolean bl) throws zzgq {
        super.zze(bl);
        this.zzahj = this.zzeh().zzahj;
        this.zzaku = this.zzahj != 0;
        this.zzbin.zza(this.zzazz);
        this.zzbim.enable();
    }

    @Override
    protected final void zza(zzhf[] zzhfArray, long l) throws zzgq {
        this.zzbis = zzhfArray;
        if (this.zzbjn == -9223372036854775807L) {
            this.zzbjn = l;
        } else {
            if (this.zzbjo == this.zzbir.length) {
                long l2 = this.zzbir[this.zzbjo - 1];
                Log.w((String)"MediaCodecVideoRenderer", (String)new StringBuilder(65).append("Too many stream changes, so dropping offset: ").append(l2).toString());
            } else {
                ++this.zzbjo;
            }
            this.zzbir[this.zzbjo - 1] = l;
        }
        super.zza(zzhfArray, l);
    }

    @Override
    protected final void zza(long l, boolean bl) throws zzgq {
        super.zza(l, bl);
        this.zzjh();
        this.zzbjb = 0;
        if (this.zzbjo != 0) {
            this.zzbjn = this.zzbir[this.zzbjo - 1];
            this.zzbjo = 0;
        }
        if (bl) {
            this.zzjg();
            return;
        }
        this.zzbiy = -9223372036854775807L;
    }

    @Override
    public final boolean isReady() {
        if (super.isReady() && (this.zzbix || this.zzbiv != null && this.zzbiu == this.zzbiv || this.zzhc() == null)) {
            this.zzbiy = -9223372036854775807L;
            return true;
        }
        if (this.zzbiy == -9223372036854775807L) {
            return false;
        }
        if (SystemClock.elapsedRealtime() < this.zzbiy) {
            return true;
        }
        this.zzbiy = -9223372036854775807L;
        return false;
    }

    @Override
    protected final void onStarted() {
        super.onStarted();
        this.zzbja = 0;
        this.zzbiz = SystemClock.elapsedRealtime();
        this.zzbiy = -9223372036854775807L;
    }

    @Override
    protected final void onStopped() {
        this.zzjm();
        super.onStopped();
    }

    @Override
    protected final void zzeg() {
        this.zzbje = -1;
        this.zzbjf = -1;
        this.zzbjh = -1.0f;
        this.zzbjd = -1.0f;
        this.zzbjn = -9223372036854775807L;
        this.zzbjo = 0;
        this.zzjj();
        this.zzjh();
        this.zzbim.disable();
        this.zzbjm = null;
        this.zzaku = false;
        try {
            super.zzeg();
            return;
        }
        finally {
            this.zzazz.zzgm();
            this.zzbin.zzb(this.zzazz);
        }
    }

    @Override
    public final void zza(int n, Object object) throws zzgq {
        if (n == 1) {
            Surface surface = (Surface)object;
            zzpg zzpg2 = this;
            if (surface == null) {
                if (zzpg2.zzbiv != null) {
                    surface = zzpg2.zzbiv;
                } else {
                    zzlc zzlc2 = zzpg2.zzhd();
                    if (zzlc2 != null && zzpg2.zzn(zzlc2.zzbab)) {
                        surface = zzpg2.zzbiv = zzpc.zzc(zzpg2.zzvf, zzlc2.zzbab);
                    }
                }
            }
            if (zzpg2.zzbiu != surface) {
                zzpg2.zzbiu = surface;
                int n2 = zzpg2.getState();
                if (n2 == 1 || n2 == 2) {
                    MediaCodec mediaCodec = zzpg2.zzhc();
                    if (zzov.SDK_INT >= 23 && mediaCodec != null && surface != null) {
                        Surface surface2 = surface;
                        mediaCodec.setOutputSurface(surface2);
                    } else {
                        ((zzlb)zzpg2).zzhe();
                        zzpg2.zzhb();
                    }
                }
                if (surface != null && surface != zzpg2.zzbiv) {
                    zzpg2.zzjl();
                    zzpg2.zzjh();
                    if (n2 == 2) {
                        zzpg2.zzjg();
                        return;
                    }
                } else {
                    zzpg2.zzjj();
                    zzpg2.zzjh();
                }
                return;
            }
            if (surface != null && surface != zzpg2.zzbiv) {
                zzpg2.zzjl();
                zzpg zzpg3 = zzpg2;
                if (zzpg3.zzbix) {
                    zzpg3.zzbin.zza(zzpg3.zzbiu);
                }
            }
            return;
        }
        if (n == 4) {
            this.zzbiw = (Integer)object;
            MediaCodec mediaCodec = this.zzhc();
            if (mediaCodec != null) {
                int n3 = this.zzbiw;
                mediaCodec.setVideoScalingMode(n3);
            }
            return;
        }
        super.zza(n, object);
    }

    @Override
    protected final boolean zza(zzlc zzlc2) {
        return this.zzbiu != null || this.zzn(zzlc2.zzbab);
    }

    @Override
    protected final void zza(zzlc zzlc2, MediaCodec mediaCodec, zzhf zzhf2, MediaCrypto mediaCrypto) throws zzlj {
        zzpi zzpi2;
        zzhf[] zzhfArray = this.zzbis;
        Object object = zzhf2;
        zzlc zzlc3 = zzlc2;
        int n = ((zzhf)object).width;
        int n2 = ((zzhf)object).height;
        int n3 = zzpg.zzi((zzhf)object);
        if (zzhfArray.length == 1) {
            zzpi2 = new zzpi(n, n2, n3);
        } else {
            boolean bl = false;
            zzhf[] zzhfArray2 = zzhfArray;
            int n4 = zzhfArray.length;
            for (int i = 0; i < n4; ++i) {
                zzhf zzhf3 = zzhfArray2[i];
                if (!zzpg.zza(zzlc3.zzbaa, (zzhf)object, zzhf3)) continue;
                bl |= zzhf3.width == -1 || zzhf3.height == -1;
                n = Math.max(n, zzhf3.width);
                n2 = Math.max(n2, zzhf3.height);
                n3 = Math.max(n3, zzpg.zzi(zzhf3));
            }
            if (bl) {
                Point point;
                Point point2;
                block16: {
                    int n5 = n;
                    n4 = n2;
                    Log.w((String)"MediaCodecVideoRenderer", (String)new StringBuilder(66).append("Resolutions unknown. Codec max resolution: ").append(n5).append("x").append(n4).toString());
                    Object object2 = object;
                    zzlc zzlc4 = zzlc3;
                    boolean bl2 = ((zzhf)object2).height > ((zzhf)object2).width;
                    int n6 = bl2 ? ((zzhf)object2).height : ((zzhf)object2).width;
                    int n7 = bl2 ? ((zzhf)object2).width : ((zzhf)object2).height;
                    float f = (float)n7 / (float)n6;
                    int[] nArray = zzbil;
                    int n8 = zzbil.length;
                    for (int i = 0; i < n8; ++i) {
                        int n9 = nArray[i];
                        int n10 = (int)((float)n9 * f);
                        if (n9 <= n6 || n10 <= n7) {
                            point2 = null;
                        } else if (zzov.SDK_INT >= 21) {
                            Point point3 = zzlc4.zzd(bl2 ? n10 : n9, bl2 ? n9 : n10);
                            float f2 = ((zzhf)object2).zzagm;
                            if (!zzlc4.zza(point3.x, point3.y, f2)) continue;
                            point2 = point3;
                        } else {
                            if ((n9 = zzov.zzf(n9, 16) << 4) * (n10 = zzov.zzf(n10, 16) << 4) > zzlf.zzhj()) continue;
                            point2 = new Point(bl2 ? n10 : n9, bl2 ? n9 : n10);
                        }
                        break block16;
                    }
                    point2 = point = null;
                }
                if (point2 != null) {
                    n = Math.max(n, point.x);
                    n2 = Math.max(n2, point.y);
                    n3 = Math.max(n3, zzpg.zza(((zzhf)object).zzagi, n, n2));
                    Log.w((String)"MediaCodecVideoRenderer", (String)new StringBuilder(57).append("Codec max resolution adjusted to: ").append(n).append("x").append(n2).toString());
                }
            }
            zzpi2 = new zzpi(n, n2, n3);
        }
        this.zzbit = zzpi2;
        int n11 = this.zzahj;
        boolean bl = this.zzbiq;
        object = this.zzbit;
        MediaFormat mediaFormat = zzhf2.zzez();
        mediaFormat.setInteger("max-width", ((zzpi)object).width);
        mediaFormat.setInteger("max-height", ((zzpi)object).height);
        if (((zzpi)object).zzbjq != -1) {
            mediaFormat.setInteger("max-input-size", ((zzpi)object).zzbjq);
        }
        if (bl) {
            mediaFormat.setInteger("auto-frc", 0);
        }
        if (n11 != 0) {
            n3 = n11;
            MediaFormat mediaFormat2 = mediaFormat;
            mediaFormat2.setFeatureEnabled("tunneled-playback", true);
            mediaFormat2.setInteger("audio-session-id", n3);
        }
        MediaFormat mediaFormat3 = mediaFormat;
        if (this.zzbiu == null) {
            zzoh.checkState(this.zzn(zzlc2.zzbab));
            if (this.zzbiv == null) {
                this.zzbiv = zzpc.zzc(this.zzvf, zzlc2.zzbab);
            }
            this.zzbiu = this.zzbiv;
        }
        mediaCodec.configure(mediaFormat3, this.zzbiu, null, 0);
        if (zzov.SDK_INT >= 23 && this.zzaku) {
            this.zzbjm = new zzph(this, mediaCodec, null);
        }
    }

    @Override
    protected final void zzhe() {
        block4: {
            block5: {
                try {
                    super.zzhe();
                    if (this.zzbiv == null) break block4;
                    if (this.zzbiu != this.zzbiv) break block5;
                    this.zzbiu = null;
                }
                catch (Throwable throwable) {
                    if (this.zzbiv != null) {
                        if (this.zzbiu == this.zzbiv) {
                            this.zzbiu = null;
                        }
                        this.zzbiv.release();
                        this.zzbiv = null;
                    }
                    throw throwable;
                }
            }
            this.zzbiv.release();
            this.zzbiv = null;
            return;
        }
    }

    @Override
    protected final void zzc(String string2, long l, long l2) {
        this.zzbin.zza(string2, l, l2);
    }

    @Override
    protected final void zzd(zzhf zzhf2) throws zzgq {
        super.zzd(zzhf2);
        this.zzbin.zzb(zzhf2);
        zzhf zzhf3 = zzhf2;
        this.zzbjd = zzhf3.zzago == -1.0f ? 1.0f : zzhf3.zzago;
        this.zzbjc = zzpg.zzj(zzhf2);
    }

    @Override
    protected final void zza(zzjb zzjb2) {
        if (zzov.SDK_INT < 23 && this.zzaku) {
            this.zzji();
        }
    }

    @Override
    protected final void onOutputFormatChanged(MediaCodec mediaCodec, MediaFormat mediaFormat) {
        boolean bl = mediaFormat.containsKey("crop-right") && mediaFormat.containsKey("crop-left") && mediaFormat.containsKey("crop-bottom") && mediaFormat.containsKey("crop-top");
        this.zzbje = bl ? mediaFormat.getInteger("crop-right") - mediaFormat.getInteger("crop-left") + 1 : mediaFormat.getInteger("width");
        this.zzbjf = bl ? mediaFormat.getInteger("crop-bottom") - mediaFormat.getInteger("crop-top") + 1 : mediaFormat.getInteger("height");
        this.zzbjh = this.zzbjd;
        if (zzov.SDK_INT >= 21) {
            if (this.zzbjc == 90 || this.zzbjc == 270) {
                int n = this.zzbje;
                this.zzbje = this.zzbjf;
                this.zzbjf = n;
                this.zzbjh = 1.0f / this.zzbjh;
            }
        } else {
            this.zzbjg = this.zzbjc;
        }
        int n = this.zzbiw;
        mediaCodec.setVideoScalingMode(n);
    }

    @Override
    protected final boolean zza(MediaCodec mediaCodec, boolean bl, zzhf zzhf2, zzhf zzhf3) {
        return zzpg.zza(bl, zzhf2, zzhf3) && zzhf3.width <= this.zzbit.width && zzhf3.height <= this.zzbit.height && zzhf3.zzagj <= this.zzbit.zzbjq;
    }

    @Override
    protected final boolean zza(long l, long l2, MediaCodec mediaCodec, ByteBuffer byteBuffer, int n, int n2, long l3, boolean bl) {
        while (this.zzbjo != 0 && l3 >= this.zzbir[0]) {
            this.zzbjn = this.zzbir[0];
            --this.zzbjo;
            System.arraycopy(this.zzbir, 1, this.zzbir, 0, this.zzbjo);
        }
        long l4 = l3 - this.zzbjn;
        if (bl) {
            this.zza(mediaCodec, n, l4);
            return true;
        }
        long l5 = l3 - l;
        if (this.zzbiu == this.zzbiv) {
            if (zzpg.zzem(l5)) {
                this.zza(mediaCodec, n, l4);
                return true;
            }
            return false;
        }
        if (!this.zzbix) {
            if (zzov.SDK_INT >= 21) {
                this.zza(mediaCodec, n, l4, System.nanoTime());
            } else {
                this.zzb(mediaCodec, n, l4);
            }
            return true;
        }
        if (this.getState() != 2) {
            return false;
        }
        long l6 = SystemClock.elapsedRealtime() * 1000L - l2;
        l5 -= l6;
        long l7 = System.nanoTime();
        long l8 = l7 + l5 * 1000L;
        long l9 = this.zzbim.zzf(l3, l8);
        l5 = (l9 - l7) / 1000L;
        if (zzpg.zzem(l5)) {
            int n3 = n;
            MediaCodec mediaCodec2 = mediaCodec;
            zzpg zzpg2 = this;
            zzow.beginSection("dropVideoBuffer");
            mediaCodec2.releaseOutputBuffer(n3, false);
            zzow.endSection();
            ++zzpg2.zzazz.zzanj;
            ++zzpg2.zzbja;
            ++zzpg2.zzbjb;
            zzpg2.zzazz.zzank = Math.max(zzpg2.zzbjb, zzpg2.zzazz.zzank);
            if (zzpg2.zzbja == zzpg2.zzbip) {
                zzpg2.zzjm();
            }
            return true;
        }
        if (zzov.SDK_INT >= 21) {
            if (l5 < 50000L) {
                this.zza(mediaCodec, n, l4, l9);
                return true;
            }
        } else if (l5 < 30000L) {
            if (l5 > 11000L) {
                try {
                    Thread.sleep((l5 - 10000L) / 1000L);
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
            }
            this.zzb(mediaCodec, n, l4);
            return true;
        }
        return false;
    }

    private final void zza(MediaCodec mediaCodec, int n, long l) {
        zzow.beginSection("skipVideoBuffer");
        mediaCodec.releaseOutputBuffer(n, false);
        zzow.endSection();
        ++this.zzazz.zzani;
    }

    private final void zzb(MediaCodec mediaCodec, int n, long l) {
        this.zzjk();
        zzow.beginSection("releaseOutputBuffer");
        mediaCodec.releaseOutputBuffer(n, true);
        zzow.endSection();
        ++this.zzazz.zzanh;
        this.zzbjb = 0;
        this.zzji();
    }

    @TargetApi(value=21)
    private final void zza(MediaCodec mediaCodec, int n, long l, long l2) {
        this.zzjk();
        zzow.beginSection("releaseOutputBuffer");
        mediaCodec.releaseOutputBuffer(n, l2);
        zzow.endSection();
        ++this.zzazz.zzanh;
        this.zzbjb = 0;
        this.zzji();
    }

    private final boolean zzn(boolean bl) {
        return zzov.SDK_INT >= 23 && !this.zzaku && (!bl || zzpc.zzc(this.zzvf));
    }

    private final void zzjg() {
        this.zzbiy = this.zzbio > 0L ? SystemClock.elapsedRealtime() + this.zzbio : -9223372036854775807L;
    }

    private final void zzjh() {
        MediaCodec mediaCodec;
        this.zzbix = false;
        if (zzov.SDK_INT >= 23 && this.zzaku && (mediaCodec = this.zzhc()) != null) {
            this.zzbjm = new zzph(this, mediaCodec, null);
        }
    }

    final void zzji() {
        if (!this.zzbix) {
            this.zzbix = true;
            this.zzbin.zza(this.zzbiu);
        }
    }

    private final void zzjj() {
        this.zzbji = -1;
        this.zzbjj = -1;
        this.zzbjl = -1.0f;
        this.zzbjk = -1;
    }

    private final void zzjk() {
        if (this.zzbji != this.zzbje || this.zzbjj != this.zzbjf || this.zzbjk != this.zzbjg || this.zzbjl != this.zzbjh) {
            this.zzbin.zza(this.zzbje, this.zzbjf, this.zzbjg, this.zzbjh);
            this.zzbji = this.zzbje;
            this.zzbjj = this.zzbjf;
            this.zzbjk = this.zzbjg;
            this.zzbjl = this.zzbjh;
        }
    }

    private final void zzjl() {
        if (this.zzbji != -1 || this.zzbjj != -1) {
            this.zzbin.zza(this.zzbje, this.zzbjf, this.zzbjg, this.zzbjh);
        }
    }

    private final void zzjm() {
        if (this.zzbja > 0) {
            long l = SystemClock.elapsedRealtime();
            long l2 = l - this.zzbiz;
            this.zzbin.zze(this.zzbja, l2);
            this.zzbja = 0;
            this.zzbiz = l;
        }
    }

    private static boolean zzem(long l) {
        return l < -30000L;
    }

    private static int zzi(zzhf zzhf2) {
        if (zzhf2.zzagj != -1) {
            return zzhf2.zzagj;
        }
        return zzpg.zza(zzhf2.zzagi, zzhf2.width, zzhf2.height);
    }

    private static int zza(String string2, int n, int n2) {
        int n3;
        int n4;
        if (n == -1 || n2 == -1) {
            return -1;
        }
        switch (string2) {
            case "video/3gpp": 
            case "video/mp4v-es": {
                n4 = n * n2;
                n3 = 2;
                break;
            }
            case "video/avc": {
                if ("BRAVIA 4K 2015".equals(zzov.MODEL)) {
                    return -1;
                }
                n4 = zzov.zzf(n, 16) * zzov.zzf(n2, 16) << 4 << 4;
                n3 = 2;
                break;
            }
            case "video/x-vnd.on2.vp8": {
                n4 = n * n2;
                n3 = 2;
                break;
            }
            case "video/hevc": 
            case "video/x-vnd.on2.vp9": {
                n4 = n * n2;
                n3 = 4;
                break;
            }
            default: {
                return -1;
            }
        }
        return n4 * 3 / (2 * n3);
    }

    private static boolean zza(boolean bl, zzhf zzhf2, zzhf zzhf3) {
        return zzhf2.zzagi.equals(zzhf3.zzagi) && zzpg.zzj(zzhf2) == zzpg.zzj(zzhf3) && (bl || zzhf2.width == zzhf3.width && zzhf2.height == zzhf3.height);
    }

    private static int zzj(zzhf zzhf2) {
        if (zzhf2.zzagn == -1) {
            return 0;
        }
        return zzhf2.zzagn;
    }
}

