/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Application;
import android.app.KeyguardManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.IntentFilter;
import android.graphics.Rect;
import android.os.Bundle;
import android.os.PowerManager;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.ViewParent;
import android.view.ViewTreeObserver;
import android.view.Window;
import android.view.WindowManager;
import androidx.annotation.Nullable;
import com.google.android.gms.ads.internal.zzq;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.ads.zzawr;
import com.google.android.gms.internal.ads.zzaxa;
import com.google.android.gms.internal.ads.zzazc;
import com.google.android.gms.internal.ads.zzpx;
import com.google.android.gms.internal.ads.zzpy;
import com.google.android.gms.internal.ads.zzpz;
import com.google.android.gms.internal.ads.zzqa;
import com.google.android.gms.internal.ads.zzqc;
import com.google.android.gms.internal.ads.zzvj;
import com.google.android.gms.internal.ads.zzzk;
import com.google.android.gms.internal.ads.zzzz;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

@TargetApi(value=14)
public final class zzpv
implements Application.ActivityLifecycleCallbacks,
View.OnAttachStateChangeListener,
ViewTreeObserver.OnGlobalLayoutListener,
ViewTreeObserver.OnScrollChangedListener {
    private static final long zzbon;
    private final Context zzzo;
    private Application zzxv;
    private final WindowManager zzboo;
    private final PowerManager zzzp;
    private final KeyguardManager zzzq;
    @Nullable
    @VisibleForTesting
    private BroadcastReceiver zzbop;
    private WeakReference<ViewTreeObserver> zzzs;
    private WeakReference<View> zzboq;
    private zzqc zzbor;
    private zzazc zzbos = new zzazc(zzbon);
    private boolean zzbot = false;
    private int zzzw = -1;
    private final HashSet<zzpz> zzbou = new HashSet();
    private final DisplayMetrics zzwz;
    private final Rect zzbov;

    public zzpv(Context context, View view) {
        this.zzzo = context.getApplicationContext();
        this.zzboo = (WindowManager)context.getSystemService("window");
        this.zzzp = (PowerManager)this.zzzo.getSystemService("power");
        this.zzzq = (KeyguardManager)context.getSystemService("keyguard");
        if (this.zzzo instanceof Application) {
            this.zzxv = (Application)this.zzzo;
            this.zzbor = new zzqc((Application)this.zzzo, this);
        }
        this.zzwz = context.getResources().getDisplayMetrics();
        this.zzbov = new Rect();
        this.zzbov.right = this.zzboo.getDefaultDisplay().getWidth();
        this.zzbov.bottom = this.zzboo.getDefaultDisplay().getHeight();
        View view2 = view;
        zzpv zzpv2 = this;
        View view3 = zzpv2.zzboq != null ? (View)zzpv2.zzboq.get() : null;
        if (view3 != null) {
            view3.removeOnAttachStateChangeListener((View.OnAttachStateChangeListener)zzpv2);
            zzpv2.zzg(view3);
        }
        zzpv2.zzboq = new WeakReference<View>(view2);
        if (view2 != null) {
            if (zzq.zzky().isAttachedToWindow(view2)) {
                zzpv2.zzf(view2);
            }
            view2.addOnAttachStateChangeListener((View.OnAttachStateChangeListener)zzpv2);
        }
    }

    public final void zza(zzpz zzpz2) {
        this.zzbou.add(zzpz2);
        this.zzbo(3);
    }

    public final void zzb(zzpz zzpz2) {
        this.zzbou.remove(zzpz2);
    }

    private final void zzcu() {
        zzaxa.zzdwf.post((Runnable)new zzpy(this));
    }

    public final void onViewAttachedToWindow(View view) {
        this.zzzw = -1;
        this.zzf(view);
        this.zzbo(3);
    }

    public final void onViewDetachedFromWindow(View view) {
        this.zzzw = -1;
        this.zzbo(3);
        this.zzcu();
        this.zzg(view);
    }

    private final void zza(Activity activity, int n) {
        if (this.zzboq == null) {
            return;
        }
        Window window = activity.getWindow();
        if (window == null) {
            return;
        }
        View view = window.peekDecorView();
        View view2 = (View)this.zzboq.get();
        if (view2 != null && view != null && view2.getRootView() == view.getRootView()) {
            this.zzzw = n;
        }
    }

    public final void onActivityCreated(Activity activity, Bundle bundle) {
        this.zza(activity, 0);
        this.zzbo(3);
        this.zzcu();
    }

    public final void onActivityStarted(Activity activity) {
        this.zza(activity, 0);
        this.zzbo(3);
        this.zzcu();
    }

    public final void onActivityResumed(Activity activity) {
        this.zza(activity, 0);
        this.zzbo(3);
        this.zzcu();
    }

    public final void onActivityPaused(Activity activity) {
        this.zza(activity, 4);
        this.zzbo(3);
        this.zzcu();
    }

    public final void onActivityStopped(Activity activity) {
        this.zzbo(3);
        this.zzcu();
    }

    public final void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
        this.zzbo(3);
        this.zzcu();
    }

    public final void onActivityDestroyed(Activity activity) {
        this.zzbo(3);
        this.zzcu();
    }

    public final void onGlobalLayout() {
        this.zzbo(2);
        this.zzcu();
    }

    public final void onScrollChanged() {
        this.zzbo(1);
    }

    private final void zzbo(int n) {
        boolean bl;
        if (this.zzbou.size() == 0) {
            return;
        }
        if (this.zzboq == null) {
            return;
        }
        View view = (View)this.zzboq.get();
        boolean bl2 = n == 1;
        boolean bl3 = view == null;
        Rect rect = new Rect();
        Rect rect2 = new Rect();
        boolean bl4 = false;
        Rect rect3 = new Rect();
        boolean bl5 = false;
        Rect rect4 = new Rect();
        int[] nArray = new int[2];
        int[] nArray2 = new int[2];
        if (view != null) {
            bl4 = view.getGlobalVisibleRect(rect2);
            bl5 = view.getLocalVisibleRect(rect3);
            view.getHitRect(rect4);
            try {
                view.getLocationOnScreen(nArray);
                view.getLocationInWindow(nArray2);
            }
            catch (Exception exception) {
                zzawr.zzc((String)"Failure getting view location.", (Throwable)exception);
            }
            rect.left = nArray[0];
            rect.top = nArray[1];
            rect.right = rect.left + view.getWidth();
            rect.bottom = rect.top + view.getHeight();
        }
        zzzk zzzk2 = zzzz.zzcmx;
        List<Rect> list = (Boolean)zzvj.zzpv().zzd(zzzk2) != false && view != null ? this.zzi(view) : Collections.emptyList();
        int n2 = view != null ? view.getWindowVisibility() : 8;
        int n3 = this.zzzw != -1 ? this.zzzw : n2;
        boolean bl6 = bl = !bl3 && zzq.zzkw().zza(view, this.zzzp, this.zzzq) && bl4 && bl5 && n3 == 0;
        if (bl2 && !this.zzbos.tryAcquire() && bl == this.zzbot) {
            return;
        }
        if (!bl && !this.zzbot && n == 1) {
            return;
        }
        zzqa zzqa2 = new zzqa(zzq.zzld().elapsedRealtime(), this.zzzp.isScreenOn(), view != null && zzq.zzky().isAttachedToWindow(view), view != null ? view.getWindowVisibility() : 8, this.zza(this.zzbov), this.zza(rect), this.zza(rect2), bl4, this.zza(rect3), bl5, this.zza(rect4), this.zzwz.density, bl, list);
        Iterator<zzpz> iterator = this.zzbou.iterator();
        while (iterator.hasNext()) {
            iterator.next().zza(zzqa2);
        }
        this.zzbot = bl;
    }

    private final Rect zza(Rect rect) {
        return new Rect(this.zzbp(rect.left), this.zzbp(rect.top), this.zzbp(rect.right), this.zzbp(rect.bottom));
    }

    private final int zzbp(int n) {
        float f = this.zzwz.density;
        return (int)((float)n / f);
    }

    private final List<Rect> zzi(View view) {
        try {
            ArrayList<Rect> arrayList = new ArrayList<Rect>();
            ViewParent viewParent = view.getParent();
            while (viewParent instanceof View) {
                View view2 = (View)viewParent;
                Rect rect = new Rect();
                View view3 = view2;
                if (view3.isScrollContainer() && view2.getGlobalVisibleRect(rect)) {
                    arrayList.add(this.zza(rect));
                }
                viewParent = viewParent.getParent();
            }
            return arrayList;
        }
        catch (Exception exception) {
            zzq.zzla().zza(exception, "PositionWatcher.getParentScrollViewRects");
            return Collections.emptyList();
        }
    }

    private final void zzf(View view) {
        ViewTreeObserver viewTreeObserver = view.getViewTreeObserver();
        if (viewTreeObserver.isAlive()) {
            this.zzzs = new WeakReference<ViewTreeObserver>(viewTreeObserver);
            viewTreeObserver.addOnScrollChangedListener((ViewTreeObserver.OnScrollChangedListener)this);
            viewTreeObserver.addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
        }
        zzpv zzpv2 = this;
        if (zzpv2.zzbop == null) {
            IntentFilter intentFilter = new IntentFilter();
            intentFilter.addAction("android.intent.action.SCREEN_ON");
            intentFilter.addAction("android.intent.action.SCREEN_OFF");
            intentFilter.addAction("android.intent.action.USER_PRESENT");
            zzpv2.zzbop = new zzpx(zzpv2);
            zzq.zzlr().zza(zzpv2.zzzo, zzpv2.zzbop, intentFilter);
        }
        if (this.zzxv != null) {
            try {
                this.zzxv.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.zzbor);
                return;
            }
            catch (Exception exception) {
                zzawr.zzc((String)"Error registering activity lifecycle callbacks.", (Throwable)exception);
            }
        }
    }

    private final void zzg(View view) {
        ViewTreeObserver viewTreeObserver;
        try {
            if (this.zzzs != null) {
                viewTreeObserver = (ViewTreeObserver)this.zzzs.get();
                if (viewTreeObserver != null && viewTreeObserver.isAlive()) {
                    viewTreeObserver.removeOnScrollChangedListener((ViewTreeObserver.OnScrollChangedListener)this);
                    viewTreeObserver.removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                }
                this.zzzs = null;
            }
        }
        catch (Exception exception) {
            zzawr.zzc((String)"Error while unregistering listeners from the last ViewTreeObserver.", (Throwable)exception);
        }
        try {
            viewTreeObserver = view.getViewTreeObserver();
            if (viewTreeObserver.isAlive()) {
                viewTreeObserver.removeOnScrollChangedListener((ViewTreeObserver.OnScrollChangedListener)this);
                viewTreeObserver.removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
            }
        }
        catch (Exception exception) {
            zzawr.zzc((String)"Error while unregistering listeners from the ViewTreeObserver.", (Throwable)exception);
        }
        zzpv zzpv2 = this;
        if (zzpv2.zzbop != null) {
            try {
                zzq.zzlr().zza(zzpv2.zzzo, zzpv2.zzbop);
            }
            catch (IllegalStateException illegalStateException) {
                zzawr.zzc((String)"Failed trying to unregister the receiver", (Throwable)illegalStateException);
            }
            catch (Exception exception) {
                zzq.zzla().zza(exception, "ActiveViewUnit.stopScreenStatusMonitoring");
            }
            zzpv2.zzbop = null;
        }
        if (this.zzxv != null) {
            try {
                this.zzxv.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.zzbor);
                return;
            }
            catch (Exception exception) {
                zzawr.zzc((String)"Error registering activity lifecycle callbacks.", (Throwable)exception);
            }
        }
    }

    public final void zzen(long l) {
        this.zzbos.zzfb(l);
    }

    public final void zzlv() {
        this.zzbos.zzfb(zzbon);
    }

    final /* synthetic */ void zzlw() {
        this.zzbo(3);
    }

    static /* synthetic */ void zza(zzpv zzpv2, int n) {
        zzpv2.zzbo(3);
    }

    static {
        zzzk zzzk2 = zzzz.zzcmu;
        zzbon = (Long)zzvj.zzpv().zzd(zzzk2);
    }
}

