/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.os.RemoteException;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import com.google.android.gms.ads.internal.util.zze;
import com.google.android.gms.ads.internal.util.zzr;
import com.google.android.gms.ads.internal.zzs;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.ObjectWrapper;
import com.google.android.gms.internal.ads.zzaci;
import com.google.android.gms.internal.ads.zzags;
import com.google.android.gms.internal.ads.zzahg;
import com.google.android.gms.internal.ads.zzams;
import com.google.android.gms.internal.ads.zzamw;
import com.google.android.gms.internal.ads.zzbce;
import com.google.android.gms.internal.ads.zzbqd;
import com.google.android.gms.internal.ads.zzcej;
import com.google.android.gms.internal.ads.zzceo;
import com.google.android.gms.internal.ads.zzcif;
import com.google.android.gms.internal.ads.zzcig;
import com.google.android.gms.internal.ads.zzeax;
import java.util.Collections;

public final class zzcih
extends zzams
implements ViewTreeObserver.OnGlobalLayoutListener,
ViewTreeObserver.OnScrollChangedListener,
zzags {
    private View zza;
    private zzaci zzb;
    private zzcej zzc;
    private boolean zzd;
    private boolean zze;

    public zzcih(zzcej zzcej2, zzceo zzceo2) {
        this.zza = zzceo2.zzF();
        this.zzb = zzceo2.zzu();
        this.zzc = zzcej2;
        this.zzd = false;
        this.zze = false;
        if (zzceo2.zzO() != null) {
            zzceo2.zzO().zzaw(this);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void zzd(IObjectWrapper object, zzamw zzamw2) throws RemoteException {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        if (((zzcih)object2).zzd) {
            com.google.android.gms.ads.internal.util.zze.zzf((String)"Instream ad can not be shown after destroy().");
            zzcih.zzi(zzamw2, 2);
            return;
        }
        View view = ((zzcih)object2).zza;
        if (view == null || ((zzcih)object2).zzb == null) {
            Object object2 = view == null ? "can not get video view." : "can not get video controller.";
            object = "Instream internal error: ";
            object2 = ((String)object2).length() != 0 ? ((String)object).concat((String)object2) : new String((String)object);
            com.google.android.gms.ads.internal.util.zze.zzf((String)object2);
            zzcih.zzi(zzamw2, 0);
            return;
        }
        if (((zzcih)object2).zze) {
            com.google.android.gms.ads.internal.util.zze.zzf((String)"Instream ad should not be used again.");
            zzcih.zzi(zzamw2, 1);
            return;
        }
        ((zzcih)object2).zze = true;
        super.zzg();
        object = ObjectWrapper.unwrap((IObjectWrapper)object);
        object = (ViewGroup)object;
        view = ((zzcih)object2).zza;
        ViewGroup.LayoutParams layoutParams = new ViewGroup.LayoutParams(-1, -1);
        object.addView(view, layoutParams);
        zzs.zzz();
        zzbce.zza(((zzcih)object2).zza, (ViewTreeObserver.OnGlobalLayoutListener)object2);
        zzs.zzz();
        zzbce.zzb(((zzcih)object2).zza, (ViewTreeObserver.OnScrollChangedListener)object2);
        super.zzh();
        try {
            zzamw2.zze();
            return;
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.zze.zzl((String)"#007 Could not call remote method.", (Throwable)remoteException);
            return;
        }
    }

    public final void zze(IObjectWrapper iObjectWrapper) throws RemoteException {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzcig zzcig2 = new zzcig(this);
        this.zzd(iObjectWrapper, (zzamw)zzcig2);
    }

    public final zzaci zzb() throws RemoteException {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        if (this.zzd) {
            com.google.android.gms.ads.internal.util.zze.zzf((String)"getVideoController: Instream ad should not be used after destroyed");
            return null;
        }
        return this.zzb;
    }

    public final zzahg zzf() {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        if (this.zzd) {
            com.google.android.gms.ads.internal.util.zze.zzf((String)"getVideoController: Instream ad should not be used after destroyed");
            return null;
        }
        zzcej zzcej2 = this.zzc;
        if (zzcej2 != null && zzcej2.zzF() != null) {
            return this.zzc.zzF().zza();
        }
        return null;
    }

    public final void zzc() throws RemoteException {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        this.zzg();
        zzcej zzcej2 = this.zzc;
        if (zzcej2 != null) {
            ((zzbqd)zzcej2).zzR();
        }
        this.zzc = null;
        this.zza = null;
        this.zzb = null;
        this.zzd = true;
    }

    private final void zzg() {
        View view = this.zza;
        if (view == null) {
            return;
        }
        if ((view = view.getParent()) instanceof ViewGroup) {
            ((ViewGroup)view).removeView(this.zza);
            return;
        }
    }

    public final void onGlobalLayout() {
        this.zzh();
    }

    public final void onScrollChanged() {
        this.zzh();
    }

    @Override
    public final void zza() {
        zzeax zzeax2 = zzr.zza;
        zzcif zzcif2 = new zzcif(this);
        zzeax2.post((Runnable)zzcif2);
    }

    private final void zzh() {
        View view;
        zzcej zzcej2 = this.zzc;
        if (zzcej2 != null && (view = this.zza) != null) {
            zzcej2.zzp(view, Collections.emptyMap(), Collections.emptyMap(), zzcej.zzz(this.zza));
            return;
        }
    }

    private static final void zzi(zzamw zzamw2, int n) {
        try {
            zzamw2.zzf(n);
            return;
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.zze.zzl((String)"#007 Could not call remote method.", (Throwable)remoteException);
            return;
        }
    }
}

