/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal;

import android.content.Context;
import android.text.TextUtils;
import androidx.annotation.Nullable;
import com.google.android.gms.ads.internal.zzd;
import com.google.android.gms.ads.internal.zzs;
import com.google.android.gms.common.util.Clock;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.ads.zzaaa;
import com.google.android.gms.internal.ads.zzaei;
import com.google.android.gms.internal.ads.zzaeq;
import com.google.android.gms.internal.ads.zzapb;
import com.google.android.gms.internal.ads.zzbar;
import com.google.android.gms.internal.ads.zzbbq;
import com.google.android.gms.internal.ads.zzbbw;
import com.google.android.gms.internal.ads.zzbbz;
import com.google.android.gms.internal.ads.zzefo;
import com.google.android.gms.internal.ads.zzefw;
import java.util.concurrent.Executor;
import javax.annotation.ParametersAreNonnullByDefault;
import org.json.JSONObject;

@ParametersAreNonnullByDefault
public final class zze {
    private Context zza;
    private long zzb = 0L;

    public final void zza(Context context, zzbbq zzbbq2, String string2, @Nullable Runnable runnable) {
        this.zzc(context, zzbbq2, true, null, string2, null, runnable);
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void zzb(Context context, zzbbq zzbbq2, String string2, zzbar zzbar2) {
        String string3 = zzbar2 != null ? zzbar2.zze() : null;
        this.zzc(context, zzbbq2, false, zzbar2, string3, string2, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @VisibleForTesting
    final void zzc(Context object, zzbbq object2, boolean bl, @Nullable zzbar zzbar2, String string2, @Nullable String string3, @Nullable Runnable runnable) {
        if (zzs.zzj().elapsedRealtime() - ((zze)((Object)zzefw2)).zzb < 5000L) {
            com.google.android.gms.ads.internal.util.zze.zzi((String)"Not retrying to fetch app settings");
            return;
        }
        ((zze)((Object)zzefw2)).zzb = zzs.zzj().elapsedRealtime();
        if (zzbar2 != null) {
            long l = zzbar2.zzb();
            Clock clock = zzs.zzj();
            long l2 = clock.currentTimeMillis();
            clock = zzaeq.zzcm;
            if (l2 - l <= (Long)zzaaa.zzc().zzb((zzaei)clock) && zzbar2.zzc()) {
                return;
            }
        }
        if (object == null) {
            com.google.android.gms.ads.internal.util.zze.zzi((String)"Context not provided to fetch application settings");
            return;
        }
        if (TextUtils.isEmpty((CharSequence)string2) && TextUtils.isEmpty((CharSequence)string3)) {
            com.google.android.gms.ads.internal.util.zze.zzi((String)"App settings could not be fetched. Required parameters missing");
            return;
        }
        zzbar2 = object.getApplicationContext();
        if (zzbar2 == null) {
            zzbar2 = object;
        }
        ((zze)((Object)zzefw2)).zza = zzbar2;
        zzefw zzefw2 = zzs.zzp().zzb(((zze)((Object)zzefw2)).zza, (zzbbq)object2).zza("google.afma.config.fetchAppSettings", zzapb.zza, zzapb.zza);
        try {
            object2 = new JSONObject();
            boolean bl2 = TextUtils.isEmpty((CharSequence)string2);
            if (!bl2) {
                object2.put("app_id", (Object)string2);
            } else {
                bl2 = TextUtils.isEmpty((CharSequence)string3);
                if (!bl2) {
                    object2.put("ad_unit_id", (Object)string3);
                }
            }
            object2.put("is_init", bl);
            object2.put("pn", (Object)object.getPackageName());
            zzefw2 = zzefw2.zzb(object2);
            object = zzd.zza;
            object2 = zzbbw.zzf;
            object = zzefo.zzh(zzefw2, object, (Executor)object2);
            if (runnable != null) {
                object2 = zzbbw.zzf;
                zzefw2.zze(runnable, (Executor)object2);
            }
            zzbbz.zza(object, "ConfigLoader.maybeFetchNewAppSettings");
            return;
        }
        catch (Exception exception) {
            com.google.android.gms.ads.internal.util.zze.zzg((String)"Error requesting application settings", (Throwable)exception);
            return;
        }
    }
}

