/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.SurfaceTexture;
import android.media.MediaPlayer;
import android.net.Uri;
import android.os.Build;
import android.view.Surface;
import android.view.TextureView;
import android.view.View;
import com.google.android.gms.ads.internal.util.zze;
import com.google.android.gms.ads.internal.util.zzr;
import com.google.android.gms.ads.internal.zzs;
import com.google.android.gms.internal.ads.zzaaa;
import com.google.android.gms.internal.ads.zzaei;
import com.google.android.gms.internal.ads.zzaeq;
import com.google.android.gms.internal.ads.zzbcn;
import com.google.android.gms.internal.ads.zzbco;
import com.google.android.gms.internal.ads.zzbcp;
import com.google.android.gms.internal.ads.zzbcq;
import com.google.android.gms.internal.ads.zzbcr;
import com.google.android.gms.internal.ads.zzbcs;
import com.google.android.gms.internal.ads.zzbct;
import com.google.android.gms.internal.ads.zzbcu;
import com.google.android.gms.internal.ads.zzbcv;
import com.google.android.gms.internal.ads.zzbcx;
import com.google.android.gms.internal.ads.zzbcy;
import com.google.android.gms.internal.ads.zzbdn;
import com.google.android.gms.internal.ads.zzbdo;
import com.google.android.gms.internal.ads.zzbdp;
import com.google.android.gms.internal.ads.zzbdq;
import com.google.android.gms.internal.ads.zzebq;
import com.google.android.gms.internal.ads.zzts;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

@TargetApi(value=14)
public final class zzbcw
extends zzbcy
implements TextureView.SurfaceTextureListener,
MediaPlayer.OnBufferingUpdateListener,
MediaPlayer.OnCompletionListener,
MediaPlayer.OnErrorListener,
MediaPlayer.OnInfoListener,
MediaPlayer.OnPreparedListener,
MediaPlayer.OnVideoSizeChangedListener {
    private static final Map<Integer, String> zzc;
    private final zzbdp zzd;
    private final zzbdq zze;
    private final boolean zzf;
    private int zzg = 0;
    private int zzh = 0;
    private MediaPlayer zzi;
    private Uri zzj;
    private int zzk;
    private int zzl;
    private int zzm;
    private int zzn;
    private int zzo;
    private zzbdn zzp;
    private final boolean zzq;
    private int zzr;
    private zzbcx zzs;
    private Integer zzt = null;

    public zzbcw(Context context, zzbdp zzbdp2, boolean bl, boolean bl2, zzbdo zzbdo2, zzbdq zzbdq2) {
        super(context);
        this.setSurfaceTextureListener(this);
        this.zzd = zzbdp2;
        this.zze = zzbdq2;
        this.zzq = bl;
        this.zzf = bl2;
        this.zze.zza(this);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public final String zza() {
        String string2 = true != ((zzbcw)((Object)string2)).zzq ? "" : " spherical";
        String string3 = "MediaPlayer";
        if (string2.length() == 0) return new String(string3);
        return string3.concat(string2);
    }

    @Override
    public final void zzb(zzbcx zzbcx2) {
        this.zzs = zzbcx2;
    }

    @Override
    public final void zzc(String string2) {
        zzts zzts2 = zzts.zza((Uri)(string2 = Uri.parse((String)string2)));
        if (zzts2 == null || zzts2.zza != null) {
            if (zzts2 != null) {
                string2 = Uri.parse((String)zzts2.zza);
            }
            this.zzj = string2;
            this.zzr = 0;
            this.zzA();
            this.requestLayout();
            this.invalidate();
            return;
        }
    }

    @Override
    public final void zzd() {
        com.google.android.gms.ads.internal.util.zze.zza("AdMediaPlayerView stop");
        MediaPlayer mediaPlayer = this.zzi;
        if (mediaPlayer != null) {
            mediaPlayer.stop();
            this.zzi.release();
            this.zzi = null;
            this.zzF(0);
            this.zzh = 0;
        }
        this.zze.zzc();
    }

    public final void onVideoSizeChanged(MediaPlayer mediaPlayer, int n, int n2) {
        int n3;
        StringBuilder stringBuilder = new StringBuilder(57);
        stringBuilder.append("AdMediaPlayerView size changed: ");
        stringBuilder.append(n);
        stringBuilder.append(" x ");
        stringBuilder.append(n2);
        com.google.android.gms.ads.internal.util.zze.zza(stringBuilder.toString());
        this.zzk = mediaPlayer.getVideoWidth();
        this.zzl = n3 = mediaPlayer.getVideoHeight();
        if (this.zzk != 0 && n3 != 0) {
            this.requestLayout();
            return;
        }
    }

    public final void onPrepared(MediaPlayer mediaPlayer) {
        com.google.android.gms.ads.internal.util.zze.zza("AdMediaPlayerView prepared");
        this.zzF(2);
        this.zze.zzb();
        zzebq zzebq2 = com.google.android.gms.ads.internal.util.zzr.zza;
        Object object = new zzbco(this, mediaPlayer);
        zzebq2.post((Runnable)object);
        this.zzk = mediaPlayer.getVideoWidth();
        this.zzl = mediaPlayer.getVideoHeight();
        int n = this.zzr;
        if (n != 0) {
            this.zzi(n);
        }
        this.zzB();
        n = this.zzk;
        int n2 = this.zzl;
        object = new StringBuilder(62);
        ((StringBuilder)object).append("AdMediaPlayerView stream dimensions: ");
        ((StringBuilder)object).append(n);
        ((StringBuilder)object).append(" x ");
        ((StringBuilder)object).append(n2);
        com.google.android.gms.ads.internal.util.zze.zzh((String)((StringBuilder)object).toString());
        if (this.zzh == 3) {
            this.zze();
        }
        this.zzq();
    }

    public final void onCompletion(MediaPlayer mediaPlayer) {
        com.google.android.gms.ads.internal.util.zze.zza("AdMediaPlayerView completion");
        this.zzF(5);
        this.zzh = 5;
        mediaPlayer = com.google.android.gms.ads.internal.util.zzr.zza;
        zzbcp zzbcp2 = new zzbcp(this);
        mediaPlayer.post((Runnable)zzbcp2);
    }

    public final boolean onInfo(MediaPlayer object, int n, int n2) {
        String string2 = zzc.get(n);
        object = zzc.get(n2);
        String string3 = String.valueOf(string2);
        int n3 = string3.length();
        String string4 = String.valueOf(object);
        int n4 = string4.length();
        StringBuilder stringBuilder = new StringBuilder(n3 + 37 + n4);
        stringBuilder.append("AdMediaPlayerView MediaPlayer info: ");
        stringBuilder.append(string2);
        stringBuilder.append(":");
        stringBuilder.append((String)object);
        com.google.android.gms.ads.internal.util.zze.zza(stringBuilder.toString());
        return true;
    }

    public final boolean onError(MediaPlayer object, int n, int n2) {
        object = zzc.get(n);
        String string2 = zzc.get(n2);
        String string3 = String.valueOf(object);
        int n3 = string3.length();
        String string4 = String.valueOf(string2);
        int n4 = string4.length();
        StringBuilder stringBuilder = new StringBuilder(n3 + 38 + n4);
        stringBuilder.append("AdMediaPlayerView MediaPlayer error: ");
        stringBuilder.append((String)object);
        stringBuilder.append(":");
        stringBuilder.append(string2);
        com.google.android.gms.ads.internal.util.zze.zzi((String)stringBuilder.toString());
        this.zzF(-1);
        this.zzh = -1;
        zzebq zzebq2 = com.google.android.gms.ads.internal.util.zzr.zza;
        zzbcq zzbcq2 = new zzbcq(this, (String)object, string2);
        zzebq2.post((Runnable)zzbcq2);
        return true;
    }

    public final void onBufferingUpdate(MediaPlayer mediaPlayer, int n) {
        this.zzm = n;
    }

    public final void onSurfaceTextureAvailable(SurfaceTexture surfaceTexture, int n, int n2) {
        com.google.android.gms.ads.internal.util.zze.zza("AdMediaPlayerView surface created");
        this.zzA();
        surfaceTexture = com.google.android.gms.ads.internal.util.zzr.zza;
        zzbcr zzbcr2 = new zzbcr(this);
        surfaceTexture.post((Runnable)zzbcr2);
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void onSurfaceTextureSizeChanged(SurfaceTexture surfaceTexture, int n, int n2) {
        zzbdn zzbdn2;
        com.google.android.gms.ads.internal.util.zze.zza("AdMediaPlayerView surface changed");
        int n3 = this.zzh;
        int n4 = this.zzk == n ? (this.zzl == n2 ? 1 : 0) : 0;
        if (this.zzi != null && n3 == 3 && n4 != 0) {
            n4 = this.zzr;
            if (n4 != 0) {
                this.zzi(n4);
            }
            this.zze();
        }
        if ((zzbdn2 = this.zzp) != null) {
            zzbdn2.zzc(n, n2);
        }
        zzbdn2 = com.google.android.gms.ads.internal.util.zzr.zza;
        zzbcs zzbcs2 = new zzbcs(this, n, n2);
        zzbdn2.post(zzbcs2);
    }

    public final boolean onSurfaceTextureDestroyed(SurfaceTexture object) {
        com.google.android.gms.ads.internal.util.zze.zza("AdMediaPlayerView surface destroyed");
        object = this.zzi;
        if (object != null && this.zzr == 0) {
            this.zzr = object.getCurrentPosition();
        }
        if ((object = this.zzp) != null) {
            ((zzbdn)object).zzd();
        }
        object = com.google.android.gms.ads.internal.util.zzr.zza;
        zzbct zzbct2 = new zzbct(this);
        object.post((Runnable)zzbct2);
        this.zzC(true);
        return true;
    }

    public final void onSurfaceTextureUpdated(SurfaceTexture surfaceTexture) {
        this.zze.zzd(this);
        this.zza.zzb(surfaceTexture, this.zzs);
    }

    protected final void onWindowVisibilityChanged(int n) {
        StringBuilder stringBuilder = new StringBuilder(58);
        stringBuilder.append("AdMediaPlayerView window visibility changed to ");
        stringBuilder.append(n);
        com.google.android.gms.ads.internal.util.zze.zza(stringBuilder.toString());
        stringBuilder = com.google.android.gms.ads.internal.util.zzr.zza;
        zzbcn zzbcn2 = new zzbcn(this, n);
        stringBuilder.post(zzbcn2);
        super.onWindowVisibilityChanged(n);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected final void onMeasure(int n, int n2) {
        block23: {
            int n3;
            int n4;
            block25: {
                block26: {
                    block27: {
                        int n5;
                        int n6;
                        block32: {
                            block31: {
                                block30: {
                                    block28: {
                                        block29: {
                                            n4 = zzbcw.getDefaultSize((int)this.zzk, (int)n);
                                            n3 = zzbcw.getDefaultSize((int)this.zzl, (int)n2);
                                            if (this.zzk <= 0) break block25;
                                            if (this.zzl <= 0) break block26;
                                            if (this.zzp != null) break block27;
                                            n4 = View.MeasureSpec.getMode((int)n);
                                            n3 = View.MeasureSpec.getSize((int)n);
                                            n6 = View.MeasureSpec.getMode((int)n2);
                                            n5 = View.MeasureSpec.getSize((int)n2);
                                            if (n4 != 0x40000000) break block28;
                                            if (n6 != 0x40000000) break block29;
                                            n = this.zzk;
                                            n2 = n * n5;
                                            n4 = this.zzl;
                                            n6 = n3 * n4;
                                            if (n2 < n6) {
                                                n = n2 / n4;
                                                n2 = n5;
                                                break block23;
                                            } else if (n2 > n6) {
                                                n2 = n6 / n;
                                                n = n3;
                                                break block23;
                                            } else {
                                                n = n3;
                                                n2 = n5;
                                            }
                                            break block23;
                                        }
                                        n = 0x40000000;
                                        break block30;
                                    }
                                    n = n4;
                                }
                                if (n != 0x40000000) break block31;
                                n2 = n3 * this.zzl / this.zzk;
                                if (n6 == Integer.MIN_VALUE) {
                                    if (n2 > n5) {
                                        n = n3;
                                        n2 = n5;
                                        break block23;
                                    } else {
                                        n = n3;
                                    }
                                    break block23;
                                } else {
                                    n = n3;
                                }
                                break block23;
                            }
                            if (n6 != 0x40000000) break block32;
                            n2 = n5 * this.zzk / this.zzl;
                            if (n == Integer.MIN_VALUE) {
                                if (n2 > n3) {
                                    n = n3;
                                    n2 = n5;
                                    break block23;
                                } else {
                                    n = n2;
                                    n2 = n5;
                                }
                                break block23;
                            } else {
                                n = n2;
                                n2 = n5;
                            }
                            break block23;
                        }
                        int n7 = this.zzk;
                        int n8 = this.zzl;
                        if (n6 == Integer.MIN_VALUE) {
                            if (n8 > n5) {
                                n2 = n5 * n7 / n8;
                                n4 = n5;
                            } else {
                                n2 = n7;
                                n4 = n8;
                            }
                        } else {
                            n2 = n7;
                            n4 = n8;
                        }
                        if (n == Integer.MIN_VALUE) {
                            if (n2 > n3) {
                                n2 = n3 * n8 / n7;
                                n = n3;
                                break block23;
                            } else {
                                n = n2;
                                n2 = n4;
                            }
                            break block23;
                        } else {
                            n = n2;
                            n2 = n4;
                        }
                        break block23;
                    }
                    n = n4;
                    n2 = n3;
                    break block23;
                }
                n = n4;
                n2 = n3;
                break block23;
            }
            n = n4;
            n2 = n3;
        }
        this.setMeasuredDimension(n, n2);
        zzbdn zzbdn2 = this.zzp;
        if (zzbdn2 != null) {
            zzbdn2.zzc(n, n2);
        }
        if (Build.VERSION.SDK_INT != 16) {
            return;
        }
        int n9 = this.zzn;
        if (n9 > 0 && n9 != n || (n9 = this.zzo) > 0 && n9 != n2) {
            this.zzB();
        }
        this.zzn = n;
        this.zzo = n2;
    }

    public final String toString() {
        String string2 = string3.getClass().getName();
        String string3 = Integer.toHexString(string3.hashCode());
        String string4 = String.valueOf(string2);
        int n = string4.length();
        String string5 = String.valueOf(string3);
        int n2 = string5.length();
        StringBuilder stringBuilder = new StringBuilder(n + 1 + n2);
        stringBuilder.append(string2);
        stringBuilder.append("@");
        stringBuilder.append(string3);
        return stringBuilder.toString();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void zzA() {
        com.google.android.gms.ads.internal.util.zze.zza("AdMediaPlayerView init MediaPlayer");
        SurfaceTexture surfaceTexture = this.getSurfaceTexture();
        if (this.zzj == null || surfaceTexture == null) {
            return;
        }
        this.zzC(false);
        try {
            void var1_3;
            MediaPlayer mediaPlayer;
            com.google.android.gms.ads.internal.zzs.zzs();
            this.zzi = mediaPlayer = new MediaPlayer();
            this.zzi.setOnBufferingUpdateListener((MediaPlayer.OnBufferingUpdateListener)this);
            this.zzi.setOnCompletionListener((MediaPlayer.OnCompletionListener)this);
            this.zzi.setOnErrorListener((MediaPlayer.OnErrorListener)this);
            this.zzi.setOnInfoListener((MediaPlayer.OnInfoListener)this);
            this.zzi.setOnPreparedListener((MediaPlayer.OnPreparedListener)this);
            this.zzi.setOnVideoSizeChangedListener((MediaPlayer.OnVideoSizeChangedListener)this);
            this.zzm = 0;
            boolean bl = this.zzq;
            if (bl) {
                zzbdn zzbdn2;
                this.zzp = zzbdn2 = new zzbdn(this.getContext());
                this.zzp.zzb(surfaceTexture, this.getWidth(), this.getHeight());
                this.zzp.start();
                zzbdn2 = this.zzp.zze();
                if (zzbdn2 != null) {
                    zzbdn zzbdn3 = zzbdn2;
                } else {
                    this.zzp.zzd();
                    this.zzp = null;
                }
            }
            this.zzi.setDataSource(this.getContext(), this.zzj);
            com.google.android.gms.ads.internal.zzs.zzt();
            Surface surface = new Surface((SurfaceTexture)var1_3);
            this.zzi.setSurface(surface);
            this.zzi.setAudioStreamType(3);
            this.zzi.setScreenOnWhilePlaying(true);
            this.zzi.prepareAsync();
            this.zzF(1);
            return;
        }
        catch (IOException | IllegalArgumentException | IllegalStateException exception) {
            String string2 = String.valueOf(this.zzj);
            String string3 = String.valueOf(string2);
            int n = string3.length();
            StringBuilder stringBuilder = new StringBuilder(n + 36);
            stringBuilder.append("Failed to initialize MediaPlayer at ");
            stringBuilder.append(string2);
            com.google.android.gms.ads.internal.util.zze.zzj((String)stringBuilder.toString(), (Throwable)exception);
            this.onError(this.zzi, 1, 0);
            return;
        }
    }

    private final void zzB() {
        if (!this.zzf) {
            return;
        }
        if (this.zzD() && this.zzi.getCurrentPosition() > 0 && this.zzh != 3) {
            com.google.android.gms.ads.internal.util.zze.zza("AdMediaPlayerView nudging MediaPlayer");
            this.zzE(0.0f);
            this.zzi.start();
            int n = this.zzi.getCurrentPosition();
            long l = com.google.android.gms.ads.internal.zzs.zzj().currentTimeMillis();
            while (this.zzD() && this.zzi.getCurrentPosition() == n && com.google.android.gms.ads.internal.zzs.zzj().currentTimeMillis() - l <= 250L) {
            }
            this.zzi.pause();
            this.zzq();
            return;
        }
    }

    private final void zzC(boolean bl) {
        com.google.android.gms.ads.internal.util.zze.zza("AdMediaPlayerView release");
        zzbdn zzbdn2 = this.zzp;
        if (zzbdn2 != null) {
            zzbdn2.zzd();
            this.zzp = null;
        }
        if ((zzbdn2 = this.zzi) != null) {
            zzbdn2.reset();
            this.zzi.release();
            this.zzi = null;
            this.zzF(0);
            if (bl) {
                this.zzh = 0;
                return;
            }
        }
    }

    @Override
    public final void zze() {
        com.google.android.gms.ads.internal.util.zze.zza("AdMediaPlayerView play");
        if (this.zzD()) {
            this.zzi.start();
            this.zzF(3);
            this.zza.zza();
            zzebq zzebq2 = com.google.android.gms.ads.internal.util.zzr.zza;
            zzbcu zzbcu2 = new zzbcu(this);
            zzebq2.post((Runnable)zzbcu2);
        }
        this.zzh = 3;
    }

    @Override
    public final void zzf() {
        com.google.android.gms.ads.internal.util.zze.zza("AdMediaPlayerView pause");
        if (this.zzD() && this.zzi.isPlaying()) {
            this.zzi.pause();
            this.zzF(4);
            zzebq zzebq2 = com.google.android.gms.ads.internal.util.zzr.zza;
            zzbcv zzbcv2 = new zzbcv(this);
            zzebq2.post((Runnable)zzbcv2);
        }
        this.zzh = 4;
    }

    @Override
    public final int zzg() {
        if (this.zzD()) {
            return this.zzi.getDuration();
        }
        return -1;
    }

    @Override
    public final int zzh() {
        if (this.zzD()) {
            return this.zzi.getCurrentPosition();
        }
        return 0;
    }

    @Override
    public final void zzi(int n) {
        StringBuilder stringBuilder = new StringBuilder(34);
        stringBuilder.append("AdMediaPlayerView seek ");
        stringBuilder.append(n);
        com.google.android.gms.ads.internal.util.zze.zza(stringBuilder.toString());
        if (this.zzD()) {
            this.zzi.seekTo(n);
            this.zzr = 0;
            return;
        }
        this.zzr = n;
    }

    private final boolean zzD() {
        int n;
        return this.zzi != null && (n = this.zzg) != -1 && n != 0 && n != 1;
    }

    @Override
    public final void zzj(float f, float f2) {
        zzbdn zzbdn2 = ((zzbcw)((Object)zzbdn2)).zzp;
        if (zzbdn2 != null) {
            zzbdn2.zzf(f, f2);
            return;
        }
    }

    @Override
    public final int zzk() {
        zzbcw zzbcw2 = zzbcw2.zzi;
        if (zzbcw2 != null) {
            return zzbcw2.getVideoWidth();
        }
        return 0;
    }

    @Override
    public final int zzl() {
        zzbcw zzbcw2 = zzbcw2.zzi;
        if (zzbcw2 != null) {
            return zzbcw2.getVideoHeight();
        }
        return 0;
    }

    @Override
    public final long zzm() {
        if (this.zzt != null) {
            return this.zzo() * (long)this.zzm / 100L;
        }
        return -1L;
    }

    @Override
    public final long zzn() {
        return 0L;
    }

    @Override
    public final long zzo() {
        if (this.zzt != null) {
            return (long)this.zzg() * (long)this.zzt.intValue();
        }
        return -1L;
    }

    @Override
    public final int zzp() {
        if (Build.VERSION.SDK_INT >= 26 && this.zzD()) {
            return this.zzi.getMetrics().getInt("android.media.mediaplayer.dropped");
        }
        return -1;
    }

    @Override
    public final void zzq() {
        this.zzE(this.zzb.zzc());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void zzE(float f) {
        zzbcw zzbcw2;
        zzbcw2 = zzbcw2.zzi;
        if (zzbcw2 == null) {
            com.google.android.gms.ads.internal.util.zze.zzi((String)"AdMediaPlayerView setMediaPlayerVolume() called before onPrepared().");
            return;
        }
        try {
            zzbcw2.setVolume(f, f);
            return;
        }
        catch (IllegalStateException illegalStateException) {
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void zzF(int n) {
        if (n == 3) {
            this.zze.zze();
            this.zzb.zzd();
        } else if (this.zzg == 3) {
            this.zze.zzf();
            this.zzb.zze();
        }
        this.zzg = n;
    }

    final /* synthetic */ void zzr(int n) {
        zzbcx zzbcx2 = ((zzbcw)((Object)zzbcx2)).zzs;
        if (zzbcx2 != null) {
            zzbcx2.onWindowVisibilityChanged(n);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    static /* synthetic */ void zzs(zzbcw zzbcw2, MediaPlayer mediaPlayer) {
        MediaPlayer.TrackInfo[] trackInfoArray = zzaeq.zzbj;
        if ((Boolean)zzaaa.zzc().zzb((zzaei)trackInfoArray) == false) return;
        if (zzbcw2.zzd == null) return;
        if (mediaPlayer == null) return;
        if (Build.VERSION.SDK_INT < 19) {
            return;
        }
        trackInfoArray = mediaPlayer.getTrackInfo();
        if (trackInfoArray == null) return;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        int n = trackInfoArray.length;
        int n2 = 0;
        while (true) {
            if (n2 >= n) {
                if (hashMap.isEmpty()) return;
                zzbcw2.zzd.zze("onMetadataEvent", hashMap);
                return;
            }
            MediaPlayer.TrackInfo trackInfo = trackInfoArray[n2];
            if (trackInfo != null) {
                switch (trackInfo.getTrackType()) {
                    default: {
                        break;
                    }
                    case 2: {
                        if ((trackInfo = trackInfo.getFormat()) == null) break;
                        if (trackInfo.containsKey("mime")) {
                            hashMap.put("audioMime", trackInfo.getString("mime"));
                        }
                        if (Build.VERSION.SDK_INT < 30 || !trackInfo.containsKey("codecs-string")) break;
                        hashMap.put("audioCodec", trackInfo.getString("codecs-string"));
                        break;
                    }
                    case 1: {
                        if ((trackInfo = trackInfo.getFormat()) == null) break;
                        if (trackInfo.containsKey("frame-rate")) {
                            try {
                                hashMap.put("frameRate", String.valueOf(trackInfo.getFloat("frame-rate")));
                            }
                            catch (ClassCastException classCastException) {
                                hashMap.put("frameRate", String.valueOf(trackInfo.getInteger("frame-rate")));
                            }
                        }
                        if (trackInfo.containsKey("bitrate")) {
                            zzbcw2.zzt = trackInfo.getInteger("bitrate");
                            hashMap.put("bitRate", String.valueOf(zzbcw2.zzt));
                        }
                        if (trackInfo.containsKey("width") && trackInfo.containsKey("height")) {
                            int n3 = trackInfo.getInteger("width");
                            int n4 = trackInfo.getInteger("height");
                            StringBuilder stringBuilder = new StringBuilder(23);
                            stringBuilder.append(n3);
                            stringBuilder.append("x");
                            stringBuilder.append(n4);
                            hashMap.put("resolution", stringBuilder.toString());
                        }
                        if (trackInfo.containsKey("mime")) {
                            hashMap.put("videoMime", trackInfo.getString("mime"));
                        }
                        if (Build.VERSION.SDK_INT < 30 || !trackInfo.containsKey("codecs-string")) break;
                        hashMap.put("videoCodec", trackInfo.getString("codecs-string"));
                    }
                }
            }
            ++n2;
        }
    }

    static /* synthetic */ zzbcx zzt(zzbcw zzbcw2) {
        return zzbcw2.zzs;
    }

    static {
        block1: {
            Map<Integer, String> map = new Map<Integer, String>();
            zzc = map;
            if (Build.VERSION.SDK_INT >= 17) {
                zzc.put(-1004, "MEDIA_ERROR_IO");
                zzc.put(-1007, "MEDIA_ERROR_MALFORMED");
                zzc.put(-1010, "MEDIA_ERROR_UNSUPPORTED");
                zzc.put(-110, "MEDIA_ERROR_TIMED_OUT");
                zzc.put(3, "MEDIA_INFO_VIDEO_RENDERING_START");
            }
            zzc.put(100, "MEDIA_ERROR_SERVER_DIED");
            map = zzc;
            Integer n = 1;
            map.put(n, "MEDIA_ERROR_UNKNOWN");
            zzc.put(n, "MEDIA_INFO_UNKNOWN");
            zzc.put(700, "MEDIA_INFO_VIDEO_TRACK_LAGGING");
            zzc.put(701, "MEDIA_INFO_BUFFERING_START");
            zzc.put(702, "MEDIA_INFO_BUFFERING_END");
            zzc.put(800, "MEDIA_INFO_BAD_INTERLEAVING");
            zzc.put(801, "MEDIA_INFO_NOT_SEEKABLE");
            zzc.put(802, "MEDIA_INFO_METADATA_UPDATE");
            if (Build.VERSION.SDK_INT < 19) break block1;
            zzc.put(901, "MEDIA_INFO_UNSUPPORTED_SUBTITLE");
            zzc.put(902, "MEDIA_INFO_SUBTITLE_TIMED_OUT");
        }
    }
}

