/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.content.Context;
import android.content.pm.PackageManager;
import android.util.Base64;
import androidx.annotation.NonNull;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.ads.zzcn;
import com.google.android.gms.internal.ads.zzct;
import com.google.android.gms.internal.ads.zzdc;
import com.google.android.gms.internal.ads.zzdyu;
import com.google.android.gms.internal.ads.zzdyw;
import com.google.android.gms.internal.ads.zzdzc;
import com.google.android.gms.internal.ads.zzdzh;
import com.google.android.gms.internal.ads.zzdzi;
import com.google.android.gms.internal.ads.zzdzj;
import com.google.android.gms.internal.ads.zzdzk;
import com.google.android.gms.internal.ads.zzdzl;
import com.google.android.gms.internal.ads.zzdzm;
import com.google.android.gms.tasks.OnFailureListener;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import java.nio.ByteBuffer;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;

public final class zzdzn {
    private final Context zza;
    private final Executor zzb;
    private final zzdyu zzc;
    private final zzdyw zzd;
    private final zzdzm zze;
    private final zzdzm zzf;
    private Task<zzdc> zzg;
    private Task<zzdc> zzh;

    @VisibleForTesting
    zzdzn(Context context, Executor executor, zzdyu zzdyu2, zzdyw zzdyw2, zzdzk zzdzk2, zzdzl zzdzl2) {
        this.zza = context;
        this.zzb = executor;
        this.zzc = zzdyu2;
        this.zzd = zzdyw2;
        this.zze = zzdzk2;
        this.zzf = zzdzl2;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public static zzdzn zza(@NonNull Context object, @NonNull Executor executor, @NonNull zzdyu zzdyu2, @NonNull zzdyw zzdyw2) {
        void var3_6;
        void var2_5;
        void var1_4;
        zzdzk zzdzk2 = new zzdzk();
        zzdzl zzdzl2 = new zzdzl();
        zzdzn zzdzn2 = new zzdzn((Context)object, (Executor)var1_4, (zzdyu)var2_5, (zzdyw)var3_6, zzdzk2, zzdzl2);
        if (zzdzn2.zzd.zzb()) {
            zzdzh zzdzh2 = new zzdzh(zzdzn2);
            zzdzn2.zzg = zzdzn2.zzg(zzdzh2);
        } else {
            zzdzn2.zzg = Tasks.forResult((Object)zzdzn2.zze.zza());
        }
        zzdzi zzdzi2 = new zzdzi(zzdzn2);
        zzdzn2.zzh = zzdzn2.zzg(zzdzi2);
        return zzdzn2;
    }

    public final zzdc zzb() {
        return zzdzn.zzh(this.zzg, this.zze.zza());
    }

    public final zzdc zzc() {
        return zzdzn.zzh(this.zzh, this.zzf.zza());
    }

    private final Task<zzdc> zzg(@NonNull Callable<zzdc> task) {
        Executor executor = this.zzb;
        task = Tasks.call((Executor)executor, task);
        executor = this.zzb;
        zzdzj zzdzj2 = new zzdzj(this);
        return task.addOnFailureListener(executor, (OnFailureListener)zzdzj2);
    }

    private static zzdc zzh(@NonNull Task<zzdc> task, @NonNull zzdc zzdc2) {
        if (!task.isSuccessful()) {
            return zzdc2;
        }
        return (zzdc)task.getResult();
    }

    final /* synthetic */ void zzd(Exception exception) {
        if (exception instanceof InterruptedException) {
            Thread.currentThread().interrupt();
        }
        this.zzc.zzd(2025, -1L, exception);
    }

    final /* synthetic */ zzdc zze() throws Exception {
        zzdzn zzdzn2 = zzdzn2.zza;
        PackageManager packageManager = zzdzn2.getPackageManager();
        String string2 = zzdzn2.getPackageName();
        packageManager = packageManager.getPackageInfo(string2, 0);
        return zzdzc.zza((Context)zzdzn2, zzdzn2.getPackageName(), Integer.toString(packageManager.versionCode));
    }

    final /* synthetic */ zzdc zzf() throws Exception {
        Object object = ((zzdzn)object).zza;
        zzcn zzcn2 = zzdc.zzj();
        AdvertisingIdClient advertisingIdClient = new AdvertisingIdClient((Context)object);
        advertisingIdClient.start();
        advertisingIdClient = advertisingIdClient.getInfo();
        object = advertisingIdClient.getId();
        if (object != null && ((String)object).matches("^[a-fA-F0-9]{8}-([a-fA-F0-9]{4}-){3}[a-fA-F0-9]{12}$")) {
            object = UUID.fromString((String)object);
            byte[] byArray = new byte[16];
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
            byteBuffer.putLong(((UUID)object).getMostSignificantBits());
            byteBuffer.putLong(((UUID)object).getLeastSignificantBits());
            object = Base64.encodeToString((byte[])byArray, (int)11);
        }
        if (object != null) {
            zzcn2.zzX((String)object);
            zzcn2.zzZ(advertisingIdClient.isLimitAdTrackingEnabled());
            zzcn2.zzY(zzct.zzf);
        }
        return (zzdc)zzcn2.zzah();
    }
}

