/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import com.google.android.gms.internal.ads.zzfra;
import com.google.android.gms.internal.ads.zzfrb;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.LockSupport;

abstract class zzfrc<T>
extends AtomicReference<Runnable>
implements Runnable {
    private static final Runnable zza;
    private static final Runnable zzb;

    zzfrc() {
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final void run() {
        T t;
        Thread thread = Thread.currentThread();
        if (!this.compareAndSet(null, thread)) {
            return;
        }
        boolean bl = this.zzd() ^ true;
        if (bl) {
            t = this.zza();
        } else {
            t = null;
        }
        if (!this.compareAndSet(thread, zza)) {
            this.zzb(thread);
        }
        if (bl) {
            this.zzf(t);
            return;
        }
        return;
        catch (Throwable throwable) {
            if (!this.compareAndSet(thread, zza)) {
                this.zzb(thread);
            }
            this.zzg(throwable);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void zzb(Thread thread) {
        Runnable runnable = (Runnable)this.get();
        boolean bl = false;
        int n = 0;
        zzfra zzfra2 = null;
        while (true) {
            if (!(runnable instanceof zzfra)) {
                if (runnable != zzb) {
                    if (bl) {
                        thread.interrupt();
                        return;
                    }
                    return;
                }
            } else {
                zzfra2 = (zzfra)runnable;
            }
            if (++n > 1000) {
                if (runnable == zzb || this.compareAndSet(runnable, zzb)) {
                    bl = !Thread.interrupted() ? bl : true;
                    LockSupport.park(zzfra2);
                }
            } else {
                Thread.yield();
            }
            runnable = (Runnable)this.get();
        }
    }

    abstract boolean zzd();

    abstract T zza() throws Exception;

    abstract void zzf(T var1);

    abstract void zzg(Throwable var1);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    final void zzh() {
        Runnable runnable = (Runnable)this.get();
        if (!(runnable instanceof Thread)) return;
        Runnable runnable2 = new zzfra(this, null);
        zzfra.zza((zzfra)runnable2, Thread.currentThread());
        if (!this.compareAndSet(runnable, runnable2)) return;
        try {
            runnable2 = (Thread)runnable;
            ((Thread)runnable2).interrupt();
        }
        catch (Throwable throwable) {
            if (this.getAndSet(zza) != zzb) {
                throw throwable;
            }
            LockSupport.unpark((Thread)runnable);
            throw throwable;
        }
        if (this.getAndSet(zza) != zzb) return;
        LockSupport.unpark((Thread)runnable2);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public final String toString() {
        CharSequence charSequence;
        Object object = (Runnable)((AtomicReference)((Object)string3)).get();
        if (object == zza) {
            object = "running=[DONE]";
        } else if (object instanceof zzfra) {
            object = "running=[INTERRUPTED]";
        } else if (object instanceof Thread) {
            object = ((Thread)object).getName();
            String string2 = String.valueOf(object);
            int n = string2.length();
            charSequence = new StringBuilder(n + 21);
            ((StringBuilder)charSequence).append("running=[RUNNING ON ");
            ((StringBuilder)charSequence).append((String)object);
            ((StringBuilder)charSequence).append("]");
            object = ((StringBuilder)charSequence).toString();
        } else {
            object = "running=[NOT STARTED YET]";
        }
        String string3 = ((zzfrc)((Object)string3)).zzc();
        String string4 = String.valueOf(object);
        int n = string4.length();
        charSequence = String.valueOf(string3);
        int n2 = ((String)charSequence).length();
        StringBuilder stringBuilder = new StringBuilder(n + 2 + n2);
        stringBuilder.append((String)object);
        stringBuilder.append(", ");
        stringBuilder.append(string3);
        return stringBuilder.toString();
    }

    abstract String zzc();

    static {
        zzfrb zzfrb2 = new zzfrb(null);
        zza = zzfrb2;
        zzfrb2 = new zzfrb(null);
        zzb = zzfrb2;
    }
}

