/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import com.google.android.gms.internal.ads.zzfrx;
import com.google.android.gms.internal.ads.zzfun;
import com.google.android.gms.internal.ads.zzgay;
import com.google.android.gms.internal.ads.zzgaz;
import com.google.android.gms.internal.ads.zzgcj;
import com.google.android.gms.internal.ads.zzgcl;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public final class zzgba
implements zzfrx {
    private static final ThreadLocal<Cipher> zza;
    private static final ThreadLocal<Cipher> zzb;
    private final byte[] zzc;
    private final byte[] zzd;
    private final SecretKeySpec zze;
    private final int zzf;

    public zzgba(byte[] object, int n) throws GeneralSecurityException {
        SecretKeySpec secretKeySpec;
        Object object2;
        if (!zzfun.zza(1)) {
            object2 = new GeneralSecurityException("Can not use AES-EAX in FIPS-mode.");
            throw object2;
        }
        if (n != 12 && n != 16) {
            object2 = new IllegalArgumentException("IV size should be either 12 or 16 bytes");
            throw object2;
        }
        ((zzgba)object2).zzf = n;
        zzgcl.zza(((byte[])object).length);
        ((zzgba)object2).zze = secretKeySpec = new SecretKeySpec((byte[])object, "AES");
        object = zza.get();
        ((Cipher)object).init(1, ((zzgba)object2).zze);
        ((zzgba)object2).zzc = zzgba.zzc(((Cipher)object).doFinal(new byte[16]));
        ((zzgba)object2).zzd = zzgba.zzc(((zzgba)object2).zzc);
    }

    private static byte[] zzb(byte[] byArray, byte[] byArray2) {
        int n = byArray.length;
        byte[] byArray3 = new byte[n];
        for (int i = 0; i < n; ++i) {
            byArray3[i] = (byte)(byArray[i] ^ byArray2[i]);
        }
        return byArray3;
    }

    private static byte[] zzc(byte[] byArray) {
        byte[] byArray2 = new byte[16];
        int n = 0;
        while (n < 15) {
            byte by = byArray[n];
            int n2 = n + 1;
            byArray2[n] = (byte)((by + by ^ (byArray[n2] & 0xFF) >>> 7) & 0xFF);
            n = n2;
        }
        n = byArray[15];
        byArray2[15] = (byte)(n + n ^ byArray[0] >> 7 & 0x87);
        return byArray2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final byte[] zzd(Cipher cipher, int n, byte[] byArray, int n2, int n3) throws IllegalBlockSizeException, BadPaddingException {
        Object object;
        byte[] byArray2 = new byte[16];
        byArray2[15] = (byte)n;
        if (n3 == 0) {
            return cipher.doFinal(zzgba.zzb(byArray2, ((zzgba)object).zzc));
        }
        byte[] byArray3 = cipher.doFinal(byArray2);
        int n4 = 0;
        while (n3 - n4 > 16) {
            for (int i = 0; i < 16; ++i) {
                byArray3[i] = (byte)(byArray3[i] ^ byArray[n2 + n4 + i]);
            }
            byArray3 = cipher.doFinal(byArray3);
            n4 += 16;
        }
        if ((byArray = Arrays.copyOfRange(byArray, n2 + n4, n2 + n3)).length == 16) {
            object = zzgba.zzb(byArray, ((zzgba)object).zzc);
            return cipher.doFinal(zzgba.zzb(byArray3, (byte[])object));
        }
        byte[] byArray4 = Arrays.copyOf(((zzgba)object).zzd, 16);
        for (int i = 0; i < (n3 = byArray.length); ++i) {
            byArray4[i] = (byte)(byArray4[i] ^ byArray[i]);
        }
        byArray4[n3] = (byte)(byArray4[n3] ^ 0x80);
        object = byArray4;
        return cipher.doFinal(zzgba.zzb(byArray3, (byte[])object));
    }

    @Override
    public final byte[] zza(byte[] byArray, byte[] byArray2) throws GeneralSecurityException {
        int n = byArray.length;
        int n2 = ((zzgba)object).zzf;
        if (n > Integer.MAX_VALUE - n2 + -16) {
            Object object = new GeneralSecurityException("plaintext too long");
            throw object;
        }
        byte[] byArray3 = new byte[n2 + n + 16];
        byte[] byArray4 = zzgcj.zza(n2);
        System.arraycopy(byArray4, 0, byArray3, 0, ((zzgba)object).zzf);
        Cipher cipher = zza.get();
        cipher.init(1, ((zzgba)object).zze);
        byArray4 = super.zzd(cipher, 0, byArray4, 0, byArray4.length);
        byArray2 = super.zzd(cipher, 1, byArray2, 0, 0);
        Cipher cipher2 = zzb.get();
        SecretKeySpec secretKeySpec = ((zzgba)object).zze;
        IvParameterSpec ivParameterSpec = new IvParameterSpec(byArray4);
        cipher2.init(1, (Key)secretKeySpec, ivParameterSpec);
        cipher2.doFinal(byArray, 0, n, byArray3, ((zzgba)object).zzf);
        byArray = super.zzd(cipher, 2, byArray3, ((zzgba)object).zzf, n);
        n += ((zzgba)object).zzf;
        for (int i = 0; i < 16; ++i) {
            byArray3[n + i] = (byte)(byArray2[i] ^ byArray4[i] ^ byArray[i]);
        }
        return byArray3;
    }

    static {
        ThreadLocal threadLocal;
        zza = threadLocal = new zzgay();
        zzb = threadLocal = new zzgaz();
    }
}

