/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import com.google.android.gms.internal.ads.zzfsi;
import com.google.android.gms.internal.ads.zzfsj;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.LockSupport;

abstract class zzfsl<T>
extends AtomicReference<Runnable>
implements Runnable {
    private static final Runnable zza;
    private static final Runnable zzb;

    zzfsl() {
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final void run() {
        T t;
        Thread thread = Thread.currentThread();
        if (!this.compareAndSet(null, thread)) {
            return;
        }
        boolean bl = this.zzd() ^ true;
        if (bl) {
            t = this.zza();
        } else {
            t = null;
        }
        if (!this.compareAndSet(thread, zza)) {
            this.zzb(thread);
        }
        if (bl) {
            this.zzf(t);
            return;
        }
        return;
        catch (Throwable throwable) {
            if (!this.compareAndSet(thread, zza)) {
                this.zzb(thread);
            }
            this.zzg(throwable);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void zzb(Thread thread) {
        Runnable runnable = (Runnable)this.get();
        boolean bl = false;
        int n = 0;
        zzfsi zzfsi2 = null;
        while (true) {
            if (!(runnable instanceof zzfsi)) {
                if (runnable != zzb) {
                    if (bl) {
                        thread.interrupt();
                        return;
                    }
                    return;
                }
            } else {
                zzfsi2 = (zzfsi)runnable;
            }
            if (++n > 1000) {
                if (runnable == zzb || this.compareAndSet(runnable, zzb)) {
                    bl = !Thread.interrupted() ? bl : true;
                    LockSupport.park(zzfsi2);
                }
            } else {
                Thread.yield();
            }
            runnable = (Runnable)this.get();
        }
    }

    abstract boolean zzd();

    abstract T zza() throws Exception;

    abstract void zzf(T var1);

    abstract void zzg(Throwable var1);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    final void zzh() {
        Runnable runnable = (Runnable)this.get();
        if (!(runnable instanceof Thread)) return;
        Runnable runnable2 = new zzfsi(this, null);
        zzfsi.zza((zzfsi)runnable2, Thread.currentThread());
        if (!this.compareAndSet(runnable, runnable2)) return;
        try {
            runnable2 = (Thread)runnable;
            ((Thread)runnable2).interrupt();
        }
        catch (Throwable throwable) {
            if (this.getAndSet(zza) != zzb) {
                throw throwable;
            }
            LockSupport.unpark((Thread)runnable);
            throw throwable;
        }
        if (this.getAndSet(zza) != zzb) return;
        LockSupport.unpark((Thread)runnable2);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public final String toString() {
        StringBuilder stringBuilder;
        Object object = (Runnable)((AtomicReference)((Object)string3)).get();
        if (object == zza) {
            object = "running=[DONE]";
        } else if (object instanceof zzfsi) {
            object = "running=[INTERRUPTED]";
        } else if (object instanceof Thread) {
            object = ((Thread)object).getName();
            String string2 = String.valueOf(object);
            int n = string2.length();
            stringBuilder = new StringBuilder(n + 21);
            stringBuilder.append("running=[RUNNING ON ");
            stringBuilder.append((String)object);
            stringBuilder.append("]");
            object = stringBuilder.toString();
        } else {
            object = "running=[NOT STARTED YET]";
        }
        String string3 = ((zzfsl)((Object)string3)).zzc();
        String string4 = String.valueOf(string3);
        int n = string4.length();
        stringBuilder = new StringBuilder(((String)object).length() + 2 + n);
        stringBuilder.append((String)object);
        stringBuilder.append(", ");
        stringBuilder.append(string3);
        return stringBuilder.toString();
    }

    abstract String zzc();

    static {
        zzfsj zzfsj2 = new zzfsj(null);
        zza = zzfsj2;
        zzfsj2 = new zzfsj(null);
        zzb = zzfsj2;
    }
}

