/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.content.Context;
import android.content.pm.PackageManager;
import android.util.Base64;
import androidx.annotation.NonNull;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.ads.zzaiz;
import com.google.android.gms.internal.ads.zzajp;
import com.google.android.gms.internal.ads.zzfmh;
import com.google.android.gms.internal.ads.zzfmj;
import com.google.android.gms.internal.ads.zzfmp;
import com.google.android.gms.internal.ads.zzfmu;
import com.google.android.gms.internal.ads.zzfmv;
import com.google.android.gms.internal.ads.zzfmw;
import com.google.android.gms.internal.ads.zzfmx;
import com.google.android.gms.internal.ads.zzfmy;
import com.google.android.gms.internal.ads.zzfmz;
import com.google.android.gms.tasks.OnFailureListener;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import java.nio.ByteBuffer;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;

public final class zzfna {
    private final Context zza;
    private final Executor zzb;
    private final zzfmh zzc;
    private final zzfmj zzd;
    private final zzfmz zze;
    private final zzfmz zzf;
    private Task<zzajp> zzg;
    private Task<zzajp> zzh;

    public final zzajp zza() {
        return zzfna.zzg(this.zzg, this.zze.zza());
    }

    public final zzajp zzb() {
        return zzfna.zzg(this.zzh, this.zzf.zza());
    }

    private static zzajp zzg(@NonNull Task<zzajp> task, @NonNull zzajp zzajp2) {
        if (!task.isSuccessful()) {
            return zzajp2;
        }
        return (zzajp)task.getResult();
    }

    final /* synthetic */ zzajp zzc() throws Exception {
        Object object = ((zzfna)object).zza;
        zzaiz zzaiz2 = zzajp.zza();
        AdvertisingIdClient.Info info = AdvertisingIdClient.getAdvertisingIdInfo((Context)object);
        if ((object = info.getId()) != null && ((String)object).matches("^[a-fA-F0-9]{8}-([a-fA-F0-9]{4}-){3}[a-fA-F0-9]{12}$")) {
            object = UUID.fromString((String)object);
            byte[] byArray = new byte[16];
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
            byteBuffer.putLong(((UUID)object).getMostSignificantBits());
            byteBuffer.putLong(((UUID)object).getLeastSignificantBits());
            object = Base64.encodeToString((byte[])byArray, (int)11);
        }
        if (object != null) {
            zzaiz2.zzq((String)object);
            zzaiz2.zzp(info.isLimitAdTrackingEnabled());
            zzaiz2.zzW(6);
        }
        return (zzajp)zzaiz2.zzah();
    }

    final /* synthetic */ zzajp zzd() throws Exception {
        zzfna zzfna2 = zzfna2.zza;
        PackageManager packageManager = zzfna2.getPackageManager();
        String string2 = zzfna2.getPackageName();
        packageManager = packageManager.getPackageInfo(string2, 0);
        return zzfmp.zza((Context)zzfna2, zzfna2.getPackageName(), Integer.toString(packageManager.versionCode));
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public static zzfna zze(@NonNull Context object, @NonNull Executor executor, @NonNull zzfmh zzfmh2, @NonNull zzfmj zzfmj2) {
        void var3_6;
        void var2_5;
        void var1_4;
        zzfmx zzfmx2 = new zzfmx();
        zzfmy zzfmy2 = new zzfmy();
        zzfna zzfna2 = new zzfna((Context)object, (Executor)var1_4, (zzfmh)var2_5, (zzfmj)var3_6, zzfmx2, zzfmy2);
        if (zzfna2.zzd.zzd()) {
            zzfmv zzfmv2 = new zzfmv(zzfna2);
            zzfna2.zzg = zzfna2.zzh(zzfmv2);
        } else {
            zzfna2.zzg = Tasks.forResult((Object)zzfna2.zze.zza());
        }
        zzfmw zzfmw2 = new zzfmw(zzfna2);
        zzfna2.zzh = zzfna2.zzh(zzfmw2);
        return zzfna2;
    }

    private final Task<zzajp> zzh(@NonNull Callable<zzajp> task) {
        Executor executor = this.zzb;
        task = Tasks.call((Executor)executor, task);
        executor = this.zzb;
        zzfmu zzfmu2 = new zzfmu(this);
        return task.addOnFailureListener(executor, (OnFailureListener)zzfmu2);
    }

    @VisibleForTesting
    zzfna(Context context, Executor executor, zzfmh zzfmh2, zzfmj zzfmj2, zzfmx zzfmx2, zzfmy zzfmy2) {
        this.zza = context;
        this.zzb = executor;
        this.zzc = zzfmh2;
        this.zzd = zzfmj2;
        this.zze = zzfmx2;
        this.zzf = zzfmy2;
    }

    final /* synthetic */ void zzf(Exception exception) {
        if (exception instanceof InterruptedException) {
            Thread.currentThread().interrupt();
        }
        this.zzc.zzc(2025, -1L, exception);
    }
}

