/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import com.google.android.gms.internal.ads.zzfqc;
import com.google.android.gms.internal.ads.zzfrr;
import com.google.android.gms.internal.ads.zzftr;
import com.google.android.gms.internal.ads.zzfup;
import com.google.android.gms.internal.ads.zzfuq;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import javax.annotation.CheckForNull;

abstract class zzftn<K, V>
extends zzfup<Map.Entry<K, V>> {
    @Override
    public final int size() {
        return this.zza().size();
    }

    abstract Map<K, V> zza();

    zzftn() {
    }

    @Override
    public final void clear() {
        this.zza().clear();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean contains(@CheckForNull Object object) {
        if (!(object instanceof Map.Entry)) return false;
        object = (Map.Entry)object;
        Object k = object.getKey();
        V v = zzftr.zza(this.zza(), k);
        if (!zzfqc.zza(v, object.getValue())) return false;
        if (v != null) return true;
        if (this.zza().containsKey(k)) return true;
        return false;
    }

    @Override
    public final boolean isEmpty() {
        return this.zza().isEmpty();
    }

    @Override
    public boolean remove(@CheckForNull Object object) {
        if (this.contains(object) && object instanceof Map.Entry) {
            object = (Map.Entry)object;
            return this.zza().keySet().remove(object.getKey());
        }
        return false;
    }

    @Override
    public final boolean removeAll(Collection<?> collection) {
        if (collection != null) {
            boolean bl = zzfuq.zzb(this, collection);
            return bl;
        }
        try {
            throw null;
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            return zzfuq.zzc(this, collection.iterator());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final boolean retainAll(Collection<?> iterator) {
        if (iterator == null) throw null;
        try {
            return super.retainAll((Collection<?>)((Object)iterator));
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            int n = iterator.size();
            if (n < 3) {
                zzfrr.zza(n, "expectedSize");
                ++n;
            } else {
                n = n < 0x40000000 ? (int)((float)n / 0.75f + 1.0f) : Integer.MAX_VALUE;
            }
            HashSet hashSet = new HashSet(n);
            iterator = iterator.iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    return this.zza().keySet().retainAll(hashSet);
                }
                Object e = iterator.next();
                if (!this.contains(e) || !(e instanceof Map.Entry)) continue;
                hashSet.add(((Map.Entry)e).getKey());
            }
        }
    }
}

