/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.net.Uri;
import android.text.TextUtils;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.ads.internal.util.client.zzm;
import com.google.android.gms.internal.ads.zzcgr;
import com.google.android.gms.internal.ads.zzcgs;
import com.google.android.gms.internal.ads.zzeq;
import com.google.android.gms.internal.ads.zzgv;
import com.google.android.gms.internal.ads.zzhh;
import com.google.android.gms.internal.ads.zzhv;
import com.google.android.gms.internal.ads.zzhy;
import com.google.android.gms.internal.ads.zzhz;
import com.google.android.gms.internal.ads.zzie;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayDeque;
import java.util.Map;
import java.util.Queue;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class zzcgt
extends zzgv
implements zzhz {
    private static final Pattern zzb = Pattern.compile("^bytes (\\d+)-(\\d+)/(\\d+)$");
    private final int zzc;
    private final int zzd;
    private final String zze;
    private final zzhy zzf;
    private zzhh zzg;
    private HttpURLConnection zzh;
    private final Queue zzi;
    private InputStream zzj;
    private boolean zzk;
    private int zzl;
    private long zzm;
    private long zzn;
    private long zzo;
    private long zzp;
    private long zzq;
    private final long zzr;
    private final long zzs;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final int zza(byte[] byArray, int n, int n2) throws zzhv {
        if (n2 == 0) {
            return 0;
        }
        try {
            long l = this.zzm;
            long l2 = this.zzn;
            if (l - l2 == 0L) {
                return -1;
            }
            long l3 = this.zzo;
            l3 += l2;
            long l4 = n2;
            long l5 = this.zzs;
            long l6 = this.zzq;
            long l7 = l6 + 1L;
            if ((l3 = l3 + l4 + l5) > l7) {
                long l8 = this.zzp;
                if (l6 < l8) {
                    l3 = this.zzr;
                    l3 = l7 + l3;
                    l3 = Math.min(l8, Math.max(l3 - l5 + -1L, l7 + l4 + -1L));
                    this.zzk(l7, l3, 2);
                    this.zzq = l3;
                } else {
                    l3 = l6;
                }
            } else {
                l3 = l6;
            }
            ++l3;
            l = this.zzo;
            l3 -= l;
            l3 = Math.min(l4, l3 - this.zzn);
            n2 = (int)l3;
            int n3 = this.zzj.read(byArray, n, n2);
            if (n3 == -1) {
                throw new EOFException();
            }
            this.zzn += (long)n3;
            this.zzg(n3);
            return n3;
        }
        catch (IOException iOException) {
            throw new zzhv(iOException, this.zzg, 2000, 2);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final long zzb(zzhh zzhh2) throws zzhv {
        long l;
        this.zzg = zzhh2;
        this.zzn = 0L;
        long l2 = zzhh2.zze;
        long l3 = zzhh2.zzf;
        long l4 = l3 == -1L ? this.zzr : Math.min(this.zzr, l3);
        long l5 = this.zzo = l2;
        this.zzh = this.zzk(l5, l5 + l4 + -1L, 1);
        String string2 = this.zzh.getHeaderField("Content-Range");
        if (TextUtils.isEmpty((CharSequence)string2)) throw new zzcgr(string2, zzhh2);
        Matcher matcher = zzb.matcher(string2);
        if (!matcher.find()) throw new zzcgr(string2, zzhh2);
        try {
            Long.parseLong(matcher.group(1));
            l = Long.parseLong(matcher.group(2));
            l4 = Long.parseLong(matcher.group(3));
        }
        catch (NumberFormatException numberFormatException) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Unexpected Content-Range [");
            stringBuilder.append(string2);
            stringBuilder.append("]");
            com.google.android.gms.ads.internal.util.client.zzm.zzg((String)stringBuilder.toString());
            throw new zzcgr(string2, zzhh2);
        }
        l2 = zzhh2.zzf;
        if (l2 != -1L) {
            this.zzm = l2;
            this.zzp = Math.max(l, this.zzo + l2 + -1L);
        } else {
            this.zzm = l4 - this.zzo;
            this.zzp = l4 + -1L;
        }
        this.zzq = l;
        this.zzk = true;
        this.zzj(zzhh2);
        return this.zzm;
    }

    @Override
    @Nullable
    public final Uri zzc() {
        HttpURLConnection httpURLConnection = ((zzcgt)((Object)httpURLConnection)).zzh;
        if (httpURLConnection == null) {
            return null;
        }
        return Uri.parse((String)httpURLConnection.getURL().toString());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @VisibleForTesting
    final HttpURLConnection zzk(long l, long l2, int n) throws zzhv {
        int n2;
        Object object;
        HttpURLConnection httpURLConnection;
        Object object2 = ((zzcgt)object).zzg.zza.toString();
        try {
            boolean bl;
            httpURLConnection = (HttpURLConnection)new URL((String)object2).openConnection();
            httpURLConnection.setConnectTimeout(((zzcgt)object).zzc);
            httpURLConnection.setReadTimeout(((zzcgt)object).zzd);
            Object object3 = ((zzcgt)object).zzf.zza().entrySet().iterator();
            while (bl = object3.hasNext()) {
                Map.Entry entry = object3.next();
                httpURLConnection.setRequestProperty((String)entry.getKey(), (String)entry.getValue());
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("bytes=");
            stringBuilder.append(l);
            stringBuilder.append("-");
            stringBuilder.append(l2);
            object3 = stringBuilder.toString();
            httpURLConnection.setRequestProperty("Range", (String)object3);
            httpURLConnection.setRequestProperty("User-Agent", ((zzcgt)object).zze);
            httpURLConnection.setRequestProperty("Accept-Encoding", "identity");
            httpURLConnection.setRequestMethod("GET");
            httpURLConnection.connect();
            ((zzcgt)object).zzi.add(httpURLConnection);
        }
        catch (IOException iOException) {
            object2 = String.valueOf(object2);
            object = ((zzcgt)object).zzg;
            throw new zzhv("Unable to connect to ".concat((String)object2), iOException, (zzhh)object, 2000, n);
        }
        object2 = ((zzcgt)object).zzg.zza.toString();
        try {}
        catch (IOException iOException) {
            super.zzl();
            object2 = String.valueOf(object2);
            object = ((zzcgt)object).zzg;
            throw new zzhv("Unable to connect to ".concat((String)object2), iOException, (zzhh)object, 2000, n);
        }
        ((zzcgt)object).zzl = n2 = httpURLConnection.getResponseCode();
        if (n2 < 200 || n2 > 299) {
            object2 = httpURLConnection.getHeaderFields();
            super.zzl();
            throw new zzcgs(((zzcgt)object).zzl, (Map)object2, ((zzcgt)object).zzg, n);
        }
        try {
            object2 = httpURLConnection.getInputStream();
            InputStream inputStream = ((zzcgt)object).zzj;
            if (inputStream != null) {
                object2 = new SequenceInputStream(((zzcgt)object).zzj, (InputStream)object2);
            }
            ((zzcgt)object).zzj = object2;
            return httpURLConnection;
        }
        catch (IOException iOException) {
            super.zzl();
            throw new zzhv(iOException, ((zzcgt)object).zzg, 2000, n);
        }
    }

    @Override
    @Nullable
    public final Map zze() {
        HttpURLConnection httpURLConnection = ((zzcgt)((Object)httpURLConnection)).zzh;
        if (httpURLConnection == null) {
            return null;
        }
        return httpURLConnection.getHeaderFields();
    }

    zzcgt(String string2, zzie zzie2, int n, int n2, long l, long l2) {
        super(true);
        zzeq.zzc(string2);
        this.zze = string2;
        this.zzf = new zzhy();
        this.zzc = n;
        this.zzd = n2;
        this.zzi = new ArrayDeque();
        this.zzr = l;
        this.zzs = l2;
        if (zzie2 != null) {
            this.zzf(zzie2);
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final void zzd() throws zzhv {
        var1_1 = this.zzj;
        if (var1_1 == null) ** GOTO lbl14
        var1_1.close();
        ** GOTO lbl14
        {
            catch (Throwable var1_2) {
                this.zzj = null;
                this.zzl();
                if (this.zzk) {
                    this.zzk = false;
                    this.zzh();
                }
                throw var1_2;
            }
lbl14:
            // 2 sources

            this.zzj = null;
            this.zzl();
            if (this.zzk) {
                this.zzk = false;
                this.zzh();
                return;
            }
            return;
            catch (IOException var1_3) {}
            {
                var3_5 = this.zzg;
                var2_4 = new zzhv(var1_3, var3_5, 2000, 3);
                throw var2_4;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void zzl() {
        while (true) {
            if (this.zzi.isEmpty()) {
                this.zzh = null;
                return;
            }
            HttpURLConnection httpURLConnection = (HttpURLConnection)this.zzi.remove();
            try {
                httpURLConnection.disconnect();
                continue;
            }
            catch (Exception exception) {
                com.google.android.gms.ads.internal.util.client.zzm.zzh((String)"Unexpected error while disconnecting", (Throwable)exception);
                continue;
            }
            break;
        }
    }
}

