/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.os.RemoteException;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import androidx.annotation.Nullable;
import com.google.android.gms.ads.internal.client.zzdq;
import com.google.android.gms.ads.internal.util.client.zzm;
import com.google.android.gms.ads.internal.zzu;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.ObjectWrapper;
import com.google.android.gms.internal.ads.zzbhh;
import com.google.android.gms.internal.ads.zzbhs;
import com.google.android.gms.internal.ads.zzbob;
import com.google.android.gms.internal.ads.zzbof;
import com.google.android.gms.internal.ads.zzccv;
import com.google.android.gms.internal.ads.zzcup;
import com.google.android.gms.internal.ads.zzdlo;
import com.google.android.gms.internal.ads.zzdlt;
import com.google.android.gms.internal.ads.zzdps;
import java.util.Collections;

public final class zzdpt
extends zzbob
implements ViewTreeObserver.OnGlobalLayoutListener,
ViewTreeObserver.OnScrollChangedListener,
zzbhh {
    private View zza;
    private zzdq zzb;
    private zzdlo zzc;
    private boolean zzd;
    private boolean zze;

    @Nullable
    public final zzdq zzb() throws RemoteException {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        if (this.zzd) {
            zzm.zzg((String)"getVideoController: Instream ad should not be used after destroyed");
            return null;
        }
        return this.zzb;
    }

    @Nullable
    public final zzbhs zzc() {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        if (((zzdpt)((Object)zzdlo2)).zzd) {
            zzm.zzg((String)"getVideoController: Instream ad should not be used after destroyed");
            return null;
        }
        zzdlo zzdlo2 = ((zzdpt)((Object)zzdlo2)).zzc;
        if (zzdlo2 != null && zzdlo2.zzc() != null) {
            return zzdlo2.zzc().zza();
        }
        return null;
    }

    public zzdpt(zzdlo zzdlo2, zzdlt zzdlt2) {
        this.zza = zzdlt2.zzf();
        this.zzb = zzdlt2.zzj();
        this.zzc = zzdlo2;
        this.zzd = false;
        this.zze = false;
        if (zzdlt2.zzs() != null) {
            zzdlt2.zzs().zzap(this);
            return;
        }
    }

    public final void zzd() throws RemoteException {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        this.zzh();
        zzdlo zzdlo2 = this.zzc;
        if (zzdlo2 != null) {
            ((zzcup)zzdlo2).zzb();
        }
        this.zzc = null;
        this.zza = null;
        this.zzb = null;
        this.zzd = true;
    }

    private final void zzg() {
        View view;
        zzdlo zzdlo2 = this.zzc;
        if (zzdlo2 != null && (view = this.zza) != null) {
            zzdlo2.zzB(view, Collections.emptyMap(), Collections.emptyMap(), zzdlo.zzX(this.zza));
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void zzh() {
        View view = this.zza;
        if (view == null || !((view = view.getParent()) instanceof ViewGroup)) {
            return;
        }
        ((ViewGroup)view).removeView(this.zza);
    }

    public final void onGlobalLayout() {
        this.zzg();
    }

    public final void onScrollChanged() {
        this.zzg();
    }

    public final void zze(IObjectWrapper iObjectWrapper) throws RemoteException {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        this.zzf(iObjectWrapper, (zzbof)new zzdps(this));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void zzf(IObjectWrapper iObjectWrapper, zzbof zzbof2) throws RemoteException {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        if (((zzdpt)((Object)string2)).zzd) {
            zzm.zzg((String)"Instream ad can not be shown after destroy().");
            zzdpt.zzi(zzbof2, 2);
            return;
        }
        View view = ((zzdpt)((Object)string2)).zza;
        if (view == null || ((zzdpt)((Object)string2)).zzb == null) {
            String string2 = view == null ? "can not get video view." : "can not get video controller.";
            zzm.zzg((String)"Instream internal error: ".concat(string2));
            zzdpt.zzi(zzbof2, 0);
            return;
        }
        if (((zzdpt)((Object)string2)).zze) {
            zzm.zzg((String)"Instream ad should not be used again.");
            zzdpt.zzi(zzbof2, 1);
            return;
        }
        ((zzdpt)((Object)string2)).zze = true;
        super.zzh();
        ((ViewGroup)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper)).addView(((zzdpt)((Object)string2)).zza, new ViewGroup.LayoutParams(-1, -1));
        zzu.zzx();
        zzccv.zza(((zzdpt)((Object)string2)).zza, (ViewTreeObserver.OnGlobalLayoutListener)string2);
        zzu.zzx();
        zzccv.zzb(((zzdpt)((Object)string2)).zza, (ViewTreeObserver.OnScrollChangedListener)string2);
        super.zzg();
        try {
            zzbof2.zzf();
            return;
        }
        catch (RemoteException remoteException) {
            zzm.zzl((String)"#007 Could not call remote method.", (Throwable)remoteException);
            return;
        }
    }

    private static final void zzi(zzbof zzbof2, int n) {
        try {
            zzbof2.zze(n);
            return;
        }
        catch (RemoteException remoteException) {
            zzm.zzl((String)"#007 Could not call remote method.", (Throwable)remoteException);
            return;
        }
    }
}

